
let mxStore = "https://mxpush.mxfast.com"
const mxStoreIP = "https://mxpush1.mxfast.com"
const s_ipregion = "ipregion4"
const wait = ms => new Promise(resolve => setTimeout(resolve, ms));
const ver_NotifyWin = "7.1.7.8601"
let pageVersion = "unknown"


async function myFetch(...args) {
	try {
		const res = await fetch(...args)
		return res
	} catch (e) {
		throw new Error(e.message, { cause: { args } })
	}
}
export class API {
	static async create({ storeUrl, gl } = {}) {
		if (gl.api) return gl.api
		try {
			const res_meta = await fetch("./meta.json")
			const meta = await res_meta.json()
			pageVersion = meta.version
		} catch (e) {
			pageVersion = 'error:' + e.message
		}
		const inst = new API
		/*if (storeUrl) {
			mxStore = storeUrl
		}*/
		inst.clients = {}
		inst.gl = gl
		inst.merger = window.objectMergeAdvanced
		let cmd = 'hide'
		await inst.handleBrowserWindow({ type: "notify", cmd, width: 200, height: 100 })
		inst.ver = pageVersion
		return inst
	}
	async wait(ms) {
		await wait(ms)
	}
	registerReceiver({ name, client }) {
		this.clients[name] = client
	}
	async getBalance({ asset }) {
		const mxtoken = await api.getCookie("MXTOKEN")
		const res = await fetch("https://s-asset.mxfast.com/asset/balance?asset=" + asset, { headers: { mxtoken } })
		if (res.ok) {
			const json = await res.json()
			return json
		}
		console.error(res)
		return { code: 100, err: "getBalance error" }
	}
	async clientFetch({ url, options }) {
		const ret = await this.callBrowser({ cmd: "fetch", param: { url, ...options } })
		return ret
	}
	async getDateTimeOnline() {
		try {
			const url = "https://worldtimeapi.org/api/ip"
			const res = await fetch(url)
			const json = await res.json()
			return new Date(json.utc_datetime)
		} catch (e) {
			try {
				const tz = Intl.DateTimeFormat().resolvedOptions().timeZone
				const url = "https://timeapi.io/api/Time/current/zone?timeZone=" + tz
				const res = await fetch(url)
				const json = await res.json()
				return new Date(json.dateTime)
			} catch (e) { console.error("can't get online time") }
		}
		return new Date()
	}
	async saveData({ module = "controller", key, value }) {
		if (typeof value === 'object') value = JSON.stringify(value)
		const ret = await this.callBrowser({ cmd: "saveData", param: { module, key, data: value } })
		return ret
	}
	async readData({ module = "controller", key }) {
		const ret = await this.callBrowser({ cmd: "readData", param: { module, key } })
		return ret.code == 0 ? ret.data : null
	}
	async removeData({ module = "controller", key }) {
		const ret = await this.callBrowser({ cmd: "removeData", param: { module, key } })
		return ret.code == 0 ? ret.data : null
	}
	async getStatistics({ param }) {
		const ret = await this.callBrowser({ cmd: "statistic", param })
		return ret.result == 200 ? ret.values : null
	}
	async setMxConfig(config) {
		const self = this
		return new Promise(resolve => {
			maxthon.send(data => resolve(data), {
				"event": "set_config", value: config
			})
		})
	}
	async openDB({ name, param }) {
		return await this.callBrowser({ from: "jsdb", cmd: "open", param: { filename: name, ...param } })
	}
	async callDB({ dbid, name, sql, vars }) {
		return await this.callBrowser({ from: "jsdb", cmd: "runPrepared", param: { dbid, name, sql, vars } })
	}
	async callBrowser({ from = "jsController", cmd, param }) {
		const self = this
		return new Promise(resolve => {
			maxthon.send(data => {
				try {
					const res = data ? JSON.parse(data) : {}
					resolve(res)
					return
				} catch (e) {
					console.error("data error:", data)
				}
				resolve({})
				self.mxSetCookie({ name: cmd + '_err', value: data, days: 2 })
			}, { from, cmd, param })
		})
	}
	async postError(err) {
		await this.postToMxStore('/err', { msg: err })
	}
	async writeLog({ from = 'jsController', log }) {
		await this.callBrowser({ from, cmd: "writeLog", param: { log } })
	}
	async callModule({ from, name, param }) {
		return await this.callBrowser({ from, cmd: "callModule", param: { name, param } })
	}
	async invokeCall({ to, cmd, param }) {
		if (cmd === 'login_end') {
			this.user = null
		}
		if (cmd === 'user_balance') {
			return await this.getBalance({ asset: param.asset })
		}
		if (to === 'api') {
			return this[cmd] ? await this[cmd](param) : null
		}
		if (to && this.clients[to]) {
			return await this.clients[to].onCall({ cmd, param })
		} else {
			for (const name in this.clients) {
				this.clients[name].onCall({ cmd, param })
			}
		}
		return to ? { code: 1000, err: to + ": not found" } : { code: 0, msg: "done" }
	}
	async compressJson(data) {
		if (!window.compressJson) {
			await import("./lib/compressJson.min.js")
		}
		if (!window.compressJson) return null
		return window.compressJson.compress(data)
	}
	async decompressJson(data) {
		if (!window.compressJson) {
			await import("./lib/compressJson.min.js")
		}
		if (!window.compressJson) return null
		return window.compressJson.decompress(data)
	}
	async debug() {
		if (this.gl.dev)
			console.log(...arguments)
	}
	async loadClass({ name }) {
		const namel = name.toLowerCase()
		let dev = this.gl.dev
		if (!dev) {
			const className = await import(`./${namel}.js`)
			return className[name]
		} else {
			let className = null
			try {
				className = await import('./dev/' + namel + ".js")
				if (className[name])
					console.log("using dev version of:", name)
				else
					className = await import(`./${namel}.js`)

			} catch (e) {
				className = await import(`./${namel}.js`)
			}
			return className[name]
		}
		return null
	}
	async getUID() {
		const info = await this.userInfo()
		return info?.user_id ? info.user_id + '' : null
	}
	async userInfo(refresh = false) {
		if (this.user && !refresh) return this.user
		const self = this
		return new Promise(resolve => {
			if (!maxthon?.Account?.send) {
				console.error("maxthon?.Account?.send err")
				resolve({})
				return
			}
			maxthon.Account.send(data => {
				console.log("userInfo:", data)
				const info = JSON.parse(data)
				if (!info.info.user_id) info.info.user_id = 0
				self.user = info.info
				resolve(info.info)
			}, { "event": "get_account_info" })
		})
	}
	browserInfo() {
		if (!this._browserInfo)
			this._browserInfo = this.parseJson(maxthon.browserInfo())
		return this._browserInfo
	}
	htmlToText(html) {
		const div = document.createElement("div");
		div.innerHTML = html;
		const text = div.textContent || div.innerText || "";
		// 主动清理引用，帮助垃圾回收
		div.remove();
		return text;
	}
	async getIPRegion(request = false) {
		let ipregion = this.ipregion
		if (!ipregion) {
			const encoded = await this.getCookie(s_ipregion)
			if (encoded)
				ipregion = decodeURIComponent(encoded)
		}
		if (!ipregion && !request) return null
		if (!ipregion) {
			await this.postToMxStore('/log', { type: 'all' })
			ipregion = decodeURIComponent(this.getCookie(s_ipregion))
		}
		if (typeof ipregion === 'string') ipregion = this.parseJson(ipregion) || {}
		const { region } = ipregion
		if (!region) return {}
		const info = region.split('|')
		return { country: info[0], area: info[1], provence: info[2], city: info[3], isp: info[4] }
	}
	async postToMxStore(path, body) {
		let retry = 0
		let res = null
		res = await this._postToMxStore(path, body)
		return res
	}
	async _postToMxStore(path, body) {
		this.ipregion = await this.getIPRegion()
		if (!this.ipregion) body.rIPRegion = true
		const packedData = msgpackr.pack(body)
		const url = mxStore + path
		try {
			const ret = await myFetch(url, {
				method: "POST",
				headers: {
					'Content-Type': 'application/msgpack'
				},
				body: packedData
			})
			const result = await ret.json()
			if (result.ipregion) {
				this.ipregion = result.ipregion
				await this.mxSetCookie({ name: s_ipregion, value: encodeURIComponent(JSON.stringify(result.ipregion)), days: 365, url: "https://maxthon.com" })
			}
			return result
		} catch (e) {
			return { result: 100, err: e.message }
		}
	}
	parseJson(data) {
		try {
			if (typeof data == 'object') return data
			return JSON.parse(data)
		} catch (e) {
			return null
		}
	}
	async getBrowserConfig(keys) {
		return new Promise(resolve => {
			if (!maxthon?.Account?.send) {
				resolve({})
				return
			}
			maxthon.Account.send(data => {
				const res = this.parseJson(data)
				if (res.result === "200") resolve(res.values)
				else {
					console.error(data)
					resolve({})
				}
			}, { "event": "browser_readconfig", keys })
		})
	}
	async getMXToken() {
		let mxtoken = await this.getCookie("MXTOKEN")
		if (!mxtoken) {
			({ mxtoken } = await this.userInfo())
			await this.mxSetCookie({ name: "MXTOKEN", value: mxtoken })
			mxtoken = await this.getCookie("MXTOKEN")
		}
		return mxtoken
	}
	async mxGetCookie({ name, url }) {
		if (!url) url = "https://www.maxthon.com/"
		const res = await this.callBrowser({ from: "jsController", cmd: "readCookie", param: { url } })
		if (res.code != 0) {
			console.error(res)
			return null
		}
		return res.values.cookies[name]
	}
	async mxSetCookie({ name, value, expire, days, url }) {
		let exptime = Math.floor(Date.now() / 1000) + 60 * 60 * 24 * 365 * 10 //10 years
		if (expire) exptime = expire
		if (days) {
			exptime = Math.floor(Date.now() / 1000) + 60 * 60 * 24 * days
		}
		const res = await this.callBrowser({ from: "jsController", cmd: "writeCookie", param: { url: "https://www.maxthon.com/", name, cookie: value, exptime } })
		if (url) {
			await this.callBrowser({ from: "jsController", cmd: "writeCookie", param: { url, name, cookie: value, exptime } })
		}
		if (res.code != 0) {
			console.error(res, name, value)
			return false
		}
		return true
	}
	async getCookie(name, url) {
		return await this.mxGetCookie({ name, url })
	}
	async setCookie({ name, value, days, url }) {
		return await this.mxSetCookie({ name, value, days, url })
	}
	async getSearchCount() {
		return new Promise(resolve => {
			if (!maxthon?.Account?.send) {
				resolve({})
				return
			}
			maxthon.Account.send(res => {
				const info = this.parseJson(res)
				if (!info.data) resolve(null)
				else
					resolve(info.data.search_list)
			}, { "event": "get_engines_statistic_data" })
		})
	}
	async getBrowserPref({ keys }) {
		return new Promise(resolve => {
			maxthon.send(data => {
				const res = JSON.parse(data)
				const ret = (res.result === '200' ? res.values : {})
				resolve(ret)
			}, {
				"event": "get_pref",
				"pref_names": keys
			})
		})

	}
	async setDefaultSearch({ name, url, key }) {
		return new Promise(resolve => {
			maxthon.send(res => {
				resolve(res)
			}, {
				"event": "set_pref",
				"pref_name": "set_search_engine",
				"pref_value": {
					name, url, key
				}
			})
		})
	}
	async setBrowserConfig(config) {
		return new Promise(resolve => {
			maxthon.send(res => { resolve(res) }, {
				"event": "set_config",
				"value": config
			})
		})
	}
	async notifyBrowser(data) {
		maxthon.send(() => { }, {
			"event": "web_event",  //固定写死的
			"model": "system",  //固定写死的
			"model_event": "message",
			"value": data
		})
		if (this.browserInfo().version >= ver_NotifyWin) { //js animation for asset change
			if (data.type === 'asset_change') {
				const config = await this.getBrowserPref({ keys: ["settings.mxnotify.enable", "settings.mxnotify.min_amount", "settings.mxnotify.voice_enable"] })
				if (config['settings.mxnotify.enable'] !== false)
					this.sendMessageToChannel({ name: "notify_window", value: data })
			}
		}
	}
	async sha1({ message, uint8array }) {
		if (message === undefined && uint8array === undefined) return null;
		let hashBuffer;
		if (message) {
			const msgBuffer = new TextEncoder().encode(message);          // 字符串转Uint8Array
			hashBuffer = await crypto.subtle.digest('SHA-1', msgBuffer); // 计算SHA-1
		}
		if (uint8array) {
			hashBuffer = await crypto.subtle.digest('SHA-1', uint8array); // 计算SHA-1
		}
		const hashArray = Array.from(new Uint8Array(hashBuffer));     // 转换为字节数组
		const hashHex = hashArray.map(b => b.toString(16).padStart(2, '0')).join('');
		return hashHex;
	}
	async handleBrowserWindow({ cmd = 'show', type, width, height }) {
		if (this.browserInfo().version < ver_NotifyWin) return
		const gl = this.gl
		return new Promise(async resolve => {
			let url = ''
			if (type === 'notify') {
				const dev = await this.getCookie("notify_dev")
				if (!dev || !gl.test) url = "./notify.html"
				else console.log("using dev version at:", dev)
			}
			if (type === 'smallspeaker') {
				url = "./speaker.html"
				const dev = await this.getCookie("speaker_dev")
				if (!dev || !gl.test) url = "./speaker.html"
				else console.log("using dev version at:", dev)
			}
			url = new URL(url, document.baseURI).href
			maxthon.send((data) => {
				resolve(data)
			}, {
				"event": "handle_window", param: {
					cmd,
					type, width, height, url
				}
			})
		})
	}
	sendMessageToChannel({ name, value }) {
		maxthon.send(null, { event: 'channel_message', model: name, value })
	}
	registerMessageChannel({ cb, name }) {
		maxthon.send(cb, { event: 'register_message_channel', model: name })
	}
	parsePrice(price) {
		const dd = price.split('|')
		let asset = dd[1], interval = dd[2]
		if (dd[1] === 'D') asset = 'diamond'
		if (dd[1] === 'G') asset = 'gold'
		if (interval === "W") interval = 'week'
		if (interval === "M") interval = 'month'
		if (interval === "Y") interval = 'year'
		return { amount: +dd[0], asset, interval }
	}
	randomNumber(n) {
		var add = 1, max = 12 - add;   // 12 is the min safe number Math.random() can generate without it starting to pad the end with zeros.   
		if (n > max) {
			return randomNumber(max) + randomNumber(n - max);
		}
		max = Math.pow(10, n + add);
		var min = max / 10; // Math.pow(10, n) basically
		var number = Math.floor(Math.random() * (max - min + 1)) + min;
		return ("" + number).substring(add);
	}
}