/**GetCanvasObject()
    @fileOverview
    the Main Method for Share
    @author liujia <liujia@maxthon.net>
 */

var g_share_locale = 'zh-cn';

function Share() {
    var ls = null;
    var shareDiv = null;
    var preDiv = null;
    var gzDiv = null;
    var bqDiv = null;
    var loginDiv = null;
    var toolbox = $('#toolbox');
    var w = $(window);
    var categorys = [];
    var emotions = [];
    // var ueip = maxthon.browser.UeipService;
    var UEIPMID = 'scncap';
    var loginDivOffsetTop = 0;

    // 初始化
    function init() {
        Global.init();
        createShareDiv();
        createLoginDiv();
        createGzDiv();
        createBqDiv();

        // 中止原截图的回车事件
        $('#share-login-uid, #share-login-pwd').bind('keydown', function (e) {
            if (e.keyCode == '13') {
                if (e.srcElement.id == 'share-login-uid') {
                    $('#share-login-pwd').focus();
                }
                else if (e.srcElement.id == 'share-login-pwd') {
                    $('#share-login-submit').click();
                }
                e.stopPropagation();
            }
        });
        $('#share-content').bind('keydown', function (e) {
            var lis = gzDiv.find('ul > li');
            var li =  gzDiv.find('ul > li.share-gz-selected');

            if (gzDiv[0].style.display == 'block') {
                switch (e.keyCode) {
                case 13:
                    li.click();
                    e.preventDefault();
                    break;
                case 38:
                    li.removeClass('share-gz-selected');
                    if (li.prev().length > 0) {
                        li.prev().addClass('share-gz-selected');
                    }
                    else {
                        lis.last().addClass('share-gz-selected');
                    }
                    e.preventDefault();
                    break;
                case 40:
                    li.removeClass('share-gz-selected');
                    if (li.next().length > 0) {
                        li.next().addClass('share-gz-selected');
                    }
                    else {
                        lis.first().addClass('share-gz-selected');
                    }
                    e.preventDefault();
                    break;
                }
            }
            e.stopPropagation();
        });

        // 中止原截图的双击事件
        $('#share-div, #share-login-div, #share-gz-div, #share-bq-div')
            .delegate('*', 'dblclick', function (e) {
                e.stopPropagation();
            }
        );
        $('#share-div, #share-login-div, #share-gz-div, #share-bq-div')
            .bind('dblclick', function (e) {
                e.stopPropagation();
            }
        );

        // 中止原截图的鼠标右键
        $('#share-div, #share-gz-div')
            .delegate('*', 'mousedown', function (e) {
                if (e.button == 2) {
                    e.stopPropagation();
                }
            }
        );
        $('#share-div, #share-gz-div')
            .bind('mousedown', function (e) {
                if (e.button == 2) {
                    e.stopPropagation();
                }
            }
        );

        // 响应原截图的鼠标右键
        $(document).bind('mousedown', function (e) {
            if (e.button == 2) {
                hide();
            }
        })

        // 点截图的其他按钮，恢复回去
        $('#toolbox .btn[id!="share-default"]').click(function () {
            hide();
            renewSnap();
        });

        // 拖拽时分享层消失
        $('#toolbox').bind('dragstart', function () {
            hide();
            renewSnap();
        });

        // 点击分享按钮
        $('#share-default').click(function () {
            pauseSnap();
            hide();
            display();
            // ueip
            // ueip.count(UEIPMID, 'c', 'sc_shareclick');
        });

        // 关闭按钮
        $('.share-close').click(function () {
            hide();
            clearText();
            renewSnap();
        });

        // 关闭登录层
        $('.share-login-close').click(function () {
            transform(loginDiv, shareDiv);
        });

        // 打开登陆层
        $('#share-div').delegate('#share-login', 'click', function () {
            showLogin();
        });

        // 账号退出
        $('#share-div').delegate('#share-logout', 'click', function () {
            Global.removeLS();
            $('.share-status').
                html('<a href="###" id="share-login">登录新浪微博</a>');
        });

        // 输入框响应按键
        $('#share-content').bind('input', function () {
            verifyText();
        });
        $('#share-content').bind('click', function () {
            gzMatch();
        });
        $('#share-content').bind('keyup', function (e) {
            if (gzDiv[0].style.display == 'block' &&
                (e.keyCode == '38' || e.keyCode == '40')) {
                return;
            }
            gzMatch();
        });
        $('#share-content').bind('blur', function (e) {
            window.setTimeout(function () {
                gzDiv.hide();
            }, 200)
        });

        // 点击话题按钮
        $('#share-huati').click(function () {
            var t = $('#share-content');
            var text = t.val();
            var str = '#在这里输入你想要说的话题#';
            var beg = t[0].selectionStart;
            var end = t[0].selectionEnd;
            var reg = /#在这里输入你想要说的话题#/;
            var match = text.match(reg);
            if (match) {
                t[0].selectionStart = match.index + 1;
                t[0].selectionEnd = t[0].selectionStart + match[0].length - 2;
            }
            else {
                if (text.length == 0) {
                    beg = 0;
                    end = 0;
                }
                text = text.substring(0, beg) + str + text.substring(end);
                t.val(text);
                t[0].selectionStart = beg + 1;
                t[0].selectionEnd = t[0].selectionStart + str.length - 2;
            }
            t.focus();

            // 验证字数
            verifyText();
        });

        // 点击@按钮
        $('#share-guanzhu').click(function () {
            var t = $('#share-content');
            var text = t.val();
            var str = '@';
            var beg = t[0].selectionStart;
            var end = t[0].selectionEnd;
            if (text.length == 0) {
                beg = 0;
                end = 0;
            }
            text = text.substring(0, beg) + str + text.substring(end);
            t.val(text);
            t[0].selectionStart = t[0].selectionEnd = beg + str.length;
            t.focus();

            // 验证字数
            verifyText();
        });

        // 选择@用户
        $('#share-gz-div').delegate('ul > li', 'click', function () {
            var t = $('#share-content');
            var text = t.val();
            var val = $(this).attr('title') + ' ';
            var end = t[0].selectionStart - 1;
            var beg = text.lastIndexOf('@', end);
            text = text.slice(0, beg + 1) + val + text.substring(end + 1);
            t.val(text);
            t[0].selectionStart = t[0].selectionEnd = beg + val.length + 1;
            t.focus();
        });

        // 显示表情
        $('#share-biaoqing').click(function () {
            showBq();
        });

        // 点其他地方表情层消失
        $(document).click(function () {
            bqDiv.hide();
        });
        $('#share-bq-div, #share-biaoqing').click(function (e) {
            e.stopPropagation();
        });
        $('#share-bq-div').delegate('*', 'click', function (e) {
            e.stopPropagation();
        });

        // 切换表情类型
        $('#share-bq-div').delegate('.right > a[class!="disable"]', 'click',
            function () {
                var val = $(this).attr('val');
                val = parseInt(val);
                createBqHead(val);
            }
        );

        // 切换表情内容
        $('#share-bq-div').delegate('.share-bq-category > a', 'click',
            function () {
                var val = $(this).attr('title');
                val = (val == '默认' ? '' : val);
                createBqContent(val);
            }
        );

        // 点击表情
        $('#share-bq-div').delegate('.share-bq-box img', 'click',
            function () {
                var t = $('#share-content');
                var text = t.val();
                var str = this.title;
                var beg = t[0].selectionStart;
                var end = t[0].selectionEnd;
                if (text.length == 0) {
                    beg = 0;
                    end = 0;
                }
                text = text.substring(0, beg) + str + text.substring(end);
                t.val(text);
                t[0].selectionStart = t[0].selectionEnd = beg + str.length;
                t.focus();

                // 验证字数
                verifyText();
                bqDiv.hide();
            }
        );

        // 发送微博
        $('#share-submit').click(function (e) {
            var t = $('#share-content');
            var c = GetCanvasObject();
            var text = t.val();
            var b = dataurlToBlob(c.toDataURL());
            if (getTextNum(text) > 140) {
                t.focus();
                return;
            }
            if (!checkLogin()) {
                showLogin('1');
                return;
            }
            Sina.statusesUpload(text, b, false, function (data) {
                if (!data.errorStr) {
                    // ueip
                    // ueip.count(UEIPMID, 'c', 'sc_sharesucc');
                    // window.setTimeout(TBCancel, 1000);
                    TBCancel();
                }
				else {
					errorHandler(data);
				}
            });
        });
    }

	function getPopupPosition(shareObj) {
		var position = {};
		
		var left = 0;
		var top = 0;
		
		if (shareObj) {
			var scale_factor = g_device_scale_factor;
			left = toolbox.offset().left + shareObj.width()/2 * (scale_factor - 1) + 100 * scale_factor;
				
			// The share popup is small than the login popup.
			// The two popups should display at the same position,
			// i.e. above or below the toolbox.
			// So check if there is enough space for login popup
			// to make sure this precondition is satisfied.
			var baseTop = toolbox.offset().top + (toolbox.height() + 10) * scale_factor;
			if (baseTop + loginDiv.height() * scale_factor > w.height()) {
				top = toolbox.offset().top - shareObj.height() - shareObj.height()/2 * (scale_factor - 1);
			} else {
				top =  baseTop + shareObj.height()/2 * (scale_factor - 1);
			}
		}
		
		position.left = left;
		position.top = top;
		
		return position;
		
	}
	
    // 显示登录层
    function showLogin(s) {
		var position = getPopupPosition(loginDiv);

        if (s == '1') {
            loginDiv.attr('auto', s);
        }
        else {
            loginDiv.removeAttr('auto');
        }
        $('#share-login-wrap').html('');
        Sina.accessToken('#share-login-wrap', function(jo) {
				//获取用户信息
				jo = Sina.usersShow('uid', LS_OBJECT.curId);
				if(jo && !jo.errorStr) {
					var key = LS_OBJECT.curType + WEIBO_SEPARATOR + LS_OBJECT.curId;
					LS_OBJECT[key].name = jo.name;
					Global.writeLS();
				}
				else {
					err.html('用户名或密码不正确');
					err.show();
					return;
				}
				var arr = [];
                arr.push('<span title="' + Global.encodeHtml(jo.name) + '">');
                arr.push(Global.encodeHtml(jo.name) + '</span>  ');
                arr.push('<a href="###" id="share-logout">退出</a>');
                $('.share-status').html(arr.join(''));
                transform(loginDiv, shareDiv);
                // 自动提交
                if (loginDiv.attr('auto') == '1') {
                    $('#share-submit').click();
                }
            });
        loginDiv.css({'left': position.left, 'top': position.top});
        transform(shareDiv, loginDiv);
        $('#share-login-wrap').css('display', 'block');
    }

    // 2个层切换动画
    function transform(o1, o2) {
        o1.addClass('share-animation1');
        window.setTimeout(function () {
            o2.show();
            if (o2 == loginDiv) {
                $('#share-login-uid').focus();
            }
            else {
                $('#share-content').focus();
            }
            o2.addClass('share-animation2');
            window.setTimeout(function () {
                o2.removeClass('share-animation2');
            }, 400);
        }, 200);
        window.setTimeout(function () {
            o1.removeClass('share-animation1');
            o1.hide();
        }, 400);
    }

    // 显示表情层的逻辑
    function showBq() {
        var bq = $('#share-biaoqing');
        var left = bq.offset().left - 30;
        var top = bq.offset().top;
        var dh = 155;
        if (bqDiv[0].style.display == 'block') {
            bqDiv.hide();
        }
        else {
            if (top + dh > w.height()) {
                top = top - dh + 20;
                bqDiv.removeClass('share-bq-top').addClass('share-bq-bottom');
            }
            else {
                top += 30;
                bqDiv.removeClass('share-bq-bottom').addClass('share-bq-top');
            }
            bqDiv.css({'top': top, 'left': left});
            bqDiv.show();
        }
    }

    // @匹配
    function gzMatch() {
        var text = $('#share-content');
        var val = text[0].value;
        var end = text[0].selectionStart - 1;
        var beg = val.lastIndexOf('@', end);
        var str;

        if (beg > -1 && end > beg) {
            str = val.slice(beg + 1, end + 1);
            if (!checkLogin()) {
                return;
            }
            Sina.atUsers(str, null, null, null, function (data) {
				// add by fanzw
				if (!data || data.errorStr) {
					errorHandler(data);
					return;
				}

                var span;
                var arr = [];
                var l = text.offset().left - 40;
                var t = text.offset().top - text.scrollTop() + 18;
                if (data.length == 0) {
                    gzDiv.hide();
                    return;
                }
                preDiv.html(val.slice(0, end + 1));
                preDiv.append('<span style="position: relative;"></span>');
                span = preDiv.find('span');
                l = l + span.offset().left - preDiv.offset().left;
                t = t + span.offset().top - preDiv.offset().top;
                for (var i = 0; i < data.length; i++) {
                    arr.push('<li title="' + data[i].nickname + '"');
                    if (i == 0) {
                        arr.push(' class="share-gz-selected"');
                    }
                    arr.push('>' + data[i].nickname + '</li>');
                }
                gzDiv.find('ul').html('');
                gzDiv.find('ul').append(arr.join(''));
                gzDiv.css({'top': t, 'left': l});
                gzDiv.show();
            });
        }
        else {
            gzDiv.hide();
        }
    }

    // 验证字数
    function getTextNum(text) {
        var count = 0;
        if (/^\s*$/.test(text)) {
            return count;
        }
        text = text.replace(/(?:http|https):\/\/[:\/;@&=$-.+!*\'(),%?#\w]+/gi,
            function (val) {
                count += 10;
                return '';
            }
        );
        text = text.replace(/[^\u0000-\u007f]{1}/g, function (val) {
            count += 1;
            return '';
        });
        count += parseInt(text.length / 2) + (text.length % 2 == 0 ? 0 : 1);
        return count;
    }

    // 验证文本内容
    function verifyText() {
        var v = $('#share-verify');
        var text = $('#share-content').val();
        var num = 140;
        var count = getTextNum(text);
        v.html(num - count);
        if (num - count < 0) {
            v.css('color', '#ff1818');
        }
        else {
            v.css('color', '#b3b3b3');
        }
    }

    // 暂停原有截图逻辑
    function pauseSnap() {
        if (!g_tb_sel) {
            TBSelect(null);
        }
        TBRecover();
    }

    // 恢复原有截图逻辑
    function renewSnap() {
        var b;
        b = g_tb_sel;
        g_tb_sel = null;
        TBSelect(b);
    }

    // 初始化表情参数
    function initBqPara() {
        var tmp;
        var tmpArr = [];
        for (var i = 0; i < SINA_WEIBO_EMOTIONS.length; i++) {
            tmp = SINA_WEIBO_EMOTIONS[i];
            if (categorys.indexOf(tmp.category) == -1) {
                categorys.push(tmp.category);
                if (tmpArr.length > 0) {
                    emotions.push(tmpArr);
                    tmpArr = [];
                    tmpArr.push(tmp);
                }
                else {
                    tmpArr.push(tmp);
                }
            }
            else {
                tmpArr.push(tmp);
            }
        }
        emotions.push(tmpArr);
    }

    // 创建表情头部
    function createBqHead(val) {
        var p = $('#share-bq-div .share-bq-category');
        var a = p.find('> a');
        var num = 3;
        var arr;
        var limit = '';
        var idx;
        var arrStr = [];
        val = val || 0;
        switch (val) {
        case -1:
            idx = categorys.indexOf(a.first().attr('title'));
            arr = categorys.slice(idx - num, idx);
            if (idx - num == 0) {
                limit = 'l';
            }
            break;
        case 0:
            arr = categorys.slice(0, num);
            limit = 'l';
            if (num >= categorys.length) {
                limit = 'r';
            }
            break;
        case 1:
            idx = categorys.indexOf(a.last().attr('title'));
            arr = categorys.slice(idx + 1, idx + 1 + num);
            if (idx + 1 + num >= categorys.length) {
                limit = 'r';
            }
            break;
        }
        for (var i = 0; i < arr.length; i++) {
            arr[i] = (arr[i] == '' ? '默认' : arr[i]);
            arrStr.push('<a href="###" title="' + arr[i] + '">' +
                arr[i] + '</a>');
        }
        arrStr = [arrStr.join('|')];
        arrStr.push('<span class="right">');
        arrStr.push('<a href="###" val="-1"');
        if (limit == 'l') {
            arrStr.push(' class="disable"');
        }
        arrStr.push('></a>');
        arrStr.push('<a href="###" val="1"');
        if (limit == 'r') {
            arrStr.push(' class="disable"');
        }
        arrStr.push('></a>');
        arrStr.push('</span>');
        p.html(arrStr.join(''));
    }

    // 创建表情内容
    function createBqContent(val) {
        var ul = $('#share-bq-div .share-bq-box');
        var arr = emotions[categorys.indexOf(val)];
        var arrStr = [];
        for (var i = 0; i < arr.length; i++) {
            arrStr.push('<li><img alt="' + arr[i].phrase + '"');
            arrStr.push(' title="' + arr[i].phrase + '"');
            arrStr.push(' src="' + arr[i].url + '"></li>');
        }
        ul.html(arrStr.join(''));;
    }

    // 创建表情层
    function createBqDiv() {
        var arr = [];
        if (!bqDiv) {
            initBqPara();
            arr.push('<div id="share-bq-div">');
            arr.push('<p class="share-bq-category"></p>');
            arr.push('<ul class="share-bq-box"></ul>');
            arr.push('</div>');
            $('body').append(arr.join(''));
            bqDiv = $('#share-bq-div');
            createBqHead();
            createBqContent('');
        }
    }

    // 创建关注层
    function createGzDiv() {
        var arr = [];
        if (!gzDiv) {
            arr.push('<div id="share-gz-div">');
            arr.push('<ul></ul>');
            arr.push('</div>');
            $('body').append(arr.join(''));
            gzDiv = $('#share-gz-div');
        }
    }

    // 创建登录层
    function createLoginDiv() {
        var arr = [];
        if (!loginDiv) {
	        arr.push('<div id="share-login-div">');
            arr.push('<div><a href="###" class="share-login-close"></a></div>');
            arr.push('<div class="share-login-waiting"></div>');
            arr.push('<div id="share-login-wrap"></div>');
            arr.push('</div>');
            $('body').append(arr.join(''));
            loginDiv = $('#share-login-div')
			
			loginDiv.height(loginDiv.height() + 10);
			loginDiv.css('transform', 'scale(' + g_device_scale_factor + ')');
        }
    }

    // 创建分享层
    function createShareDiv() {
        var arr = [];
        if (!shareDiv) {
            arr.push('<div id="share-div">');
            arr.push('<div class="share-status"></div>');
            arr.push('<a href="###" class="share-close"></a>');
            arr.push('<textarea id="share-content"></textarea>');
            arr.push('<h2 id="share-verify">140</h2>');
            arr.push('<div class="share-operate">');
            arr.push('<button type="button" id="share-huati"></button>');
            arr.push('<button type="button" id="share-guanzhu"></button>');
            arr.push('<button type="button" id="share-biaoqing"></button>');
            arr.push('<button type="button" id="share-submit">发送</button>');
            arr.push('</div>')
            arr.push('</div>')
            $('body').append(arr.join(''));
            shareDiv = $('#share-div');
			
			 shareDiv.css('transform', 'scale(' + g_device_scale_factor + ')');
        }
        if (!preDiv) {
            $('body').append('<pre id="share-pre"></pre>');
            preDiv = $('#share-pre');
        }
    }

    // 分享开始
    function display() {
		var position = getPopupPosition(shareDiv);

        var arr = [];
        if (checkLogin() && ls.name) {
            arr.push('<span title="' + Global.encodeHtml(ls.name) + '">');
            arr.push(Global.encodeHtml(ls.name) + '</span>  ');
            arr.push('<a href="###" id="share-logout">退出</a>');
        }
        else{
            arr.push('<a href="###" id="share-login">登录新浪微博</a>');
        }
        var span = $('.share-status');
        span.html(arr.join(''));
        shareDiv.css({ 'left': position.left, 'top': position.top});
        shareDiv.show();
        $('#share-content').focus();
    }

    // 退出分享
    function hide() {
        var t = $('#share-content');
        var v = $('#share-verify');

        shareDiv.hide();
        loginDiv.hide();
        gzDiv.hide();
        bqDiv.hide();
    }

    // 清除文字
    function clearText() {
        var t = $('#share-content');
        var v = $('#share-verify');
        t.val('');
        v.html('140');
        v.css('color', '#b3b3b3');
    }

    // 检查登录
    function checkLogin() {
		var user;
        Global.readLS();
        ls = LS_OBJECT[LS_OBJECT.curType + WEIBO_SEPARATOR + LS_OBJECT.curId];
        if (ls && ls.access_token) {
			Sina.accessConfig.access_token = ls.access_token;
			Sina.accessConfig.expires_in = ls.expires_in;
			Sina.accessConfig.uid = ls.uid;
			return true;
        }
		else {
			//检查obj中是否包含access_token字段，如果有，那么说明是新的接口；如果没有，说明还是老接口，需要清除storage，并从新登录
			Global.removeLS();
		}
        return false;
    }

	/**
        @description 处理微博操作错误，目前只处理了access_token失效的错误，其它的错误还没有处理 add by fanzw
		@param {object} error 错误对象，这个对象中会包含errorCode和errorStr属性
		@param {string} autoSubmit
     */
	function errorHandler(error) {
		if(!error) {
			return;
		}
		var errorCode = error.errorCode;
		var errorStr = '账号信息已失效，请重新登录';//error.errorStr;

        //显示登录界面
        showLogin();
        //在登录界面显示错误信息
        $('#share-login-err').html(errorStr).show();
	}

    // description base64格式转成blob
    function dataurlToBlob(dataurl) {
        // data:image/jpeg;base64,xxxxxx
        var datas = dataurl.split(',', 2);
        var blob = Global.binaryToBlob(atob(datas[1]));
        blob.fileType = datas[0].split(';')[0].split(':')[1];
        blob.name = blob.fileName = 'pic.' + blob.fileType.split('/')[1];
        return blob;
    }

    if (g_share_locale != 'zh-cn') {
        $('#share-default').hide();
        $('#share-default').next().hide();
        return;
    }
    else {
        init();
    }
}

var ShareLocale = {
    localeChanged: function(obj){
        if (obj.status) {
            g_share_locale = obj.result.toLowerCase();
            Share();
            console.log("__localeChanged________" + g_share_locale);
        } else {
            console.log("___share error:" + obj.reason);
        }
    }
};

(function(){
    var locale_dict = {
        params:{},
        callback:'ShareLocale.localeChanged'
    };

    //maxthon.send("getLocale", [locale_dict]);
	
	// Add CSS rules for animation.
	var animation1_style_rule_set = ' \
		.share-animation1 { \
			-webkit-animation: sa1 0.4s; \
			-webkit-animation-iteration-count: 1; \
		} \
	';
	var animation1_style_at_rule = ' \
		@keyframes sa1{ \
			from { \
				transform: rotateY(0deg); \
				transform: scale(' + g_device_scale_factor + '); \
				opacity: 1; \
			} \
			to { \
				transform: scale(' + g_device_scale_factor + ');   \
				transform: rotateY(90deg);   \
				opacity: 0; \
			} \
		} \
	';

	var animation2_style_rule_set = ' \
		.share-animation2 { \
			-webkit-animation: sa2 0.4s; \
			-webkit-animation-iteration-count: 1; \
		} \
	';
	
	var animation2_style_at_rule = ' \
		@keyframes sa2 { \
			from { \
				transform: scale(' + g_device_scale_factor + ');   \
				transform: rotateY(90deg);   \
				opacity: 0; \
			} \
			to { \
				transform: rotateY(0deg); \
				transform: scale(' + g_device_scale_factor + '); \
				opacity: 1; \
			} \
		} \
	';
	
	var sheet = document.styleSheets[0];
    sheet.insertRule(animation1_style_at_rule, 0);
	sheet.insertRule(animation1_style_rule_set, 0);
		
	sheet.insertRule(animation2_style_at_rule, 0);
	sheet.insertRule(animation2_style_rule_set, 0);
		
})();
