/**************************************************/
/* filename: snap-screen.js                   */
/* author: zhsoft88                               */
/* date: 2011.5.6                                 */
/* copyright (c) 2011 maxthon internaltional ltd. */
/**************************************************/
//try {

function QuitSnapCompleteCall(result) {
    // reason: 1 :click ok or save button, snap screen normal complete.
    // 0:cancel by x button or esc key
    // 2:by addmole button
    if (g_add_mole_waiting == true) {
        maxthon.send('closeSnapWindow', [{ reason: 2 }]);
        g_add_mole_waiting = false;
    } else {
        maxthon.send('closeSnapWindow', [{ reason: 1 }]);
    }
}

function QuitSnap(reason) {
    if (reason) {
        var temp_file_params = {
            params: {
                'temp-filename': 'mx3-snap-screen.json',
                'data': JSON.stringify(reason)
            },
            callback: 'QuitSnapCompleteCall'
        };
        maxthon.send("writeTempFile", [temp_file_params]);
    } else {
      maxthon.send('closeSnapWindow', [{reason:0}]);
    }
}

var keys = { 37: 1, 38: 1, 39: 1, 40: 1 };

function scrollPreventFunc(e) {
    e = e || window.event;
    if (e.preventDefault)
        e.preventDefault();
    e.returnValue = true;
}

function preventDefaultForScrollKeys(e) {
    if (keys[e.keyCode]) {
        preventDefault(e);
        return true;
    }
}

function disableScroll() {
    window.onwheel = scrollPreventFunc; // modern standard
    window.onmousewheel = scrollPreventFunc; // older browsers, IE
    document.onmousewheel = scrollPreventFunc; // older browsers, IE
    window.ontouchmove = scrollPreventFunc; // mobile
    document.onkeydown = preventDefaultForScrollKeys;
}

function enableScroll() {
    document.onkeydown = null;
}

var g_device_scale_factor = 1;
(function(){
    uri = parseUri(location);
    var scale_factor_str = uri.queryKey['devicescalefactor'];
	if (scale_factor_str) {
		g_device_scale_factor = parseFloat(scale_factor_str);
	}
})();

	
const GLOBAL_ALPHA = 0.8;
const BORDER_ALPHA = 0.7;
const MAX_LINES = 6;
const TOOL_DIST = 7 * g_device_scale_factor;
const ZOOM_DIST = 10;
const ZOOM_MARGIN = 6;
const TOOLBOX_HEIGHT = 40;
const SUBTOOL_TOPMARGIN = 4 * g_device_scale_factor;
const BRUSH_SIZE_S = 2;
const BRUSH_SIZE_M = 4;
const BRUSH_SIZE_L = 6;
const BLUR_SIZE_S = 15;
const BLUR_SIZE_M = 21;
const BLUR_SIZE_L = 27;
const HIGHLIGHT_SIZE_S = 13;
const HIGHLIGHT_SIZE_M = 19;
const HIGHLIGHT_SIZE_L = 25;
const TEXT_FONT_SEL_WIDTH = 103;
const TEXT_SIZE_SEL_WIDTH = 48;
const BACK_BORDER_WIDTH = 8;
const ZOOM_BORDER_WIDTH = 5;

const ZOOM_VALUE = 8;
const ZOOMPIXEL_HALF_WIDTH = 8;
const ZOOMPIXEL_HALF_HEIGHT = 8;
const ZOOMPIXEL_WIDTH = 2 * ZOOMPIXEL_HALF_WIDTH + 1;
const ZOOMPIXEL_HEIGHT = 2 * ZOOMPIXEL_HALF_HEIGHT + 1;

var g_lang_locale = 'zh-cn';
// -1: init, 0: selecting, 1: resize, 2: start edit 3: text edit 4: bubble edit
var g_step = -1;
var g_title = '';
var g_vscreen = null;
var g_monitors = [];
var g_curpos = null;
var g_zoom = {
    width: -1,
    height: -1
};
var g_sel = null;
var g_tb_sel = null;
var g_tb_sel_init = false;
var g_draw_start = null;
var g_history = [];
var g_sel_list = [];
var g_text_size_sel = null;
var g_text_font_sel = null;
var g_texteditor = null;
var g_bubbles = {};
var g_will_close = false;
var g_update_result = false;
var g_texteditor_tr_start = null;
var g_windows = [];
var g_active_window_inited = false;
var g_toobox_images_loaded = false;
var g_additional_javascripts_loaded = false;
var g_toolbox_in_selbox = false;
var g_bubble_sel_scrollLeft = 0;
var g_default_bubble_loaded = false;
var g_toolbox_dragged = false;
var g_toolbox_drag_start = null;
var g_zoom_in_selbox = false;
var g_selbox_dragged = false;
var g_cache = {};
var g_blur_pos = null;

var g_viewport_w;
var g_viewport_h;
var g_selbox_w;
var g_selbox_h;

var g_default_text_font;
var g_default_text_size;

var g_toolbox_obj = $('#toolbox')[0];
var g_texttool_obj = $('#texttool')[0];
var g_brushtool_obj = $('#brushtool')[0];
var g_blurtool_obj = $('#blurtool')[0];
var g_hightool_obj = $('#hightool')[0];
var g_zoom_obj = $('#zoom')[0];

var g_selbox;
var g_flipInfo = [
    [1, 3],
    [0, 2],
    [3, 1],
    [2, 0]
];
var g_transInfo = ['', 'translate(@w,0) scale(-1,1)', 'translate(@w,0) scale(-1,1) translate(0,@h) scale(1,-1)', 'translate(0,@h) scale(1,-1)'];
var g_flipFlag;
var g_sx, g_sy, g_sw, g_sh;

var g_cursors = {
    blur_s: {
        x: 16,
        y: 16
    },
    blur_m: {
        x: 16,
        y: 16
    },
    blur_l: {
        x: 16,
        y: 16
    },
    brush_s: {
        x: 15,
        y: 15
    },
    brush_m: {
        x: 15,
        y: 15
    },
    brush_l: {
        x: 15,
        y: 15
    },
    highlight_s: {
        x: 15,
        y: 16
    },
    highlight_m: {
        x: 15,
        y: 16
    },
    highlight_l: {
        x: 15,
        y: 16
    },
    precise_positioning: {
        x: 15,
        y: 15
    },
};

var g_selbox_top_line_selected = false;
var g_selbox_left_line_selected = false;

var g_called_by_jsapi = false;

var g_fontfamilys = [];
var g_config_str;
var g_my_pic_dir;
var g_save_file_path = '';
var g_from_note = false;
var g_add_mole_waiting = false;

function GetCursorURL(id) {
    if (!g_cursors[id])
        return;
    var hotpot = g_cursors[id];
    return 'url(image/cursor/' + id + '.cur) ' + hotpot.x + ' ' + hotpot.y + ',auto';
}

function MakeFlipFlag(width, height) {
    var flag = (width >= 0) ? '1' : '0';
    flag += (height >= 0) ? '1' : '0';
    return flag;
}

function GetFlipTransform(flipId, width, height) {
    return g_transInfo[flipId].replace(/@w/g, width).replace(/@h/g, height);
}

function GetSize(id) {
    if (id == 'brush_s')
        return BRUSH_SIZE_S;
    if (id == 'brush_m')
        return BRUSH_SIZE_M;
    if (id == 'brush_l')
        return BRUSH_SIZE_L;
    if (id == 'blur_s')
        return BLUR_SIZE_S;
    if (id == 'blur_m')
        return BLUR_SIZE_M;
    if (id == 'blur_l')
        return BLUR_SIZE_L;
    if (id == 'highlight_s')
        return HIGHLIGHT_SIZE_S;
    if (id == 'highlight_m')
        return HIGHLIGHT_SIZE_M;
    if (id == 'highlight_l')
        return HIGHLIGHT_SIZE_L;
    throw "bad id";
}

//default brush size
var g_brush_size_obj = $('.default_brush')[0];
window.__defineGetter__('g_brush_size', function() {
    return GetSize(g_brush_size_obj.id);
});

//default blur size
var g_blur_size_obj = $('.default_blur')[0];
window.__defineGetter__('g_blur_size', function() {
    return GetSize(g_blur_size_obj.id);
});

//default highlight size
var g_highlight_size_obj = $('.default_highlight')[0];
window.__defineGetter__('g_highlight_size', function() {
    return GetSize(g_highlight_size_obj.id);
});

var g_brush_color_obj = $('.default_brushtool_colorpick')[0];
window.__defineGetter__('g_brush_color', function() {
    return window.getComputedStyle(g_brush_color_obj.firstChild).backgroundColor;
});

var g_text_color_obj = $('.default_texttool_colorpick')[0];
window.__defineGetter__('g_text_color', function() {
    return window.getComputedStyle(g_text_color_obj.firstChild).backgroundColor;
});

var g_high_color_obj = $('.default_hightool_colorpick')[0];
window.__defineGetter__('g_high_color', function() {
    return window.getComputedStyle(g_high_color_obj.firstChild).backgroundColor;
});

var g_bubble_obj = $('.default_bubble')[0];
var g_bubble_init = true;

function PickBubble(obj) {
    if (obj == g_bubble_obj)
        return;
    if (g_step == 4) {
        DrawBubbleDone();
    }
    $(g_bubble_obj).removeClass('bubble_selected').addClass('bubble');
    g_bubble_obj = obj;
    $(g_bubble_obj).removeClass('bubble').addClass('bubble_selected');
    LoadBubble(obj);
}

function PickSize(obj) {
    if (obj.id == 'brush_s' || obj.id == 'brush_m' || obj.id == 'brush_l') {
        if (g_brush_size_obj == obj)
            return;
        $(g_brush_size_obj).removeClass('btn_selected2').addClass('btn');
        g_brush_size_obj = obj;
        $(g_brush_size_obj).removeClass('btn').addClass('btn_selected2');
        if (g_tb_sel == 'tb_brush') {
            SetEditCursor(obj.id);
        }
    } else if (obj.id == 'blur_s' || obj.id == 'blur_m' || obj.id == 'blur_l') {
        if (g_blur_size_obj == obj)
            return;
        $(g_blur_size_obj).removeClass('btn_selected2').addClass('btn');
        g_blur_size_obj = obj;
        $(g_blur_size_obj).removeClass('btn').addClass('btn_selected2');
        SetEditCursor(obj.id);
    } else if (obj.id == 'highlight_s' || obj.id == 'highlight_m' || obj.id == 'highlight_l') {
        if (g_highlight_size_obj == obj)
            return;
        $(g_highlight_size_obj).removeClass('btn_selected2').addClass('btn');
        g_highlight_size_obj = obj;
        $(g_highlight_size_obj).removeClass('btn').addClass('btn_selected2');
        SetEditCursor(obj.id);
    }
}


function PickColor(obj) {
    var type = obj.id.substring(0, obj.id.indexOf('_'));
    if (type == 'brush' && g_brush_color_obj) {
        if (g_brush_color_obj == obj)
            return;
        $(g_brush_color_obj).removeClass('colorpick_selected');
        g_brush_color_obj = obj;
        $(g_brush_color_obj).addClass('colorpick_selected');
        $('#brushtool_colorpick_current').css('background-color', g_brush_color);
    } else if (type == 'text' && g_text_color_obj) {
        if (g_text_color_obj == obj) {
            g_texteditor.Focus();
            return;
        }
        $(g_text_color_obj).removeClass('colorpick_selected');
        g_text_color_obj = obj;
        $(g_text_color_obj).addClass('colorpick_selected');
        $('#texttool_colorpick_current').css('background-color', g_text_color);
        g_texteditor.color = g_text_color;
        g_texteditor.Focus();
    } else if (type == 'high' && g_high_color_obj) {
        if (g_high_color_obj == obj)
            return;
        $(g_high_color_obj).removeClass('colorpick_selected');
        g_high_color_obj = obj;
        $(g_high_color_obj).addClass('colorpick_selected');
        $('#hightool_colorpick_current').css('background-color', g_high_color);
    }
}

function Monitor(left, top_, right, bottom) {
    this.left = left ;
    this.top = top_;
    this.right = right;
    this.bottom = bottom;
    //getters
    this.__defineGetter__('width', function() {
        return this.right - this.left;
    });
    this.__defineGetter__('height', function() {
        return this.bottom - this.top;
    });
    this.inSight = function(x, y) {
        return x >= this.left && x < this.right && y >= this.top && y < this.bottom;
    };
    //
    this.toString = function() {
        return 'Monitor[left=' + this.left + ',top=' + this.top + ',right=' + this.right + ',bottom=' + this.bottom +
            ',width=' + this.width + ',height=' + this.height + ']';
    }
}

function GetMonitorInSight(x, y) {
    for (var i = 0; i < g_monitors.length; i++) {
        var m = g_monitors[i];
        if (m.inSight(x, y))
            return m;
    }
    return null;
}

function DrawZoomView(sx, sy, imageData) {
    var zoomView = document.getElementById('zoomView');
    var ctx = zoomView.getContext('2d');
    for (var x = 0; x < ZOOMPIXEL_WIDTH; x++) {
        for (var y = 0; y < ZOOMPIXEL_HEIGHT; y++) {
            var r, g, b, a;
            if (sx + x < 0 || sx + x > g_vscreen.width - 1 || sy + y < 0 || sy + y > g_vscreen.height - 1) {
                r = g = b = 0;
                a = 255;
            } else {
                var i = (y * ZOOMPIXEL_WIDTH + x) * 4;
                r = imageData.data[i];
                g = imageData.data[i + 1];
                b = imageData.data[i + 2];
                a = imageData.data[i + 3];
            }
            ctx.fillStyle = "rgba(" + r + "," + g + "," + b + "," + (a / 255) + ")";
            ctx.fillRect(x * ZOOM_VALUE, y * ZOOM_VALUE, ZOOM_VALUE, ZOOM_VALUE);
        }
    }
}

function HexIt(val) {
    var s = '';
    if (val < 16)
        s += '0';
    s += val.toString(16).toUpperCase();
    return s;
}

function DrawHotInfo(imageData, x, y) {
    var zoomHotPoint = document.getElementById('zoomHotPoint');
    zoomHotPoint.style.backgroundColor = 'rgb(' + imageData[0] + ',' + imageData[1] + ',' + imageData[2] + ')';
    $('#zoomHotInfo').html(x + 'x' + y + '<br/>' + '#' + HexIt(imageData[0]) + HexIt(imageData[1]) + HexIt(imageData[2]));
}

function GetPreferredZoomViewPos(x, y, indraw) {
    var monitor = GetMonitorInSight(x, y);
    if (g_zoom.width == -1)
        g_zoom.width = $('#zoom').width() + ZOOM_MARGIN;
    if (g_zoom.height == -1)
        g_zoom.height = $('#zoom').height() + ZOOM_MARGIN;
    var dist = g_step == -1 ? ZOOM_DIST : ZOOM_MARGIN;
    var px, py;
    if (indraw && g_sel && $('#selbox').css('display') != 'none') {
        var selbox = $('#selbox');
        sx = selbox.position().left;
        sy = selbox.position().top;
        sw = selbox.width();
        sh = selbox.height();
        px = sx + sw + dist;
        py = sy + sh - g_zoom.height - dist;
        if (px + g_zoom.width > g_vscreen.width) {
            px = sx - dist - g_zoom.width - ZOOM_MARGIN;
            if (px < 0) {
                px = 0;
            }
        }
        if (py < 0) {
            py = 0;
        } else if (py + g_zoom.height + dist > g_vscreen.height) {
            py = g_vscreen.height - g_zoom.height - dist;
        }
    } else {
        px = x + dist;
        if (px + g_zoom.width > monitor.right - 1) {
            px = x - dist - g_zoom.width;
        }
        py = y + dist;
        if (py + g_zoom.height > monitor.bottom - 1) {
            py = y - dist - g_zoom.height;
        }
        /*    py = y - dist - g_zoom.height;
            if (py < monitor.top) {
              py = y + dist;
            }*/
    }
    return {
        left: px,
        top: py
    };
}

function UpdateZoomView(x, y) {
    var orig = document.getElementById('orig');
    var ctx = orig.getContext('2d');
    var sx = x - ZOOMPIXEL_HALF_WIDTH;
    var sy = y - ZOOMPIXEL_HALF_HEIGHT;
    DrawZoomView(sx, sy, ctx.getImageData(sx, sy, ZOOMPIXEL_WIDTH, ZOOMPIXEL_HEIGHT));
    var selbox = $('#selbox');
    var w = h = 0;
    if (selbox.css('display') != 'none') {
        w = g_selbox_dragged ? g_selbox_w : selbox.width();
        h = g_selbox_dragged ? g_selbox_h : selbox.height();
    } else if (g_active_window) {
        w = g_active_window.width;
        h = g_active_window.height;
    }
    DrawHotInfo(ctx.getImageData(x, y, 1, 1).data, w, h);
}

function UpdateAndLocateZoomView(x, y, indraw) {
    UpdateZoomView(x, y);
    var pos = GetPreferredZoomViewPos(x, y, indraw);
    $('#zoom').css('left', pos.left).css('top', pos.top);
}

function DrawEllipse(ctx, x, y, w, h) {
    var kappa = .5522848;
    ox = (w / 2) * kappa, // control point offset horizontal
        oy = (h / 2) * kappa, // control point offset vertical
        xe = x + w, // x-end
        ye = y + h, // y-end
        xm = x + w / 2, // x-middle
        ym = y + h / 2; // y-middle

    ctx.beginPath();
    ctx.moveTo(x, ym);
    ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
    ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
    ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
    ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
    ctx.closePath();
    ctx.stroke();
}

function IsSelboxShouldVisible(w, h) {
    return w > 1 && h > 1;
}

function GetWindowByPos(x, y) {
    for (var i = 0; i < g_windows.length; i++) {
        if (g_windows[i].inSight(x, y))
            return g_windows[i];
    }
    return null;
}

var g_active_window_border_size = parseInt(window.getComputedStyle($('#activewindow')[0]).borderTopWidth);
var g_active_window = null;

function ActiveWindow(x, y) {
    if (g_step != -1)
        return;
    var win = GetWindowByPos(x, y);
    if (!win) {
        $('#activewindow').hide();
        $('#viewport').hide();
        g_active_window = null;
        return;
    }
    if (win == g_active_window)
        return;
    g_active_window = win;
    //zhsoft88: fix MX3BUG-6200 (20110831)
    if (win.left < 0) {
        win.left = 0;
    }
    $('#viewport').css('left', win.left).css('top', win.top).css('width', win.width).css('height', win.height).show().scrollTop(win.top).scrollLeft(win.left);
// { modified at 2021/1/27 by hsrao for fixing bug 20745
    /*var left_ = win.left - g_active_window_border_size;
    var top_ = win.top - g_active_window_border_size;
    $('#activewindow').css('left', left_).css('top', top_).css('width', win.width).css('height', win.height).show();*/
    $('#activewindow').css('left', win.left)
                    .css('top', win.top)
                    .css('width', win.width - 2*g_active_window_border_size )
                    .css('height', win.height -  2*g_active_window_border_size )
                    .show();
// } by hsrao
}

function DrawSelbox(e) {
    if (g_step != 0 || !g_sel)
        return;

    if (g_active_window) {
        $('#activewindow').hide();
        g_active_window = null;
    }

    var x = Math.min(g_sel.sx, e.pageX);
    var y = Math.min(g_sel.sy, e.pageY);
    var w = Math.abs(g_sel.sx - e.pageX) + 1;
    var h = Math.abs(g_sel.sy - e.pageY) + 1;
    $('#selbox').css('left', x - 1).css('top', y - 1).css('width', w).css('height', h);
    $('#viewport').css('left', x).css('top', y).css('width', w).css('height', h).scrollTop(y).scrollLeft(x);
    if (IsSelboxShouldVisible(w, h)) {
        $('#selbox').show();
        $('#viewport').show();
    } else {
        $('#selbox').hide();
        $('#viewport').hide();
    }

    e.preventDefault();

    UpdateAndLocateZoomView(e.pageX, e.pageY, true);
}

function ResizeSelbox(e, ui) {
// { modified at 2021/11/5 by hsrao for bug 777
    if(ui.size && ui.originalSize) {
      var left = ui.position.left;
      var top =  ui.position.top;
      var right = left + ui.size.width;
      var bottom = top + ui.size.height;
      if(ui.originalSize.width != ui.size.width && ui.size.width > 10) {
        if(Math.abs(e.pageX - left) < Math.abs(e.pageX - right)) {
          ui.size.width -= e.pageX - left;
          ui.position.left = e.pageX;
        } else {
          ui.size.width = e.pageX - left;
        }
      }
      if(ui.originalSize.height != ui.size.height && ui.size.height > 10) {
        if(Math.abs(e.pageY - top) < Math.abs(e.pageY - bottom)) {
          ui.size.height -= e.pageY - top;
          ui.position.top = e.pageY;
        } else {
          ui.size.height = e.pageY - top;
        }
      }
    }
// }
    if (ui.size) {
        if (ui.size.width > g_vscreen.width)
            ui.size.width = g_vscreen.width;
        if (ui.size.height > g_vscreen.height)
            ui.size.height = g_vscreen.height;
    }
    if (ui.position.top < -1) {
        if (ui.size) {
            ui.size.height += ui.position.top + 1;
        }
        ui.position.top = -1;
    } else {
        var h = ui.size ? ui.size.height : g_viewport_h;
        if (ui.position.top + h > g_vscreen.height - 1) {
            ui.position.top = g_vscreen.height - 1 - h;
            if (document.body.scrollTop)
                document.body.scrollTop = 0;
        }
    }
    if (ui.position.left < -1) {
        if (ui.size) {
            ui.size.width += ui.position.left + 1;
        }
        ui.position.left = -1;
    } else {
        var w = ui.size ? ui.size.width : g_viewport_w;
        if (ui.position.left + w > g_vscreen.width - 1) {
            ui.position.left = g_vscreen.width - 1 - w;
            if (document.body.scrollLeft)
                document.body.scrollLeft = 0;
        }
    }
    if (ui.size) {
        $('#selbox').css('width', ui.size.width)
            .css('height', ui.size.height)
            .css('top', ui.position.top)
            .css('left', ui.position.left);
        $('#viewport').scrollTop(ui.position.top + 1)
            .scrollLeft(ui.position.left + 1)
// { modified at 2021/11/5 by hsrao for bug 777
            //.css('width', ui.size.width)
            //.css('height', ui.size.height)
            .css('width', ui.size.width-1)
            .css('height', ui.size.height-1)
// }
            .css('top', ui.position.top + 1)
            .css('left', ui.position.left + 1);
    } else {
        $('#selbox').css('top', ui.position.top)
            .css('left', ui.position.left);
        $('#viewport').scrollTop(ui.position.top + 1)
            .scrollLeft(ui.position.left + 1)
            .css('top', ui.position.top + 1)
            .css('left', ui.position.left + 1);
    }
    //
    RelocateToolBoxAndZoomBox(ui);
}

function scaleWidget(widget) {
    if (widget) {
        widget.css('transform-origin', 'left top');
        widget.css('transform', 'scale(' + g_device_scale_factor + ')');
    }
}

function RelocateToolBoxAndZoomBox(ui, resizeon) {
    var dist = TOOL_DIST;
    var sx, sy, sw, sh;
    if (ui) {
        sx = ui.position.left;
        sy = ui.position.top;
        if (ui.size) {
            sw = ui.size.width;
            sh = ui.size.height;
        } else {
            var selbox = $('#selbox');
            sw = g_selbox_dragged ? g_selbox_w : selbox.width();
            sh = g_selbox_dragged ? g_selbox_h : selbox.height();
        }
    } else {
        var selbox = $('#selbox');
        sx = selbox.position().left;
        sy = selbox.position().top;
        sw = selbox.width();
        sh = selbox.height();
    }
    var zw = g_zoom.width;
    var zh = g_zoom.height;
    var zx = sx + sw + dist;
    var zy = sy + sh - g_zoom.height - dist;
    if (zx + g_zoom.width > g_vscreen.width) {
        zx = sx - dist - g_zoom.width - ZOOM_MARGIN;
        if (zx < 0) {
            zx = 0;
        }
    }
    if (zy < 0) {
        zy = 0;
    } else if (zy + g_zoom.height + dist > g_vscreen.height) {
        zy = g_vscreen.height - g_zoom.height - dist;
    }
    $('#zoom').css('left', zx).css('top', zy);
    g_zoom_in_selbox = IsAreaOverlapped2(sx, sy, sw, sh, zx, zy, zw + ZOOM_BORDER_WIDTH, zh + ZOOM_BORDER_WIDTH);
    //
    var toolbox = $('#toolbox');
    scaleWidget(toolbox);
    
    if (!g_toolbox_dragged) {
        var tw = GetCachedWidth('toolbox');
        var th = GetCachedHeight('toolbox');
        var tx = sx + sw - tw - dist;
        var ty = sy + sh + dist;
        if (ty + th > g_vscreen.height) {
            ty = sy - dist - th;
            if (sy >= ty && sy <= ty + th + 2 * dist) {
                if (sy > th + 2 * dist) {
                    ty = sy - 2 * dist - th;
                } else {
                    ty = sy + dist;
                }
            }
        }
        var m1 = GetMonitorInSight(tx, ty);
        var m2 = GetMonitorInSight(tx + tw - 1, ty + th - 1);
        if (m1 != m2) {
            if (m2) {
                tx = m2.left;
                if (ty < m2.top) {
                    ty = m2.top;
                } else if (ty + th > m2.bottom - 1) {
                    ty = m2.bottom - th - 1;
                }
            } else if (m1) {
                tx = m1.right - tw;
                if (ty < m1.top) {
                    ty = m1.top;
                } else if (ty + th > m1.bottom - 1) {
                    ty = m1.bottom - th - 1;
                }
            }
        } else if (!m1 && !m2) {
            m1 = GetMonitorInSight(sx + sw - 1, sy + sh - 1);
            if (m1) {
                tx = m1.right - tw;
                if (ty < m1.top) {
                    ty = m1.top;
                } else if (ty + th > m1.bottom - 1) {
                    ty = m1.bottom - th - 1;
                }
            }
        }
        var mx = Math.max(zx, tx);
        var my = Math.max(zy, ty);
        var nx = Math.min(zx + zw - 1, tx + tw - 1);
        var ny = Math.min(zy + zh - 1, ty + th - 1);
        if (mx >= zx && mx < zx + zw && my >= zy && my < zy + zh &&
            nx >= zx && nx < zx + zw && ny >= zy && ny < zy + zh) {
            ty = zy + zh + dist;
            m1 = GetMonitorInSight(zx, zy + zh - 1);
            m2 = GetMonitorInSight(tx, ty + th - 1);
            if (m1 != m2) {
                ty = Math.min(zy - dist - th, sy - dist - th);
            }
        }
        toolbox.css('left', tx).css('top', ty);
    }
    //check toolbox in selbox
    g_toolbox_in_selbox = IsAreaOverlapped2(sx, sy, sw, sh, toolbox.position().left, toolbox.position().top, GetCachedWidth('toolbox') + BACK_BORDER_WIDTH, GetCachedHeight('toolbox') + BACK_BORDER_WIDTH);
}

function CheckBoxBeforeCopyOrSave() {
    if ($('#cont_vas').css('display') == 'none') {
        CopyViewportToSelvas();
        return true;
    }
    var box = $('#selbox');
    return IsSelboxShouldVisible(box.width(), box.height());
}

function CopyAndExit() {
    CopyToClipboard();
}

var copyClipboardCall;
var tempFileWriteCall;
var g_tempFileName = "";

function CopyToClipboard() {
    copyClipboardCall = function(results) {
        if (g_tempFileName != "") {
            reason = {type: 'copy-to-clipboard', filename: g_tempFileName};
            QuitSnap(reason);
        } else {
            QuitSnap();
        }
    };

    var canvas = GetCanvasObject();
    if (!canvas)
        return null;
    //CleanTempPics(); // copy file not impl now.
    var suffix = 'png';
    var dataurl;
    //if (g_called_by_jsapi) {
    //  var type = g_jsapi_image_type == 'jpeg' ? 'image/jpeg' : 'image/png';
    //  dataurl = canvas.toDataURL(type, g_jsapi_image_quality);
    //  if (g_jsapi_image_type == 'jpeg')
    //    suffix = 'jpg';
    //} else {
    dataurl = canvas.toDataURL();
    //}

    tempFileWriteCall = function(result) {
        var file = result.filepath;
        var ok = result.success;

        if (ok == true) {
            g_tempFileName = result.filepath;
        }

        var copy_params = {
/**                                                
clipboard读取顺序：  html  ---->   (blob/file)
===================================================
                OEClassic  Word   WebPage  Desktop
--------------------------------------------------
<img:local         YES      YES     NO       NO
<img:base64        YES      NO      YES      NO
--------------------------------------------------
blob               NO       YES     YES      NO
--------------------------------------------------
file               NO       NO      NO       YES
===================================================
*/
            params: [
// { modified at 2021/1/25 by hsrao for fixing bug20610
// maxthon note should use CF_DIB format, because if there is a html format in clipboard, 
// some program for example wps which maybe use html format first can't correctly paste.
// mx5 can use CF_DIB correctly, but mx6 failed
            /*{
                type: 'html',
                data: '<img src="' + dataurl + '"/>',
                url:'mx://snap-screen'
            },*/
// }
            {
                type: "canvas-dataurl", // Word2013  WebPage ...
                data: dataurl
            }, {
                type: 'file',           // Desktop ...
                data: result.filepath
            }
        ],
            callback: 'copyClipboardCall'
        };

        maxthon.send('copyToClipboard', [copy_params]);
    };

    var temp_file_params = {
        params: {
            'temp-filename': 'snap_screen_'+ GetTimeStamp() +'.png',
            'data': dataurl
        },
        callback: 'tempFileWriteCall'
    };

    maxthon.send('snapToTempFile', [temp_file_params]);
}

function GetTimeStamp() {
    var d = new Date;
    var s = '';
    s += d.getFullYear();
    if ((d.getMonth() + 1) < 10)
        s += '0';
    s += d.getMonth() + 1;
    if (d.getDate() < 10)
        s += '0';
    s += d.getDate();
    if (d.getHours() < 10)
        s += '0';
    s += d.getHours();
    if (d.getMinutes() < 10)
        s += '0';
    s += d.getMinutes();
    if (d.getSeconds() < 10)
        s += '0';
    s += d.getSeconds();
    return s;
}

function GetCanvasObject() {
    var canvas = null;
    if (g_step == 1) {
        if (!CheckBoxBeforeCopyOrSave())
            return null;
        canvas = $('#selvas')[0];
    } else if (g_step == 2 || g_step == 3 || g_step == 4) {
        canvas = g_update_result ? $('#resultvas')[0] : $('#selvas')[0];
    }
    return canvas;
}

function configWritedCall(result) {
    QuitSnap({type: 'save-to-file', filename: g_save_file_path});
}

function ConfigMan() {
    this.default_config = {
        filterIndex: 1,
        dir: g_my_pic_dir
    };
    this.getConfig = function() {
        try {
            var result = JSON.parse(g_config_str);
            if (typeof(result) != 'object')
                return this.default_config;
            if (typeof(result.filterIndex) != 'number') {
                result.filterIndex = this.default_config.filterIndex;
            } else {
                if (result.filterIndex % 1 != 0) {
                    result.filterIndex = Math.ceil(result.filterIndex);
                }
                if (result.filterIndex < 1 || result.filterIndex > 3) {
                    result.filterIndex = 1;
                }
            }
            if (typeof(result.dir) != 'string')
                result.dir = this.default_config.dir;
            return result;
        } catch (e) {
            return this.default_config;
        }
    };
    this.setConfig = function(result) {
        try {
            var write_config_dict = {
                params: {
                    data: JSON.stringify(result)
                },
                callback: "configWritedCall"
            };

            maxthon.send("writeSnapConfig", [write_config_dict]);
            return true;
        } catch (e) {
            return false;
        }
    };
}

var dialogCall;
var saveCall;

/*! canvas-to-bmp version 1.0 ALPHA
    (c) 2015 Ken "Epistemex" Fyrstenberg
    MIT License (this header required)
*/

var CanvasToBMP = {

  /**
   * Convert a canvas element to ArrayBuffer containing a BMP file
   * with support for 32-bit (alpha).
   *
   * Note that CORS requirement must be fulfilled.
   *
   * @param {HTMLCanvasElement} canvas - the canvas element to convert
   * @return {ArrayBuffer}
   */
  toArrayBuffer: function(canvas) {

    var w = canvas.width,
        h = canvas.height,
        w4 = w * 4,
        idata = canvas.getContext("2d").getImageData(0, 0, w, h),
        data32 = new Uint32Array(idata.data.buffer), // 32-bit representation of canvas

        stride = Math.floor((32 * w + 31) / 32) * 4, // row length incl. padding
        pixelArraySize = stride * h,                 // total bitmap size
        fileLength = 122 + pixelArraySize,           // header size is known + bitmap

        file = new ArrayBuffer(fileLength),          // raw byte buffer (returned)
        view = new DataView(file),                   // handle endian, reg. width etc.
        pos = 0, x, y = 0, p, s = 0, a, v;

    // write file header
    setU16(0x4d42);          // BM
    setU32(fileLength);      // total length
    pos += 4;                // skip unused fields
    setU32(0x7a);            // offset to pixels

    // DIB header
    setU32(108);             // header size
    setU32(w);
    setU32(-h >>> 0);        // negative = top-to-bottom
    setU16(1);               // 1 plane
    setU16(32);              // 32-bits (RGBA)
    setU32(3);               // no compression (BI_BITFIELDS, 3)
    setU32(pixelArraySize);  // bitmap size incl. padding (stride x height)
    setU32(2835);            // pixels/meter h (~72 DPI x 39.3701 inch/m)
    setU32(2835);            // pixels/meter v
    pos += 8;                // skip color/important colors
    setU32(0xff0000);        // red channel mask
    setU32(0xff00);          // green channel mask
    setU32(0xff);            // blue channel mask
    setU32(0xff000000);      // alpha channel mask
    setU32(0x57696e20);      // " win" color space

    // bitmap data, change order of ABGR to BGRA
    while (y < h) {
      p = 0x7a + y * stride; // offset + stride x height
      x = 0;
      while (x < w4) {
        v = data32[s++];                     // get ABGR
        a = v >>> 24;                        // alpha channel
        view.setUint32(p + x, (v << 8) | a); // set BGRA
        x += 4;
      }
      y++
    }

    return file;

    // helper method to move current buffer position
    function setU16(data) {view.setUint16(pos, data, true); pos += 2}
    function setU32(data) {view.setUint32(pos, data, true); pos += 4}
  },

  /**
   * Converts a canvas to BMP file, returns a Blob representing the
   * file. This can be used with URL.createObjectURL().
   * Note that CORS requirement must be fulfilled.
   *
   * @param {HTMLCanvasElement} canvas - the canvas element to convert
   * @return {Blob}
   */
  toBlob: function(canvas) {
    return new Blob([this.toArrayBuffer(canvas)], {
      type: "image/bmp"
    });
  },

  /**
   * Converts the canvas to a data-URI representing a BMP file.
   * Note that CORS requirement must be fulfilled.
   *
   * @param canvas
   * @return {string}
   */
  toDataURL: function(canvas) {
    var buffer = new Uint8Array(this.toArrayBuffer(canvas)),
        bs = "", i = 0, l = buffer.length;
    while (i < l) bs += String.fromCharCode(buffer[i++]);
    return "data:image/bmp;base64," + btoa(bs);
  }
};

function SaveCanvas() {
    var canvas = GetCanvasObject();
    if (!canvas)
        return;
    var man = new ConfigMan;
    var config = man.getConfig();
    var index_from_config = config.filterIndex; // base 1
    var dir = config.dir;
    var filename_str = (function() {
        var fn = dir + '\\' + g_title + GetTimeStamp();
        return fn;
    })();

    var path_from_dialog;
    var index_from_dialog;

    saveCall = function(success) {
        config.filterIndex = index_from_dialog;
        g_save_file_path = path_from_dialog;
        config.dir = path_from_dialog.substr(0, path_from_dialog.lastIndexOf('\\'));
        man.setConfig(config);
        //close window after config saved.
    };

    dialogCall = function(files) {
        if (typeof(files) != 'object' || files.length == 0)
           return;
        path_from_dialog = files[0].filepath;
        index_from_dialog = files[0].index;
        var idx = path_from_dialog.lastIndexOf('.');
        var ext = '';
        if (idx != -1) {
            ext = path_from_dialog.substring(idx);
        }
        var type;
        switch (files[0].index) {
            case 1:
                type = 'image/png';
                if (ext == '')
                    path_from_dialog += '.png';
                index_from_dialog = 1;
                break;
            case 2:
                type = 'image/jpeg';
                if (ext == '')
                    path_from_dialog += '.jpg';
                index_from_dialog = 2;
                break;
            case 3:
                type = 'image/bmp';
                if (ext == '')
                    path_from_dialog += '.bmp';
                index_from_dialog = 3;
                break;
            default:
                type = 'image/png';
                if (ext == '')
                    path_from_dialog += '.png';
                index_from_dialog = 1;
                break;
        }

        var dataurl = type == 'image/bmp' ? CanvasToBMP.toDataURL(canvas) : canvas.toDataURL(type);
        var file_param = {
            params: {
                filepath: path_from_dialog,
                dataurl: dataurl
            },
            callback: "saveCall"
        };
        maxthon.send("snapSaveToFile", [file_param])
    };

    var dialog_params = {
        params: {
            filename: filename_str, //string
            mode: "save", // if save, title is invalid
            accepttypes: [{
                type: [".png"],
                desc: "ImagePng(*.png)"
            }, {
                type: [".jpg"],
                desc: "ImageJpg(*.jpg)"
            }, {
                type: [".bmp"],
                desc: "ImageBmp(*.bmp)"
            }],
            filterindex: index_from_config,
            includeall: false
        },
        callback: "dialogCall" // return arg: filenames []
    };
    maxthon.send("openFileDialog", [dialog_params]);
}

function TBRecover() {
    if (!g_tb_sel)
        return;
    $('#' + g_tb_sel).removeClass('btn_selected1').addClass('btn');
    $('#' + GetSubtoolName(g_tb_sel)).hide();
}

function GetSubtoolName(tb) {
    var name = null;
    switch (tb) {
        case 'tb_rect':
        case 'tb_circle':
        case 'tb_arrow':
        case 'tb_brush':
            name = 'brush';
            break;
        case 'tb_highlight':
            name = 'high';
            break;
        case 'tb_blur':
            name = 'blur';
            break;
        case 'tb_text':
        case 'tb_bubble':
            name = 'text';
            break;
    }
    if (name)
        return name + 'tool';
    return null;
}

function GetCachedWidth(name) {
    var key = name + '_w';
    if (!g_cache[key]) {
        g_cache[key] = $('#' + name).innerWidth();
    }
    return g_cache[key] * g_device_scale_factor;
}

function GetCachedHeight(name) {
    var key = name + '_h';
    if (!g_cache[key] || name == 'texttool') {
        g_cache[key] = $('#' + name).outerHeight();
        //console.log(g_cache[key]);
    }
    return g_cache[key] * g_device_scale_factor;
}

function RelocateSubtool() {
    var sx = g_toolbox_drag_start ? g_toolbox_drag_start.selbox_x : $('#selbox').position().left;
    var sy = g_toolbox_drag_start ? g_toolbox_drag_start.selbox_y : $('#selbox').position().top;
    var sw = g_toolbox_drag_start ? g_toolbox_drag_start.selbox_w : $('#selbox').width();
    var sh = g_toolbox_drag_start ? g_toolbox_drag_start.selbox_h : $('#selbox').height();
    var tx = $('#toolbox').position().left;
    var ty = $('#toolbox').position().top;
    var tw = GetCachedWidth('toolbox');
    var th = GetCachedHeight('toolbox');
    var name = GetSubtoolName(g_tb_sel);
    if (!name) {
        g_toolbox_in_selbox = IsAreaOverlapped2(sx, sy, sw, sh, tx, ty, tw + BACK_BORDER_WIDTH, th + BACK_BORDER_WIDTH);
        return false;
    }
	scaleWidget($('#' + name));

    var offset = $('#toolbox').offset();
    var x = offset.left;
    var y = offset.top + TOOLBOX_HEIGHT + SUBTOOL_TOPMARGIN;
    var w = GetCachedWidth(name);
    var h = GetCachedHeight(name);
    var m1 = GetMonitorInSight(offset.left, offset.top);
    var m2 = GetMonitorInSight(x + w - 1, y + h - 1);
    if (m1 != m2) {
        y = offset.top - h - 2 * SUBTOOL_TOPMARGIN;
        $('#' + name).css('top', y).css('left', x);
    } else if (!g_toolbox_dragged && y + h >= g_selbox.sy && y + h <= g_selbox.ey) {
        if (g_selbox.sy > TOOLBOX_HEIGHT + 2 * SUBTOOL_TOPMARGIN + h) {
            var ty = g_selbox.sy - TOOLBOX_HEIGHT - 2 * SUBTOOL_TOPMARGIN - 1;
            if (ty < 0) {
                ty = 0;
            }
            $('#toolbox').css('top', ty);
            var t = ty - 2 * SUBTOOL_TOPMARGIN - h;
            if (t < 0) {
                t = ty + TOOLBOX_HEIGHT + SUBTOOL_TOPMARGIN;
            }
            var m2 = GetMonitorInSight(x, t);
            if (!m2) {
                t = ty + TOOLBOX_HEIGHT + SUBTOOL_TOPMARGIN;
            }
            $('#' + name).css('top', t).css('left', x);
        } else {
            var t = offset.top - h - 2 * SUBTOOL_TOPMARGIN;
            if (t < 0) {
                t = offset.top + TOOLBOX_HEIGHT + SUBTOOL_TOPMARGIN;
            }
            var m2 = GetMonitorInSight(x, t);
            if (!m2) {
                t = offset.top + TOOLBOX_HEIGHT + SUBTOOL_TOPMARGIN;
            }
            $('#' + name).css('top', t).css('left', x);
        }
    } else {
        $('#' + name).css('top', y).css('left', x);
    }
    //check tool & selbox overlapped
    tx = $('#toolbox').position().left;
    ty = $('#toolbox').position().top;
    g_toolbox_in_selbox = IsAreaOverlapped2(sx, sy, sw, sh, tx, ty, tw + BACK_BORDER_WIDTH, th + BACK_BORDER_WIDTH) || IsAreaOverlapped2(sx, sy, sw, sh, $('#' + name).position().left, $('#' + name).position().top, w + BACK_BORDER_WIDTH, h + BACK_BORDER_WIDTH);
    return true;
}

function IsAreaOverlapped2(sx, sy, sw, sh, tx, ty, tw, th) {
    var mx = Math.max(sx, tx);
    var my = Math.max(sy, ty);
    var nx = Math.min(sx + sw - 1, tx + tw - 1);
    var ny = Math.min(sy + sh - 1, ty + th - 1);
    return mx >= sx && mx < sx + sw && my >= sy && my < sy + sh &&
        nx >= sx && nx < sx + sw && ny >= sy && ny < sy + sh;
}

function SetEditCursor(id) {
// { modified at 2021/7/23 by hsrao for bug 344
  //$('#tempvas').css('cursor', GetCursorURL(id));
// { modified at 2021/8/31 by hsrao for bug 529
// only custom blur cursor
  let cursor = GetCursorURL(id);
  if( !cursor ) {
    if(id == "precise_positioning")
      $('#tempvas').css('cursor', GetCrosshairCursor());
    else
      $('#tempvas').css('cursor', 'default');
  }else {
    $('#tempvas').css('cursor', cursor);
  }
// }
// }  
}

function TBSelect(id) {
    if (!g_tb_sel_init) {
        $('#selbox').resizable("destroy").draggable('destroy').css('cursor', 'default');
        $('*[class*="dragresize"]').addClass('default-cursor');
        g_tb_sel_init = true;
    }
    if (g_tb_sel == id) {
        return;
        //    var toolsel = $('#' + GetSubtoolName(g_tb_sel));
        /*    var sel = $('#' + g_tb_sel);
            if (toolsel.css('display') == 'none') {
              sel.removeClass('btn').addClass('btn_selected1');
              g_tb_sel = id;
            } else {
              sel.removeClass('btn_selected1').addClass('btn');
              g_tb_sel = null;
            }*/
        /*    if (toolsel.css('display') != 'none' && id == 'tb_bubble') {
              g_bubble_sel_scrollLeft = $('#bubble_sel').scrollLeft();
            }
            toolsel.toggle();
            if (toolsel.css('display') != 'none' && id == 'tb_bubble') {
              $('#bubble_sel').scrollLeft(g_bubble_sel_scrollLeft);
            }*/
    } else {
        if (g_tb_sel) {
            var sel = $('#' + g_tb_sel);
            sel.removeClass('btn_selected1').addClass('btn');
            if (g_tb_sel == 'tb_bubble') {
                g_bubble_sel_scrollLeft = $('#bubble_sel').scrollLeft();
            }
            $('#' + GetSubtoolName(g_tb_sel)).hide();
        }
        g_tb_sel = id;
        $('#' + g_tb_sel).removeClass('btn').addClass('btn_selected1');
        if (id == 'tb_text') {
            $('#bubble_sel').hide();
        } else if (id == 'tb_bubble') {
            if (!g_default_bubble_loaded) {
                LoadBubble($('.bubble_selected')[0]);
                g_default_bubble_loaded = true;
            }
            $('#bubble_sel').show();
        }
        $('#' + GetSubtoolName(g_tb_sel)).show();
        if (id == 'tb_bubble') {
            if (g_bubble_init) {
                $('#bubble_sel').scrollLeft($('.bubble_selected')[0].offsetLeft);
                g_bubble_init = false;
                g_bubble_sel_scrollLeft = $('#bubble_sel').scrollLeft();
            } else {
                $('#bubble_sel').scrollLeft(g_bubble_sel_scrollLeft);
            }
        }
        RelocateSubtool();
    }
    //
    switch (id) {
        case 'tb_rect':
        case 'tb_circle':
        case 'tb_arrow':
        case 'tb_text':
        case 'tb_bubble':
            SetEditCursor('precise_positioning');
            break;
        case 'tb_brush':
            SetEditCursor(g_brush_size_obj.id);
            break;
        case 'tb_highlight':
            SetEditCursor(g_highlight_size_obj.id);
            break;
        case 'tb_blur':
            SetEditCursor(g_blur_size_obj.id);
            break;
    }
}

function HideCurrentBubble() {
    if ($('#cont_' + g_bubble_obj.id).css('display') == 'none')
        return;
    $('#cont_' + g_bubble_obj.id).css('width', 0).css('height', 0).hide();
}

function HideTextEditor() {
    if ($(g_texteditor.container).css('display') == 'none')
        return;
    $(g_texteditor.container).css('width', 0).css('height', 0).hide();
}

function TBUndo() {
    HideCurrentBubble();
    HideTextEditor();
    if (g_history.length == 0) {
        RestoreToInitMode();
        return;
    }
    if (g_step == 3 || g_step == 4) {
        g_step = 2;
        return;
    }
    UndoOnce();
}

function UndoOnce() {
    var history = g_history.pop();
    if (!history)
        return false;

    var canvas = $('#selvas')[0];
    var ctx = canvas.getContext('2d');
    ctx.putImageData(history.data, 0, 0);

    UpdateResult();
    return true;
}

function CommitChange() {
    if (g_step == 3) {
        DrawTextDone();
    } else if (g_step == 4) {
        DrawBubbleDone();
    }
}

function TBSave() {
    CommitChange();
    SaveCanvas();
}

function TBCancel() {
    QuitSnap();
}

function TBOK() {
    CommitChange();
    CopyAndExit();
}

function TBAddMole() {
    if (g_add_mole_waiting == true)
        return;

    CommitChange();
    CopyAndExit();

    g_add_mole_waiting = true;
}

function CopyViewportToSelvas() {
    var width = $('#viewport').width();
    var height = $('#viewport').height();
    if (width > 0 && height > 0) {
        var selvas = $('#selvas');
        selvas[0].width = width;
        selvas[0].height = height;
        var ctx = selvas[0].getContext('2d');
        var x = $('#viewport').scrollLeft();
        var y = $('#viewport').scrollTop();
        ctx.drawImage($('#orig')[0], x, y, width, height, 0, 0, width, height);
    }
    return {
        width: width,
        height: height
    };
}

function BeforeEdit() {
    var v = CopyViewportToSelvas();
    if (v.width < 1 || v.height < 1)
        return;

    //set cursor
    //$('#tempvas').css('cursor', 'url(image/cursor/blur_3.cur) 16 16'); //crosshair');

    var tempvas = $('#tempvas');
    tempvas.attr('width', v.width).attr('height', v.height).show();

    $('#cont_vas').show();

    g_selbox = {
        sx: $('#selbox').position().left,
        sy: $('#selbox').position().top,
        width: $('#selbox').width(),
        height: $('#selbox').height(),
        ex: 0,
        ey: 0,
    };
    g_selbox.ex = g_selbox.sx + g_selbox.width;
    g_selbox.ey = g_selbox.sy + g_selbox.height;
}

function OnTBClicked(id) {
    switch (id) {
        case 'tb_undo':
            TBUndo();
            break;
        case 'tb_save':
            TBSave();
            break;
        case 'tb_cancel':
            TBCancel();
            break;
        case 'tb_ok':
            TBOK();
            break;
        case 'tb_addmole':
            TBAddMole();
            break;
        default:
            if (g_step == 3) {
                if (id == 'tb_text')
                    return;
                DrawTextDone();
            } else if (g_step == 4) {
                if (id == 'tb_bubble')
                    return;
                DrawBubbleDone();
            }
            if (g_step != 2) {
                g_step = 2;
                BeforeEdit();
            }
            TBSelect(id);
            break;
    }
}

function InSelBox(ex, ey) {
    var selbox = $('#selbox');
    var x = selbox.position().left;
    var y = selbox.position().top;
    if (ex >= x && ex < x + selbox.width() &&
        ey >= y && ey < y + selbox.height())
        return true;
    return false;
}

function MakeToolBox() {
    var tool_tips = [
        templateData.Tooltip_rect,
        templateData.Tooltip_circle,
        templateData.Tooltip_arrow,
        templateData.Tooltip_brush,
        templateData.Tooltip_highlight,
        templateData.Tooltip_blur,
        templateData.Tooltip_text,
        templateData.Tooltip_bubble,
        templateData.Tooltip_undo,
        templateData.Tooltip_save,
        templateData.Tooltip_addmole,
        templateData.Tooltip_cancel,
        templateData.Tooltip_ok
    ];
    var tool_tip_drag = templateData.Tooltip_drag;
    var tools = ['rect', 'circle', 'arrow', 'brush', 'highlight', 'blur', 'text', 'bubble', 'undo', 'save', 'addmole', 'cancel', 'ok'];
    for (var i = 0; i < tools.length; i++) {
        $('#tb_' + tools[i]).click(function(e) {
            OnTBClicked($(this).attr('id'));
        }).attr('title', tool_tips[i]);
    }
    $('#tb_drag').attr('title', tool_tip_drag);
}

function AdjustDrawLocation(e) {
    var canvas = $('#tempvas')[0];
    var offset = $('#tempvas').offset();
    var x = Math.min(g_draw_start.x, e.pageX) - offset.left;
    var y = Math.min(g_draw_start.y, e.pageY) - offset.top;
    var w = Math.abs(e.pageX - g_draw_start.x);
    var h = Math.abs(e.pageY - g_draw_start.y);
    if (x < 0) {
        w += x;
        x = 0;
    } else if (x + w > canvas.width) {
        w = canvas.width - x;
    }
    if (y < 0) {
        h += y;
        y = 0;
    } else if (y + h > canvas.height) {
        h = canvas.height - y;
    }
    return {
        x: x,
        y: y,
        width: w,
        height: h
    };
}

function DrawRect(e) {
    var canvas = $('#tempvas')[0];
    var ctx = canvas.getContext('2d');
    ctx.save();
    ctx.strokeStyle = g_brush_color;
    ctx.lineWidth = g_brush_size;
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    var loc = AdjustDrawLocation(e);
    ctx.strokeRect(loc.x, loc.y, loc.width, loc.height);
    ctx.restore();
}

function ShowTextEditor(show) {
    if (show) {
        $(g_texteditor.container).show();
        $(g_texteditor.br).show();
        $(g_texteditor.tr).show();
    } else {
        $(g_texteditor.container).hide();
        $(g_texteditor.br).hide();
        $(g_texteditor.tr).hide();
    }
}

function MoveTextEditor(e) {
    var offset = $('#tempvas').offset();
    var loc = AdjustDrawLocation(e);
    var w = loc.width - 1;
    if (w < 0)
        w = 0;
    var h = loc.height - 1;
    if (h < 0)
        h = 0;
    $(g_texteditor.container).css('left', loc.x + offset.left).css('top', loc.y + offset.top).css('width', w).css('height', h);
    ShowTextEditor(w && h);
}

function MoveBubble(e) {
    if (g_draw_start && g_draw_start.x == e.pageX && g_draw_start.y == e.pageY) {
        $('#cont_' + id).hide();
        $(g_texteditor.container).hide();
        return;
    }
    var offset = $('#tempvas').offset();
    var loc = AdjustDrawLocation(e);
    var id = g_bubble_obj.id;
    $('#cont_' + id).css('left', loc.x + offset.left - 1).css('top', loc.y + offset.top - 1).css('width', loc.width).css('height', loc.height).show();
    var flipId = 0;
    if (e.pageX >= g_draw_start.x && e.pageY >= g_draw_start.y) {
        flipId = 0;
    } else if (e.pageX < g_draw_start.x && e.pageY >= g_draw_start.y) {
        flipId = 1;
    } else if (e.pageX < g_draw_start.x && e.pageY < g_draw_start.y) {
        flipId = 2;
    } else if (e.pageX >= g_draw_start.x && e.pageY < g_draw_start.y) {
        flipId = 3;
    }
    $('#group_' + id)[0].setAttribute('flipId', flipId);
    ResizeSVG(id, loc.width - 2, loc.height - 2);
}

function DrawCircle(e) {
    var canvas = $('#tempvas')[0];
    var ctx = canvas.getContext('2d');
    ctx.save();
    ctx.strokeStyle = g_brush_color;
    ctx.lineWidth = g_brush_size;
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    var loc = AdjustDrawLocation(e);
    DrawEllipse(ctx, loc.x, loc.y, loc.width, loc.height);
    ctx.restore();
}

function GetArrowLocation(e) {
    var canvas = $('#tempvas');
    var offset = canvas.offset();
    var dx1 = Math.abs(g_draw_start.x - offset.left);
    var dx2 = canvas[0].width - dx1;
    var dy1 = Math.abs(g_draw_start.y - offset.top);
    var dy2 = canvas[0].height - dy1;
    var ex = e.pageX;
    var ey = e.pageY;
    if (ex > g_draw_start.x + dx2 ||
        ex < offset.left ||
        ey > g_draw_start.y + dy2 ||
        ey < offset.top) {
        var dh = Math.abs(ey - g_draw_start.y) / Math.abs(ex - g_draw_start.x);
        var dw = Math.abs(ex - g_draw_start.x) / Math.abs(ey - g_draw_start.y);
        if (ex > g_draw_start.x) {
            dh *= dx2;
            if (ey > g_draw_start.y) {
                if (dh > dy2) {
                    dw *= dy2;
                    ex = g_draw_start.x + dw;
                    ey = g_draw_start.y + dy2;
                } else {
                    ex = g_draw_start.x + dx2;
                    ey = g_draw_start.y + dh;
                }
            } else {
                if (dh > dy1) {
                    dw *= dy1;
                    ex = g_draw_start.x + dw;
                    ey = g_draw_start.y - dy1;
                } else {
                    ex = g_draw_start.x + dx2;
                    ey = g_draw_start.y - dh;
                }
            }
        } else {
            dh *= dx1;
            if (ey > g_draw_start.y) {
                if (dh > dy2) {
                    dw *= dy2;
                    ex = g_draw_start.x - dw;
                    ey = g_draw_start.y + dy2;
                } else {
                    ex = offset.left;
                    ey = g_draw_start.y + dh;
                }
            } else {
                if (dh > dy1) {
                    dw *= dy1;
                    ex = g_draw_start.x - dw;
                    ey = g_draw_start.y - dy1;
                } else {
                    ex = offset.left;
                    ey = g_draw_start.y - dh;
                }
            }
        }
    }
    var x0 = g_draw_start.x - offset.left;
    var y0 = g_draw_start.y - offset.top;
    var x1 = ex - offset.left;
    var y1 = ey - offset.top;
    return {
        x0: x0,
        y0: y0,
        x1: x1,
        y1: y1
    };
}

function DrawArrow(e) {
    var canvas = $('#tempvas')[0];
    var ctx = canvas.getContext('2d');
    ctx.save();
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    var loc = GetArrowLocation(e);
    var x0 = loc.x0;
    var y0 = loc.y0;
    var x1 = loc.x1;
    var y1 = loc.y1;
    if (x0 == x1 && y0 == y1)
        return;
    var a = y1 - y0;
    var b = x1 - x0;
    var c = Math.sqrt(a * a + b * b);
    const H = 18;
    var D = 15;
    if (g_brush_size == BRUSH_SIZE_L) {
        D = 20;
    }
    var L = H * Math.tan(D * Math.PI / 180);
    var S = H / Math.cos(D * Math.PI / 180);
    var w0 = H * b / c;
    var h0 = Math.sqrt(H * H - w0 * w0);
    var DR = Math.atan2(a, b) * 180 / Math.PI;
    var x2 = x1 - w0;
    var y2 = DR < 0 ? y1 + h0 : y1 - h0;
    var D2 = 90 - D - Math.abs(DR);
    var w1, h1, w2, h2, x3, y3;
    if (DR < 0) {
        w1 = S * Math.sin(D2 * Math.PI / 180);
        h1 = S * Math.cos(D2 * Math.PI / 180);
        var D3 = 90 - Math.abs(DR);
        h2 = L * Math.sin(D3 * Math.PI / 180);
        w2 = L * Math.cos(D3 * Math.PI / 180);
        x3 = x2 - w2;
        y3 = y2 - h2;
    } else {
        var D4 = 180 - 2 * D - D2;
        w1 = S * Math.sin(D4 * Math.PI / 180);
        h1 = S * Math.cos(D4 * Math.PI / 180);
        w2 = S * Math.sin(D2 * Math.PI / 180);
        h2 = S * Math.cos(D2 * Math.PI / 180);
        x3 = x1 - w2;
        y3 = y1 - h2;
    }
    var x4 = x1 - w1;
    var y4 = y1 + h1;
    ctx.strokeStyle = g_brush_color;
    ctx.fillStyle = g_brush_color;
    ctx.lineWidth = g_brush_size;
    ctx.beginPath();
    ctx.moveTo(x0, y0);
    ctx.lineTo(x2, y2);
    ctx.closePath();
    ctx.stroke();
    ctx.beginPath();
    ctx.moveTo(x2, y2);
    ctx.moveTo(x3, y3);
    ctx.lineTo(x1, y1);
    ctx.lineTo(x4, y4);
    ctx.closePath();
    ctx.fill();
    ctx.restore();
}

function DrawBrush(e) {
    var canvas = $('#tempvas')[0];
    var offset = $('#tempvas').offset();
    var ctx = canvas.getContext('2d');
    if (e.pageX > offset.left + canvas.width ||
        e.pageX < offset.left ||
        e.pageY > offset.top + canvas.height ||
        e.pageY < offset.top)
        return;
    ctx.lineTo(e.pageX - offset.left, e.pageY - offset.top);
    ctx.stroke();
}

function DrawHighlight(e) {
    var canvas = $('#selvas')[0];
    var offset = $('#selvas').offset();
    var ctx = canvas.getContext('2d');
    if (e.pageX > offset.left + canvas.width ||
        e.pageX < offset.left ||
        e.pageY > offset.top + canvas.height ||
        e.pageY < offset.top)
        return;
    ctx.lineTo(e.pageX - offset.left, e.pageY - offset.top);
    ctx.stroke();
}

function DrawBlur(e) {
    BlurLineTo(e);
}

function BlurStart(e) {
    var canvas = $('#selvas')[0];
    var offset = $('#selvas').offset();
    var x = e.pageX - offset.left;
    var y = e.pageY - offset.top;
    g_blur_pos = {
        x: x,
        y: y,
        offset: offset,
        width: canvas.width,
        height: canvas.height,
        hs: Math.ceil(g_blur_size / 2)
    };
    stackBlurCanvasRGBA('selvas', x - g_blur_pos.hs, y - g_blur_pos.hs, g_blur_size, g_blur_size, 2);
}

function BlurLineTo(e) {
    if (e.pageX > g_blur_pos.offset.left + g_blur_pos.width ||
        e.pageX < g_blur_pos.offset.left ||
        e.pageY > g_blur_pos.offset.top + g_blur_pos.height ||
        e.pageY < g_blur_pos.offset.top)
        return;
    var x = e.pageX - g_blur_pos.offset.left;
    var y = e.pageY - g_blur_pos.offset.top;
    if (g_blur_pos.x == x && g_blur_pos.y == y)
        return;
    var dx = x - g_blur_pos.x;
    var dy = y - g_blur_pos.y;
    if (dx == 0) {
        var rx = x - g_blur_pos.hs;
        if (y > g_blur_pos.y) {
            for (var i = g_blur_pos.y; i <= y; i++) {
                stackBlurCanvasRGBA('selvas', rx, i - g_blur_pos.hs, g_blur_size, g_blur_size, 2);
            }
        } else {
            for (var i = g_blur_pos.y; i >= y; i--) {
                stackBlurCanvasRGBA('selvas', rx, i - g_blur_pos.hs, g_blur_size, g_blur_size, 2);
            }
        }
    } else if (dy == 0) {
        var ry = y - g_blur_pos.hs;
        if (x > g_blur_pos.x) {
            for (var i = g_blur_pos.x; i <= x; i++) {
                stackBlurCanvasRGBA('selvas', i - g_blur_pos.hs, ry, g_blur_size, g_blur_size, 2);
            }
        } else {
            for (var i = g_blur_pos.x; i >= x; i--) {
                stackBlurCanvasRGBA('selvas', i - g_blur_pos.hs, ry, g_blur_size, g_blur_size, 2);
            }
        }
    } else {
        var delta = Math.abs(dy / dx);
        if (x > g_blur_pos.x && y < g_blur_pos.y) {
            //up right
            for (var i = g_blur_pos.x, j = g_blur_pos.y; i <= x; i++, j -= delta) {
                stackBlurCanvasRGBA('selvas', i - g_blur_pos.hs, j - g_blur_pos.hs, g_blur_size, g_blur_size, 2);
            }
        } else if (x > g_blur_pos.x && y > g_blur_pos.y) {
            //down right
            for (var i = g_blur_pos.x, j = g_blur_pos.y; i <= x; i++, j += delta) {
                stackBlurCanvasRGBA('selvas', i - g_blur_pos.hs, j - g_blur_pos.hs, g_blur_size, g_blur_size, 2);
            }
        } else if (x < g_blur_pos.x && y < g_blur_pos.y) {
            //up left
            for (var i = g_blur_pos.x, j = g_blur_pos.y; i >= x; i--, j -= delta) {
                stackBlurCanvasRGBA('selvas', i - g_blur_pos.hs, j - g_blur_pos.hs, g_blur_size, g_blur_size, 2);
            }
        } else if (x < g_blur_pos.x && y > g_blur_pos.y) {
            //down left
            for (var i = g_blur_pos.x, j = g_blur_pos.y; i >= x; i--, j += delta) {
                stackBlurCanvasRGBA('selvas', i - g_blur_pos.hs, j - g_blur_pos.hs, g_blur_size, g_blur_size, 2);
            }
        }
    }
    g_blur_pos.x = x;
    g_blur_pos.y = y;
}

function BlurStop(e) {
    g_blur_pos = null;
}

function UpdateHistory() {
    var canvas = $('#selvas')[0];
    var ctx = canvas.getContext('2d');
    g_history.push({
        back: false,
        data: ctx.getImageData(0, 0, canvas.width, canvas.height)
    });
}

function ResizeSVG(id, w, h) {
    if (w < 0) {
        w = 0;
    }
    if (h < 0) {
        h = 0;
    }
    var sw = w / g_bubbles[id].width;
    var sh = h / g_bubbles[id].height;
    $('#svg_' + id).attr('width', w + 'px').attr('height', h + 'px');
    var g = $('#group_' + id)[0];
    var flipId = g.getAttribute('flipId');
    flipId = flipId ? parseInt(flipId) : 0;
    var trans = GetFlipTransform(flipId, w, h) + ' scale(' + sw + ',' + sh + ')';
    g.setAttribute('transform', trans);
    //
    var edit = g_bubbles[id].edit;
    var offset = $('#cont_' + id).offset();
    const border_width = 1;
    var tx = offset.left + border_width + edit.pos[flipId].x * sw;
    var ty = offset.top + border_width + edit.pos[flipId].y * sh;
    var tw = edit.width * sw;
    var th = edit.height * sh;
    if (tw < 0)
        tw = 0;
    if (th < 0)
        th = 0;
    $(g_texteditor.container).css('left', tx).css('top', ty).css('width', tw).css('height', th);
    g_texteditor.Redraw();
    $('#cont_' + id).show();
    $(g_texteditor.container).show();
}

function MoveTextEditorInBubble(id, flipId, sw, sh) {
    var edit = g_bubbles[id].edit;
    var offset = $('#cont_' + id).offset();
    const border_width = 1;
    var tx = offset.left + border_width + edit.pos[flipId].x * sw;
    var ty = offset.top + border_width + edit.pos[flipId].y * sh;
    $(g_texteditor.container).css('left', tx).css('top', ty);
}

function ShowTool(show) {
    if (show) {
        if (g_tb_sel)
            $('#' + GetSubtoolName(g_tb_sel)).show();
        $('#toolbox').show();
    } else {
        if (g_tb_sel)
            $('#' + GetSubtoolName(g_tb_sel)).hide();
        $('#toolbox').hide();
    }
}

function DrawStart(e) {
    if (g_toolbox_in_selbox) {
        ShowTool(false);
    }
    if (g_zoom_in_selbox) {
        $('#zoom').hide();
    }
    if (g_step == 2 && g_tb_sel == 'tb_text') {
        //
    } else if (g_step == 2 && g_tb_sel == 'tb_bubble') {
        //
    } else {
        UpdateHistory();
    }
    switch (g_tb_sel) {
        case 'tb_blur':
            BlurStart(e);
            break;
        case 'tb_brush':
            (function() {
                var canvas = $('#tempvas')[0];
                var ctx = canvas.getContext('2d');
                ctx.save();
                ctx.strokeStyle = g_brush_color;
                ctx.lineWidth = g_brush_size;
                ctx.lineJoin = 'round';
                ctx.lineCap = 'round';
                ctx.beginPath();
                var offset = $('#tempvas').offset();
                ctx.moveTo(e.pageX - offset.left, e.pageY - offset.top);
            })();
            break;
        case 'tb_highlight':
            (function() {
                var canvas = $('#selvas')[0];
                var ctx = canvas.getContext('2d');
                ctx.save();
                ctx.strokeStyle = g_high_color;
                ctx.lineWidth = g_highlight_size;
                ctx.globalCompositeOperation = 'darken';
                ctx.lineCap = 'butt';
                ctx.lineJoin = 'round';
                ctx.beginPath();
                var offset = $('#selvas').offset();
                ctx.moveTo(e.pageX - offset.left, e.pageY - offset.top);
            })();
            break;
        case 'tb_bubble':
            $('#group_' + g_bubble_obj.id)[0].removeAttribute('flipId');
            //ResizeSVG(g_bubble_obj.id, 0, 0);
            $('#cont_' + g_bubble_obj.id).resizable({
                handles: 'all',
                minWidth: 0,
                minHeight: 0,
                start: function(e, ui) {
                    g_sx = $(this).offset().left;
                    g_sy = $(this).offset().top;
                    g_sw = ui.size.width;
                    g_sh = ui.size.height;
                    g_flipFlag = MakeFlipFlag(ui.size.width, ui.size.height);
                },
                resize: function(e, ui) {
                    var x = ui.position.left;
                    var y = ui.position.top;
                    var w = ui.size.width;
                    var h = ui.size.height;
                    //console.log('ui: x='+x+',y='+y+',w='+w+',h='+h)
                    if (ui.position.left == g_sx && ui.position.top == g_sy) {
                        //console.log('bottom/right handle')
                        if (w < 0) {
                            x = e.pageX;
                            w = Math.abs(w);
                        }
                        if (h < 0) {
                            y = e.pageY;
                            h = Math.abs(h);
                        }
                    } else if (ui.position.left == g_sx) {
                        //console.log('top handle')
                        if (w < 0) {
                            x = e.pageX;
                            w = Math.abs(w);
                        }
                        if (h < 0) {
                            y = g_sy + g_sh - 1;
                            h = Math.abs(h);
                        }
                    } else if (ui.position.top == g_sy) {
                        //console.log('left handle')
                        if (w < 0) {
                            x = g_sx + g_sw - 1;
                            w = Math.abs(w);
                        }
                        if (h < 0) {
                            y = e.pageY;
                            h = Math.abs(h);
                        }
                    } else {
                        //console.log('top/left handle')
                        if (w < 0) {
                            x = g_sx + g_sw - 1;
                            w = Math.abs(w);
                        }
                        if (h < 0) {
                            y = g_sy + g_sh - 1;
                            h = Math.abs(h);
                        }
                    }
                    if (x < g_selbox.sx) {
                        w += x - g_selbox.sx;
                        x = g_selbox.sx;
                    }
                    if (x + w > g_selbox.ex) {
                        w = g_selbox.ex - x;
                    }
                    if (y < g_selbox.sy) {
                        h += y - g_selbox.sy;
                        y = g_selbox.sy;
                    }
                    if (y + h > g_selbox.ey) {
                        h = g_selbox.ey - y;
                    }
                    $(this).css('left', x).css('top', y).css('width', w).css('height', h);
                    //flip
                    var flipFlag = MakeFlipFlag(ui.size.width, ui.size.height);
                    var g = $(this)[0].querySelector('g[id]');
                    var flipId = g.getAttribute('flipId');
                    flipId = flipId ? parseInt(flipId) : 0;
                    if (g_flipFlag != flipFlag) {
                        if (flipFlag[0] != g_flipFlag[0]) {
                            //flip hhh
                            flipId = g_flipInfo[flipId][0];
                            g.setAttribute('flipId', flipId);
                        }
                        if (flipFlag[1] != g_flipFlag[1]) {
                            //flip vvv
                            flipId = g_flipInfo[flipId][1];
                            g.setAttribute('flipId', flipId);
                        }
                        //
                        g_flipFlag = flipFlag;
                    }
                    ResizeSVG(g_bubble_obj.id, w - 2, h - 2);
                },
                stop: function(e, ui) {
                    g_texteditor.Focus();
                },
            }).draggable({
                start: function(e, ui) {
                    var id = g_bubble_obj.id;
                    var g = $('#group_' + id)[0];
                    var flipId = g.getAttribute('flipId');
                    flipId = flipId ? parseInt(flipId) : 0;
                    var w = parseInt($('#svg_' + id).attr('width'));
                    var h = parseInt($('#svg_' + id).attr('height'));
                    var sw = w / g_bubbles[id].width;
                    var sh = h / g_bubbles[id].height;
                    $(this).data('id', id).data('flipId', flipId).data('sw', sw).data('sh', sh).data('tw', $(this).width()).data('th', $(this).height());
                },
                drag: function(e, ui) {
                    var seloff = $('#selbox').offset();
                    var tw = $(this).data('tw');
                    var th = $(this).data('th');
                    if (ui.position.left < seloff.left) {
                        ui.position.left = seloff.left;
                    } else if (ui.position.left + tw > seloff.left + g_selbox.width) {
                        ui.position.left = seloff.left + g_selbox.width - tw;
                    }
                    if (ui.position.top < seloff.top) {
                        ui.position.top = seloff.top;
                    } else if (ui.position.top + th > seloff.top + g_selbox.height) {
                        ui.position.top = seloff.top + g_selbox.height - th;
                    }
                    MoveTextEditorInBubble($(this).data('id'), $(this).data('flipId'), $(this).data('sw'), $(this).data('sh'));
                },
                stop: function(e, ui) {
                    g_texteditor.Focus();
                },
            });
            g_texteditor.InitToEmpty();
            g_texteditor.centerText = true;
            $(g_texteditor.br).hide();
            $(g_texteditor.tr).hide();
            //$(g_texteditor.container).show();
            break;
        case 'tb_text':
            g_texteditor.InitToEmpty();
            g_texteditor.centerText = false;
            MoveTextEditor(e);
            $(g_texteditor.container).resizable({
                handles: 'n,s,e,w,se',
                resize: function(e, ui) {
                    if (!InSelBox(e.pageX, e.pageY)) {
                        var sx = $('#selbox').position().left;
                        var sy = $('#selbox').position().top;
                        var ex = sx + $('#selbox').width();
                        var ey = sy + $('#selbox').height();
                        if (ui.position.left < sx) {
                            ui.size.width += ui.position.left - sx;
                            ui.position.left = sx;
                        } else if (ui.position.left > ex) {
                            ui.position.left = ex;
                        }
                        if (ui.position.top < sy) {
                            ui.size.height += ui.position.top - sy;
                            ui.position.top = sy;
                        } else if (ui.position.top > ey) {
                            ui.position.top = ey;
                        }
                        var con = $(g_texteditor.container);
                        var offset = con.offset();
                        if (offset.left < sx) {
                            con.css('left', sx);
                        }
                        if (offset.top < sy) {
                            con.css('top', sy);
                        }
                        offset = con.offset();
                        if (offset.left + con.width() > ex) {
                            con.css('width', ex - offset.left);
                        }
                        if (offset.top + con.height() > ey) {
                            con.css('height', ey - offset.top);
                        }
                    }
                    g_texteditor.Redraw();
                },
                stop: function(e, ui) {
                    g_texteditor.Focus();
                }
            }).show();
            break;
    }
}

function Draw(e) {
    switch (g_tb_sel) {
        case 'tb_rect':
            DrawRect(e);
            break;
        case 'tb_circle':
            DrawCircle(e);
            break;
        case 'tb_arrow':
            DrawArrow(e);
            break;
        case 'tb_brush':
            DrawBrush(e);
            break;
        case 'tb_highlight':
            DrawHighlight(e);
            break;
        case 'tb_blur':
            DrawBlur(e);
            break;
        case 'tb_text':
            MoveTextEditor(e);
            break;
        case 'tb_bubble':
            MoveBubble(e);
            break;
    }
}

function UpdateResult() {
    var selvas = $('#selvas')[0];
    var width = selvas.width;
    var height = selvas.height;
    var resultvas = $('#resultvas')[0];
    resultvas.width = width;
    resultvas.height = height;
    var ctx = resultvas.getContext('2d');
    ctx.drawImage(selvas, 0, 0);
    //
    var offset = $('#selvas').offset();
    var x = offset.left;
    var y = offset.top;
    var origctx = $('#orig')[0].getContext('2d');
    origctx.clearRect(x, y, width, height);
    origctx.drawImage(resultvas, x, y, width, height);
    //
    g_update_result = true;
}

function MergeSelvas() {
    var selvas = $('#selvas')[0];
    var tempvas = $('#tempvas')[0];
    var ctx = selvas.getContext('2d');
    ctx.drawImage(tempvas, 0, 0);
    tempvas.getContext('2d').clearRect(0, 0, tempvas.width, tempvas.height);
}

function DrawTextDone() {
    if (!g_texteditor.empty) {
        UpdateHistory();
        //
        g_texteditor.DrawToCanvas($('#tempvas')[0]);
        //
        MergeSelvas();
        UpdateResult();
    }
    //
    g_step = 2;
    HideTextEditor();
    $(g_texteditor.container).resizable('destroy');
}

function DrawBubbleDone() {
    if ($('#cont_' + g_bubble_obj.id).width() && $('#cont_' + g_bubble_obj.id).height()) {
        UpdateHistory();
        //
        var xs = new XMLSerializer;
        var str = xs.serializeToString($('#svg_' + g_bubble_obj.id)[0]);
        var seloff = $('#selbox').offset();
        var svgoff = $('#cont_' + g_bubble_obj.id).offset();
        var tempvas = $('#tempvas')[0];
        var x = svgoff.left - seloff.left;
        var y = svgoff.top - seloff.top;
        tempvas.getContext('2d').drawImage(SVGToCanvas(str), x, y);
        g_texteditor.DrawToCanvas(tempvas);
        //
        MergeSelvas();
        UpdateResult();
    }
    //
    g_step = 2;
    HideTextEditor();
    $('#cont_' + g_bubble_obj.id).resizable('destroy').draggable('destroy').css('width', 0).css('height', 0).hide();
}

function GetMeasureChar()
{
    return g_lang_locale.indexOf('zh') == 0 ? '\u56fd' : 'D';
}

function DrawStop(e) {
    Draw(e);
    switch (g_tb_sel) {
        case 'tb_blur':
            BlurStop(e);
            break;
        case 'tb_brush':
            (function() {
                var canvas = $('#tempvas')[0];
                var ctx = canvas.getContext('2d');
                ctx.closePath();
                if (g_draw_start && g_draw_start.x == e.pageX && g_draw_start.y == e.pageY) {
                    //single click draw
                    ctx.fillStyle = g_brush_color;
                    var offset = $('#tempvas').offset();
                    ctx.beginPath();
                    ctx.arc(e.pageX - offset.left, e.pageY - offset.top, g_brush_size / 2.0, 0, 2 * Math.PI, true);
                    ctx.closePath();
                    ctx.fill();
                }
                ctx.restore();
            })();
            break;
        case 'tb_highlight':
            (function() {
                var canvas = $('#selvas')[0];
                var ctx = canvas.getContext('2d');
                ctx.closePath();
                ctx.restore();
            })();
            break;
    }
    if (g_tb_sel == 'tb_text') {
        var cont = $(g_texteditor.container);
        //console.log("cont:width" + cont.width());
        //console.log("cont:height" + cont.height());
        if (cont.width() == 0 && cont.height() == 0) {
            var w = MeasureTextWidth(g_texteditor.fontName, g_texteditor.fontSize, GetMeasureChar());
            var h = g_texteditor.fontHeight;

            //console.log("font:width" + w);
            //console.log("font:height" + h);
            if (e.pageX + w > g_selbox.ex) {
                w = g_selbox.ex - e.pageX;
            }
            if (e.pageY + h > g_selbox.ey) {
                h = g_selbox.ey - e.pageY;
            }
            cont.css('left', e.pageX).css('top', e.pageY).css('width', w).css('height', h);
            $(g_texteditor.container).resizable('destroy').show();
            $(g_texteditor.tr).show();
            g_texteditor.nowrap = true;
        } else {
            g_texteditor.nowrap = false;
        }
        g_step = 3;
        g_texteditor.Focus();
    } else if (g_tb_sel == 'tb_bubble') {
        if ($('#cont_' + g_bubble_obj.id).css('display') == 'none') {
            g_step = 2;
        } else if ($('#cont_' + g_bubble_obj.id).width() && $('#cont_' + g_bubble_obj.id).height()) {
            g_step = 4;
        } else {
            g_step = 2;
        }
        g_texteditor.nowrap = false;
    } else {
        MergeSelvas();
        UpdateResult();
    }
    if (g_toolbox_in_selbox) {
        ShowTool(true);
    }
    if (g_zoom_in_selbox) {
        $('#zoom').show();
    }
    //console.log('draw end');
}

function ShowCursor(cursor) {
    document.body.style.cursor = cursor;
}

function GetCrosshairCursor() {
    return 'crosshair';
}

function RestoreToInitMode() {
    if (g_history.length)
        while (UndoOnce());
    g_step = -1;
    $('#viewport').hide();
    $('#cont_vas').hide();
    $('#selbox').hide();
    $('#toolbox').hide();
    $('#tempvas').hide();
    $(g_texteditor.container).hide();
    $('#cont_' + g_bubble_obj.id).hide();
    TBRecover();
    g_tb_sel = null;
    g_tb_sel_init = false;
    g_draw_start = null;
    g_update_result = false;
    g_toolbox_dragged = false;
    //
    ShowCursor(GetCrosshairCursor());
}

function AddDragResizeHandler(id) {
    var locs = ['tl', 'tm', 'tr', 'ml', 'mr', 'bl', 'bm', 'br'];
    var o = document.getElementById(id);
    for (var i = 0; i < locs.length; i++) {
        var div = document.createElement('div');
        div.setAttribute('class', 'dragresize dragresize-' + locs[i]);
        o.appendChild(div);
    }
}

function MeasureFontHeight(fontName, fontSize) {
    var ta = document.createElement('textarea');
    ta.setAttribute('style', 'display:none;position:absolute;top:100px;left:100px;font-family: ' + fontName + ';font-size: ' + fontSize + 'px; border: 0px; margin: 0px; padding: 0px;');
    ta.setAttribute('rows', '1');
    document.documentElement.appendChild(ta);
    var height = $(ta).height();
    document.documentElement.removeChild(ta);
    ta = null;
    return height;
}

var ctx_measureTextWidth_;

function MeasureTextWidth(fontName, fontSize, text) {
    if (!ctx_measureTextWidth_) {
        var elem = document.createElement('canvas');
        ctx_measureTextWidth_ = elem.getContext('2d');
    }
    ctx_measureTextWidth_.save();
    ctx_measureTextWidth_.font = fontSize + 'px ' + fontName;
    var width = ctx_measureTextWidth_.measureText(text).width;
    ctx_measureTextWidth_.restore();
    return width;
}

function TextEditor(fontName, fontSize, color) {
    this.fontName_ = fontName;
    this.fontSize_ = fontSize;
    this.color_ = color;
    //
    var _this = this;
    this.centerText_ = false;
    //
    this.container = (function() {
        var e = document.createElement('div');
        e.setAttribute('class', 'texteditor_container');
        return e;
    })();
    this.textarea = (function() {
        var e = document.createElement('textarea');
        e.setAttribute('class', 'texteditor');
        return e;
    })();
    this.br = (function() {
        var e = document.createElement('div');
        e.setAttribute('class', 'dragresize-te');
        return e;
    })();
    this.tr = (function() {
        var e = document.createElement('div');
        e.setAttribute('class', 'move-te');
        return e;
    })();
    this.container.appendChild(this.textarea);
    this.container.appendChild(this.br);
    this.container.appendChild(this.tr);
    document.body.appendChild(this.container);
    //
    this.InitToEmpty = function() {
        this.textarea.value = '\n';
        this.lb = '\n';
        this.ll = [{
            len: 1,
            rt: false
        }];
        this.line = 0;
        this.col = 0;
        this.selectionStart = this.selectionEnd = 0;
    };
    this.InitToEmpty();
    //
    this.textarea.addEventListener('textInput', function(e) {
        _this.InsertText(e.data);
        e.preventDefault();
        //    console.log('textInput: '+e.data)
    }, false);
    this.textarea.addEventListener('keyup', function(e) {
        if (e.target.scrollTop)
            e.target.scrollTop = 0;
        if (e.ctrlKey && e.keyCode == 88) {
            //zhsoft88: detect ^X (2010.12.27)
            var pos = this.selectionStart;
            _this.lb = _this.textarea.value;
            _this.Rebuild();
            _this.ValidateLineCol(pos);
            _this.SetCursor();
            _this.Resize();
        }
    }, false);
    this.textarea.addEventListener('keydown', function(e) {
        //console.log('keydown: '+e.keyCode);
        _this.imeon = e.keyCode == 229;
        if (_this.imeon)
            return;
        switch (e.keyCode) {
            case 38:
            case 40:
            case 37:
            case 39:
            case 8:
            case 36:
            case 35:
            case 33:
            case 34:
            case 9:
            case 45:
            case 46:
                e.preventDefault();
                break;
        }
        switch (e.keyCode) {
            case 38:
                _this.OnUp();
                break;
            case 40:
                _this.OnDown();
                break;
            case 37:
                _this.OnLeft();
                break;
            case 39:
                _this.OnRight();
                break;
            case 8:
                _this.OnBackspace();
                break;
            case 36:
                _this.OnHome();
                break;
            case 35:
                _this.OnEnd();
                break;
            case 33:
                _this.OnPageUp();
                break;
            case 34:
                _this.OnPageDown();
                break;
            case 9:
                _this.OnTab();
            case 45:
                _this.OnInsert();
                break;
            case 46:
                _this.OnDelete();
                break;
        }
    }, false);
    this.mouse_is_down = false;
    this.textarea.addEventListener('mousedown', function(e) {
        _this.mouse_is_down = true;
    }, false);
    this.OnMouseUp = function(e) {
        if (!_this.mouse_is_down)
            return;
        var target = _this.textarea;
        _this.selectionStart = target.selectionStart;
        _this.selectionEnd = target.selectionEnd;
        if (target.selectionStart != target.selectionEnd)
            return;
        var found = false;
        var off = 0;
        for (var i = 0; i < _this.ll.length; i++) {
            if (target.selectionStart >= off && target.selectionStart < off + _this.ll[i].len) {
                _this.line = i;
                _this.col = target.selectionStart - off;
                found = true;
                break;
            }
            off += _this.ll[i].len;
        }
        _this.SetCursor();
        _this.mouse_is_down = false;
    };
    this.textarea.addEventListener('mouseup', this.OnMouseUp, false);
    this.__defineGetter__('lineoff', function() {
        var pos = 0;
        for (var i = 0; i < this.line; i++) {
            pos += this.ll[i].len;
        }
        return pos;
    });
    this.__defineGetter__('linelen', function() {
        return this.ll[this.line].len;
    });
    this.__defineGetter__('lineeolr', function() {
        return this.ll[this.line].rt;
    });
    this.GetRawText = function() {
        var text = '';
        for (var i = 0; i < this.lb.length; i++) {
            if (this.lb[i] == '\r')
                continue;
            text += this.lb[i];
        }
        return text;
    };
    this.HasReturn = function() {
        for (var i = 0; i < this.lb.length; i++) {
            if (this.lb[i] == '\r')
                return true;
        }
        return false;
    };
    this.TranslateReturn = function() {
        if (!this.nowrap || !this.HasReturn())
            return;
        var text = '';
        for (var i = 0; i < this.lb.length; i++) {
            if (this.lb[i] == '\r')
                text += '\n';
            else
                text += this.lb[i];
        }
        this.lb = text;
        this.textarea.value = text;
    };
    /*  this.AutoResize = function() {
        if (!this.nowrap || !this.HasReturn())
          return;
        //cal max width
        var text = this.GetRawText();
        var mw = 0;
        var i = 0;
        while (i < text.length) {
          var lw = 0;
          while (i < text.length) {
            var ch = text[i];
            if (ch == '\n')
              break;
            var cw = MeasureTextWidth(this.fontName, this.fontSize, ch);
            lw += cw;
            i++;
          }
          if (lw > mw)
            mw = lw;
          if (i == text.length)
            break;
          i++;
        }
        var left = $(this.container).offset().left;
        if (left + mw > g_selbox.ex)
          mw = g_selbox.ex - left;
        if (mw == this.width)
          return;
        $(this.container).css('width', mw);
        this.Redraw();
      };*/

    this.Rebuild = function() {
        var text = this.GetRawText();
        //
        var str = '';
        this.ll = [];
        var i = 0;
        while (i < text.length) {
            var len = 0;
            var lw = 0;
            var rt = false;
            while (i < text.length) {
                var ch = text[i];
                if (ch == '\n') {
                    str += ch;
                    i++;
                    len++;
                    break;
                }
                var cw = MeasureTextWidth(this.fontName, this.fontSize, ch);
                if (lw + cw > this.width) {
                    if (lw == 0) {
                        //no any room, accept one char
                        str += ch + '\r';
                        i++;
                        len += 2;
                        rt = true;
                        break;
                    }
                    str += '\r';
                    len++;
                    rt = true;
                    break;
                }
                str += ch;
                lw += cw;
                len++;
                i++;
            }
            this.ll.push({
                len: len,
                rt: rt
            });
        }
        if (this.ll.length == 0) {
            this.InitToEmpty();
        } else {
            this.lb = str;
            this.textarea.value = str;
        }
    };
    this.SetCursor = function() {
        this.textarea.selectionStart = this.lineoff + this.col;
        this.textarea.selectionEnd = this.textarea.selectionStart;
        this.textarea.focus();
        _this.selectionStart = this.textarea.selectionStart;
        _this.selectionEnd = this.textarea.selectionEnd;
    };
    this.ValidateLineCol = function(currpos) {
        var pos = 0;
        for (var i = 0; i < this.ll.length; i++) {
            if (currpos >= pos) {
                var f = false;
                if (this.ll[i].rt) {
                    f = currpos < pos + this.ll[i].len;
                } else {
                    f = currpos <= pos + this.ll[i].len;
                }
                if (f) {
                    this.line = i;
                    this.col = currpos - pos;
                    break;
                }
            }
            pos += this.ll[i].len;
            if (this.ll[i].rt) {
                pos--;
            }
        }
    };
    this.Redraw = function() {
        var currpos = 0;
        for (var i = 0; i < this.line; i++) {
            currpos += this.ll[i].len;
            if (this.ll[i].rt) {
                currpos--;
            }
        }
        currpos += this.col;
        //
        this.Rebuild();
        this.ValidateLineCol(currpos);
        this.SetCursor();
    };
    this.ExpandHeight = function() {
        if (!this.nowrap)
            return;
        //expand height when possible
        var t = $(this.container).offset().top;
        if (t + this.height < g_selbox.ey && this.ll.length * this.fontHeight <= this.height) {
            if (this.height / this.fontHeight > this.ll.length)
                return;
            var nh = t + this.height + this.fontHeight;
            if (nh > g_selbox.ey) {
                $(this.container).css('height', g_selbox.ey - t);
            } else {
                $(this.container).css('height', nh - t);
            }
        }
    };
    this.ExpandWidth = function(c, check) {
        if (!this.nowrap)
            return;
        if (check) {
            if (this.width > this.GetMaxWidth())
                return;
        }
        var left = $(this.container).offset().left;
        if (left + this.width < g_selbox.ex) {
            var aw = MeasureTextWidth(this.fontName, this.fontSize, c);
            var nw = left + this.width + aw;
            if (nw > g_selbox.ex) {
                $(this.container).css('width', g_selbox.ex - left);
            } else {
                $(this.container).css('width', nw - left);
            }
        }
    };
    this.ExpandWidthAndHeight = function(c, check) {
        this.ExpandWidth(c, check);
        this.ExpandHeight();
    };
    this.InsertChar = function(c) {
        if ((this.line + 1) * this.fontHeight > this.height)
            return false;
        if (c == '\n') {
            if ((this.line + 2) * this.fontHeight > this.height && this.nowrap) {
                var t = $(this.container).offset().top;
                if (t + (this.line + 2) * this.fontHeight > g_selbox.ey) {
                    $(this.container).css('height', g_selbox.ey - t);
                } else {
                    $(this.container).css('height', (this.line + 2) * this.fontHeight);
                }
            }
            if ((this.line + 2) * this.fontHeight > this.height)
                return false;
            var pos = this.lineoff + this.col;
            var front = this.lb.substring(0, pos);
            var back = this.lb.substring(pos);
            this.lb = front + c + back;
            this.Rebuild();
            this.OnRight();
            return true;
        }
        var text = this.lb.substring(this.lineoff, this.lineoff + this.linelen - 1);
        var lw = MeasureTextWidth(this.fontName, this.fontSize, text);
        var cw = MeasureTextWidth(this.fontName, this.fontSize, c);
        var found = false;
        if (lw + cw > this.width) {
            this.ExpandWidthAndHeight(c);
        }
        if (lw + cw > this.width) {
            if ((this.line + 2) * this.fontHeight > this.height && this.nowrap) {
                var t = $(this.container).offset().top;
                if (t + (this.line + 2) * this.fontHeight > g_selbox.ey) {
                    $(this.container).css('height', g_selbox.ey - t);
                } else {
                    $(this.container).css('height', (this.line + 2) * this.fontHeight);
                }
            }
            if ((this.line + 2) * this.fontHeight > this.height)
                return false;
            found = this.col == this.linelen - 1;
        }
        var pos = this.lineoff + this.col;
        var front = this.lb.substring(0, pos);
        var back = this.lb.substring(pos);
        this.lb = front + c + back;
        this.Rebuild();
        this.OnRight();
        if (found) {
            this.OnRight();
        }
        if (this.textarea.scrollTop)
            this.textarea.scrollTop = 0;
        this.ExpandWidthAndHeight(c, true);
        return true;
    };
    this.InsertText = function(text) {
        this.DeleteSelection();
        for (var i = 0; i < text.length; i++) {
            if (!this.InsertChar(text[i]))
                break;
        }
    };
    this.OnUp = function() {
        if (!this.line)
            return;
        this.line--;
        if (this.col > this.linelen - 1) {
            this.col = this.linelen - 1;
            if (this.lineeolr) {
                this.col--;
            }
        }
        this.SetCursor();
    };
    this.OnDown = function() {
        if (this.line == this.ll.length - 1)
            return;
        this.line++;
        if (this.col > this.linelen - 1) {
            this.col = this.linelen - 1;
            if (this.lineeolr) {
                this.col--;
            }
        }
        this.SetCursor();
    };
    this.OnLeft = function() {
        if (!this.col) {
            if (this.line == 0)
                return false;
            this.line--;
            this.col = this.linelen - 1;
            if (this.lineeolr) {
                this.col--;
            }
        } else {
            this.col--;
        }
        this.SetCursor();
        return true;
    };
    this.OnRight = function() {
        if (this.col == this.linelen - 1) {
            if (this.line == this.ll.length - 1)
                return;
            this.line++;
            this.col = 0;
        } else {
            this.col++;
            if (this.col == this.linelen - 1 && this.lineeolr) {
                this.line++;
                this.col = 0;
            }
        }
        this.SetCursor();
    };
    this.OnHome = function() {
        if (!this.col)
            return;
        this.col = 0;
        this.SetCursor();
    };
    this.OnEnd = function() {
        if (this.col == this.linelen - 1)
            return;
        this.col = this.linelen - 1;
        if (this.lineeolr) {
            this.col--;
        }
        this.SetCursor();
    };
    this.OnPageUp = function() {};
    this.OnPageDown = function() {};
    this.DeleteSelection = function() {
        //console.log('delsel: '+this.selectionStart+','+this.selectionEnd)
        //    return;
        if (this.selectionStart == this.selectionEnd)
            return false;
        var pos = this.selectionStart;
        var front = this.lb.substring(0, pos);
        var back = this.lb.substring(this.selectionEnd);
        if (back.length < 1)
            back = '\n';
        this.lb = front + back;
        this.Rebuild();
        this.ValidateLineCol(pos);
        this.SetCursor();
        this.Resize();
        return true;
    };
    this.OnBackspace = function() {
        if (this.DeleteSelection())
            return;
        if (this.OnLeft()) {
            this.OnDelete();
        }
    };
    this.OnTab = function() {};
    this.GetMaxWidth = function() {
        var w = 0;
        var pos = 0;
        for (var i = 0; i < this.ll.length; i++) {
            var text = this.lb.substring(pos, pos + this.ll[i].len - 1);
            var lw = MeasureTextWidth(this.fontName, this.fontSize, text);
            if (lw > w) {
                w = lw;
            }
            pos += this.ll[i].len;
        }
        return w;
    };
    this.Resize = function() {
        if (!this.nowrap)
            return;
        var w = this.GetMaxWidth();
        var cw = MeasureTextWidth(this.fontName, this.fontSize, GetMeasureChar());
        if (w < cw) {
            w = cw;
        }
        var h = this.ll.length * this.fontHeight;
        var t = $(this.container).offset().top;
        if (t + h > g_selbox.ey) {
            h = g_selbox.ey - t;
        }
        $(this.container).css('width', w).css('height', h);
    };
    this.OnDelete = function() {
        if (this.DeleteSelection())
            return;
        if (this.line == this.ll.length - 1 && this.col == this.linelen - 1)
            return;
        var pos = this.lineoff + this.col;
        var front = this.lb.substring(0, pos);
        var back = this.lb.substring(pos + 1);
        this.lb = front + back;
        this.Rebuild();
        this.SetCursor();
        this.Resize();
    };
    this.OnInsert = function() {};
    this.nowrap_ = false;
    this.__defineGetter__('nowrap', function() {
        return this.nowrap_;
    });
    this.__defineSetter__('nowrap', function(val) {
        this.nowrap_ = val;
    });
    this.__defineSetter__('fontName', function(val) {
        this.fontName_ = val;
        $(this.textarea).css('font-family', val);
        this.RecalcFontHeight();
        this.Resize();
        this.Redraw();
        this.ExpandWidthAndHeight();
    });
    this.__defineGetter__('fontName', function() {
        return this.fontName_;
    });
    this.__defineSetter__('fontSize', function(val) {
        this.fontSize_ = val;
        $(this.textarea).css('font-size', val);
        this.RecalcFontHeight();
        this.Resize();
        this.Redraw();
        this.ExpandWidthAndHeight();
    });
    this.__defineGetter__('fontSize', function() {
        return this.fontSize_;
    });
    this.__defineSetter__('color', function(val) {
        this.color_ = val;
        $(this.textarea).css('color', val);
    });
    this.__defineGetter__('color', function() {
        return this.color_;
    });
    this.__defineGetter__('height', function() {
        return $(this.container).height();
    });
    this.__defineGetter__('width', function() {
        return $(this.container).width();
    });
    this.__defineGetter__('fontHeight', function() {
        return this.fontHeight_;
    });
    this.__defineGetter__('empty', function() {
        for (var i = 0; i < this.lb.length; i++) {
            var c = this.lb[i];
            if (c == ' ' || c == '\r' || c == '\n')
                continue;
            return false;
        }
        return true;
    });
    this.__defineGetter__('centerText', function() {
        return this.centerText_;
    });
    this.__defineSetter__('centerText', function(val) {
        this.centerText_ = val;
        $(this.textarea).css('text-align', val ? 'center' : 'left');
    });
    this.RecalcFontHeight = function() {
        this.fontHeight_ = MeasureFontHeight(this.fontName, this.fontSize);
    };
    this.RecalcFontHeight();
    $(this.textarea).css('font-family', this.fontName).css('font-size', this.fontSize).css('color', this.color);
    //
    this.DrawToCanvas = function(canvas) {
        var ctx = canvas.getContext('2d');
        ctx.save();
        ctx.textBaseline = 'top';
        ctx.font = this.fontSize + 'px ' + this.fontName;
        ctx.fillStyle = this.color;
        var sboff = $('#selbox').offset();
        var ttoff = $(this.container).offset();
        var x = ttoff.left - sboff.left;
        var y = ttoff.top - sboff.top;
        var max_height = $(this.container).height();
        var max_width = $(this.container).width();
        var pos = 0;
        for (var i = 0; i < this.ll.length; i++) {
            if ((i + 1) * this.fontHeight_ > max_height)
                break;
            var text = this.lb.substring(pos, pos + this.ll[i].len - 1);
            var draw = true;
            if (this.ll[i].len == 2) {
                var lw = MeasureTextWidth(this.fontName, this.fontSize, text);
                if (lw > max_width)
                    draw = false;
            }
            if (draw) {
                var off = 0;
                if (this.centerText) {
                    var lw = MeasureTextWidth(this.fontName, this.fontSize, text);
                    off = (max_width - lw) / 2;
                }
                ctx.fillText(text, x + off, y);
            }
            y += this.fontHeight_;
            pos += this.ll[i].len;
        }
        ctx.restore();
    };
    this.Focus = function() {
        this.SetCursor();
    };
    this.SetCursor();
}

function Select(id, listValues, listLabels, max_lines, line_height, width, left, defValue, defLabel, callback, delayLoad) {
    var _this = this;
    this.id = id;
    this.line_height = line_height;
    this.width = width;
    this.left = left;
    this.callback = callback;
    this.delayLoad = delayLoad;
    this.delayLoaded = false;
    this.focused = false;
    this.max_height = max_lines * line_height;
    //
    this.focus = function() {
        this.focused = true;
        $(this.sb).addClass('selectbox_selected');
        enableScroll();
    };
    this.blur = function() {
        this.focused = false;
        this.showList(false);
        $(this.sb).removeClass('selectbox_selected');
        disableScroll();
    };
    //
    var o = document.getElementById(id);
    o.addEventListener('click', function(e) {
        _this.focus();
    }, false);
    this.node = o;
    //
    var sb = document.createElement('div');
    sb.setAttribute('class', 'selectbox');
    if (width) {
        sb.setAttribute('style', 'width:' + width + 'px');
    }
    sb.addEventListener('click', function(e) {
        var show = _this.listShown();
        _this.showList(!show);
        if (!show) {
            _this.scrollToView();
            _this.hover_start = false;
        }
    }, false);
    sb.addEventListener('dblclick', function(e) {
        e.preventDefault();
    }, false);
    sb.addEventListener('selectstart', function(e) {
        e.preventDefault();
    }, false);
    this.sb = sb;
    //
    var st = document.createElement('div');
    st.setAttribute('class', 'selectbox_title');
    st.setAttribute('value', defValue ? defValue : listValues[0]);
    st.innerText = defLabel ? defLabel : listLabels[0];
    sb.appendChild(st);
    o.appendChild(sb);
    this.st = st;
    //
    var sl = document.createElement('ul');
    sl.setAttribute('class', 'selectlist');
    sl.setAttribute('style', 'position:absolute;display:none;max-height:' + this.max_height + 'px');
    o.appendChild(sl);
    this.sl = sl;
    //
    this.createList = function(selectobj, values, labels) {
        for (var i = 0; i < values.length; i++) {
            var li = document.createElement('li');
            li.setAttribute('value', values[i]);
            li.innerText = labels[i];
            li.addEventListener('click', function(e) {
                selectobj.st.setAttribute('value', e.target.getAttribute('value'));
                selectobj.st.innerText = e.target.innerText;
                selectobj.showList(false);
                if (selectobj.callback) {
                    selectobj.callback(e.target.getAttribute('value'));
                }
            }, false);
            li.addEventListener('mouseover', function(e) {
                if (!selectobj.hover_start) {
                    selectobj.hover_start = true;
                    var list = selectobj.sl.childNodes;
                    for (var k = 0; k < list.length; k++) {
                        if (list[k].className == 'selectlist_selected') {
                            list[k].removeAttribute('class');
                            break;
                        }
                    }
                }
            }, false);
            selectobj.sl.appendChild(li);
        }
    };
    if (!delayLoad) {
        this.createList(_this, listValues, listLabels);
    }
    //
    this.listShown = function() {
        return this.sl.style.display != 'none';
    };
    this.showList = function(show) {
        if (show) {
            if (this.delayLoad && !this.delayLoaded) {
                this.createList(this, this.delayLoad.GetValues(), this.delayLoad.GetLabels());
                this.delayLoaded = true;
            }
            var off = $(this.sb).offset();
            var y = $(this.sb).height() + 4;
            if (off.top + y + this.max_height > g_vscreen.height) {
                y = -4 - this.max_height;
            }
            $(this.sl).css('left', this.left).css('top', y).css('width', this.width).css('height', this.max_height);
        }
        this.sl.style.display = show ? '' : 'none';
    };
    this.scrollToView = function() {
        var title = this.st.getAttribute('value');
        var list = this.sl.childNodes;
        for (var i = 0; i < list.length; i++) {
            if (list[i].getAttribute('value') == title) {
                this.sl.scrollTop = list[i].offsetTop;
                $(list[i]).addClass('selectlist_selected');
                break;
            }
        }
    };
    this.__defineGetter__('value', function() {
        return this.st.getAttribute('value');
    });
}

function LoadBubble(obj) {
    var id = obj.id;
    if (g_bubbles[id])
        return;
    //var src = obj.firstChild.src;
    //src = src.substring(0, src.lastIndexOf('.')) + '.svg';
    var src = '../image/bubble/' + id + '.svg';
    $.ajax({
        url: src,
        method:'get',
        dataType: "xml",
        success: function (data) {
            var doc = data;
            if (!doc)
                return;
            var root = doc.documentElement;
            root.setAttribute('id', 'svg_' + id);
            var width = parseFloat(root.getAttribute('width'));
            var height = parseFloat(root.getAttribute('height'));
            var edit = doc.getElementById('edit');
            var edit_x = parseFloat(edit.getAttribute('x'));
            var edit_y = parseFloat(edit.getAttribute('y'));
            var edit_width = parseFloat(edit.getAttribute('width'));
            var edit_height = parseFloat(edit.getAttribute('height'));
            edit.setAttribute('id', 'edit_' + id);
            var group = doc.getElementById('group');
            group.setAttribute('id', 'group_' + id);
            g_bubbles[id] = {
                width: width,
                height: height,
                edit: {
                    pos: [{
                        x: edit_x,
                        y: edit_y
                    }, {
                        x: width - edit_x - edit_width,
                        y: edit_y
                    }, {
                        x: width - edit_x - edit_width,
                        y: height - edit_y - edit_height
                    }, {
                        x: edit_x,
                        y: height - edit_y - edit_height
                    }, ],
                    width: edit_width,
                    height: edit_height,
                },
            };
            var cont_id = 'cont_' + id;
            var cont = document.createElement('div');
            cont.setAttribute('id', cont_id);
            cont.setAttribute('class', 'svg');
            cont.appendChild(document.adoptNode(root));
            document.body.appendChild(cont);
            AddDragResizeHandler(cont_id);
        }
    });

}

function FixTitle(title) {
    var result = '';
    for (var i = 0; i < title.length; i++) {
        var c = title[i];
        if (c == ':' || c == '?' || c == '*' || c == '/' || c == '\\' || c == '|' || c == '<' || c == '>' || c == '\"') {
            result += '-';
        } else {
            result += c;
        }
    }
    return result;
}

function TruncateFontName(name, max_width, font, size) {
    if (MeasureTextWidth(font, size, name) <= max_width)
        return name;
    var half = name.length / 2;
    while (MeasureTextWidth(font, size, name.substring(0, half)) > max_width) {
        half = half / 2;
    }
    var result = name.substring(0, half);
    for (var i = 0; i < half; i++) {
        if (MeasureTextWidth(font, size, result + name[half + i]) > max_width)
            break;
        result += name[half + i];
    }
    return result;
}

function DisableDragStartOnButtons() {
    var buttons = $('.btn,.bubble,.bubble_selected,.btn_selected2,.sep,#zoomViewOverlay');
    for (var i = 0; i < buttons.length; i++) {
        buttons[i].ondragstart = function(e) {
            return false;
        };
    }
}

function LoadToolboxImages() {
    if (g_toobox_images_loaded)
        return;
    g_toobox_images_loaded = true;
    var images = [
        /*    { id: 'tb_rect', src: 'rectangle_16.png' },
            { id: 'tb_circle', src: 'ecllipse_16.png' },
            { id: 'tb_arrow', src: 'arrow_16.png' },
            { id: 'tb_brush', src: 'brush_16.png' },
            { id: 'tb_highlight', src: 'highlighter_16.png' },
            { id: 'tb_blur', src: 'blur_16.png' },
            { id: 'tb_text', src: 'type_16.png' },
            { id: 'tb_bubble', src: 'bubble_16.png' },
            { id: 'tb_undo', src: 'undo_16.png' },
            { id: 'tb_save', src: 'save_16.png' },
            { id: 'tb_cancel', src: 'cancel_16.png' },*/
        {
            id: 'brush_s',
            src: 'cur_brush_s.png'
        }, {
            id: 'brush_m',
            src: 'cur_brush_m.png'
        }, {
            id: 'brush_l',
            src: 'cur_brush_l.png'
        }, {
            id: 'blur_s',
            src: 'cur_blur_s.png'
        }, {
            id: 'blur_m',
            src: 'cur_blur_m.png'
        }, {
            id: 'blur_l',
            src: 'cur_blur_l.png'
        }, {
            id: 'highlight_s',
            src: 'cur_highlighter_s.png'
        }, {
            id: 'highlight_m',
            src: 'cur_highlighter_m.png'
        }, {
            id: 'highlight_l',
            src: 'cur_highlighter_l.png'
        }, {
            id: 'bubble_01',
            src: 'bubble/bubble_01.png'
        }, {
            id: 'bubble_02',
            src: 'bubble/bubble_02.png'
        }, {
            id: 'bubble_03',
            src: 'bubble/bubble_03.png'
        }, {
            id: 'bubble_04',
            src: 'bubble/bubble_04.png'
        }, {
            id: 'bubble_05',
            src: 'bubble/bubble_05.png'
        }, {
            id: 'bubble_06',
            src: 'bubble/bubble_06.png'
        }, {
            id: 'bubble_07',
            src: 'bubble/bubble_07.png'
        }, {
            id: 'bubble_08',
            src: 'bubble/bubble_08.png'
        }, {
            id: 'bubble_09',
            src: 'bubble/bubble_09.png'
        }, {
            id: 'bubble_10',
            src: 'bubble/bubble_10.png'
        },
        /*    { id: 'tb_ok_image', src: 'ok_16.png' },
            { id: 'tb_drag', src: 'toolbar_draghandle.png' },*/
    ];
    for (var i = 0; i < images.length; i++) {
        document.getElementById(images[i].id).firstChild.src = 'image/' + images[i].src;
    }
    /*  var seps = $('.sep');
      for (var i = 0; i < seps.length; i++) {
        seps[i].firstChild.src = 'image/separator.png';
      }*/
    //
    $(g_brush_color_obj).addClass('colorpick_selected');
    $('#brushtool_colorpick_current').css('background-color', g_brush_color);
    $(g_text_color_obj).addClass('colorpick_selected');
    $('#texttool_colorpick_current').css('background-color', g_text_color);
    $(g_high_color_obj).addClass('colorpick_selected');
    $('#hightool_colorpick_current').css('background-color', g_high_color);
    //
    var ll = MeasureFontHeight(g_default_text_font, g_default_text_size);
    var truncatedDefaultFont = TruncateFontName(g_default_text_font, TEXT_FONT_SEL_WIDTH - 38, g_default_text_font, g_default_text_size);
    g_text_font_sel = new Select('text_font_sel', [], [], MAX_LINES, ll, TEXT_FONT_SEL_WIDTH, 4, g_default_text_font, truncatedDefaultFont, function(text) {
        g_texteditor.fontName = text;
    }, {
        values_: null,
        labels_: null,
        GetValues: function() {
            if (!this.values_) {
                //this.values_ = maxthon.system.GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                this.values_ = g_fontfamilys;
            }
            return this.values_;
        },
        GetLabels: function() {
            if (!this.labels_) {
                this.labels_ = [];
                for (var i = 0; i < this.values_.length; i++) {
                    this.labels_.push(TruncateFontName(this.values_[i], TEXT_FONT_SEL_WIDTH - 38, g_default_text_font, g_default_text_size));
                }
            }
            return this.labels_;
        },
    });
    g_sel_list.push(g_text_font_sel);
    var tmpsels = templateData.TextSizeSel;
    var sels = tmpsels.split(/\s*,\s*/);
    g_text_size_sel = new Select('text_size_sel', sels, sels, MAX_LINES, ll, TEXT_SIZE_SEL_WIDTH, 116, g_default_text_size, g_default_text_size, function(text) {
        g_texteditor.fontSize = parseInt(text);
    });
    g_sel_list.push(g_text_size_sel);

    //  g_texteditor = new TextEditor(g_default_text_font, g_default_text_size, g_text_color);
    $(g_texteditor.tr).draggable({
        start: function(e, ui) {
            var offset = $(g_texteditor.container).offset();
            g_texteditor_tr_start = {
                sx: ui.position.left,
                sy: ui.position.top,
                cont_x: offset.left,
                cont_y: offset.top,
                cont_w: $(g_texteditor.container).width(),
                cont_h: $(g_texteditor.container).height(),
            };
            g_texteditor.TranslateReturn();
        },
        drag: function(e, ui) {
            var dx = ui.position.left - g_texteditor_tr_start.sx;
            var dy = ui.position.top - g_texteditor_tr_start.sy;
            var cx = g_texteditor_tr_start.cont_x + dx;
            var cy = g_texteditor_tr_start.cont_y + dy;
            if (cx < g_selbox.sx) {
                cx = g_selbox.sx;
            } else if (cx + g_texteditor_tr_start.cont_w > g_selbox.ex) {
                cx = g_selbox.ex - g_texteditor_tr_start.cont_w;
            }
            if (cy < g_selbox.sy) {
                cy = g_selbox.sy;
            } else if (cy + g_texteditor_tr_start.cont_h > g_selbox.ey) {
                cy = g_selbox.ey - g_texteditor_tr_start.cont_h;
            }
            $(g_texteditor.container).css('left', cx).css('top', cy);
            ui.position.left -= dx;
            ui.position.top -= dy;
            //g_texteditor.AutoResize();
        },
        stop: function(e, ui) {
            $(this).removeAttr('style');
            g_texteditor.Focus();
        }
    });

    $('#tb_drag').draggable({
        scrollSensitivity: 0,
        addClasses: false,
        start: function(e, ui) {
            g_toolbox_dragged = true;
            var offset = $('#toolbox').offset();
            g_toolbox_drag_start = {
                sx: ui.position.left,
                sy: ui.position.top,
                cont_x: offset.left,
                cont_y: offset.top,
                cont_w: $('#toolbox').width() + BACK_BORDER_WIDTH,
                cont_h: $('#toolbox').height() + BACK_BORDER_WIDTH,
                selbox_x: $('#selbox').position().left,
                selbox_y: $('#selbox').position().top,
                selbox_w: $('#selbox').width(),
                selbox_h: $('#selbox').height(),
            };
        },
        drag: function(e, ui) {
            var dx = ui.position.left - g_toolbox_drag_start.sx;
            var dy = ui.position.top - g_toolbox_drag_start.sy;
            ui.position.left -= dx;
            ui.position.top -= dy;
            var cx = g_toolbox_drag_start.cont_x + dx;
            var cy = g_toolbox_drag_start.cont_y + dy;
            if (cx < 0) {
                cx = 0;
            } else if (cx + g_toolbox_drag_start.cont_w > g_vscreen.width - 1) {
                cx = g_vscreen.width - 1 - g_toolbox_drag_start.cont_w;
            }
            if (cy < 0) {
                cy = 0;
            } else if (cy + g_toolbox_drag_start.cont_h > g_vscreen.height - 1) {
                cy = g_vscreen.height - 1 - g_toolbox_drag_start.cont_h;
            }
            $('#toolbox').css('left', cx).css('top', cy);
            RelocateSubtool();
        },
        stop: function(e, ui) {
            g_toolbox_drag_start = null;
        },
    });

    //  LoadBubble($('.bubble_selected')[0]);

    $('.colorpick').click(function() {
        PickColor(this);
    });
    $('.bubble,.default_bubble').click(function() {
        PickBubble(this)
    });
    $('#brush_s,#brush_m,#brush_l,#blur_s,#blur_m,#blur_l,#highlight_s,#highlight_m,#highlight_l').click(function() {
        PickSize(this);
    });

    DisableDragStartOnButtons();
}

function LoadAdditionalJavaScripts() {
    //if (g_additional_javascripts_loaded)
    //  return;
    //g_additional_javascripts_loaded = true;
    //var jsa = ['js/StackBlur.js', 'js/parse-svg.js'];
    //for (var i = 0; i < jsa.length; i++) {
    //  var elem = document.createElement('script');
    //  elem.setAttribute('src', jsa[i]);
    //  document.documentElement.appendChild(elem);
    //}
}

function ResizeBoxAndUpdateInfo(ui) {
    ResizeSelbox(null, ui);
    var info = $('#zoomHotInfo')[0];
    var selbox = $('#selbox');
    var text = document.createTextNode(selbox.width() + 'x' + selbox.height());
    info.removeChild(info.firstChild);
    info.insertBefore(text, info.firstChild);
}

function ChangeResizeCursors() {
    var cursor = GetCrosshairCursor();
    var urs = ['n', 's', 'w', 'e', 'nw', 'ne', 'sw', 'se'];
    for (var i = 0; i < urs.length; i++)
        $('.ui-resizable-' + urs[i]).css('cursor', cursor);
    var drs = ['tl', 'tr', 'bl', 'br'];
    for (var i = 0; i < drs.length; i++)
        $('.dragresize-' + drs[i]).css('cursor', cursor);
}

function RestoreResizeCursors() {
    var urs = ['n', 's', 'w', 'e', 'nw', 'ne', 'sw', 'se'];
    for (var i = 0; i < urs.length; i++)
        $('.ui-resizable-' + urs[i]).css('cursor', urs[i] + '-resize');
}

function LoadJsAsync() {
    loadJs("StackBlur", "js/StackBlur.js", function () { });
    loadJs("parse-svg", "js/parse-svg.js", function () { });

    if (!g_from_note) {
        loadJs("share_js_global", "share/js/global.js", function () { });
        loadJs("share_js_oauth", "share/js/oauth.js", function () { });
        loadJs("share_js_sha1", "share/js/sha1.js", function () { });
        loadJs("share_js_sina_oauth_app", "share/js/sina_oauth_app.js", function () { });
        loadJs("share_js_sina_weibo_emotions", "share/js/sina_weibo_emotions.js", function () { });
        loadJs("share_js_sina_weibo_errors", "share/js/sina_weibo_errors.js", function () { });
        loadJs("share_js_share", "share/js/share.js", function () { });
    }
}

// main

var uri;

function SnapDataCallBack(data) {
    var extradata = JSON.parse(data.extradata);
    // get title
    var title = uri.queryKey['title'];
    g_title = title ? decodeURI(title) : '';
    g_title = g_title.trim();
    if (g_title.length == 0) {
        g_title = templateData.DefaultFileName;
    } else {
        g_title = FixTitle(g_title);
    }

    // get screen info
    var vscreen = extradata.vscreen;
    if (vscreen) {
        g_vscreen = new Monitor(...vscreen);
    } else {
        g_vscreen = new Monitor(0, 0, screen.width, screen.height);
    }

    // get monitors info
    var monitors = extradata.monitors;
    if (monitors) {
        for (var i = 0; i < monitors.length; i++) {
            g_monitors.push(new Monitor(...monitors[i]));
        }
    } else {
        g_monitors.push(new Monitor(0, 0, screen.width, screen.height));
    }

    // get cursor info
    var curpos = extradata.curpos;
    if (curpos) {
        g_curpos = {
            x: parseInt(curpos[0]),
            y: parseInt(curpos[1])
        };
    } else {
        g_curpos = {
            x: 0,
            y: 0
        };
    }

    // parse windows data
    var windows = extradata.windows;
    if (windows) {
        for (var i = 0; i < windows.length; i++) {
            var win = new Monitor(...windows[i]);
// { modified at 2021/1/27 by hsrao for fixing bug 20745}
            /*win.left += 6;
            win.right -= 8;
            win.bottom -= 6;*/
// } by hsrao
            g_windows.push(win);
        }
    }

    //make position positive
    if (g_vscreen.left < 0) {
        for (var i = 0; i < g_monitors.length; i++) {
            var m = g_monitors[i];
            m.left -= g_vscreen.left;
            m.right -= g_vscreen.left;
        }
        for (var i = 0; i < g_windows.length; i++) {
            var m = g_windows[i];
            m.left -= g_vscreen.left;
            m.right -= g_vscreen.left;
        }
        g_vscreen.right -= g_vscreen.left;
        g_curpos.x -= g_vscreen.left;
        g_vscreen.left = 0;
    }
    if (g_vscreen.top < 0) {
        for (var i = 0; i < g_monitors.length; i++) {
            var m = g_monitors[i];
            m.top -= g_vscreen.top;
            m.bottom -= g_vscreen.top;
        }
        for (var i = 0; i < g_windows.length; i++) {
            var m = g_windows[i];
            m.top -= g_vscreen.top;
            m.bottom -= g_vscreen.top;
        }
        g_vscreen.bottom -= g_vscreen.top;
        g_curpos.y -= g_vscreen.top;
        g_vscreen.top = 0;
    }
    for (var i = 0; i < g_windows.length; i++) {
        var m = g_windows[i];
        if (m.right > g_vscreen.right) {
            m.right = g_vscreen.right;
        }
        if (m.bottom > g_vscreen.bottom) {
            m.bottom = g_vscreen.bottom;
        }
    }

    // draw image
    var img = new Image;
    img.src = data.imagedata;
    img.onload = function() {
        (function() {
            var canvas = document.getElementById('orig');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
        })();
        (function() {
            var canvas = document.getElementById('curr');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.globalAlpha = GLOBAL_ALPHA;
            ctx.fillStyle = 'black';
            ctx.fillRect(0, 0, canvas.width, canvas.height);
            ctx.drawImage(img, 0, 0);
        })();

        // show zoom view
        $('#zoom').show();
        UpdateAndLocateZoomView(g_curpos.x, g_curpos.y);
        MakeToolBox();

        LoadJsAsync();

        document.onselectstart = function(e) {
            return false;
        };

        $(window).mousedown(function(e) {
            if (g_step > 1) {
                for (var i = 0; i < g_sel_list.length; i++) {
                    var item = g_sel_list[i];
                    if (!item.focused)
                        continue;
                    var t = e.target;
                    while (t && t != item.node) {
                        t = t.parentNode;
                    }
                    if (!t) {
                        item.blur();
                    }
                }
            }
            if (e.button == 0) {
                if (g_step == -1 && g_active_window) {
                    g_step = 0;
                    g_sel = {
                        sx: e.pageX,
                        sy: e.pageY
                    };
                    ChangeResizeCursors();
                } else if (g_step == -1 || g_step == 0) {
                    g_step = 0;
                    g_sel = {
                        sx: e.pageX,
                        sy: e.pageY
                    };
                    DrawSelbox(e);
                    ChangeResizeCursors();
                } else if (g_step == 2) {
                    var t = e.target;
                    while (t && t != g_toolbox_obj && t != g_brushtool_obj && t != g_blurtool_obj && t != g_hightool_obj && t != g_texttool_obj) {
                        t = t.parentNode;
                    }
                    if (!t && InSelBox(e.pageX, e.pageY)) {
                        //draw start
                        g_draw_start = {
                            x: e.pageX,
                            y: e.pageY
                        };
                        DrawStart(e);
                    }
                } else if (g_step == 3) {
                    //console.log(g_step+','+e.target);
                    var t = e.target;
                    while (t && t != g_texteditor.container && t != g_toolbox_obj && t != g_texttool_obj) {
                        t = t.parentNode;
                    }
                    if (!t) {
                        DrawTextDone();
                        //console.log('text done')
                    }
                } else if (g_step == 4) {
                    //console.log(g_step+','+e.target);
                    var bo = $('#cont_' + g_bubble_obj.id)[0];
                    var t = e.target;
                    while (t && t != g_texteditor.container && t != g_toolbox_obj && t != g_texttool_obj && t != bo) {
                        t = t.parentNode;
                    }
                    if (!t) {
                        DrawBubbleDone();
                        //console.log('bubble done')
                    }
                }
            } else if (e.button == 2) {
                if (g_step == -1) {
                    g_will_close = true;
                } else {
                    var box = $('#selbox');
                    var x = parseInt(box.css('left'));
                    var y = parseInt(box.css('top'));
                    if (e.pageX >= x && e.pageX <= x + box.width() - 1 &&
                        e.pageY >= y && e.pageY <= y + box.height() - 1) {
                        //do nothing
                    } else {
                        RestoreToInitMode();
                        UpdateAndLocateZoomView(e.pageX, e.pageY);
                    }
                }
            }
        });

        $(window).mousemove(function(e) {
            if (e.button != 0)
                return;
            var t = e.target;
            while (t && t != g_texteditor.container && t != g_toolbox_obj && t != g_texttool_obj && t != g_brushtool_obj && t != g_blurtool_obj && t != g_hightool_obj) {
                t = t.parentNode;
            }
            if (t)
                return;
            if (g_step == -1) {
                if (g_active_window_inited) {
                    ActiveWindow(e.pageX, e.pageY);
                    UpdateAndLocateZoomView(e.pageX, e.pageY);
                } else {
                    g_active_window_inited = !(g_curpos.x == e.pageX && g_curpos.y == e.pageY);
                }
            } else if (g_step == 0) {
                if (g_sel) {
                    DrawSelbox(e);
                } else {
                    UpdateAndLocateZoomView(e.pageX, e.pageY);
                }
            } else {
                UpdateZoomView(e.pageX, e.pageY);
                if (g_step == 2 && g_draw_start && g_tb_sel) {
                    Draw(e);
                }
            }
        });

        $(window).mouseup(function(e) {
            if (g_will_close) {
                e.preventDefault();
                QuitSnap();
                return;
            }
            if (e.button == 2 && g_step == -1) {
                ShowCursor(GetCrosshairCursor());
                //window.setTimeout("maxthon.system.Utility.showCursor('crosshair')", 0);
                return;
            }
            if (e.button != 0)
                return;
            if (g_step == 0) {
                if (g_sel.sx == e.pageX && g_sel.sy == e.pageY) {
                    if (g_active_window) {
                        var offset = $('#viewport').offset();
                        var x = offset.left;
                        var y = offset.top;
                        var w = $('#viewport').width();
                        var h = $('#viewport').height();
                        $('#selbox').css('left', x - 1).css('top', y - 1).css('width', w).css('height', h).show();
                        $('#activewindow').hide();
                        RelocateToolBoxAndZoomBox();
                    } else {
                        g_step = -1;
                    }
                } else {
                    DrawSelbox(e);
                }
                g_sel = null;
                var box = $('#selbox');
                if (g_step == 0 && IsSelboxShouldVisible(box.width(), box.height())) {
                    g_step = 1;
                    box.resizable({
                        handles: 'all',
                        resize: function(event, ui) {
                            ResizeSelbox(event, ui);
                            //console.log("___rezise__x" + event.x + "_y:" + event.y);
                        },
                    }).draggable({
                        scrollSensitivity: 0,
                        start: function(event, ui) {
                            if (g_step != 1)
                                return false; // if not in resize state, cancel drag.
                            g_viewport_w = $('#viewport').width();
                            g_viewport_h = $('#viewport').height();
                            g_selbox_w = $('#selbox').width();
                            g_selbox_h = $('#selbox').height();
                            g_selbox_dragged = true;
                        },
                        drag: function(event, ui) {
                            ResizeSelbox(event, ui);
                        },
                        stop: function(event, ui) {
                            g_selbox_dragged = false;
                        },
                    }).mouseup(function(e) {
                        var obj = $(e.srcElement);
                        if (obj.hasClass('ui-resizable-n')) {
                            g_selbox_top_line_selected = true;
                        } else if (obj.hasClass('ui-resizable-s')) {
                            g_selbox_top_line_selected = false;
                        } else if (obj.hasClass('ui-resizable-w')) {
                            g_selbox_left_line_selected = true;
                        } else if (obj.hasClass('ui-resizable-e')) {
                            g_selbox_left_line_selected = false;
                        }
                    });
                    box.css('cursor', 'move');
                    LoadToolboxImages();
                    $('#toolbox').show();
                    RelocateToolBoxAndZoomBox();
                    //LoadAdditionalJavaScripts();
                    ShowCursor('default');
                    RestoreResizeCursors();
                }
            } else if (g_step == 2) {
                if (g_draw_start) {
                    //draw stop
                    DrawStop(e);
                    g_draw_start = null;
                }
            } else if (g_step == 3 || g_step == 4) {
                g_texteditor.OnMouseUp(e);
            }
        });

        $(window).dblclick(function(e) {
            //console.log('dbl step='+g_step+',target='+e.target)
            //check btn
            var t = e.target;
            while (t && t != g_toolbox_obj && t != g_texttool_obj) {
                t = t.parentNode;
            }
            if (t)
                return;
            //
            var found = false;
            if ((g_step == 1 || g_step == 2)) {
                found = true;
            } else if (g_step == 3) {
                var t = e.target;
                while (t && t != g_texteditor.container && t != g_toolbox_obj && t != g_texttool_obj) {
                    t = t.parentNode;
                }
                //console.log(t)
                if (!t) {
                    DrawTextDone();
                    //console.log('text done')
                    found = true;
                }
            } else if (g_step == 4) {
                //console.log(g_step+','+e.target);
                var bo = $('#cont_' + g_bubble_obj.id)[0];
                var t = e.target;
                while (t && t != g_texteditor.container && t != g_toolbox_obj && t != g_texttool_obj && t != bo) {
                    t = t.parentNode;
                }
                if (!t) {
                    DrawBubbleDone();
                    //console.log('bubble done')
                    found = true;
                }
            }
            //console.log('found='+found)
            if (found) {
                CopyAndExit();
            }
        });

        $(document).keydown(function(e) {
            if (e.keyCode == 27) {
                QuitSnap();
            } else if (e.keyCode == 67 && e.ctrlKey) {
                e.preventDefault();
                // CopyToClipboard();
            } else if (e.keyCode == 13) {
                var t = e.target;
                while (t && t != g_texteditor.textarea) {
                    t = t.parentNode;
                }
                if (t)
                    return;
                CopyAndExit();
// { added at 2021/4/28 by hsrao for http://mx6.aoyiteam.com/, bug 26
// support ctrl+z
            } else if(e.keyCode == 90 && e.ctrlKey){
                TBUndo();
// }
            } else if (g_step == 1) {
                if (e.keyCode == 38) {
                    //up
                    if (e.ctrlKey) {
                        if (g_selbox_top_line_selected) {
                            var pos = $('#selbox').position();
                            if (pos.top < 0)
                                return;
                            var ui = {
                                position: {
                                    top: pos.top - 1,
                                    left: pos.left,
                                },
                                size: {
                                    width: $('#selbox').width(),
                                    height: $('#selbox').height() + 1,
                                },
                            };
                            ResizeBoxAndUpdateInfo(ui);
                        } else {
                            var sh = $('#selbox').height();
                            if (sh <= 10)
                                return;
                            var ui = {
                                position: $('#selbox').position(),
                                size: {
                                    width: $('#selbox').width(),
                                    height: sh - 1,
                                },
                            };
                            ResizeBoxAndUpdateInfo(ui);
                        }
                    } else {
                        var pos = $('#selbox').position();
                        if (pos.top < 0)
                            return;
                        var ui = {
                            position: {
                                top: pos.top - 1,
                                left: pos.left,
                            },
                        };
                        ResizeBoxAndUpdateInfo(ui);
                    }
                } else if (e.keyCode == 40) {
                    //down
                    var sh = $('#selbox').height();
                    var pos = $('#selbox').position();
                    if (e.ctrlKey) {
                        if (g_selbox_top_line_selected) {
                            if (sh <= 10)
                                return;
                            var ui = {
                                position: {
                                    top: pos.top + 1,
                                    left: pos.left,
                                },
                                size: {
                                    width: $('#selbox').width(),
                                    height: $('#selbox').height() - 1,
                                },
                            };
                            ResizeBoxAndUpdateInfo(ui);
                        } else {
                            if (pos.top + sh > g_vscreen.height - 2)
                                return;
                            var ui = {
                                position: pos,
                                size: {
                                    width: $('#selbox').width(),
                                    height: sh + 1,
                                },
                            };
                            ResizeBoxAndUpdateInfo(ui);
                        }
                    } else {
                        if (pos.top + sh > g_vscreen.height - 2)
                            return;
                        var ui = {
                            position: {
                                top: pos.top + 1,
                                left: pos.left,
                            },
                        };
                        ResizeBoxAndUpdateInfo(ui);
                    }
                } else if (e.keyCode == 37) {
                    //left
                    if (e.ctrlKey) {
                        if (g_selbox_left_line_selected) {
                            var pos = $('#selbox').position();
                            if (pos.left < 0)
                                return;
                            var ui = {
                                position: {
                                    top: pos.top,
                                    left: pos.left - 1,
                                },
                                size: {
                                    width: $('#selbox').width() + 1,
                                    height: $('#selbox').height(),
                                },
                            };
                            ResizeBoxAndUpdateInfo(ui);
                        } else {
                            var sw = $('#selbox').width();
                            if (sw <= 10)
                                return;
                            var ui = {
                                position: $('#selbox').position(),
                                size: {
                                    width: sw - 1,
                                    height: $('#selbox').height(),
                                },
                            };
                            ResizeBoxAndUpdateInfo(ui);
                        }
                    } else {
                        var pos = $('#selbox').position();
                        if (pos.left < 0)
                            return;
                        var ui = {
                            position: {
                                top: pos.top,
                                left: pos.left - 1,
                            },
                        };
                        ResizeBoxAndUpdateInfo(ui);
                    }
                } else if (e.keyCode == 39) {
                    //right
                    var sw = $('#selbox').width();
                    var pos = $('#selbox').position();
                    if (e.ctrlKey) {
                        if (g_selbox_left_line_selected) {
                            if (sw <= 10)
                                return;
                            var ui = {
                                position: {
                                    top: pos.top,
                                    left: pos.left + 1,
                                },
                                size: {
                                    width: sw - 1,
                                    height: $('#selbox').height(),
                                },
                            };
                            ResizeBoxAndUpdateInfo(ui);
                        } else {
                            if (pos.left + sw > g_vscreen.width - 2)
                                return;
                            var ui = {
                                position: pos,
                                size: {
                                    width: sw + 1,
                                    height: $('#selbox').height(),
                                },
                            };
                            ResizeBoxAndUpdateInfo(ui);
                        }
                    } else {
                        if (pos.left + sw > g_vscreen.width - 2)
                            return;
                        var ui = {
                            position: {
                                top: pos.top,
                                left: pos.left + 1,
                            },
                        };
                        ResizeBoxAndUpdateInfo(ui);
                    }
                }
            }
        });

        AddDragResizeHandler('selbox');

        // notify show window
        setTimeout(function(){
            maxthon.send("snapImageLoaded");
        }, 300);
        
    }
}

function GetDefaultFontCall(font) {
    g_default_text_font = font;
}

function GetFontFamilysCall(msg) {
    function filterFont(value) {
        if (value.indexOf("@") == 0)
            return false;
        return true;
    }
    g_fontfamilys = msg.result;
    g_fontfamilys = g_fontfamilys.filter(filterFont);
}

function GetSnapConfigCall(result) {
    //var success = result.success;
    g_config_str = result.data;
}

function GetMyPicDirCall(result) {
    g_my_pic_dir = result.filepath;
}

var SnapLocale = {
    localeChanged: function(obj) {
        if (obj.status) {
            g_lang_locale = obj.result;
            //console.log("__localeChanged________" + g_lang_locale);
        } else {
        }
    }
};

(function() {
    ShowCursor(GetCrosshairCursor());
    if (window.location.pathname.substring(1) === 'index-fav.htm')
        g_from_note = true;

    uri = parseUri(location);
    var datasizestr = uri.queryKey['datasize'];
    var imagesizestr = uri.queryKey['imagesize'];
    var snap_dict = {
        params: {
            datasize: parseInt(datasizestr),
            imagesize: parseInt(imagesizestr)
        },

        callback: "SnapDataCallBack"
    };

    var default_font_dict = {
        params: {
            // none
        },
        callback: "GetDefaultFontCall"
    };

    var font_familys_dict = {
        params: {
            // none
        },
        callback: "GetFontFamilysCall"
    };

    var config_dict = {
        params: {
            // none
        },
        callback: "GetSnapConfigCall"
    };

    var my_pic_dir_dict = {
        params: {
            'folder-tag': "MyPictures"
        },
        callback: "GetMyPicDirCall"
    };

    var locale_dict = {
        params:{},
        callback:'SnapLocale.localeChanged'
    };

    //maxthon.send("getLocale", [locale_dict]);
    g_lang_locale = navigator.language;
    maxthon.send("getSnapDefaultFont", [default_font_dict]);
    maxthon.send("getSystemFontNames", [font_familys_dict]);
    maxthon.send("getSnapConfig", [config_dict]);
    maxthon.send("getFolderPath", [my_pic_dir_dict]);
    var defaultsize = templateData.DefaultTextSize;
    g_default_text_size = parseInt(defaultsize);
    g_texteditor = new TextEditor(g_default_text_font, g_default_text_size, g_text_color);

    maxthon.send('getSnapData', [snap_dict]);
    window.focus();
    
    disableScroll();
})();
