const baseUrl = "https://surlcn.mxfast.com/data/"

export class SURL {
    static async create(gl) {
        const inst = new SURL
        inst.gl = gl
        return inst
    }
    async run() {
        await this.initDB()
        this.checkUpdate()
    }
    async initDB() {
        const { api } = this.gl
        let ret = await api.openDB({ name: "surl.db", param: { type: "browser" } })
        if (ret.code != 0) {
            console.error("cannot open surl.db")
            return false
        }
        this.dbid = ret.values

        let sql = `CREATE TABLE urls (
            hash TEXT UNIQUE,pv INTEGER
        ); `
        ret = await api.callDB({ dbid: this.dbid, sql, vars: [] })

        sql = `CREATE INDEX index_url ON urls ( hash )`
        ret = await api.callDB({ dbid: this.dbid, sql, vars: [] })

        sql = `CREATE TABLE kv (
            key TEXT UNIQUE,value TEXT
        ); `
        ret = await api.callDB({ dbid: this.dbid, sql, vars: [] })
        sql = 'PRAGMA journal_mode=WAL;'
        ret = await api.callDB({ dbid: this.dbid, sql, vars: [] })

        return true
    }
    async readKV({ key }) {
        const sql = "select * from kv where key = ?"
        const ret = await api.callDB({ dbid: this.dbid, name: "readKV", sql, vars: [key] })
        if (ret.code != 0) return null
        return ret.values[0]?.value
    }
    async saveKV({ key, value }) {
        const sql = "Insert into kv (key,value) values (?,?)"
        const ret = await api.callDB({ dbid: this.dbid, name: "saveKV", sql, vars: [key, value] })
        return ret
    }
    async downloadFile({ url, checkNew = false, checkKey }) {
        const { api } = this.gl
        let lt = await this.readKV({ key: checkKey }) || 0
        if (!checkNew && lt) return null
        const options = {}
        /*if (lt) options.headers = {
            'If-Modified-Since': new Date(lt * 1000).toUTCString(),
            'Cache-Control': "no-cache"
        }*/
        try {
            api.debug("surl: downloading,", url)
            const ret = await fetch(url, options)
            if (ret.status === 200) {
                api.debug("surl: download success,", url)
                lt = Math.floor(Date.now() / 1000)
                await this.saveKV({ key: checkKey, value: lt })
                const text = await ret.text()
                return text
            }
        } catch (e) {
            console.error("surl->downloadFile:", e.message)
        }
        return null
    }
    async addHasheFromUrl({ url, checkNew = false }) {
        if (url.indexOf('http') != 0) url = baseUrl + url
        const hashfile = await this.downloadFile({ url, checkNew, checkKey: url })
        let ret = null
        if (hashfile) {
            const hashes = hashfile.split('\n')
            //ret = await api.callDB({ dbid: this.dbid, sql: 'BEGIN TRANSACTION', vars: [] })
            ret = await this.addHashes(hashes)
            //ret = await api.callDB({ dbid: this.dbid, sql: 'COMMIT', vars: [] })
        }
        return ret
    }
    async addHashes(hashes) {
        const { api } = this.gl
        let ret = null
        let sql = 'insert into urls (hash) values(?)'
        if (!hashes || hashes.length === 0) return false
        for (const hash of hashes) {
            ret = await api.callDB({ dbid: this.dbid, name: "inserthash1", sql, vars: [hash] })
        }
        return ret
    }
    async delHashes(hashes) {
        const { api } = this.gl
        let ret = null
        if (!hashes || hashes.length === 0) return false
        let sql = 'delete from urls where hash = ?'
        for (const hash of hashes) {
            ret = await api.callDB({ dbid: this.dbid, name: "deletehash", sql, vars: [hash] })
        }
        return ret
    }
    async handleDelta(url) {
        if (url.indexOf('http') != 0) url = baseUrl + url
        let delta = await this.downloadFile({ url, checkNew: true, checkKey: url })
        let ret = null
        if (delta) {
            delta = JSON.parse(delta)
            const { hashes, del } = delta
            if (hashes.length > 300) {
                hashes.splice(0, hashes.length - 300)
            }
            ret = await this.addHashes(hashes)
            ret = await this.delHashes(del)
        }
        return ret
    }
    async checkUpdate() {
        let config = await this.downloadFile({ url: baseUrl + "config.json", checkKey: "config", checkNew: true })
        /*if (config) {
            config = JSON.parse(config)
            for (const item of config.files) {
                await this.addHasheFromUrl({ url: item.url })
            }
        } */
        const delta = "delta.json"
        await this.handleDelta(delta)
        const self = this
        setTimeout(() => {
            self.checkUpdate()
        }, 1000 * 60 * 10);
    }

}