/**
    @fileOverview
    the Main Method for WeiBo
    @author liujia <liujia@maxthon.net>

    sidebar_weibo = {
        curId: XXXX,
        curType: XXXX,
        [curType]: [curId], 用来保存对应微博当前的账号
        uids: [sina#XXXX, qq#XXXX, ...],
        [curType]#[curId]: {
            sign: 1代表自动登录 0代表非自动登录,
            name: 用户昵称之类 有别于uid,
            uid: 用户id,
            token: XXXX,
            secret: XXXX,
            alc: XXXX,
            attention: XXX,XXX,
            sinceId: XXX,
            unread: 1111 首页, @我, 评论, 新粉丝,
            sendHotkey: 0代表enter 1代表ctrl+enter
        },
        ....
    }
 */




// localStorage提取的json对象
var LS_OBJECT = {};

// 分隔符
const WEIBO_SEPARATOR = '#';

// localStorage本地存储的key
var LS_KEY = 'snap_weibo';

// 微博表情
var WEIBO_EMOTIONS;

var Global = {
    // 图标显示数字的标示
    sidebar_icon_sign: false,

    /**
        @description 全局参数初始化
     */
    init: function () {
        WEIBO_EMOTIONS = SINA_WEIBO_EMOTIONS;
		LS_OBJECT.curType = LS_OBJECT.curType || Sina.COMPANY;
    },

    /**
        @description 读取本地localStorage对象
     */
    readLS: function () {
       var str = window.localStorage.getItem(LS_KEY);
       if (str) {
           LS_OBJECT = JSON.parse(str);
       }
    },

    /**
        @description 写入本地localStorage对象
     */
    writeLS: function () {
       var str = JSON.stringify(LS_OBJECT);
       window.localStorage.setItem(LS_KEY, str);
    },

    /**
        @description 移除本地localStorage对象
     */          
    removeLS: function () {
       window.localStorage.removeItem(LS_KEY);
       LS_OBJECT = {};
    },

    /**
        @description 将符合字节流的string转化成Blob对象
     */
    binaryToBlob: function (data) {
        var bb;
        var arr = new Uint8Array(data.length);
        for(var i = 0, l = data.length; i < l; i++) {
            arr[i] = data.charCodeAt(i);
        }

        if (Blob) {
            bb = new Blob([arr.buffer]);
            return bb;
        } else {
            if (WebKitBlobBuilder) {
                bb = new WebKitBlobBuilder();
            } else {
                bb = new BlobBuilder();
            }
            bb.append(arr.buffer);
            return bb.getBlob();
        }
    },

    /**
        @description 位数补0
     */
    pad: function (source, length) {
        var pre = "",
            negative = (source < 0),
            string = String(Math.abs(source));

        if (string.length < length) {
            pre = (new Array(length - string.length + 1)).join('0');
        }
        return (negative ?  "-" : "") + pre + string;
    },

    /**
        @description 过滤html
     */
    encodeHtml: function (str) {
        return str.replace(/\&/ig, '&amp;')
            .replace(/\>/ig, '&gt;')
            .replace(/\</ig, '&lt;')
            .replace(/\"/ig, '&quot;');
    }

};

// ajax超时设置
$.ajaxSetup({timeout: 10000});



