import { html, Polymer, Base, dom, templatize, afterNextRender, flush, useShadow, Templatizer, OptionalMutableDataBehavior, animationFrame, microTask, idlePeriod, Debouncer, enqueueDebouncer, matches, translate, dashToCamelCase } from "/resources/polymer/v3_0/polymer/polymer_bundled.min.js";
import { isIOS, isWindows, isMac, addSingletonGetter, addWebUIListener, removeWebUIListener, isChromeOS } from "/resources/js/cr.m.js";
import "/strings.m.js";
import { loadTimeData } from "chrome://resources/js/load_time_data.m.js";
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const template = html`<custom-style>
    <style is="custom-style" css-build="shadow">
      [hidden] {
        display: none !important;
      }
    </style>
  </custom-style>
  <custom-style>
    <style is="custom-style" css-build="shadow">
      html {
        --layout_-_display: flex;

        --layout-inline_-_display: inline-flex;

        --layout-horizontal_-_display: var(--layout_-_display);
        --layout-horizontal_-_flex-direction: row;

        --layout-horizontal-reverse_-_display: var(--layout_-_display);
        --layout-horizontal-reverse_-_flex-direction: row-reverse;

        --layout-vertical_-_display: var(--layout_-_display);
        --layout-vertical_-_flex-direction: column;

        --layout-vertical-reverse_-_display: var(--layout_-_display);
        --layout-vertical-reverse_-_flex-direction: column-reverse;

        --layout-wrap_-_flex-wrap: wrap;

        --layout-wrap-reverse_-_flex-wrap: wrap-reverse;

        --layout-flex-auto_-_flex: 1 1 auto;

        --layout-flex-none_-_flex: none;

        --layout-flex_-_flex: 1;
        --layout-flex_-_flex-basis: 0.000000001px;

        --layout-flex-2_-_flex: 2;

        --layout-flex-3_-_flex: 3;

        --layout-flex-4_-_flex: 4;

        --layout-flex-5_-_flex: 5;

        --layout-flex-6_-_flex: 6;

        --layout-flex-7_-_flex: 7;

        --layout-flex-8_-_flex: 8;

        --layout-flex-9_-_flex: 9;

        --layout-flex-10_-_flex: 10;

        --layout-flex-11_-_flex: 11;

        --layout-flex-12_-_flex: 12;

        --layout-start_-_align-items: flex-start;

        --layout-center_-_align-items: center;

        --layout-end_-_align-items: flex-end;

        --layout-baseline_-_align-items: baseline;

        --layout-start-justified_-_justify-content: flex-start;

        --layout-center-justified_-_justify-content: center;

        --layout-end-justified_-_justify-content: flex-end;

        --layout-around-justified_-_justify-content: space-around;

        --layout-justified_-_justify-content: space-between;

        --layout-center-center_-_align-items: var(--layout-center_-_align-items);
        --layout-center-center_-_justify-content: var(--layout-center-justified_-_justify-content);

        --layout-self-start_-_align-self: flex-start;

        --layout-self-center_-_align-self: center;

        --layout-self-end_-_align-self: flex-end;

        --layout-self-stretch_-_align-self: stretch;

        --layout-self-baseline_-_align-self: baseline;

        --layout-start-aligned_-_align-content: flex-start;

        --layout-end-aligned_-_align-content: flex-end;

        --layout-center-aligned_-_align-content: center;

        --layout-between-aligned_-_align-content: space-between;

        --layout-around-aligned_-_align-content: space-around;

        --layout-block_-_display: block;

        --layout-invisible_-_visibility: hidden !important;

        --layout-relative_-_position: relative;

        --layout-fit_-_position: absolute;
        --layout-fit_-_top: 0;
        --layout-fit_-_right: 0;
        --layout-fit_-_bottom: 0;
        --layout-fit_-_left: 0;

        --layout-scroll_-_-webkit-overflow-scrolling: touch;
        --layout-scroll_-_overflow: auto;

        --layout-fullbleed_-_margin: 0;
        --layout-fullbleed_-_height: 100vh;

        --layout-fixed-top_-_position: fixed;
        --layout-fixed-top_-_top: 0;
        --layout-fixed-top_-_left: 0;
        --layout-fixed-top_-_right: 0;

        --layout-fixed-right_-_position: fixed;
        --layout-fixed-right_-_top: 0;
        --layout-fixed-right_-_right: 0;
        --layout-fixed-right_-_bottom: 0;

        --layout-fixed-bottom_-_position: fixed;
        --layout-fixed-bottom_-_right: 0;
        --layout-fixed-bottom_-_bottom: 0;
        --layout-fixed-bottom_-_left: 0;

        --layout-fixed-left_-_position: fixed;
        --layout-fixed-left_-_top: 0;
        --layout-fixed-left_-_bottom: 0;
        --layout-fixed-left_-_left: 0;
      }
    </style>
  </custom-style>`;
template.setAttribute("style", "display: none;");
document.head.appendChild(template.content);
var style = document.createElement("style");
style.textContent = "[hidden] { display: none !important; }";
document.head.appendChild(style);
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
class IronMeta {
  constructor(options) {
    IronMeta[" "](options);
    this.type = (options && options.type) || "default";
    this.key = options && options.key;
    if (options && "value" in options) {
      this.value = options.value;
    }
  }
  get value() {
    var type = this.type;
    var key = this.key;
    if (type && key) {
      return IronMeta.types[type] && IronMeta.types[type][key];
    }
  }
  set value(value) {
    var type = this.type;
    var key = this.key;
    if (type && key) {
      type = IronMeta.types[type] = IronMeta.types[type] || {};
      if (value == null) {
        delete type[key];
      } else {
        type[key] = value;
      }
    }
  }
  get list() {
    var type = this.type;
    if (type) {
      var items = IronMeta.types[this.type];
      if (!items) {
        return [];
      }
      return Object.keys(items).map(function(key) {
        return metaDatas[this.type][key];
      }, this);
    }
  }
  byKey(key) {
    this.key = key;
    return this.value;
  }
}
IronMeta[" "] = function() { };
IronMeta.types = {};
var metaDatas = IronMeta.types;
Polymer({
  is: "iron-meta",
  properties: {
    type: {
      type: String,
      value: "default",
    },
    key: {
      type: String,
    },
    value: {
      type: String,
      notify: true,
    },
    self: {
      type: Boolean,
      observer: "_selfChanged",
    },
    __meta: {
      type: Boolean,
      computed: "__computeMeta(type, key, value)",
    },
  },
  hostAttributes: {
    hidden: true,
  },
  __computeMeta: function(type, key, value) {
    var meta = new IronMeta({
      type: type,
      key: key,
    });
    if (value !== undefined && value !== meta.value) {
      meta.value = value;
    } else if (this.value !== meta.value) {
      this.value = meta.value;
    }
    return meta;
  },
  get list() {
    return this.__meta && this.__meta.list;
  },
  _selfChanged: function(self) {
    if (self) {
      this.value = this;
    }
  },
  byKey: function(key) {
    return new IronMeta({
      type: this.type,
      key: key,
    }).value;
  },
});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
Polymer({
  _template: html`<!--css-build:shadow--><style scope="iron-icon">
      :host {
        display: var(--layout-inline_-_display);
        align-items: var(--layout-center-center_-_align-items);
        justify-content: var(--layout-center-center_-_justify-content);
        position: relative;

        vertical-align: middle;

        fill: var(--iron-icon-fill-color, currentcolor);
        stroke: var(--iron-icon-stroke-color, none);

        width: var(--iron-icon-width, 24px);
        height: var(--iron-icon-height, 24px);
      }

      :host([hidden]) {
        display: none;
      }
    </style> `,
  is: "iron-icon",
  properties: {
    icon: {
      type: String,
    },
    theme: {
      type: String,
    },
    src: {
      type: String,
    },
    _meta: {
      value: Base.create("iron-meta", {
        type: "iconset",
      }),
    },
  },
  observers: ["_updateIcon(_meta, isAttached)", "_updateIcon(theme, isAttached)", "_srcChanged(src, isAttached)", "_iconChanged(icon, isAttached)"],
  _DEFAULT_ICONSET: "icons",
  _iconChanged: function(icon) {
    var parts = (icon || "").split(":");
    this._iconName = parts.pop();
    this._iconsetName = parts.pop() || this._DEFAULT_ICONSET;
    this._updateIcon();
  },
  _srcChanged: function(src) {
    this._updateIcon();
  },
  _usesIconset: function() {
    return this.icon || !this.src;
  },
  _updateIcon: function() {
    if (this._usesIconset()) {
      if (this._img && this._img.parentNode) {
        dom(this.root).removeChild(this._img);
      }
      if (this._iconName === "") {
        if (this._iconset) {
          this._iconset.removeIcon(this);
        }
      } else if (this._iconsetName && this._meta) {
        this._iconset = this._meta.byKey(this._iconsetName);
        if (this._iconset) {
          this._iconset.applyIcon(this, this._iconName, this.theme);
          this.unlisten(window, "iron-iconset-added", "_updateIcon");
        } else {
          this.listen(window, "iron-iconset-added", "_updateIcon");
        }
      }
    } else {
      if (this._iconset) {
        this._iconset.removeIcon(this);
      }
      if (!this._img) {
        this._img = document.createElement("img");
        this._img.style.width = "100%";
        this._img.style.height = "100%";
        this._img.draggable = false;
      }
      this._img.src = this.src;
      dom(this.root).appendChild(this._img);
    }
  },
});
// Copyright (c) 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function assert(condition, opt_message) {
  if (!condition) {
    let message = "Assertion failed";
    if (opt_message) {
      message = message + ": " + opt_message;
    }
    const error = new Error(message);
    const global = (function() {
      const thisOrSelf = this || self;
      thisOrSelf.traceAssertionsForTesting;
      return thisOrSelf;
    })();
    if (global.traceAssertionsForTesting) {
      console.warn(error.stack);
    }
    throw error;
  }
  return condition;
}
function assertNotReached(opt_message) {
  assert(false, opt_message || "Unreachable code hit");
}
function assertInstanceof(value, type, opt_message) {
  if (!(value instanceof type)) {
    assertNotReached(opt_message || "Value " + value + " is not a[n] " + (type.name || typeof type));
  }
  return value;
}
// Copyright (c) 2012 The Chromium Authors. All rights reserved.
function getDeepActiveElement() {
  let a = document.activeElement;
  while (a && a.shadowRoot && a.shadowRoot.activeElement) {
    a = a.shadowRoot.activeElement;
  }
  return a;
}
function isRTL() {
  return document.documentElement.dir === "rtl";
}
function listenOnce(target, eventNames, callback) {
  if (!Array.isArray(eventNames)) {
    eventNames = eventNames.split(/ +/);
  }
  const removeAllAndCallCallback = function(event) {
    eventNames.forEach(function(eventName) {
      target.removeEventListener(eventName, removeAllAndCallCallback, false);
    });
    return callback(event);
  };
  eventNames.forEach(function(eventName) {
    target.addEventListener(eventName, removeAllAndCallCallback, false);
  });
}
//   /* is_ios */
function hasKeyModifiers(e) {
  return !!(e.altKey || e.ctrlKey || e.metaKey || e.shiftKey);
}
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const template$1 = html`<custom-style>
  <style is="custom-style" css-build="shadow">
    html {
      --google-red-100-rgb: 244, 199, 195;
      --google-red-100: rgb(var(--google-red-100-rgb));
      --google-red-300-rgb: 230, 124, 115;
      --google-red-300: rgb(var(--google-red-300-rgb));
      --google-red-500-rgb: 219, 68, 55;
      --google-red-500: rgb(var(--google-red-500-rgb));
      --google-red-700-rgb: 197, 57, 41;
      --google-red-700: rgb(var(--google-red-700-rgb));

      --google-blue-100-rgb: 198, 218, 252;
      --google-blue-100: rgb(var(--google-blue-100-rgb));
      --google-blue-300-rgb: 123, 170, 247;
      --google-blue-300: rgb(var(--google-blue-300-rgb));
      --google-blue-500-rgb: 66, 133, 244;
      --google-blue-500: rgb(var(--google-blue-500-rgb));
      --google-blue-700-rgb: 51, 103, 214;
      --google-blue-700: rgb(var(--google-blue-700-rgb));

      --google-green-100-rgb: 183, 225, 205;
      --google-green-100: rgb(var(--google-green-100-rgb));
      --google-green-300-rgb: 87, 187, 138;
      --google-green-300: rgb(var(--google-green-300-rgb));
      --google-green-500-rgb: 15, 157, 88;
      --google-green-500: rgb(var(--google-green-500-rgb));
      --google-green-700-rgb: 11, 128, 67;
      --google-green-700: rgb(var(--google-green-700-rgb));

      --google-yellow-100-rgb: 252, 232, 178;
      --google-yellow-100: rgb(var(--google-yellow-100-rgb));
      --google-yellow-300-rgb: 247, 203, 77;
      --google-yellow-300: rgb(var(--google-yellow-300-rgb));
      --google-yellow-500-rgb: 244, 180, 0;
      --google-yellow-500: rgb(var(--google-yellow-500-rgb));
      --google-yellow-700-rgb: 240, 147, 0;
      --google-yellow-700: rgb(var(--google-yellow-700-rgb));

      --google-grey-100-rgb: 245, 245, 245;
      --google-grey-100: rgb(var(--google-grey-100-rgb));
      --google-grey-300-rgb: 224, 224, 224;
      --google-grey-300: rgb(var(--google-grey-300-rgb));
      --google-grey-500-rgb: 158, 158, 158;
      --google-grey-500: rgb(var(--google-grey-500-rgb));
      --google-grey-700-rgb: 97, 97, 97;
      --google-grey-700: rgb(var(--google-grey-700-rgb));

      --paper-red-50: #ffebee;
      --paper-red-100: #ffcdd2;
      --paper-red-200: #ef9a9a;
      --paper-red-300: #e57373;
      --paper-red-400: #ef5350;
      --paper-red-500: #f44336;
      --paper-red-600: #e53935;
      --paper-red-700: #d32f2f;
      --paper-red-800: #c62828;
      --paper-red-900: #b71c1c;
      --paper-red-a100: #ff8a80;
      --paper-red-a200: #ff5252;
      --paper-red-a400: #ff1744;
      --paper-red-a700: #d50000;

      --paper-pink-50: #fce4ec;
      --paper-pink-100: #f8bbd0;
      --paper-pink-200: #f48fb1;
      --paper-pink-300: #f06292;
      --paper-pink-400: #ec407a;
      --paper-pink-500: #e91e63;
      --paper-pink-600: #d81b60;
      --paper-pink-700: #c2185b;
      --paper-pink-800: #ad1457;
      --paper-pink-900: #880e4f;
      --paper-pink-a100: #ff80ab;
      --paper-pink-a200: #ff4081;
      --paper-pink-a400: #f50057;
      --paper-pink-a700: #c51162;

      --paper-purple-50: #f3e5f5;
      --paper-purple-100: #e1bee7;
      --paper-purple-200: #ce93d8;
      --paper-purple-300: #ba68c8;
      --paper-purple-400: #ab47bc;
      --paper-purple-500: #9c27b0;
      --paper-purple-600: #8e24aa;
      --paper-purple-700: #7b1fa2;
      --paper-purple-800: #6a1b9a;
      --paper-purple-900: #4a148c;
      --paper-purple-a100: #ea80fc;
      --paper-purple-a200: #e040fb;
      --paper-purple-a400: #d500f9;
      --paper-purple-a700: #aa00ff;

      --paper-deep-purple-50: #ede7f6;
      --paper-deep-purple-100: #d1c4e9;
      --paper-deep-purple-200: #b39ddb;
      --paper-deep-purple-300: #9575cd;
      --paper-deep-purple-400: #7e57c2;
      --paper-deep-purple-500: #673ab7;
      --paper-deep-purple-600: #5e35b1;
      --paper-deep-purple-700: #512da8;
      --paper-deep-purple-800: #4527a0;
      --paper-deep-purple-900: #311b92;
      --paper-deep-purple-a100: #b388ff;
      --paper-deep-purple-a200: #7c4dff;
      --paper-deep-purple-a400: #651fff;
      --paper-deep-purple-a700: #6200ea;

      --paper-indigo-50: #e8eaf6;
      --paper-indigo-100: #c5cae9;
      --paper-indigo-200: #9fa8da;
      --paper-indigo-300: #7986cb;
      --paper-indigo-400: #5c6bc0;
      --paper-indigo-500: #3f51b5;
      --paper-indigo-600: #3949ab;
      --paper-indigo-700: #303f9f;
      --paper-indigo-800: #283593;
      --paper-indigo-900: #1a237e;
      --paper-indigo-a100: #8c9eff;
      --paper-indigo-a200: #536dfe;
      --paper-indigo-a400: #3d5afe;
      --paper-indigo-a700: #304ffe;

      --paper-blue-50: #e3f2fd;
      --paper-blue-100: #bbdefb;
      --paper-blue-200: #90caf9;
      --paper-blue-300: #64b5f6;
      --paper-blue-400: #42a5f5;
      --paper-blue-500: #2196f3;
      --paper-blue-600: #1e88e5;
      --paper-blue-700: #1976d2;
      --paper-blue-800: #1565c0;
      --paper-blue-900: #0d47a1;
      --paper-blue-a100: #82b1ff;
      --paper-blue-a200: #448aff;
      --paper-blue-a400: #2979ff;
      --paper-blue-a700: #2962ff;

      --paper-light-blue-50: #e1f5fe;
      --paper-light-blue-100: #b3e5fc;
      --paper-light-blue-200: #81d4fa;
      --paper-light-blue-300: #4fc3f7;
      --paper-light-blue-400: #29b6f6;
      --paper-light-blue-500: #03a9f4;
      --paper-light-blue-600: #039be5;
      --paper-light-blue-700: #0288d1;
      --paper-light-blue-800: #0277bd;
      --paper-light-blue-900: #01579b;
      --paper-light-blue-a100: #80d8ff;
      --paper-light-blue-a200: #40c4ff;
      --paper-light-blue-a400: #00b0ff;
      --paper-light-blue-a700: #0091ea;

      --paper-cyan-50: #e0f7fa;
      --paper-cyan-100: #b2ebf2;
      --paper-cyan-200: #80deea;
      --paper-cyan-300: #4dd0e1;
      --paper-cyan-400: #26c6da;
      --paper-cyan-500: #00bcd4;
      --paper-cyan-600: #00acc1;
      --paper-cyan-700: #0097a7;
      --paper-cyan-800: #00838f;
      --paper-cyan-900: #006064;
      --paper-cyan-a100: #84ffff;
      --paper-cyan-a200: #18ffff;
      --paper-cyan-a400: #00e5ff;
      --paper-cyan-a700: #00b8d4;

      --paper-teal-50: #e0f2f1;
      --paper-teal-100: #b2dfdb;
      --paper-teal-200: #80cbc4;
      --paper-teal-300: #4db6ac;
      --paper-teal-400: #26a69a;
      --paper-teal-500: #009688;
      --paper-teal-600: #00897b;
      --paper-teal-700: #00796b;
      --paper-teal-800: #00695c;
      --paper-teal-900: #004d40;
      --paper-teal-a100: #a7ffeb;
      --paper-teal-a200: #64ffda;
      --paper-teal-a400: #1de9b6;
      --paper-teal-a700: #00bfa5;

      --paper-green-50: #e8f5e9;
      --paper-green-100: #c8e6c9;
      --paper-green-200: #a5d6a7;
      --paper-green-300: #81c784;
      --paper-green-400: #66bb6a;
      --paper-green-500: #4caf50;
      --paper-green-600: #43a047;
      --paper-green-700: #388e3c;
      --paper-green-800: #2e7d32;
      --paper-green-900: #1b5e20;
      --paper-green-a100: #b9f6ca;
      --paper-green-a200: #69f0ae;
      --paper-green-a400: #00e676;
      --paper-green-a700: #00c853;

      --paper-light-green-50: #f1f8e9;
      --paper-light-green-100: #dcedc8;
      --paper-light-green-200: #c5e1a5;
      --paper-light-green-300: #aed581;
      --paper-light-green-400: #9ccc65;
      --paper-light-green-500: #8bc34a;
      --paper-light-green-600: #7cb342;
      --paper-light-green-700: #689f38;
      --paper-light-green-800: #558b2f;
      --paper-light-green-900: #33691e;
      --paper-light-green-a100: #ccff90;
      --paper-light-green-a200: #b2ff59;
      --paper-light-green-a400: #76ff03;
      --paper-light-green-a700: #64dd17;

      --paper-lime-50: #f9fbe7;
      --paper-lime-100: #f0f4c3;
      --paper-lime-200: #e6ee9c;
      --paper-lime-300: #dce775;
      --paper-lime-400: #d4e157;
      --paper-lime-500: #cddc39;
      --paper-lime-600: #c0ca33;
      --paper-lime-700: #afb42b;
      --paper-lime-800: #9e9d24;
      --paper-lime-900: #827717;
      --paper-lime-a100: #f4ff81;
      --paper-lime-a200: #eeff41;
      --paper-lime-a400: #c6ff00;
      --paper-lime-a700: #aeea00;

      --paper-yellow-50: #fffde7;
      --paper-yellow-100: #fff9c4;
      --paper-yellow-200: #fff59d;
      --paper-yellow-300: #fff176;
      --paper-yellow-400: #ffee58;
      --paper-yellow-500: #ffeb3b;
      --paper-yellow-600: #fdd835;
      --paper-yellow-700: #fbc02d;
      --paper-yellow-800: #f9a825;
      --paper-yellow-900: #f57f17;
      --paper-yellow-a100: #ffff8d;
      --paper-yellow-a200: #ffff00;
      --paper-yellow-a400: #ffea00;
      --paper-yellow-a700: #ffd600;

      --paper-amber-50: #fff8e1;
      --paper-amber-100: #ffecb3;
      --paper-amber-200: #ffe082;
      --paper-amber-300: #ffd54f;
      --paper-amber-400: #ffca28;
      --paper-amber-500: #ffc107;
      --paper-amber-600: #ffb300;
      --paper-amber-700: #ffa000;
      --paper-amber-800: #ff8f00;
      --paper-amber-900: #ff6f00;
      --paper-amber-a100: #ffe57f;
      --paper-amber-a200: #ffd740;
      --paper-amber-a400: #ffc400;
      --paper-amber-a700: #ffab00;

      --paper-orange-50: #fff3e0;
      --paper-orange-100: #ffe0b2;
      --paper-orange-200: #ffcc80;
      --paper-orange-300: #ffb74d;
      --paper-orange-400: #ffa726;
      --paper-orange-500: #ff9800;
      --paper-orange-600: #fb8c00;
      --paper-orange-700: #f57c00;
      --paper-orange-800: #ef6c00;
      --paper-orange-900: #e65100;
      --paper-orange-a100: #ffd180;
      --paper-orange-a200: #ffab40;
      --paper-orange-a400: #ff9100;
      --paper-orange-a700: #ff6500;

      --paper-deep-orange-50: #fbe9e7;
      --paper-deep-orange-100: #ffccbc;
      --paper-deep-orange-200: #ffab91;
      --paper-deep-orange-300: #ff8a65;
      --paper-deep-orange-400: #ff7043;
      --paper-deep-orange-500: #ff5722;
      --paper-deep-orange-600: #f4511e;
      --paper-deep-orange-700: #e64a19;
      --paper-deep-orange-800: #d84315;
      --paper-deep-orange-900: #bf360c;
      --paper-deep-orange-a100: #ff9e80;
      --paper-deep-orange-a200: #ff6e40;
      --paper-deep-orange-a400: #ff3d00;
      --paper-deep-orange-a700: #dd2c00;

      --paper-brown-50: #efebe9;
      --paper-brown-100: #d7ccc8;
      --paper-brown-200: #bcaaa4;
      --paper-brown-300: #a1887f;
      --paper-brown-400: #8d6e63;
      --paper-brown-500: #795548;
      --paper-brown-600: #6d4c41;
      --paper-brown-700: #5d4037;
      --paper-brown-800: #4e342e;
      --paper-brown-900: #3e2723;

      --paper-grey-50: #fafafa;
      --paper-grey-100: #f5f5f5;
      --paper-grey-200: #eeeeee;
      --paper-grey-300: #e0e0e0;
      --paper-grey-400: #bdbdbd;
      --paper-grey-500: #9e9e9e;
      --paper-grey-600: #757575;
      --paper-grey-700: #616161;
      --paper-grey-800: #424242;
      --paper-grey-900: #212121;

      --paper-blue-grey-50: #eceff1;
      --paper-blue-grey-100: #cfd8dc;
      --paper-blue-grey-200: #b0bec5;
      --paper-blue-grey-300: #90a4ae;
      --paper-blue-grey-400: #78909c;
      --paper-blue-grey-500: #607d8b;
      --paper-blue-grey-600: #546e7a;
      --paper-blue-grey-700: #455a64;
      --paper-blue-grey-800: #37474f;
      --paper-blue-grey-900: #263238;

      --dark-divider-opacity: 0.12;
      --dark-disabled-opacity: 0.38;
      --dark-secondary-opacity: 0.54;
      --dark-primary-opacity: 0.87;

      --light-divider-opacity: 0.12;
      --light-disabled-opacity: 0.3;
      --light-secondary-opacity: 0.7;
      --light-primary-opacity: 1;
    }
  </style>
</custom-style> `;
template$1.setAttribute("style", "display: none;");
document.head.appendChild(template$1.content);
const $_documentContainer = document.createElement("template");
$_documentContainer.innerHTML = `<custom-style>
<style is="custom-style" css-build="shadow">html {
    --google-blue-50-rgb: 232, 240, 254;
      --google-blue-50: rgb(var(--google-blue-50-rgb));
      --google-blue-200-rgb: 174, 203, 250;
      --google-blue-200: rgb(var(--google-blue-200-rgb));
      --google-blue-600-rgb: 26, 115, 232;
      --google-blue-600: rgb(var(--google-blue-600-rgb));
      --google-grey-200-rgb: 232, 234, 237;
      --google-grey-200: rgb(var(--google-grey-200-rgb));
      --google-grey-400-rgb: 189, 193, 198;
      --google-grey-400: rgb(var(--google-grey-400-rgb));
      --google-grey-600-rgb: 128, 134, 139;
      --google-grey-600: rgb(var(--google-grey-600-rgb));
      --google-grey-800-rgb: 60, 64, 67;
      --google-grey-800: rgb(var(--google-grey-800-rgb));
      --google-grey-900-rgb: 32, 33, 36;
      --google-grey-900: rgb(var(--google-grey-900-rgb));

      --google-grey-900-white-4-percent: #292a2d;
      --google-red-600-rgb: 217, 48, 37;
      --google-red-600: rgb(var(--google-red-600-rgb));

      --google-blue-refresh-100-rgb: 210, 227, 252;
      --google-blue-refresh-100: rgb(var(--google-blue-refresh-100-rgb));
      --google-blue-refresh-300-rgb: 138, 180, 248;
      --google-blue-refresh-300: rgb(var(--google-blue-refresh-300-rgb));
      --google-blue-refresh-500-rgb: 66, 133, 244;
      --google-blue-refresh-500: rgb(var(--google-blue-refresh-500-rgb));
      --google-blue-refresh-700-rgb: 25, 103, 210;
      --google-blue-refresh-700: rgb(var(--google-blue-refresh-700-rgb));
      --google-green-refresh-300-rgb: 129, 201, 149;
      --google-green-refresh-300: rgb(var(--google-green-refresh-300-rgb));
      --google-green-refresh-700-rgb: 24, 128, 56;
      --google-green-refresh-700: rgb(var(--google-green-refresh-700-rgb));
      --google-grey-refresh-100-rgb: 241, 243, 244;
      --google-grey-refresh-100: rgb(var(--google-grey-refresh-100-rgb));
      --google-grey-refresh-300-rgb: 218, 220, 224;
      --google-grey-refresh-300: rgb(var(--google-grey-refresh-300-rgb));
      --google-grey-refresh-500-rgb: 154, 160, 166;
      --google-grey-refresh-500: rgb(var(--google-grey-refresh-500-rgb));
      --google-grey-refresh-700-rgb: 95, 99, 104;
      --google-grey-refresh-700: rgb(var(--google-grey-refresh-700-rgb));
      --google-red-refresh-300-rgb: 242, 139, 130;
      --google-red-refresh-300: rgb(var(--google-red-refresh-300-rgb));
      --google-red-refresh-500-rgb: 234, 67, 53;
      --google-red-refresh-500: rgb(var(--google-red-refresh-500-rgb));
      --google-yellow-refresh-300-rgb: 253, 214, 51;
      --google-yellow-refresh-300: rgb(var(--google-yellow-refresh-300-rgb));
      --cr-primary-text-color: var(--google-grey-900);
      --cr-secondary-text-color: var(--google-grey-refresh-700);
      --cr-card-shadow-color-rgb: var(--google-grey-800-rgb);
      --cr-elevation-1: rgba(var(--cr-card-shadow-color-rgb), .3) 0 1px 2px 0,
                        rgba(var(--cr-card-shadow-color-rgb), .15) 0 1px 3px 1px;
      --cr-elevation-2: rgba(var(--cr-card-shadow-color-rgb), .3) 0 1px 2px 0,
                        rgba(var(--cr-card-shadow-color-rgb), .15) 0 2px 6px 2px;
      --cr-elevation-3: rgba(var(--cr-card-shadow-color-rgb), .3) 0 1px 3px 0,
                        rgba(var(--cr-card-shadow-color-rgb), .15) 0 4px 8px 3px;
      --cr-elevation-4: rgba(var(--cr-card-shadow-color-rgb), .3) 0 2px 3px 0,
                        rgba(var(--cr-card-shadow-color-rgb), .15) 0 6px 10px 4px;
      --cr-elevation-5: rgba(var(--cr-card-shadow-color-rgb), .3) 0 4px 4px 0,
                        rgba(var(--cr-card-shadow-color-rgb), .15) 0 8px 12px 6px;
      --cr-card-shadow: var(--cr-elevation-1);
      --cr-checked-color: var(--google-blue-600);
      --cr-focused-item-color: var(--google-grey-300);
      --cr-form-field-label-color: var(--google-grey-refresh-700);
      --cr-hairline-rgb: 0, 0, 0;
      --cr-link-color: var(--google-blue-700);
      --cr-menu-background-color: white;
      --cr-menu-background-focus-color: var(--google-grey-200);
      --cr-menu-shadow: 0 2px 6px var(--paper-grey-500);
      --cr-separator-color: rgba(0, 0, 0, .06);
      --cr-title-text-color: rgb(90, 90, 90);
      --cr-toggle-color: var(--google-blue-500);

      /* 2022-01-10 */
      --maxthon-border: #ddd;
      --maxthon-bg-base: #fff;
      --maxthon-bg-hover: #fafafa;
      --maxthon-bg-active: #f1f1f1;
      --maxthon-bg-input: var(--maxthon-bg-base);
      --cr-toolbar-search-field-input-text-color: #212121;
      --cr-toolbar-background-color: var(--maxthon-bg-base);
      --cr-card-background-color: var(--maxthon-bg-base);
}
@media (prefers-color-scheme: dark) {
  html {
    --maxthon-border: #4f4f4f;
    --maxthon-bg-base: #333;
    --maxthon-bg-hover: #444;
    --maxthon-bg-active: #444;
    --maxthon-bg-input: #2b2b2b;
    --cr-toolbar-search-field-input-text-color: #9e9e9e;
    --cr-toolbar-background-color: var(--maxthon-bg-base);
    --cr-card-background-color: var(--maxthon-bg-base);
      /* 2022-01-10 */

    --cr-primary-text-color: var(--google-grey-200);
    --cr-secondary-text-color: var(--google-grey-refresh-500);
    --cr-card-shadow-color-rgb: 0, 0, 0;
    --cr-checked-color: var(--google-blue-refresh-300);
    --cr-form-field-label-color: var(--dark-secondary-color);
    --cr-hairline-rgb: 255, 255, 255;
    --cr-link-color: var(--google-blue-refresh-300);
    --cr-menu-background-color: var(--google-grey-900);
    --cr-menu-background-focus-color: rgba(var(--google-grey-800-rgb), .6);
    --cr-menu-background-sheen: rgba(255, 255, 255, .06);
    --cr-menu-shadow: rgba(0, 0, 0, .3) 0 1px 2px 0,
                      rgba(0, 0, 0, .15) 0 3px 6px 2px;
    --cr-separator-color: rgba(255, 255, 255, .1);

    --cr-title-text-color: var(--cr-primary-text-color);
  }
}
html {
    --cr-button-edge-spacing: 12px;
      --cr-button-height: 32px;

      --cr-controlled-by-spacing: 24px;

      --cr-default-input-max-width: 264px;

      --cr-icon-ripple-size: 36px;
      --cr-icon-ripple-padding: 8px;
      --cr-icon-size: 20px;
      --cr-icon-button-margin-start: 16px;

      --cr-icon-ripple-margin: calc(var(--cr-icon-ripple-padding) * -1);


      --cr-section-min-height: 48px;
      --cr-section-two-line-min-height: 64px;
      --cr-section-three-line-min-height: 84px;
      --cr-section-padding: 20px;
      --cr-section-vertical-padding: 12px;
      --cr-section-indent-width: 40px;
      --cr-section-indent-padding: calc(
          var(--cr-section-padding) + var(--cr-section-indent-width));

      --cr-section_-_align-items:  center; --cr-section_-_border-top:  var(--cr-separator-line); --cr-section_-_display:  flex; --cr-section_-_min-height:  var(--cr-section-min-height); --cr-section_-_padding:  0 var(--cr-section-padding);
      --cr-section-vertical-margin: 21px;
      --cr-centered-card-max-width: 680px;
      --cr-centered-card-width-percentage: 0.96;
      --cr-hairline: 1px solid rgba(var(--cr-hairline-rgb), .14);
      --cr-separator-height: 1px;
      --cr-separator-line: var(--cr-separator-height) solid
          var(--cr-separator-color);
      --cr-toolbar-overlay-animation-duration: 150ms;
      --cr-toolbar-height: 56px;
      --cr-container-shadow-height: 6px;
      --cr-container-shadow-margin: calc(-1 * var(--cr-container-shadow-height));
      --cr-container-shadow-max-opacity: 1;

      --cr-card-border-radius: 4px;
      --cr-disabled-opacity: .38;
      --cr-form-field-bottom-spacing: 16px;
      --cr-form-field-label-font-size: .625rem;
      --cr-form-field-label-height: 1em;
      --cr-form-field-label-line-height: 1em;
}
</style>
</custom-style>
`;
document.head.appendChild($_documentContainer.content);
// Copyright 2016 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="cr-drawer">
      :host dialog {
        --drawer-width: 240px;
        --transition-timing: 200ms ease;
        background-color: #fff;
        border: none;
        bottom: 0;
        left: calc(-1 * var(--drawer-width));
        margin: 0;
        overflow: hidden;
        padding: 0;
        position: absolute;
        top: 0;
        transition: left var(--transition-timing);
        width: var(--drawer-width);
      }

      @media (prefers-color-scheme: dark) {
        :host dialog {
          background: var(--google-grey-900) linear-gradient(rgba(255, 255, 255, 0.04), rgba(255, 255, 255, 0.04));
        }
      }

      :host dialog,
      #container {
        height: 100%;
        word-break: break-word;
      }

      :host([show_]) dialog {
        left: 0;
      }

      :host([align="rtl"]) dialog {
        left: auto;
        right: calc(-1 * var(--drawer-width));
        transition: right var(--transition-timing);
      }

      :host([show_][align="rtl"]) dialog {
        right: 0;
      }

      :host dialog::backdrop {
        background: rgba(0, 0, 0, 0.5);
        bottom: 0;
        left: 0;
        opacity: 0;
        position: absolute;
        right: 0;
        top: 0;
        transition: opacity var(--transition-timing);
      }

      :host([show_]) dialog::backdrop {
        opacity: 1;
      }

      .drawer-header {
        align-items: center;
        border-bottom: var(--cr-separator-line);
        color: var(--cr-drawer-header-color, inherit);
        display: flex;
        font-size: 123.08%;
        font-weight: var(--cr-drawer-header-font-weight, inherit);
        min-height: 56px;
        padding-inline-start: var(--cr-drawer-header-padding, 24px);
      }

      @media (prefers-color-scheme: dark) {
        .drawer-header {
          color: var(--cr-primary-text-color);
        }
      }

      #heading {
        outline: none;
      }

      #iconButton {
        cursor: pointer;
        margin-inline-end: 14px;
        margin-inline-start: 0;
        outline: none;
      }

      :host ::slotted(.drawer-content) {
        height: calc(100% - 56px);
        overflow: auto;
      }
    </style>
    <dialog id="dialog" on-cancel="onDialogCancel_" on-click="onDialogTap_" on-close="onDialogClose_">
      <div id="container" on-click="onContainerTap_">
        <div class="drawer-header">
          <!-- Hidden from a11y because this icon is decorative. Clicking closes
              the dialog, but screen reader users can do this by pressing ESC,
              so aria-hidden is OK here. -->
          <iron-icon id="iconButton" icon="[[iconName]]" on-click="onIconTap_" title="[[iconTitle]]" hidden="[[!iconName]]" aria-hidden="true"> </iron-icon>
          <div id="heading" tabindex="-1">[[heading]]</div>
        </div>
        <slot></slot>
      </div>
    </dialog>
    <!--_html_template_end_-->`,
  is: "cr-drawer",
  properties: {
    heading: String,
    show_: {
      type: Boolean,
      reflectToAttribute: true,
    },
    align: {
      type: String,
      value: "ltr",
      reflectToAttribute: true,
    },
    iconName: {
      type: String,
      value: null,
    },
    iconTitle: String,
  },
  get open() {
    return this.$.dialog.open;
  },
  set open(value) {
    assertNotReached("Cannot set |open|.");
  },
  toggle() {
    if (this.open) {
      this.cancel();
    } else {
      this.openDrawer();
    }
  },
  openDrawer() {
    if (this.open) {
      return;
    }
    this.$.dialog.showModal();
    this.show_ = true;
    this.fire("cr-drawer-opening");
    listenOnce(this.$.dialog, "transitionend", () => {
      this.fire("cr-drawer-opened");
    });
  },
  dismiss_(cancel) {
    if (!this.open) {
      return;
    }
    this.show_ = false;
    listenOnce(this.$.dialog, "transitionend", () => {
      this.$.dialog.close(cancel ? "canceled" : "closed");
    });
  },
  cancel() {
    this.dismiss_(true);
  },
  close() {
    this.dismiss_(false);
  },
  wasCanceled() {
    return !this.open && this.$.dialog.returnValue === "canceled";
  },
  onIconTap_(event) {
    this.cancel();
  },
  onContainerTap_(event) {
    event.stopPropagation();
  },
  onDialogTap_() {
    this.cancel();
  },
  onDialogCancel_(event) {
    event.preventDefault();
    this.cancel();
  },
  onDialogClose_(event) {
    event.stopPropagation();
    this.fire("close");
  },
});
// Copyright 2016 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><slot
    ></slot>
    <!--_html_template_end_-->`,
  is: "cr-lazy-render",
  child_: null,
  instance_: null,
  get() {
    if (!this.child_) {
      this.render_();
    }
    return this.child_;
  },
  getIfExists() {
    return this.child_;
  },
  render_() {
    const template = this.getContentChildren()[0];
    const TemplateClass = templatize(template, this, {
      mutableData: false,
      forwardHostProp: this._forwardHostPropV2,
    });
    const parentNode = this.parentNode;
    if (parentNode && !this.child_) {
      this.instance_ = new TemplateClass();
      this.child_ = this.instance_.root.firstElementChild;
      parentNode.insertBefore(this.instance_.root, this);
    }
  },
  _forwardHostPropV2(prop, value) {
    if (this.instance_) {
      this.instance_.forwardHostProp(prop, value);
    }
  },
});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
var IronA11yAnnouncer = Polymer({
  _template: html`<!--css-build:shadow--><style scope="iron-a11y-announcer">
      :host {
        display: inline-block;
        position: fixed;
        clip: rect(0px, 0px, 0px, 0px);
      }
    </style>
    <div aria-live$="[[mode]]">[[_text]]</div> `,
  is: "iron-a11y-announcer",
  properties: {
    mode: {
      type: String,
      value: "polite",
    },
    _text: {
      type: String,
      value: "",
    },
  },
  created: function() {
    if (!IronA11yAnnouncer.instance) {
      IronA11yAnnouncer.instance = this;
    }
    document.body.addEventListener("iron-announce", this._onIronAnnounce.bind(this));
  },
  announce: function(text) {
    this._text = "";
    this.async(function() {
      this._text = text;
    }, 100);
  },
  _onIronAnnounce: function(event) {
    if (event.detail && event.detail.text) {
      this.announce(event.detail.text);
    }
  },
});
IronA11yAnnouncer.instance = null;
IronA11yAnnouncer.requestAvailability = function() {
  if (!IronA11yAnnouncer.instance) {
    IronA11yAnnouncer.instance = document.createElement("iron-a11y-announcer");
  }
  document.body.appendChild(IronA11yAnnouncer.instance);
};
// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var EventTracker = class {
  constructor() {
    this.listeners_ = [];
  }
  add(target, eventType, listener, opt_capture) {
    const capture = !!opt_capture;
    const h = {
      target: target,
      eventType: eventType,
      listener: listener,
      capture: capture,
    };
    this.listeners_.push(h);
    target.addEventListener(eventType, listener, capture);
  }
  remove(target, eventType) {
    this.listeners_ = this.listeners_.filter((listener) => {
      if (listener.target === target && (!eventType || listener.eventType === eventType)) {
        EventTracker.removeEventListener(listener);
        return false;
      }
      return true;
    });
  }
  removeAll() {
    this.listeners_.forEach((listener) => EventTracker.removeEventListener(listener));
    this.listeners_ = [];
  }
  static removeEventListener(entry) {
    entry.target.removeEventListener(entry.eventType, entry.listener, entry.capture);
  }
};
// Copyright 2017 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="cr-toast">
      :host {
        --cr-toast-background: #323232;
        --cr-toast-button-color: var(--google-blue-300);
        --cr-toast-text-color: #fff;
      }

      @media (prefers-color-scheme: dark) {
        :host {
          --cr-toast-background: var(--google-grey-900) linear-gradient(rgba(255, 255, 255, 0.06), rgba(255, 255, 255, 0.06));
          --cr-toast-button-color: var(--google-blue-refresh-300);
          --cr-toast-text-color: var(--google-grey-200);
        }
      }

      :host {
        align-items: center;
        background: var(--cr-toast-background);
        border-radius: 4px;
        bottom: 0;
        box-shadow: 0 2px 4px 0 rgba(0, 0, 0, 0.28);
        box-sizing: border-box;
        display: flex;
        margin: 24px;
        max-width: 568px;
        min-height: 52px;
        min-width: 288px;
        opacity: 0;
        padding: 0 24px;
        position: fixed;
        transform: translateY(100px);
        transition: opacity 300ms, transform 300ms, visibility 300ms;
        visibility: hidden;
        z-index: 1;
      }

      :host-context([dir="ltr"]) {
        left: 0;
      }

      :host-context([dir="rtl"]) {
        right: 0;
      }

      :host([open]) {
        opacity: 1;
        transform: translateY(0);
        visibility: visible;
      }

      :host ::slotted(*) {
        color: var(--cr-toast-text-color);
      }

      :host ::slotted(cr-button) {
        background-color: transparent !important;
        border: none !important;
        color: var(--cr-toast-button-color) !important;
        margin-inline-start: 32px !important;
        min-width: 52px !important;
        padding: 8px !important;
      }

      :host ::slotted(cr-button:hover) {
        background-color: transparent !important;
      }
    </style>
    <slot></slot>
    <!--_html_template_end_-->`,
  is: "cr-toast",
  properties: {
    duration: {
      type: Number,
      value: 0,
    },
    open: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
    },
  },
  hostAttributes: {
    role: "alert",
  },
  observers: ["resetAutoHide_(duration, open)"],
  hideTimeoutId_: null,
  resetAutoHide_() {
    if (this.hideTimeoutId_ !== null) {
      window.clearTimeout(this.hideTimeoutId_);
      this.hideTimeoutId_ = null;
    }
    if (this.open && this.duration !== 0) {
      this.hideTimeoutId_ = window.setTimeout(() => {
        this.open = false;
      }, this.duration);
    }
  },
  announceA11yMessage_(text) {
    IronA11yAnnouncer.requestAvailability();
    this.fire("iron-announce", {
      text: text,
    });
  },
  show(duration, text, shouldAnnounceA11y) {
    if (text !== undefined) {
      this.textContent = "";
      const span = document.createElement("span");
      span.textContent = text;
      this.appendChild(span);
      if (shouldAnnounceA11y) {
        this.announceA11yMessage_(text);
      }
    }
    let shouldResetAutoHide = true;
    if (typeof duration !== "undefined" && duration >= 0 && this.duration !== duration) {
      this.duration = duration;
      shouldResetAutoHide = false;
    }
    if (!this.open) {
      this.open = true;
      shouldResetAutoHide = false;
    }
    if (shouldResetAutoHide) {
      this.resetAutoHide_();
    }
  },
  hide() {
    this.open = false;
  },
});
// Copyright 2019 The Chromium Authors. All rights reserved.
let toastManagerInstance = null;
function getToastManager() {
  return assert(toastManagerInstance);
}
function setInstance(instance) {
  assert(!instance || !toastManagerInstance);
  toastManagerInstance = instance;
}
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="cr-toast-manager">
      #content {
        display: flex;
        flex: 1;
      }

      .collapsible {
        overflow: hidden;
        text-overflow: ellipsis;
      }

      span {
        white-space: pre;
      }

      .elided-text {
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
      }
    </style>
    <cr-toast id="toast" duration="[[duration]]">
      <div id="content" class="elided-text"></div>
      <slot></slot>
    </cr-toast>
    <!--_html_template_end_-->`,
  is: "cr-toast-manager",
  properties: {
    duration: {
      type: Number,
      value: 0,
    },
  },
  get isToastOpen() {
    return this.$.toast.open;
  },
  attached() {
    setInstance(this);
  },
  detached() {
    setInstance(null);
  },
  show(label) {
    this.$.content.textContent = label;
    this.showInternal_();
  },
  showForStringPieces(pieces) {
    const content = this.$.content;
    content.textContent = "";
    pieces.forEach(function(p) {
      if (p.value.length === 0) {
        return;
      }
      const span = document.createElement("span");
      span.textContent = p.value;
      if (p.collapsible) {
        span.classList.add("collapsible");
      }
      content.appendChild(span);
    });
    this.showInternal_();
  },
  showInternal_() {
    IronA11yAnnouncer.requestAvailability();
    this.fire("iron-announce", {
      text: this.$.content.textContent,
    });
    this.$.toast.show();
  },
  hide() {
    this.$.toast.hide();
  },
});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
var KEY_IDENTIFIER = {
  "U+0008": "backspace",
  "U+0009": "tab",
  "U+001B": "esc",
  "U+0020": "space",
  "U+007F": "del",
};
var KEY_CODE = {
  8: "backspace",
  9: "tab",
  13: "enter",
  27: "esc",
  33: "pageup",
  34: "pagedown",
  35: "end",
  36: "home",
  32: "space",
  37: "left",
  38: "up",
  39: "right",
  40: "down",
  46: "del",
  106: "*",
};
var MODIFIER_KEYS = {
  shift: "shiftKey",
  ctrl: "ctrlKey",
  alt: "altKey",
  meta: "metaKey",
};
var KEY_CHAR = /[a-z0-9*]/;
var IDENT_CHAR = /U\+/;
var ARROW_KEY = /^arrow/;
var SPACE_KEY = /^space(bar)?/;
var ESC_KEY = /^escape$/;
function transformKey(key, noSpecialChars) {
  var validKey = "";
  if (key) {
    var lKey = key.toLowerCase();
    if (lKey === " " || SPACE_KEY.test(lKey)) {
      validKey = "space";
    } else if (ESC_KEY.test(lKey)) {
      validKey = "esc";
    } else if (lKey.length == 1) {
      if (!noSpecialChars || KEY_CHAR.test(lKey)) {
        validKey = lKey;
      }
    } else if (ARROW_KEY.test(lKey)) {
      validKey = lKey.replace("arrow", "");
    } else if (lKey == "multiply") {
      validKey = "*";
    } else {
      validKey = lKey;
    }
  }
  return validKey;
}
function transformKeyIdentifier(keyIdent) {
  var validKey = "";
  if (keyIdent) {
    if (keyIdent in KEY_IDENTIFIER) {
      validKey = KEY_IDENTIFIER[keyIdent];
    } else if (IDENT_CHAR.test(keyIdent)) {
      keyIdent = parseInt(keyIdent.replace("U+", "0x"), 16);
      validKey = String.fromCharCode(keyIdent).toLowerCase();
    } else {
      validKey = keyIdent.toLowerCase();
    }
  }
  return validKey;
}
function transformKeyCode(keyCode) {
  var validKey = "";
  if (Number(keyCode)) {
    if (keyCode >= 65 && keyCode <= 90) {
      validKey = String.fromCharCode(32 + keyCode);
    } else if (keyCode >= 112 && keyCode <= 123) {
      validKey = "f" + (keyCode - 112 + 1);
    } else if (keyCode >= 48 && keyCode <= 57) {
      validKey = String(keyCode - 48);
    } else if (keyCode >= 96 && keyCode <= 105) {
      validKey = String(keyCode - 96);
    } else {
      validKey = KEY_CODE[keyCode];
    }
  }
  return validKey;
}
function normalizedKeyForEvent(keyEvent, noSpecialChars) {
  if (keyEvent.key) {
    return transformKey(keyEvent.key, noSpecialChars);
  }
  if (keyEvent.detail && keyEvent.detail.key) {
    return transformKey(keyEvent.detail.key, noSpecialChars);
  }
  return transformKeyIdentifier(keyEvent.keyIdentifier) || transformKeyCode(keyEvent.keyCode) || "";
}
function keyComboMatchesEvent(keyCombo, event) {
  var keyEvent = normalizedKeyForEvent(event, keyCombo.hasModifiers);
  return keyEvent === keyCombo.key && (!keyCombo.hasModifiers || (!!event.shiftKey === !!keyCombo.shiftKey && !!event.ctrlKey === !!keyCombo.ctrlKey && !!event.altKey === !!keyCombo.altKey && !!event.metaKey === !!keyCombo.metaKey));
}
function parseKeyComboString(keyComboString) {
  if (keyComboString.length === 1) {
    return {
      combo: keyComboString,
      key: keyComboString,
      event: "keydown",
    };
  }
  return keyComboString.split("+").reduce(
    function(parsedKeyCombo, keyComboPart) {
      var eventParts = keyComboPart.split(":");
      var keyName = eventParts[0];
      var event = eventParts[1];
      if (keyName in MODIFIER_KEYS) {
        parsedKeyCombo[MODIFIER_KEYS[keyName]] = true;
        parsedKeyCombo.hasModifiers = true;
      } else {
        parsedKeyCombo.key = keyName;
        parsedKeyCombo.event = event || "keydown";
      }
      return parsedKeyCombo;
    },
    {
      combo: keyComboString.split(":").shift(),
    }
  );
}
function parseEventString(eventString) {
  return eventString
    .trim()
    .split(" ")
    .map(function(keyComboString) {
      return parseKeyComboString(keyComboString);
    });
}
const IronA11yKeysBehavior = {
  properties: {
    keyEventTarget: {
      type: Object,
      value: function() {
        return this;
      },
    },
    stopKeyboardEventPropagation: {
      type: Boolean,
      value: false,
    },
    _boundKeyHandlers: {
      type: Array,
      value: function() {
        return [];
      },
    },
    _imperativeKeyBindings: {
      type: Object,
      value: function() {
        return {};
      },
    },
  },
  observers: ["_resetKeyEventListeners(keyEventTarget, _boundKeyHandlers)"],
  keyBindings: {},
  registered: function() {
    this._prepKeyBindings();
  },
  attached: function() {
    this._listenKeyEventListeners();
  },
  detached: function() {
    this._unlistenKeyEventListeners();
  },
  addOwnKeyBinding: function(eventString, handlerName) {
    this._imperativeKeyBindings[eventString] = handlerName;
    this._prepKeyBindings();
    this._resetKeyEventListeners();
  },
  removeOwnKeyBindings: function() {
    this._imperativeKeyBindings = {};
    this._prepKeyBindings();
    this._resetKeyEventListeners();
  },
  keyboardEventMatchesKeys: function(event, eventString) {
    var keyCombos = parseEventString(eventString);
    for (var i = 0; i < keyCombos.length; ++i) {
      if (keyComboMatchesEvent(keyCombos[i], event)) {
        return true;
      }
    }
    return false;
  },
  _collectKeyBindings: function() {
    var keyBindings = this.behaviors.map(function(behavior) {
      return behavior.keyBindings;
    });
    if (keyBindings.indexOf(this.keyBindings) === -1) {
      keyBindings.push(this.keyBindings);
    }
    return keyBindings;
  },
  _prepKeyBindings: function() {
    this._keyBindings = {};
    this._collectKeyBindings().forEach(function(keyBindings) {
      for (var eventString in keyBindings) {
        this._addKeyBinding(eventString, keyBindings[eventString]);
      }
    }, this);
    for (var eventString in this._imperativeKeyBindings) {
      this._addKeyBinding(eventString, this._imperativeKeyBindings[eventString]);
    }
    for (var eventName in this._keyBindings) {
      this._keyBindings[eventName].sort(function(kb1, kb2) {
        var b1 = kb1[0].hasModifiers;
        var b2 = kb2[0].hasModifiers;
        return b1 === b2 ? 0 : b1 ? -1 : 1;
      });
    }
  },
  _addKeyBinding: function(eventString, handlerName) {
    parseEventString(eventString).forEach(function(keyCombo) {
      this._keyBindings[keyCombo.event] = this._keyBindings[keyCombo.event] || [];
      this._keyBindings[keyCombo.event].push([keyCombo, handlerName]);
    }, this);
  },
  _resetKeyEventListeners: function() {
    this._unlistenKeyEventListeners();
    if (this.isAttached) {
      this._listenKeyEventListeners();
    }
  },
  _listenKeyEventListeners: function() {
    if (!this.keyEventTarget) {
      return;
    }
    Object.keys(this._keyBindings).forEach(function(eventName) {
      var keyBindings = this._keyBindings[eventName];
      var boundKeyHandler = this._onKeyBindingEvent.bind(this, keyBindings);
      this._boundKeyHandlers.push([this.keyEventTarget, eventName, boundKeyHandler]);
      this.keyEventTarget.addEventListener(eventName, boundKeyHandler);
    }, this);
  },
  _unlistenKeyEventListeners: function() {
    var keyHandlerTuple;
    var keyEventTarget;
    var eventName;
    var boundKeyHandler;
    while (this._boundKeyHandlers.length) {
      keyHandlerTuple = this._boundKeyHandlers.pop();
      keyEventTarget = keyHandlerTuple[0];
      eventName = keyHandlerTuple[1];
      boundKeyHandler = keyHandlerTuple[2];
      keyEventTarget.removeEventListener(eventName, boundKeyHandler);
    }
  },
  _onKeyBindingEvent: function(keyBindings, event) {
    if (this.stopKeyboardEventPropagation) {
      event.stopPropagation();
    }
    if (event.defaultPrevented) {
      return;
    }
    for (var i = 0; i < keyBindings.length; i++) {
      var keyCombo = keyBindings[i][0];
      var handlerName = keyBindings[i][1];
      if (keyComboMatchesEvent(keyCombo, event)) {
        this._triggerKeyHandler(keyCombo, handlerName, event);
        if (event.defaultPrevented) {
          return;
        }
      }
    }
  },
  _triggerKeyHandler: function(keyCombo, handlerName, keyboardEvent) {
    var detail = Object.create(keyCombo);
    detail.keyboardEvent = keyboardEvent;
    var event = new CustomEvent(keyCombo.event, {
      detail: detail,
      cancelable: true,
    });
    this[handlerName].call(this, event);
    if (event.defaultPrevented) {
      keyboardEvent.preventDefault();
    }
  },
};
var MAX_RADIUS_PX = 300;
var MIN_DURATION_MS = 800;
var distance = function(x1, y1, x2, y2) {
  var xDelta = x1 - x2;
  var yDelta = y1 - y2;
  return Math.sqrt(xDelta * xDelta + yDelta * yDelta);
};
Polymer({
  _template: html`<!--css-build:shadow--><style scope="paper-ripple">
      :host {
        border-radius: inherit;
        bottom: 0;
        display: block;
        left: 0;
        overflow: hidden;
        pointer-events: none;
        position: absolute;
        right: 0;
        top: 0;

        transform: translate3d(0, 0, 0);
      }

      .ripple {
        background-color: currentcolor;
        left: 0;
        opacity: var(--paper-ripple-opacity, 0.25);
        pointer-events: none;
        position: absolute;
        will-change: height, transform, width;
      }

      .ripple,
      :host(.circle) {
        border-radius: 50%;
      }
    </style> `,
  is: "paper-ripple",
  behaviors: [IronA11yKeysBehavior],
  properties: {
    center: {
      type: Boolean,
      value: false,
    },
    holdDown: {
      type: Boolean,
      value: false,
      observer: "_holdDownChanged",
    },
    recenters: {
      type: Boolean,
      value: false,
    },
    noink: {
      type: Boolean,
      value: false,
    },
  },
  keyBindings: {
    "enter:keydown": "_onEnterKeydown",
    "space:keydown": "_onSpaceKeydown",
    "space:keyup": "_onSpaceKeyup",
  },
  created: function() {
    this.ripples = [];
  },
  attached: function() {
    this.keyEventTarget = this.parentNode.nodeType == 11 ? dom(this).getOwnerRoot().host : this.parentNode;
    this.keyEventTarget = this.keyEventTarget;
    this.listen(this.keyEventTarget, "up", "uiUpAction");
    this.listen(this.keyEventTarget, "down", "uiDownAction");
  },
  detached: function() {
    this.unlisten(this.keyEventTarget, "up", "uiUpAction");
    this.unlisten(this.keyEventTarget, "down", "uiDownAction");
    this.keyEventTarget = null;
  },
  simulatedRipple: function() {
    this.downAction();
    this.async(
      function() {
        this.upAction();
      }.bind(this),
      1
    );
  },
  uiDownAction: function(e) {
    if (!this.noink) this.downAction(e);
  },
  downAction: function(e) {
    if (this.ripples.length && this.holdDown) return;
    this.debounce(
      "show ripple",
      function() {
        this.__showRipple(e);
      },
      1
    );
  },
  clear: function() {
    this.__hideRipple();
    this.holdDown = false;
  },
  showAndHoldDown: function() {
    this.ripples.forEach((ripple) => {
      ripple.remove();
    });
    this.ripples = [];
    this.holdDown = true;
  },
  __showRipple: function(e) {
    var rect = this.getBoundingClientRect();
    var roundedCenterX = function() {
      return Math.round(rect.width / 2);
    };
    var roundedCenterY = function() {
      return Math.round(rect.height / 2);
    };
    var centered = !e || this.center;
    if (centered) {
      var x = roundedCenterX();
      var y = roundedCenterY();
    } else {
      var sourceEvent = e.detail.sourceEvent;
      var x = Math.round(sourceEvent.clientX - rect.left);
      var y = Math.round(sourceEvent.clientY - rect.top);
    }
    var corners = [
      {
        x: 0,
        y: 0,
      },
      {
        x: rect.width,
        y: 0,
      },
      {
        x: 0,
        y: rect.height,
      },
      {
        x: rect.width,
        y: rect.height,
      },
    ];
    var cornerDistances = corners.map(function(corner) {
      return Math.round(distance(x, y, corner.x, corner.y));
    });
    var radius = Math.min(MAX_RADIUS_PX, Math.max.apply(Math, cornerDistances));
    var startTranslate = x - radius + "px, " + (y - radius) + "px";
    if (this.recenters && !centered) {
      var endTranslate = roundedCenterX() - radius + "px, " + (roundedCenterY() - radius) + "px";
    } else {
      var endTranslate = startTranslate;
    }
    var ripple = document.createElement("div");
    ripple.classList.add("ripple");
    ripple.style.height = ripple.style.width = 2 * radius + "px";
    this.ripples.push(ripple);
    this.shadowRoot.appendChild(ripple);
    ripple.animate(
      {
        transform: ["translate(" + startTranslate + ") scale(0)", "translate(" + endTranslate + ") scale(1)"],
      },
      {
        duration: Math.max(MIN_DURATION_MS, Math.log(radius) * radius) || 0,
        easing: "cubic-bezier(.2, .9, .1, .9)",
        fill: "forwards",
      }
    );
  },
  uiUpAction: function(e) {
    if (!this.noink) this.upAction();
  },
  upAction: function(e) {
    if (!this.holdDown)
      this.debounce(
        "hide ripple",
        function() {
          this.__hideRipple();
        },
        1
      );
  },
  __hideRipple: function() {
    Promise.all(
      this.ripples.map(function(ripple) {
        return new Promise(function(resolve) {
          var removeRipple = function() {
            ripple.remove();
            resolve();
          };
          var opacity = getComputedStyle(ripple).opacity;
          if (!opacity.length) {
            removeRipple();
          } else {
            var animation = ripple.animate(
              {
                opacity: [opacity, 0],
              },
              {
                duration: 150,
                fill: "forwards",
              }
            );
            animation.addEventListener("finish", removeRipple);
            animation.addEventListener("cancel", removeRipple);
          }
        });
      })
    ).then(
      function() {
        this.fire("transitionend");
      }.bind(this)
    );
    this.ripples = [];
  },
  _onEnterKeydown: function() {
    this.uiDownAction();
    this.async(this.uiUpAction, 1);
  },
  _onSpaceKeydown: function() {
    this.uiDownAction();
  },
  _onSpaceKeyup: function() {
    this.uiUpAction();
  },
  _holdDownChanged: function(newHoldDown, oldHoldDown) {
    if (oldHoldDown === undefined) return;
    if (newHoldDown) this.downAction();
    else this.upAction();
  },
});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const IronButtonStateImpl = {
  properties: {
    pressed: {
      type: Boolean,
      readOnly: true,
      value: false,
      reflectToAttribute: true,
      observer: "_pressedChanged",
    },
    toggles: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
    },
    active: {
      type: Boolean,
      value: false,
      notify: true,
      reflectToAttribute: true,
    },
    pointerDown: {
      type: Boolean,
      readOnly: true,
      value: false,
    },
    receivedFocusFromKeyboard: {
      type: Boolean,
      readOnly: true,
    },
    ariaActiveAttribute: {
      type: String,
      value: "aria-pressed",
      observer: "_ariaActiveAttributeChanged",
    },
  },
  listeners: {
    down: "_downHandler",
    up: "_upHandler",
    tap: "_tapHandler",
  },
  observers: ["_focusChanged(focused)", "_activeChanged(active, ariaActiveAttribute)"],
  keyBindings: {
    "enter:keydown": "_asyncClick",
    "space:keydown": "_spaceKeyDownHandler",
    "space:keyup": "_spaceKeyUpHandler",
  },
  _mouseEventRe: /^mouse/,
  _tapHandler: function() {
    if (this.toggles) {
      this._userActivate(!this.active);
    } else {
      this.active = false;
    }
  },
  _focusChanged: function(focused) {
    this._detectKeyboardFocus(focused);
    if (!focused) {
      this._setPressed(false);
    }
  },
  _detectKeyboardFocus: function(focused) {
    this._setReceivedFocusFromKeyboard(!this.pointerDown && focused);
  },
  _userActivate: function(active) {
    if (this.active !== active) {
      this.active = active;
      this.fire("change");
    }
  },
  _downHandler: function(event) {
    this._setPointerDown(true);
    this._setPressed(true);
    this._setReceivedFocusFromKeyboard(false);
  },
  _upHandler: function() {
    this._setPointerDown(false);
    this._setPressed(false);
  },
  _spaceKeyDownHandler: function(event) {
    var keyboardEvent = event.detail.keyboardEvent;
    var target = dom(keyboardEvent).localTarget;
    if (this.isLightDescendant(target)) return;
    keyboardEvent.preventDefault();
    keyboardEvent.stopImmediatePropagation();
    this._setPressed(true);
  },
  _spaceKeyUpHandler: function(event) {
    var keyboardEvent = event.detail.keyboardEvent;
    var target = dom(keyboardEvent).localTarget;
    if (this.isLightDescendant(target)) return;
    if (this.pressed) {
      this._asyncClick();
    }
    this._setPressed(false);
  },
  _asyncClick: function() {
    this.async(function() {
      this.click();
    }, 1);
  },
  _pressedChanged: function(pressed) {
    this._changedButtonState();
  },
  _ariaActiveAttributeChanged: function(value, oldValue) {
    if (oldValue && oldValue != value && this.hasAttribute(oldValue)) {
      this.removeAttribute(oldValue);
    }
  },
  _activeChanged: function(active, ariaActiveAttribute) {
    if (this.toggles) {
      this.setAttribute(this.ariaActiveAttribute, active ? "true" : "false");
    } else {
      this.removeAttribute(this.ariaActiveAttribute);
    }
    this._changedButtonState();
  },
  _controlStateChanged: function() {
    if (this.disabled) {
      this._setPressed(false);
    } else {
      this._changedButtonState();
    }
  },
  _changedButtonState: function() {
    if (this._buttonStateChanged) {
      this._buttonStateChanged();
    }
  },
};
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const PaperRippleBehavior = {
  properties: {
    noink: {
      type: Boolean,
      observer: "_noinkChanged",
    },
    _rippleContainer: {
      type: Object,
    },
  },
  _buttonStateChanged: function() {
    if (this.focused) {
      this.ensureRipple();
    }
  },
  _downHandler: function(event) {
    IronButtonStateImpl._downHandler.call(this, event);
    if (this.pressed) {
      this.ensureRipple(event);
    }
  },
  ensureRipple: function(optTriggeringEvent) {
    if (!this.hasRipple()) {
      this._ripple = this._createRipple();
      this._ripple.noink = this.noink;
      var rippleContainer = this._rippleContainer || this.root;
      if (rippleContainer) {
        dom(rippleContainer).appendChild(this._ripple);
      }
      if (optTriggeringEvent) {
        var domContainer = dom(this._rippleContainer || this);
        var target = dom(optTriggeringEvent).rootTarget;
        if (domContainer.deepContains(target)) {
          this._ripple.uiDownAction(optTriggeringEvent);
        }
      }
    }
  },
  getRipple: function() {
    this.ensureRipple();
    return this._ripple;
  },
  hasRipple: function() {
    return Boolean(this._ripple);
  },
  _createRipple: function() {
    var element = document.createElement("paper-ripple");
    return element;
  },
  _noinkChanged: function(noink) {
    if (this.hasRipple()) {
      this._ripple.noink = noink;
    }
  },
};
// Copyright 2018 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="cr-icon-button">
      :host {
        --cr-icon-button-fill-color: var(--google-grey-refresh-700);
        --cr-icon-button-icon-start-offset: 0;
        --cr-icon-button-icon-size: 20px;
        --cr-icon-button-size: 36px;
        --cr-icon-button-height: var(--cr-icon-button-size);
        --cr-icon-button-transition: 150ms ease-in-out;
        --cr-icon-button-width: var(--cr-icon-button-size);

        -webkit-tap-highlight-color: transparent;
        border-radius: 4px;
        color: var(--cr-icon-button-stroke-color, var(--cr-icon-button-fill-color));
        cursor: pointer;
        display: inline-flex;
        flex-shrink: 0;
        height: var(--cr-icon-button-height);
        margin-inline-end: var(--cr-icon-button-margin-end, var(--cr-icon-ripple-margin));
        margin-inline-start: var(--cr-icon-button-margin-start);
        outline: none;
        user-select: none;
        vertical-align: middle;
        width: var(--cr-icon-button-width);
      }

      :host([disabled]) {
        cursor: initial;
        opacity: var(--cr-disabled-opacity);
        pointer-events: none;
      }

      :host(.no-overlap) {
        --cr-icon-button-margin-end: 0;
        --cr-icon-button-margin-start: 0;
      }

      :host-context([dir="rtl"]):host(:not([dir="ltr"])) {
        transform: scaleX(-1);
      }

      :host(:not([iron-icon])) #maskedImage {
        -webkit-mask-image: var(--cr-icon-image);
        -webkit-mask-position: center;
        -webkit-mask-repeat: no-repeat;
        -webkit-mask-size: var(--cr-icon-button-icon-size);
        background-color: var(--cr-icon-button-fill-color);
        height: 100%;
        transition: background-color var(--cr-icon-button-transition);
        width: 100%;
        z-index: 1;
      }

      #icon {
        align-items: center;
        border-radius: 4px;
        display: flex;
        height: 100%;
        justify-content: center;
        padding-inline-start: var(--cr-icon-button-icon-start-offset);

        position: relative;
        width: 100%;
      }

      iron-icon {
        --iron-icon-stroke-color: var(--cr-icon-button-stroke-color, none);
        --iron-icon-height: var(--cr-icon-button-icon-size);
        --iron-icon-width: var(--cr-icon-button-icon-size);
        transition: fill var(--cr-icon-button-transition), stroke var(--cr-icon-button-transition);
        z-index: 1;
      }

      paper-ripple {
        --paper-ripple-opacity: var(--cr-icon-button-ripple-opacity, 0.21);
      }

      @media (prefers-color-scheme: dark) {
        :host {
          --cr-icon-button-fill-color: var(--google-grey-refresh-500);
        }

        paper-ripple {
          --paper-ripple-opacity: var(--cr-icon-button-ripple-opacity, 0.4);
        }
      }
    </style>
    <div id="icon">
      <div id="maskedImage"></div>
    </div>
    <!--_html_template_end_-->`,
  is: "cr-icon-button",
  behaviors: [PaperRippleBehavior],
  properties: {
    disabled: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      observer: "disabledChanged_",
    },
    customTabIndex: {
      type: Number,
      observer: "applyTabIndex_",
    },
    ironIcon: {
      type: String,
      observer: "onIronIconChanged_",
      reflectToAttribute: true,
    },
    rippleShowing_: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
    },
  },
  hostAttributes: {
    "aria-disabled": "false",
    role: "button",
    tabindex: 0,
  },
  listeners: {
    blur: "onBlur_",
    click: "onClick_",
    down: "showRipple_",
    focus: "showRipple_",
    keydown: "onKeyDown_",
    keyup: "onKeyUp_",
    pointerdown: "ensureRipple",
    up: "hideRipple_",
  },
  spaceKeyDown_: false,
  hideRipple_() {
    if (this.hasRipple()) {
      this.getRipple().clear();
      this.rippleShowing_ = false;
    }
  },
  showRipple_() {
    if (!this.noink && !this.disabled) {
      this.getRipple().showAndHoldDown();
      this.rippleShowing_ = true;
    }
  },
  disabledChanged_(newValue, oldValue) {
    if (!newValue && oldValue === undefined) {
      return;
    }
    if (this.disabled) {
      this.blur();
    }
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
    this.applyTabIndex_();
  },
  applyTabIndex_() {
    let value = this.customTabIndex;
    if (value === undefined) {
      value = this.disabled ? -1 : 0;
    }
    this.setAttribute("tabindex", value);
  },
  onBlur_() {
    this.spaceKeyDown_ = false;
    this.hideRipple_();
  },
  onClick_(e) {
    if (this.disabled) {
      e.stopImmediatePropagation();
    }
  },
  onIronIconChanged_() {
    this.shadowRoot.querySelectorAll("iron-icon").forEach((el) => el.remove());
    if (!this.ironIcon) {
      return;
    }
    const icons = (this.ironIcon || "").split(",");
    icons.forEach((icon) => {
      const ironIcon = document.createElement("iron-icon");
      ironIcon.icon = icon;
      this.$.icon.appendChild(ironIcon);
      if (ironIcon.shadowRoot) {
        ironIcon.shadowRoot.querySelectorAll("svg", "img").forEach((child) => child.setAttribute("role", "none"));
      }
    });
    if (!this.hasRipple()) {
      return;
    }
    if (icons.length > 1) {
      this.getRipple().classList.remove("circle");
    } else {
      this.getRipple().classList.add("circle");
    }
  },
  onKeyDown_(e) {
    if (e.key !== " " && e.key !== "Enter") {
      return;
    }
    e.preventDefault();
    e.stopPropagation();
    if (e.repeat) {
      return;
    }
    if (e.key === "Enter") {
      this.click();
    } else if (e.key === " ") {
      this.spaceKeyDown_ = true;
    }
  },
  onKeyUp_(e) {
    if (e.key === " " || e.key === "Enter") {
      e.preventDefault();
      e.stopPropagation();
    }
    if (this.spaceKeyDown_ && e.key === " ") {
      this.spaceKeyDown_ = false;
      this.click();
    }
  },
  _createRipple() {
    this._rippleContainer = this.$.icon;
    const ripple = PaperRippleBehavior._createRipple();
    ripple.id = "ink";
    ripple.setAttribute("recenters", "");
    if (!(this.ironIcon || "").includes(",")) {
      ripple.classList.add("circle");
    }
    return ripple;
  },
});
const template$2 = document.createElement("template");
template$2.innerHTML = `<dom-module id="cr-icons" assetpath="chrome://resources/">
  <template>
    <style scope="cr-icons">.icon-arrow-back {
    --cr-icon-image: url(../images/icon_arrow_back.svg);
}
.icon-arrow-dropdown {
    --cr-icon-image: url(../images/icon_arrow_dropdown.svg);
}
.icon-cancel {
    --cr-icon-image: url(../images/icon_cancel.svg);
}
.icon-clear {
    --cr-icon-image: url(../images/icon_clear.svg);
}
.icon-copy-content {
    --cr-icon-image: url(../images/icon_copy_content.svg);
}
.icon-delete-gray {
    --cr-icon-image: url(../images/icon_delete_gray.svg);
}
.icon-picture-delete {
    --cr-icon-image: url(../images/icon_picture_delete.svg);
}
.icon-expand-less {
    --cr-icon-image: url(../images/icon_expand_less.svg);
}
.icon-expand-more {
    --cr-icon-image: url(../images/icon_expand_more.svg);
}
.icon-more-vert {
    --cr-icon-image: url(../images/icon_more_vert.svg);
}
.icon-refresh {
    --cr-icon-image: url(../images/icon_refresh.svg);
}
.icon-search {
    --cr-icon-image: url(../images/icon_search.svg);
}
.icon-settings {
    --cr-icon-image: url(../images/icon_settings.svg);
}
.icon-visibility {
    --cr-icon-image: url(../images/icon_visibility.svg);
}
.icon-visibility-off {
    --cr-icon-image: url(../images/icon_visibility_off.svg);
}
.subpage-arrow {
    --cr-icon-image: url(../images/arrow_right.svg);
}
.cr-icon {
    -webkit-mask-image: var(--cr-icon-image);
        -webkit-mask-position: center;
        -webkit-mask-repeat: no-repeat;
        -webkit-mask-size: var(--cr-icon-size);
        background-color: var(--google-grey-refresh-700);
        flex-shrink: 0;
        height: var(--cr-icon-ripple-size);
        margin-inline-end: var(--cr-icon-ripple-margin);
        margin-inline-start: var(--cr-icon-button-margin-start);
        user-select: none;
        width: var(--cr-icon-ripple-size);
}
:host-context([dir=rtl]) .cr-icon {
    transform: scaleX(-1);
}
.cr-icon.no-overlap {
    margin-inline-end: 0;
        margin-inline-start: 0;
}
@media (prefers-color-scheme: dark) {
  .cr-icon {
    background-color: var(--google-grey-refresh-500);
  }
}
</style>
  </template>
</dom-module>
`;
document.body.appendChild(template$2.content.cloneNode(true));
// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrSearchFieldBehavior = {
  properties: {
    label: {
      type: String,
      value: "",
    },
    clearLabel: {
      type: String,
      value: "",
    },
    hasSearchText: {
      type: Boolean,
      reflectToAttribute: true,
      value: false,
    },
  },
  effectiveValue_: "",
  searchDelayTimer_: -1,
  getSearchInput() { },
  getValue() {
    return this.getSearchInput().value;
  },
  setValue(value, opt_noEvent) {
    const updated = this.updateEffectiveValue_(value);
    this.getSearchInput().value = this.effectiveValue_;
    if (!updated) {
      if (value === "" && this.hasSearchText) {
        this.hasSearchText = false;
      }
      return;
    }
    this.onSearchTermInput();
    if (!opt_noEvent) {
      this.fire("search-changed", this.effectiveValue_);
    }
  },
  scheduleSearch_() {
    if (this.searchDelayTimer_ >= 0) {
      clearTimeout(this.searchDelayTimer_);
    }
    const length = this.getValue().length;
    const timeoutMs = length > 0 ? 500 - 100 * (Math.min(length, 4) - 1) : 0;
    this.searchDelayTimer_ = setTimeout(() => {
      this.getSearchInput().dispatchEvent(
        new CustomEvent("search", {
          composed: true,
          detail: this.getValue(),
        })
      );
      this.searchDelayTimer_ = -1;
    }, timeoutMs);
  },
  onSearchTermSearch() {
    this.onValueChanged_(this.getValue(), false);
  },
  onSearchTermInput() {
    this.hasSearchText = this.$.searchInput.value !== "";
    this.scheduleSearch_();
  },
  onValueChanged_(newValue, noEvent) {
    const updated = this.updateEffectiveValue_(newValue);
    if (updated && !noEvent) {
      this.fire("search-changed", this.effectiveValue_);
    }
  },
  updateEffectiveValue_(value) {
    const effectiveValue = value.replace(/\s+/g, " ").replace(/^\s/, "");
    if (effectiveValue === this.effectiveValue_) {
      return false;
    }
    this.effectiveValue_ = effectiveValue;
    return true;
  },
};
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
Polymer({
  is: "iron-iconset-svg",
  properties: {
    name: {
      type: String,
      observer: "_nameChanged",
    },
    size: {
      type: Number,
      value: 24,
    },
    rtlMirroring: {
      type: Boolean,
      value: false,
    },
    useGlobalRtlAttribute: {
      type: Boolean,
      value: false,
    },
  },
  created: function() {
    this._meta = new IronMeta({
      type: "iconset",
      key: null,
      value: null,
    });
  },
  attached: function() {
    this.style.display = "none";
  },
  getIconNames: function() {
    this._icons = this._createIconMap();
    return Object.keys(this._icons).map(function(n) {
      return this.name + ":" + n;
    }, this);
  },
  applyIcon: function(element, iconName) {
    this.removeIcon(element);
    var svg = this._cloneIcon(iconName, this.rtlMirroring && this._targetIsRTL(element));
    if (svg) {
      var pde = dom(element.root || element);
      pde.insertBefore(svg, pde.childNodes[0]);
      return (element._svgIcon = svg);
    }
    return null;
  },
  createIcon: function(iconName, targetIsRTL) {
    return this._cloneIcon(iconName, this.rtlMirroring && targetIsRTL);
  },
  removeIcon: function(element) {
    if (element._svgIcon) {
      dom(element.root || element).removeChild(element._svgIcon);
      element._svgIcon = null;
    }
  },
  _targetIsRTL: function(target) {
    if (this.__targetIsRTL == null) {
      if (this.useGlobalRtlAttribute) {
        var globalElement = document.body && document.body.hasAttribute("dir") ? document.body : document.documentElement;
        this.__targetIsRTL = globalElement.getAttribute("dir") === "rtl";
      } else {
        if (target && target.nodeType !== Node.ELEMENT_NODE) {
          target = target.host;
        }
        this.__targetIsRTL = target && window.getComputedStyle(target)["direction"] === "rtl";
      }
    }
    return this.__targetIsRTL;
  },
  _nameChanged: function() {
    this._meta.value = null;
    this._meta.key = this.name;
    this._meta.value = this;
    this.async(function() {
      this.fire("iron-iconset-added", this, {
        node: window,
      });
    });
  },
  _createIconMap: function() {
    var icons = Object.create(null);
    dom(this)
      .querySelectorAll("[id]")
      .forEach(function(icon) {
        icons[icon.id] = icon;
      });
    return icons;
  },
  _cloneIcon: function(id, mirrorAllowed) {
    this._icons = this._icons || this._createIconMap();
    return this._prepareSvgClone(this._icons[id], this.size, mirrorAllowed);
  },
  _prepareSvgClone: function(sourceSvg, size, mirrorAllowed) {
    if (sourceSvg) {
      var content = sourceSvg.cloneNode(true),
        svg = document.createElementNS("http://www.w3.org/2000/svg", "svg"),
        viewBox = content.getAttribute("viewBox") || "0 0 " + size + " " + size,
        cssText = "pointer-events: none; display: block; width: 100%; height: 100%;";
      if (mirrorAllowed && content.hasAttribute("mirror-in-rtl")) {
        cssText += "-webkit-transform:scale(-1,1);transform:scale(-1,1);transform-origin:center;";
      }
      svg.setAttribute("viewBox", viewBox);
      svg.setAttribute("preserveAspectRatio", "xMidYMid meet");
      svg.setAttribute("focusable", "false");
      svg.style.cssText = cssText;
      svg.appendChild(content).removeAttribute("id");
      return svg;
    }
    return null;
  },
});
const template$3 = html`<iron-iconset-svg name="cr20" size="20">
    <svg>
      <defs>
        <!--
      Keep these in sorted order by id="". See also http://goo.gl/Y1OdAq
      -->
        <g id="domain">
          <path d="M2,3 L2,17 L11.8267655,17 L13.7904799,17 L18,17 L18,7 L12,7 L12,3 L2,3 Z M8,13 L10,13 L10,15 L8,15 L8,13 Z M4,13 L6,13 L6,15 L4,15 L4,13 Z M8,9 L10,9 L10,11 L8,11 L8,9 Z M4,9 L6,9 L6,11 L4,11 L4,9 Z M12,9 L16,9 L16,15 L12,15 L12,9 Z M12,11 L14,11 L14,13 L12,13 L12,11 Z M8,5 L10,5 L10,7 L8,7 L8,5 Z M4,5 L6,5 L6,7 L4,7 L4,5 Z"></path>
        </g>
        <g id="kite">
          <path fill-rule="evenodd" clip-rule="evenodd" d="M4.6327 8.00094L10.3199 2L16 8.00094L10.1848 16.8673C10.0995 16.9873 10.0071 17.1074 9.90047 17.2199C9.42417 17.7225 8.79147 18 8.11611 18C7.44076 18 6.80806 17.7225 6.33175 17.2199C5.85545 16.7173 5.59242 16.0497 5.59242 15.3371C5.59242 14.977 5.46445 14.647 5.22275 14.3919C4.98104 14.1369 4.66825 14.0019 4.32701 14.0019H4V12.6667H4.32701C5.00237 12.6667 5.63507 12.9442 6.11137 13.4468C6.58768 13.9494 6.85071 14.617 6.85071 15.3296C6.85071 15.6896 6.97867 16.0197 7.22038 16.2747C7.46209 16.5298 7.77488 16.6648 8.11611 16.6648C8.45735 16.6648 8.77014 16.5223 9.01185 16.2747C9.02396 16.2601 9.03607 16.246 9.04808 16.2319C9.08541 16.1883 9.12176 16.1458 9.15403 16.0947L9.55213 15.4946L4.6327 8.00094ZM10.3199 13.9371L6.53802 8.17116L10.3199 4.1814L14.0963 8.17103L10.3199 13.9371Z"></path>
        </g>
        <g id="menu">
          <path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path>
        </g>
      </defs>
    </svg>
  </iron-iconset-svg>
  <iron-iconset-svg name="cr" size="24">
    <svg>
      <defs>
        <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      See http://goo.gl/Y1OdAq for instructions on adding additional icons.
      -->
        <g id="account-child-invert" viewBox="0 0 48 48">
          <path d="M24 4c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6 2.69-6 6-6z"></path>
          <path fill="none" d="M0 0h48v48H0V0z"></path>
          <circle fill="none" cx="24" cy="26" r="4"></circle>
          <path d="M24 18c-6.16 0-13 3.12-13 7.23v11.54c0 2.32 2.19 4.33 5.2 5.63 2.32 1 5.12 1.59 7.8 1.59.66 0 1.33-.06 2-.14v-5.2c-.67.08-1.34.14-2 .14-2.63 0-5.39-.57-7.68-1.55.67-2.12 4.34-3.65 7.68-3.65.86 0 1.75.11 2.6.29 2.79.62 5.2 2.15 5.2 4.04v4.47c3.01-1.31 5.2-3.31 5.2-5.63V25.23C37 21.12 30.16 18 24 18zm0 12c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z"></path>
        </g>
        <g id="add">
          <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"></path>
        </g>
        <g id="arrow-back">
          <path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"></path>
        </g>
        <g id="arrow-drop-up">
          <path d="M7 14l5-5 5 5z"></path>
        </g>
        <g id="arrow-drop-down">
          <path d="M7 10l5 5 5-5z"></path>
        </g>
        <g id="arrow-forward">
          <path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z"></path>
        </g>
        <g id="arrow-right">
          <path d="M10 7l5 5-5 5z"></path>
        </g>

        <g id="cancel">
          <path d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z"></path>
        </g>
        <g id="check">
          <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
        </g>
        <g id="chevron-left">
          <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path>
        </g>
        <g id="chevron-right">
          <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path>
        </g>
        <g id="clear">
          <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"></path>
        </g>
        <g id="close">
          <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"></path>
        </g>
        <g id="computer">
          <path d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z"></path>
        </g>
        <g id="delete">
          <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path>
        </g>
        <g id="domain">
          <path d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z"></path>
        </g>
        <g id="error">
          <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"></path>
        </g>
        <g id="error-outline">
          <path d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"></path>
        </g>
        <g id="expand-less">
          <path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path>
        </g>
        <g id="expand-more">
          <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path>
        </g>
        <g id="extension">
          <path d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z"></path>
        </g>
        <g id="file-download">
          <path d="M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z"></path>
        </g>

        <g id="fullscreen">
          <path d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z"></path>
        </g>
        <g id="group">
          <path d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"></path>
        </g>
        <g id="help-outline">
          <path d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z"></path>
        </g>
        <g id="info">
          <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z"></path>
        </g>
        <g id="info-outline">
          <path d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z"></path>
        </g>
        <g id="insert-drive-file">
          <path d="M6 2c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6H6zm7 7V3.5L18.5 9H13z"></path>
        </g>
        <g id="location-on">
          <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"></path>
        </g>
        <g id="mic">
          <path d="M12 14c1.66 0 2.99-1.34 2.99-3L15 5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 14 6.7 11H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z"></path>
        </g>
        <g id="more-vert">
          <path d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"></path>
        </g>
        <g id="open-in-new">
          <path d="M19 19H5V5h7V3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-7h-2v7zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3h-7z"></path>
        </g>
        <g id="person">
          <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"></path>
        </g>
        <g id="print">
          <path d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z"></path>
        </g>
        <g id="search">
          <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"></path>
        </g>
        <g id="security">
          <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z"></path>
        </g>

        <!-- The <g> IDs are exposed as global variables in Vulcanized mode, which
        conflicts with the "settings" namespace of MD Settings. Using an "_icon"
        suffix prevents the naming conflict. -->
        <g id="settings_icon">
          <path d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z"></path>
        </g>
        <g id="star">
          <path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z"></path>
        </g>
        <g id="supervisor-account" viewBox="0 0 48 48">
          <path d="M0 0h48v48H0z" fill="none"></path>
          <path d="M33 24c2.76 0 4.98-2.24 4.98-5s-2.22-5-4.98-5c-2.76 0-5 2.24-5 5s2.24 5 5 5zm-15-2c3.31 0 5.98-2.69 5.98-6s-2.67-6-5.98-6c-3.31 0-6 2.69-6 6s2.69 6 6 6zm15 6c-3.67 0-11 1.84-11 5.5V38h22v-4.5c0-3.66-7.33-5.5-11-5.5zm-15-2c-4.67 0-14 2.34-14 7v5h14v-4.5c0-1.7.67-4.67 4.74-6.94C21 26.19 19.31 26 18 26z"></path>
        </g>
        <g id="sync">
          <path d="M12 4V1L8 5l4 4V6c3.31 0 6 2.69 6 6 0 1.01-.25 1.97-.7 2.8l1.46 1.46C19.54 15.03 20 13.57 20 12c0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-1.01.25-1.97.7-2.8L5.24 7.74C4.46 8.97 4 10.43 4 12c0 4.42 3.58 8 8 8v3l4-4-4-4v3z"></path>
        </g>
        <g id="videocam">
          <path d="M17 10.5V7c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l4 4v-11l-4 4z"></path>
        </g>
        <g id="warning">
          <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path>
        </g>
      </defs>
    </svg>
  </iron-iconset-svg> `;
document.head.appendChild(template$3.content);
const template$4 = document.createElement("template");
template$4.innerHTML = `<dom-module id="cr-hidden-style" assetpath="chrome://resources/">
  <template>
    <style scope="cr-hidden-style">[hidden], :host([hidden]) {
    display: none !important;
}
</style>
  </template>
</dom-module>
`;
document.body.appendChild(template$4.content.cloneNode(true));
const template$5 = document.createElement("template");
template$5.innerHTML = `<dom-module id="cr-shared-style" assetpath="chrome://resources/">
  <template>
    <style include="cr-hidden-style cr-icons" scope="cr-shared-style">html, :host {
    --scrollable-border-color: var(--google-grey-refresh-300);
}
@media (prefers-color-scheme: dark) {
  html, :host {
    --scrollable-border-color: var(--google-grey-refresh-700);
  }
}
[actionable] {
    cursor: pointer;
}
.hr {
    border-top: var(--cr-separator-line);
}
iron-list.cr-separators > *:not([first]) {
    border-top: var(--cr-separator-line);
}
[scrollable] {
    border-color: transparent;
        border-style: solid;
        border-width: 1px 0;
        overflow-y: auto;
}
[scrollable].is-scrolled {
    border-top-color: var(--scrollable-border-color);
}
[scrollable].can-scroll:not(.scrolled-to-bottom) {
    border-bottom-color: var(--scrollable-border-color);
}
[scrollable] iron-list > :not(.no-outline):focus, [selectable]:focus, [selectable] > :focus {
    background-color: var(--cr-focused-item-color);
        outline: none;
}
.scroll-container {
    display: flex;
        flex-direction: column;
        min-height: 1px;
}
[selectable] > * {
    cursor: pointer;
}
.cr-centered-card-container {
    box-sizing: border-box;
        display: block;
        height: inherit;
        margin: 0 auto;
        max-width: var(--cr-centered-card-max-width);
        min-width: 550px;
        position: relative;
        width: calc(100% * var(--cr-centered-card-width-percentage));
}
.cr-container-shadow {
    box-shadow: inset 0 5px 6px -3px rgba(0, 0, 0, .4);
        height: var(--cr-container-shadow-height);
        left: 0;
        margin: 0 0 var(--cr-container-shadow-margin);
        opacity: 0;
        pointer-events: none;
        position: relative;
        right: 0;
        top: 0;
        transition: opacity 500ms;
        z-index: 1;
}
#cr-container-shadow-bottom {
    margin-bottom: 0;
        margin-top: var(--cr-container-shadow-margin);
        transform: scaleY(-1);
}
#cr-container-shadow-top.has-shadow, #cr-container-shadow-bottom.has-shadow {
    opacity: var(--cr-container-shadow-max-opacity); display: none;
}
.cr-row {
    align-items: center;
        border-top: var(--cr-separator-line);
        display: flex;
        min-height: var(--cr-section-min-height);
        padding: 0 var(--cr-section-padding);
}
.cr-row.first, .cr-row.continuation {
    border-top: none;
}
.cr-row-gap {
    padding-inline-start: 16px;
}
.cr-button-gap {
    margin-inline-start: 8px;
}
paper-tooltip {
    --paper-tooltip_-_font-size:  92.31%; --paper-tooltip_-_font-weight:  500; --paper-tooltip_-_max-width:  330px; --paper-tooltip_-_min-width:  var(--paper-tooltip-min-width, 200px); --paper-tooltip_-_padding:  var(--paper-tooltip-padding, 10px 8px);
}
.cr-padded-text {
    padding-block-end: var(--cr-section-vertical-padding);
        padding-block-start: var(--cr-section-vertical-padding);
}
.cr-title-text {
    color: var(--cr-title-text-color);
        font-size: 107.6923%;
        font-weight: 500;
}
.cr-secondary-text {
    color: var(--cr-secondary-text-color);
        font-weight: 400;
}
.cr-form-field-label {
    color: var(--cr-form-field-label-color);
        display: block;
        font-size: var(--cr-form-field-label-font-size);
        font-weight: 500;
        letter-spacing: .4px;
        line-height: var(--cr-form-field-label-line-height);
        margin-bottom: 8px;
}
</style>
  </template>
</dom-module>
`;
document.body.appendChild(template$5.content.cloneNode(true));
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const $_documentContainer$1 = document.createElement("template");
$_documentContainer$1.setAttribute("style", "display: none;");
$_documentContainer$1.innerHTML = `<dom-module id="paper-spinner-styles">
  <template>
    <style scope="paper-spinner-styles">:host {
    display: inline-block;
          position: relative;
          width: 28px;
          height: 28px;

          --paper-spinner-container-rotation-duration: 1568ms;

          --paper-spinner-expand-contract-duration: 1333ms;

          --paper-spinner-full-cycle-duration: 5332ms;

          --paper-spinner-cooldown-duration: 400ms;
}
#spinnerContainer {
    width: 100%;
          height: 100%;

          direction: ltr;
}
#spinnerContainer.active {
    animation: container-rotate var(--paper-spinner-container-rotation-duration) linear infinite;
}
@-webkit-keyframes container-rotate {
  to {
    -webkit-transform: rotate(360deg)
}
}
@keyframes container-rotate {
  to {
    transform: rotate(360deg)
}
}
.spinner-layer {
    position: absolute;
          width: 100%;
          height: 100%;
          opacity: 0;
          white-space: nowrap;
          color: var(--paper-spinner-color, var(--google-blue-500));
}
.layer-1 {
    color: var(--paper-spinner-layer-1-color, var(--google-blue-500));
}
.layer-2 {
    color: var(--paper-spinner-layer-2-color, var(--google-red-500));
}
.layer-3 {
    color: var(--paper-spinner-layer-3-color, var(--google-yellow-500));
}
.layer-4 {
    color: var(--paper-spinner-layer-4-color, var(--google-green-500));
}
.active .spinner-layer {
    animation-name: fill-unfill-rotate;
          animation-duration: var(--paper-spinner-full-cycle-duration);
          animation-timing-function: cubic-bezier(0.4, 0.0, 0.2, 1);
          animation-iteration-count: infinite;
          opacity: 1;
}
.active .spinner-layer.layer-1 {
    animation-name: fill-unfill-rotate, layer-1-fade-in-out;
}
.active .spinner-layer.layer-2 {
    animation-name: fill-unfill-rotate, layer-2-fade-in-out;
}
.active .spinner-layer.layer-3 {
    animation-name: fill-unfill-rotate, layer-3-fade-in-out;
}
.active .spinner-layer.layer-4 {
    animation-name: fill-unfill-rotate, layer-4-fade-in-out;
}
@-webkit-keyframes fill-unfill-rotate {
  12.5% {
    -webkit-transform: rotate(135deg)
}
25% {
    -webkit-transform: rotate(270deg)
}
37.5% {
    -webkit-transform: rotate(405deg)
}
50% {
    -webkit-transform: rotate(540deg)
}
62.5% {
    -webkit-transform: rotate(675deg)
}
75% {
    -webkit-transform: rotate(810deg)
}
87.5% {
    -webkit-transform: rotate(945deg)
}
to {
    -webkit-transform: rotate(1080deg)
}
}
@keyframes fill-unfill-rotate {
  12.5% {
    transform: rotate(135deg)
  }
  25% {
      transform: rotate(270deg)
  }
  37.5% {
      transform: rotate(405deg)
  }
  50% {
      transform: rotate(540deg)
  }
  62.5% {
      transform: rotate(675deg)
  }
  75% {
      transform: rotate(810deg)
  }
  87.5% {
      transform: rotate(945deg)
  }
  to {
      transform: rotate(1080deg)
  }
}
@-webkit-keyframes layer-1-fade-in-out {
  0% {
    opacity: 1
  }
  25% {
      opacity: 1
  }
  26% {
      opacity: 0
  }
  89% {
      opacity: 0
  }
  90% {
      opacity: 1
  }
  to {
      opacity: 1
  }
}
@keyframes layer-1-fade-in-out {
  0% {
    opacity: 1
  }
  25% {
      opacity: 1
  }
  26% {
      opacity: 0
  }
  89% {
      opacity: 0
  }
  90% {
      opacity: 1
  }
  to {
      opacity: 1
  }
}
@-webkit-keyframes layer-2-fade-in-out {
  0% {
    opacity: 0
  }
  15% {
      opacity: 0
  }
  25% {
      opacity: 1
  }
  50% {
      opacity: 1
  }
  51% {
      opacity: 0
  }
  to {
      opacity: 0
  }
}
@keyframes layer-2-fade-in-out {
  0% {
    opacity: 0
  }
  15% {
      opacity: 0
  }
  25% {
      opacity: 1
  }
  50% {
      opacity: 1
  }
  51% {
      opacity: 0
  }
  to {
      opacity: 0
  }
}
@-webkit-keyframes layer-3-fade-in-out {
  0% {
    opacity: 0
  }
  40% {
      opacity: 0
  }
  50% {
      opacity: 1
  }
  75% {
      opacity: 1
  }
  76% {
      opacity: 0
  }
  to {
      opacity: 0
  }
}
@keyframes layer-3-fade-in-out {
  0% {
    opacity: 0
  }
  40% {
      opacity: 0
  }
  50% {
      opacity: 1
  }
  75% {
      opacity: 1
  }
  76% {
      opacity: 0
  }
  to {
      opacity: 0
  }
}
@-webkit-keyframes layer-4-fade-in-out {
  0% {
    opacity: 0
  }
  65% {
      opacity: 0
  }
  75% {
      opacity: 1
  }
  90% {
      opacity: 1
  }
  to {
      opacity: 0
  }
}
@keyframes layer-4-fade-in-out {
  0% {
    opacity: 0
  }
  65% {
      opacity: 0
  }
  75% {
      opacity: 1
  }
  90% {
      opacity: 1
  }
  to {
      opacity: 0
  }
}
.circle-clipper {
    display: inline-block;
          position: relative;
          width: 50%;
          height: 100%;
          overflow: hidden;
}
.spinner-layer::after {
    content: '';
        left: 45%;
        width: 10%;
        border-top-style: solid;
}
.spinner-layer::after, .circle-clipper .circle {
    box-sizing: border-box;
          position: absolute;
          top: 0;
          border-width: var(--paper-spinner-stroke-width, 3px);
          border-radius: 50%;
}
.circle-clipper .circle {
    bottom: 0;
          width: 200%;
          border-style: solid;
          border-bottom-color: transparent !important;
}
.circle-clipper.left .circle {
    left: 0;
          border-right-color: transparent !important;
          transform: rotate(129deg);
}
.circle-clipper.right .circle {
    left: -100%;
          border-left-color: transparent !important;
          transform: rotate(-129deg);
}
.active .gap-patch::after, .active .circle-clipper .circle {
    animation-duration: var(--paper-spinner-expand-contract-duration);
          animation-timing-function: cubic-bezier(0.4, 0.0, 0.2, 1);
          animation-iteration-count: infinite;
}
.active .circle-clipper.left .circle {
    animation-name: left-spin;
}
.active .circle-clipper.right .circle {
    animation-name: right-spin;
}
@-webkit-keyframes left-spin {
  0% {
    -webkit-transform: rotate(130deg)
  }
  50% {
      -webkit-transform: rotate(-5deg)
  }
  to {
      -webkit-transform: rotate(130deg)
  }
}
@keyframes left-spin {
  0% {
    transform: rotate(130deg)
  }
  50% {
      transform: rotate(-5deg)
  }
  to {
      transform: rotate(130deg)
  }
}
@-webkit-keyframes right-spin {
  0% {
    -webkit-transform: rotate(-130deg)
  }
  50% {
      -webkit-transform: rotate(5deg)
  }
  to {
      -webkit-transform: rotate(-130deg)
  }
}
@keyframes right-spin {
  0% {
    transform: rotate(-130deg)
  }
  50% {
      transform: rotate(5deg)
  }
  to {
      transform: rotate(-130deg)
  }
}
#spinnerContainer.cooldown {
    animation: container-rotate var(--paper-spinner-container-rotation-duration) linear infinite, fade-out var(--paper-spinner-cooldown-duration) cubic-bezier(0.4, 0.0, 0.2, 1);
}
@-webkit-keyframes fade-out {
  0% {
    opacity: 1
  }
  to {
      opacity: 0
  }
  }
  @keyframes fade-out {
    0% {
      opacity: 1
  }
  to {
      opacity: 0
  }
}
</style>
  </template>
</dom-module>`;
document.head.appendChild($_documentContainer$1.content);
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const PaperSpinnerBehavior = {
  properties: {
    active: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      observer: "__activeChanged",
    },
    alt: {
      type: String,
      value: "loading",
      observer: "__altChanged",
    },
    __coolingDown: {
      type: Boolean,
      value: false,
    },
  },
  __computeContainerClasses: function(active, coolingDown) {
    return [active || coolingDown ? "active" : "", coolingDown ? "cooldown" : ""].join(" ");
  },
  __activeChanged: function(active, old) {
    this.__setAriaHidden(!active);
    this.__coolingDown = !active && old;
  },
  __altChanged: function(alt) {
    if (alt === "loading") {
      this.alt = this.getAttribute("aria-label") || alt;
    } else {
      this.__setAriaHidden(alt === "");
      this.setAttribute("aria-label", alt);
    }
  },
  __setAriaHidden: function(hidden) {
    var attr = "aria-hidden";
    if (hidden) {
      this.setAttribute(attr, "true");
    } else {
      this.removeAttribute(attr);
    }
  },
  __reset: function() {
    this.active = false;
    this.__coolingDown = false;
  },
};
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const template$6 = html`<style include="paper-spinner-styles"></style>

  <div id="spinnerContainer" class-name="[[__computeContainerClasses(active, __coolingDown)]]" on-animationend="__reset" on-webkit-animation-end="__reset">
    <div class="spinner-layer">
      <div class="circle-clipper left">
        <div class="circle"></div>
      </div>
      <div class="circle-clipper right">
        <div class="circle"></div>
      </div>
    </div>
  </div> `;
template$6.setAttribute("strip-whitespace", "");
Polymer({
  _template: template$6,
  is: "paper-spinner-lite",
  behaviors: [PaperSpinnerBehavior],
});
// Copyright 2016 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow-->
    <!--_html_template_start_-->
    <style include="cr-shared-style cr-icons" scope="cr-toolbar-search-field">
      :host {
        align-items: center;
        display: flex;
        height: 32px;
        transition: background-color 150ms cubic-bezier(0.4, 0, 0.2, 1), width 150ms cubic-bezier(0.4, 0, 0.2, 1);
        width: 44px;
      }

      [hidden] {
        display: none !important;
      }

      cr-icon-button {
        --cr-icon-button-size: var(--cr-toolbar-icon-container-size, 32px);
        margin: var(--cr-toolbar-icon-margin, 6px);
      }

      @media (prefers-color-scheme: light) {
        cr-icon-button {
          --cr-icon-button-fill-color: var(--cr-toolbar-search-field-input-icon-color, white);
          --cr-icon-button-fill-color: 99ee9e;
        }
      }

      @media (prefers-color-scheme: dark) {
        cr-icon-button {
          --cr-icon-button-fill-color: var(--cr-toolbar-search-field-input-icon-color, var(--google-grey-refresh-500));
        }
      }

      #icon {
        transition: margin 150ms, opacity 200ms;
      }

      #prompt {
        --cr-toolbar-search-field-prompt-opacity: 0.7;
        opacity: 0;
      }

      @media (prefers-color-scheme: dark) {
        #prompt {
          --cr-toolbar-search-field-prompt-opacity: 1;
        }
      }

      paper-spinner-lite {
        --paper-spinner-color: var(--cr-toolbar-search-field-input-icon-color, white);
        height: var(--cr-icon-size);
        margin: var(--cr-toolbar-search-field-paper-spinner-margin, 0 6px);
        opacity: 0;
        padding: 6px;
        position: absolute;
        width: var(--cr-icon-size);
      }

      paper-spinner-lite[active] {
        opacity: 1;
      }

      #prompt,
      paper-spinner-lite {
        transition: opacity 200ms;
      }

      #searchTerm {
        -webkit-font-smoothing: antialiased;
        flex: 1;
        line-height: 185%;
        margin: var(--cr-toolbar-search-field-term-margin, 0 2px);
        position: relative;
      }

      label {
        bottom: 0;
        cursor: var(--cr-toolbar-search-field-cursor, text);
        left: 0;
        overflow: hidden;
        position: absolute;
        right: 0;
        top: 0;
        white-space: nowrap;
      }

      :host([has-search-text]) label {
        visibility: hidden;
      }

      input {
        -webkit-appearance: none;
        background: var(--maxthon-bg-input);
        border: none;
        color: var(--cr-toolbar-search-field-input-text-color, white);
        cursor: var(--cr-toolbar-search-field-cursor, text);
        font: inherit;
        outline: none;
        padding: 0;
        position: relative;
        width: 100%;
      }

      input[type="search"]::-webkit-search-cancel-button {
        -webkit-appearance: none;
        margin: 0;
      }

      :host([narrow]) {
        border-radius: var(--cr-toolbar-search-field-border-radius, 0);
      }

      :host(:not([narrow])) {
        background: var(--maxthon-bg-input);
        border: 1px solid var(--maxthon-border);
        cursor: var(--cr-toolbar-search-field-cursor, text);
        padding-inline-end: 0;
        width: 240px;
        height: 32px;
      }

      :host(:not([narrow]):not([showing-search])) #icon {
        opacity: 0.7;
      }

      :host(:not([narrow])) #prompt {
        margin-inline-start: var(--cr-toolbar-search-field-prompt-margin-inline-start);
        opacity: var(--cr-toolbar-search-field-prompt-opacity);
      }

      :host([narrow]:not([showing-search])) #searchTerm {
        display: none;
      }

      :host([showing-search][spinner-active]) #icon {
        opacity: 0;
      }

      :host([narrow][showing-search]) {
        width: 100%;
        margin-left: 20px;
        border: 1px solid #bdbdbd;
      }

      :host([narrow][showing-search]) #icon,
      :host([narrow][showing-search]) paper-spinner-lite {
        margin-inline-start: 18px;
      }
    </style>
    <template is="dom-if" id="spinnerTemplate">
      <paper-spinner-lite active="[[isSpinnerShown_]]"> </paper-spinner-lite>
    </template>
    <cr-icon-button id="icon" iron-icon="cr:search" title="[[label]]" dir="ltr" tabindex$="[[computeIconTabIndex_(narrow, hasSearchText)]]" aria-hidden$="[[computeIconAriaHidden_(narrow, hasSearchText)]]"> </cr-icon-button>
    <div id="searchTerm">
      <label id="prompt" for="searchInput" aria-hidden="true">[[label]]</label>
      <input id="searchInput" placeholder="[[label]]" aria-labelledby="prompt" autocomplete="off" type="search" on-input="onSearchTermInput" on-search="onSearchTermSearch" on-keydown="onSearchTermKeydown_" on-focus="onInputFocus_" on-blur="onInputBlur_" autofocus="" spellcheck="false" />
    </div>
    <template is="dom-if" if="[[hasSearchText]]">
      <cr-icon-button id="clearSearch" iron-icon="cr:cancel" title="[[clearLabel]]" on-click="clearSearch_"></cr-icon-button>
    </template>
    <!--_html_template_end_-->`,
  is: "cr-toolbar-search-field",
  behaviors: [CrSearchFieldBehavior],
  properties: {
    narrow: {
      type: Boolean,
      reflectToAttribute: true,
    },
    showingSearch: {
      type: Boolean,
      value: false,
      notify: true,
      observer: "showingSearchChanged_",
      reflectToAttribute: true,
    },
    label: String,
    clearLabel: String,
    spinnerActive: {
      type: Boolean,
      reflectToAttribute: true,
    },
    isSpinnerShown_: {
      type: Boolean,
      computed: "computeIsSpinnerShown_(spinnerActive, showingSearch)",
    },
    searchFocused_: {
      type: Boolean,
      value: false,
    },
  },
  listeners: {
    click: "showSearch_",
  },
  getSearchInput() {
    return this.$.searchInput;
  },
  isSearchFocused() {
    return this.searchFocused_;
  },
  showAndFocus() {
    this.showingSearch = true;
    this.focus_();
  },
  onSearchTermInput() {
    CrSearchFieldBehavior.onSearchTermInput.call(this);
    this.showingSearch = this.hasSearchText || this.isSearchFocused();
  },
  focus_() {
    this.getSearchInput().focus();
  },
  computeIconTabIndex_(narrow) {
    return narrow && !this.hasSearchText ? 0 : -1;
  },
  computeIconAriaHidden_(narrow) {
    return Boolean(!narrow || this.hasSearchText).toString();
  },
  computeIsSpinnerShown_() {
    const showSpinner = this.spinnerActive && this.showingSearch;
    if (showSpinner) {
      this.$.spinnerTemplate.if = true;
    }
    return showSpinner;
  },
  onInputFocus_() {
    this.searchFocused_ = true;
  },
  onInputBlur_() {
    this.searchFocused_ = false;
    if (!this.hasSearchText) {
      this.showingSearch = false;
    }
  },
  onSearchTermKeydown_(e) {
    if (e.key === "Escape") {
      this.showingSearch = false;
    }
  },
  showSearch_(e) {
    if (e.target !== this.$.clearSearch) {
      this.showingSearch = true;
    }
  },
  clearSearch_(e) {
    this.setValue("");
    this.focus_();
    this.spinnerActive = false;
  },
  showingSearchChanged_(current, previous) {
    if (previous === undefined) {
      return;
    }
    if (this.showingSearch) {
      this.focus_();
      return;
    }
    this.setValue("");
    this.getSearchInput().blur();
  },
});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
Polymer({
  is: "iron-media-query",
  properties: {
    queryMatches: {
      type: Boolean,
      value: false,
      readOnly: true,
      notify: true,
    },
    query: {
      type: String,
      observer: "queryChanged",
    },
    full: {
      type: Boolean,
      value: false,
    },
    _boundMQHandler: {
      value: function() {
        return this.queryHandler.bind(this);
      },
    },
    _mq: {
      value: null,
    },
  },
  attached: function() {
    this.style.display = "none";
    this.queryChanged();
  },
  detached: function() {
    this._remove();
  },
  _add: function() {
    if (this._mq) {
      this._mq.addListener(this._boundMQHandler);
    }
  },
  _remove: function() {
    if (this._mq) {
      this._mq.removeListener(this._boundMQHandler);
    }
    this._mq = null;
  },
  queryChanged: function() {
    this._remove();
    var query = this.query;
    if (!query) {
      return;
    }
    if (!this.full && query[0] !== "(") {
      query = "(" + query + ")";
    }
    this._mq = window.matchMedia(query);
    this._add();
    this.queryHandler(this._mq);
  },
  queryHandler: function(mq) {
    this._setQueryMatches(mq.matches);
  },
});
// Copyright 2016 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow-->
    <!--_html_template_start_-->
    <style include="cr-icons cr-hidden-style" scope="cr-toolbar">
      :host {
        display: flex;
        align-items: center;
        --cr-toolbar-field-width: 280px;
        height: var(--cr-toolbar-height);
        background-color: var(--cr-toolbar-background-color);
        border-bottom: 1px solid var(--maxthon-border);
        color: #458ff3;
      }

      @media (prefers-color-scheme: dark) {
        :host {
          border-bottom: var(--cr-separator-line);
          box-sizing: border-box;
          color: var(--cr-secondary-text-color);
        }
      }

      h1 {
        flex: 1;
        font-size: 20px;
        font-weight: normal;
        color: #000;
      }

      @media (prefers-color-scheme: dark) {
        h1 {
          color: var(--cr-primary-text-color);
        }
      }

      #leftContent {
        position: relative;
        transition: opacity 100ms;
      }

      #leftSpacer {
        display: flex;
        align-items: center;
        box-sizing: border-box;
        width: var(--cr-toolbar-left-spacer-width, auto);
        padding-inline-start: 32px;
      }

      cr-icon-button {
        --cr-icon-button-size: 32px;
        min-width: 32px;
      }

      @media (prefers-color-scheme: light) {
        cr-icon-button {
          --cr-icon-button-fill-color: currentColor;
          --cr-icon-button-fill-color: #9e9e9e;
        }
      }

      #centeredContent {
        display: flex;
        flex: 0 0;
        justify-content: flex-start;
        color: #9e9e9e;
      }

      #rightSpacer {
        padding-inline-end: 12px;
      }

      :host([narrow]) #centeredContent {
        justify-content: flex-end;
      }

      :host([has-overlay]) {
        transition: visibility var(--cr-toolbar-overlay-animation-duration);
        visibility: hidden;
      }

      :host([narrow][showing-search_]) #leftContent {
        opacity: 0;
        position: absolute;
      }

      :host(:not([narrow])) #leftContent {
        flex: 0 0 200px;
      }

      :host(:not([narrow])) #centeredContent {
        flex-basis: var(--cr-toolbar-center-basis, 0);
      }

      :host(:not([narrow])) #rightContent {
        flex: 1 1 0;
        text-align: end;
      }

      #menuPromo {
        align-items: center;
        background: #616161;
        border-radius: 2px;
        color: white;
        display: flex;
        font-size: 92.3%;
        font-weight: 500;
        opacity: 0;
        padding-bottom: 6px;
        padding-inline-end: 12px;
        padding-inline-start: 8px;
        padding-top: 6px;
        position: absolute;
        top: var(--cr-toolbar-height);
        white-space: nowrap;
        z-index: 2;
      }

      #menuPromo::before {
        background: inherit;
        clip-path: polygon(0 105%, 100% 105%, 50% 0);
        content: "";
        display: block;
        height: 6px;
        left: 10px;
        position: absolute;
        top: -6px;
        width: 12px;
      }

      :host-context([dir="rtl"]) #menuPromo::before {
        left: auto;
        right: 10px;
      }

      #closePromo {
        -webkit-appearance: none;
        background: none;
        border: none;
        color: inherit;
        font-size: 20px;
        line-height: 20px;
        margin-inline-start: 12px;
        padding: 0;
        width: 20px;
      }
    </style>
    <div id="leftContent">
      <div id="leftSpacer">
        <h1>___toolbarTitle___</h1>
      </div>
    </div>

    <div id="centeredContent" hidden$="[[!showSearch]]">
      <cr-toolbar-search-field id="search" narrow="[[narrow]]" label="___search___" clear-label="___clearSearch___" spinner-active="[[spinnerActive]]" showing-search="{{showingSearch_}}"> </cr-toolbar-search-field>
      <iron-media-query query="(max-width: [[narrowThreshold]]px)" query-matches="{{narrow}}"> </iron-media-query>
    </div>

    <div id="rightContent">
      <div id="rightSpacer">
        <slot></slot>
      </div>
    </div>
    <!--_html_template_end_-->`,
  is: "cr-toolbar",
  properties: {
    pageName: String,
    searchPrompt: String,
    clearLabel: String,
    menuLabel: String,
    menuPromo: String,
    spinnerActive: Boolean,
    showMenu: {
      type: Boolean,
      value: false,
    },
    showMenuPromo: {
      type: Boolean,
      value: false,
    },
    showSearch: {
      type: Boolean,
      value: true,
    },
    narrow: {
      type: Boolean,
      reflectToAttribute: true,
      readonly: true,
      notify: true,
    },
    narrowThreshold: {
      type: Number,
      value: 900,
    },
    closeMenuPromo: String,
    showingSearch_: {
      type: Boolean,
      reflectToAttribute: true,
    },
  },
  observers: ["possiblyShowMenuPromo_(showMenu, showMenuPromo, showingSearch_)"],
  getSearchField() {
    return this.$.search;
  },
  onClosePromoTap_() {
    this.fire("cr-toolbar-menu-promo-close");
  },
  onMenuTap_() {
    this.fire("cr-toolbar-menu-tap");
  },
  possiblyShowMenuPromo_() {
    afterNextRender(
      this,
      function() {
        if (this.showMenu && this.showMenuPromo && !this.showingSearch_) {
          this.$$("#menuPromo").animate(
            [
              {
                opacity: 0,
              },
              {
                opacity: 0.9,
              },
            ],
            {
              duration: 500,
              fill: "forwards",
            }
          );
          this.fire("cr-toolbar-menu-promo-shown");
        }
      }.bind(this)
    );
  },
  titleIfNotShowMenuPromo_(title, showMenuPromo) {
    return showMenuPromo ? "" : title;
  },
});
// Copyright 2018 The Chromium Authors. All rights reserved.
function whenFinished(animation) {
  return new Promise(function(resolve, reject) {
    animation.addEventListener("finish", resolve);
  });
}
const viewAnimations = new Map();
viewAnimations.set("no-animation", () => Promise.resolve());
viewAnimations.set("fade-in", (element) => {
  const animation = element.animate(
    [
      {
        opacity: 0,
      },
      {
        opacity: 1,
      },
    ],
    {
      duration: 180,
      easing: "ease-in-out",
      iterations: 1,
    }
  );
  return whenFinished(animation);
});
viewAnimations.set("fade-out", (element) => {
  const animation = element.animate(
    [
      {
        opacity: 1,
      },
      {
        opacity: 0,
      },
    ],
    {
      duration: 180,
      easing: "ease-in-out",
      iterations: 1,
    }
  );
  return whenFinished(animation);
});
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="cr-view-manager">
      :host ::slotted([slot="view"]) {
        bottom: 0;
        display: none;
        left: 0;
        position: absolute;
        right: 0;
        top: 0;
      }

      :host ::slotted(.active),
      :host ::slotted(.closing) {
        display: block;
      }
    </style>
    <slot name="view"></slot>
    <!--_html_template_end_-->`,
  is: "cr-view-manager",
  exit_(element, animation) {
    const animationFunction = viewAnimations.get(animation);
    assert(animationFunction);
    element.classList.remove("active");
    element.classList.add("closing");
    element.dispatchEvent(
      new CustomEvent("view-exit-start", {
        bubbles: true,
        composed: true,
      })
    );
    return animationFunction(element).then(function() {
      element.classList.remove("closing");
      element.dispatchEvent(
        new CustomEvent("view-exit-finish", {
          bubbles: true,
          composed: true,
        })
      );
    });
  },
  enter_(view, animation) {
    const animationFunction = viewAnimations.get(animation);
    assert(animationFunction);
    const effectiveView = view.matches("cr-lazy-render") ? view.get() : view;
    effectiveView.classList.add("active");
    effectiveView.dispatchEvent(
      new CustomEvent("view-enter-start", {
        bubbles: true,
        composed: true,
      })
    );
    return animationFunction(effectiveView).then(() => {
      effectiveView.dispatchEvent(
        new CustomEvent("view-enter-finish", {
          bubbles: true,
          composed: true,
        })
      );
    });
  },
  switchView(newViewId, enterAnimation, exitAnimation) {
    const previousView = this.querySelector(".active");
    const newView = assert(this.querySelector("#" + newViewId));
    const promises = [];
    if (previousView) {
      promises.push(this.exit_(previousView, exitAnimation || "fade-out"));
      promises.push(this.enter_(newView, enterAnimation || "fade-in"));
    } else {
      promises.push(this.enter_(newView, "no-animation"));
    }
    return Promise.all(promises);
  },
});
// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CLASS_NAME = "focus-outline-visible";
const docsToManager = new Map();
class FocusOutlineManager {
  constructor(doc) {
    this.focusByKeyboard_ = true;
    this.classList_ = doc.documentElement.classList;
    const onEvent = function(focusByKeyboard, e) {
      if (this.focusByKeyboard_ === focusByKeyboard) {
        return;
      }
      this.focusByKeyboard_ = focusByKeyboard;
      this.updateVisibility();
    };
    doc.addEventListener("keydown", onEvent.bind(this, true), true);
    doc.addEventListener("mousedown", onEvent.bind(this, false), true);
    this.updateVisibility();
  }
  updateVisibility() {
    this.visible = this.focusByKeyboard_;
  }
  set visible(visible) {
    this.classList_.toggle(CLASS_NAME, visible);
  }
  get visible() {
    return this.classList_.contains(CLASS_NAME);
  }
  static forDocument(doc) {
    let manager = docsToManager.get(doc);
    if (!manager) {
      manager = new FocusOutlineManager(doc);
      docsToManager.set(doc, manager);
    }
    return manager;
  }
}
// Copyright 2019 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-hidden-style" scope="cr-button">
      :host {
        --active-shadow-rgb: var(--google-grey-800-rgb);
        --active-shadow-action-rgb: var(--google-blue-refresh-500-rgb);
        --bg-action: var(--google-blue-600);
        --border-color: var(--google-grey-refresh-300);
        --disabled-bg-action: var(--google-grey-refresh-100);
        --disabled-bg: white;
        --disabled-border-color: var(--google-grey-refresh-100);
        --focus-shadow-color: rgba(var(--google-blue-600-rgb), 0.4);
        --hover-bg-action: rgba(var(--google-blue-600-rgb), 0.9);
        --hover-bg-color: rgba(var(--google-blue-refresh-500-rgb), 0.04);
        --hover-border-color: var(--google-blue-refresh-100);
        --hover-shadow-action-rgb: var(--google-blue-refresh-500-rgb);
        --ink-color-action: white;

        --ink-color: var(--google-blue-600);
        --ripple-opacity-action: 0.32;
        --ripple-opacity: 0.1;
        --text-color-action: white;
        --text-color: var(--google-blue-600);
      }

      @media (prefers-color-scheme: dark) {
        :host {
          --active-bg: black linear-gradient(rgba(255, 255, 255, 0.06), rgba(255, 255, 255, 0.06));
          --active-shadow-rgb: 0, 0, 0;
          --active-shadow-action-rgb: var(--google-blue-refresh-500-rgb);
          --bg-action: var(--google-blue-refresh-300);
          --border-color: var(--google-grey-refresh-700);
          --disabled-bg-action: var(--google-grey-800);

          --disabled-bg: transparent;
          --disabled-border-color: var(--google-grey-800);
          --focus-shadow-color: rgba(var(--google-blue-refresh-300-rgb), 0.5);
          --hover-bg-action: var(--bg-action) linear-gradient(rgba(0, 0, 0, 0.08), rgba(0, 0, 0, 0.08));
          --hover-bg-color: rgba(var(--google-blue-refresh-300-rgb), 0.08);
          --ink-color-action: black;
          --ink-color: var(--google-blue-refresh-300);
          --ripple-opacity-action: 0.16;
          --ripple-opacity: 0.16;
          --text-color-action: var(--google-grey-900);
          --text-color: var(--google-blue-refresh-300);
        }
      }

      :host {
        --paper-ripple-opacity: var(--ripple-opacity);
        -webkit-tap-highlight-color: transparent;
        align-items: center;
        border: 1px solid var(--border-color);
        box-sizing: border-box;
        color: #458ff3;
        cursor: pointer;
        display: inline-flex;
        flex-shrink: 0;
        font-weight: 500;
        height: var(--cr-button-height);
        justify-content: center;
        min-width: 5.14em;
        outline-width: 0;
        padding: 8px 16px;
        position: relative;
        user-select: none;
      }

      :host-context(.focus-outline-visible):host(:focus) {
        box-shadow: 0 0 0 2px var(--focus-shadow-color);
      }

      :host(:active) {
        background: var(--active-bg);
        box-shadow: 0 1px 2px 0 rgba(var(--active-shadow-rgb), 0.3), 0 3px 6px 2px rgba(var(--active-shadow-rgb), 0.15);
      }

      :host(:hover) {
        background-color: var(--hover-bg-color);
      }

      @media (prefers-color-scheme: light) {
        :host(:hover) {
          border-color: var(--hover-border-color);
        }
      }

      :host(.action-button) {
        --ink-color: var(--ink-color-action);
        --paper-ripple-opacity: var(--ripple-opacity-action);
        background-color: #458ff3;
        border: none;
        color: var(--text-color-action);
      }

      :host(.action-button:active) {
        box-shadow: 0 1px 2px 0 rgba(var(--active-shadow-action-rgb), 0.3), 0 3px 6px 2px rgba(var(--active-shadow-action-rgb), 0.15);
      }

      :host(.action-button:hover) {
        background: var(--hover-bg-action);
      }

      @media (prefers-color-scheme: light) {
        :host(.action-button:not(:active):hover) {
          box-shadow: 0 1px 2px 0 rgba(var(--hover-shadow-action-rgb), 0.3), 0 1px 3px 1px rgba(var(--hover-shadow-action-rgb), 0.15);
        }
      }

      :host([disabled]) {
        background-color: var(--disabled-bg);
        border-color: var(--disabled-border-color);
        color: var(--google-grey-600);
        cursor: auto;
        pointer-events: none;
      }

      :host(.action-button[disabled]) {
        background-color: var(--disabled-bg-action);
        border-color: transparent;
      }

      :host(.cancel-button) {
        margin-inline-end: 8px;
      }

      :host(.action-button),
      :host(.cancel-button) {
        line-height: 154%;
      }

      paper-ripple {
        color: var(--ink-color);
        height: var(--paper-ripple-height);
        width: var(--paper-ripple-width);

        left: var(--paper-ripple-left, 0);
        top: var(--paper-ripple-top, 0);
      }
    </style>
    <slot></slot>
    <!--_html_template_end_-->`,
  is: "cr-button",
  behaviors: [PaperRippleBehavior],
  properties: {
    disabled: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      observer: "disabledChanged_",
    },
    customTabIndex: {
      type: Number,
      observer: "applyTabIndex_",
    },
    circleRipple: {
      type: Boolean,
      value: false,
    },
  },
  hostAttributes: {
    "aria-disabled": "false",
    role: "button",
    tabindex: 0,
  },
  listeners: {
    blur: "onBlur_",
    click: "onClick_",
    keydown: "onKeyDown_",
    keyup: "onKeyUp_",
    pointerdown: "onPointerDown_",
    tap: "onTap_",
  },
  spaceKeyDown_: false,
  timeoutIds_: null,
  ready() {
    FocusOutlineManager.forDocument(document);
    this.timeoutIds_ = new Set();
  },
  detached() {
    this.timeoutIds_.forEach(clearTimeout);
    this.timeoutIds_.clear();
  },
  setTimeout_(fn, delay) {
    if (!this.isConnected) {
      return;
    }
    const id = setTimeout(() => {
      this.timeoutIds_.delete(id);
      fn();
    }, delay);
    this.timeoutIds_.add(id);
  },
  disabledChanged_(newValue, oldValue) {
    if (!newValue && oldValue === undefined) {
      return;
    }
    if (this.disabled) {
      this.blur();
    }
    this.setAttribute("aria-disabled", Boolean(this.disabled));
    this.applyTabIndex_();
  },
  applyTabIndex_() {
    let value = this.customTabIndex;
    if (value === undefined) {
      value = this.disabled ? -1 : 0;
    }
    this.setAttribute("tabindex", value);
  },
  onBlur_() {
    this.spaceKeyDown_ = false;
  },
  onClick_(e) {
    if (this.disabled) {
      e.stopImmediatePropagation();
    }
  },
  onKeyDown_(e) {
    if (e.key !== " " && e.key !== "Enter") {
      return;
    }
    e.preventDefault();
    e.stopPropagation();
    if (e.repeat) {
      this.lastKeyDownKey_ = null;
      return;
    }
    this.getRipple().uiDownAction();
    if (e.key === "Enter") {
      this.click();
      this.setTimeout_(() => this.getRipple().uiUpAction(), 100);
    } else if (e.key === " ") {
      this.spaceKeyDown_ = true;
    }
  },
  onKeyUp_(e) {
    if (e.key !== " " && e.key !== "Enter") {
      return;
    }
    e.preventDefault();
    e.stopPropagation();
    if (this.spaceKeyDown_ && e.key === " ") {
      this.spaceKeyDown_ = false;
      this.click();
      this.getRipple().uiUpAction();
    }
  },
  onPointerDown_() {
    this.ensureRipple();
  },
  onTap_() { },
  _createRipple() {
    const ripple = PaperRippleBehavior._createRipple();
    if (this.circleRipple) {
      ripple.setAttribute("center", "");
      ripple.classList.add("circle");
    }
    return ripple;
  },
});
// Copyright 2017 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style cr-hidden-style" scope="cr-link-row">
      :host {
        align-items: center;
        align-self: stretch;
        box-sizing: border-box;
        cursor: pointer;
        display: flex;
        flex: 1;
        font-family: inherit;
        font-size: 100%;
        line-height: 154%;
        margin: 0;
        min-height: var(--cr-section-min-height);
        outline: none;
        padding: 0;
      }

      :host(:not([embedded])) {
        padding: 0 var(--cr-section-padding);
      }

      :host([disabled]) {
        color: var(--paper-grey-500);
        cursor: auto;
        pointer-events: none;
      }

      #startIcon {
        --iron-icon-fill-color: var(--cr-link-row-start-icon-color, var(--google-grey-refresh-700));
        display: flex;
        flex-shrink: 0;
        padding-inline-end: var(--cr-icon-button-margin-start);
        width: var(--cr-link-row-icon-width, var(--cr-icon-size));
      }

      @media (prefers-color-scheme: dark) {
        #startIcon {
          --iron-icon-fill-color: var(--cr-link-row-start-icon-color, var(--google-grey-refresh-500));
        }
      }

      #labelWrapper {
        flex: 1;
        flex-basis: 0.000000001px;
        padding-bottom: var(--cr-section-vertical-padding);
        padding-top: var(--cr-section-vertical-padding);
        text-align: start;
      }

      #label,
      #subLabel {
        display: flex;
      }
    </style>
    <iron-icon id="startIcon" icon="[[startIcon]]" hidden="[[!startIcon]]" aria-hidden="true"> </iron-icon>
    <div id="labelWrapper" hidden="[[hideLabelWrapper_]]">
      <div id="label" aria-hidden="true">
        [[label]]
        <slot name="label"></slot>
      </div>
      <div id="subLabel" class="cr-secondary-text" aria-hidden="true">
        [[subLabel]]
        <slot name="sub-label"></slot>
      </div>
    </div>
    <slot></slot>
    <cr-icon-button id="icon" iron-icon="[[getIcon_(external)]]" role="link" aria-roledescription$="[[roleDescription]]" aria-describedby="subLabel" aria-labelledby="label" disabled="[[disabled]]"></cr-icon-button>
    <!--_html_template_end_-->`,
  is: "cr-link-row",
  properties: {
    startIcon: {
      type: String,
      value: "",
    },
    label: {
      type: String,
      value: "",
    },
    subLabel: {
      type: String,
      value: "",
    },
    disabled: {
      type: Boolean,
      reflectToAttribute: true,
    },
    external: {
      type: Boolean,
      value: false,
    },
    usingSlottedLabel: {
      type: Boolean,
      value: false,
    },
    roleDescription: String,
    hideLabelWrapper_: {
      type: Boolean,
      computed: "computeHideLabelWrapper_(label, usingSlottedLabel)",
    },
  },
  get noink() {
    return this.$.icon.noink;
  },
  set noink(value) {
    this.$.icon.noink = value;
  },
  focus() {
    this.$.icon.focus();
  },
  computeHideLabelWrapper_() {
    return !(this.label || this.usingSlottedLabel);
  },
  getIcon_() {
    return this.external ? "cr:open-in-new" : "cr:arrow-right";
  },
});
// Copyright 2017 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="cr-toggle">
      :host {
        --cr-toggle-checked-bar-color: var(--google-blue-600);
        --cr-toggle-checked-button-color: var(--google-blue-600);
        --cr-toggle-checked-ripple-color: rgba(var(--google-blue-600-rgb), 0.2);
        --cr-toggle-unchecked-bar-color: var(--google-grey-400);
        --cr-toggle-unchecked-button-color: white;
        --cr-toggle-unchecked-ripple-color: rgba(var(--google-grey-600-rgb), 0.15);
        -webkit-tap-highlight-color: transparent;
        cursor: pointer;
        display: block;
        min-width: 34px;
        outline: none;
        position: relative;
        width: 34px;
      }

      @media (prefers-color-scheme: dark) {
        :host {
          --cr-toggle-checked-bar-color: var(--google-blue-refresh-300);
          --cr-toggle-checked-button-color: var(--google-blue-refresh-300);
          --cr-toggle-checked-ripple-color: rgba(var(--google-blue-refresh-300-rgb), 0.4);
          --cr-toggle-unchecked-bar-color: var(--google-grey-refresh-500);
          --cr-toggle-unchecked-button-color: var(--google-grey-refresh-300);
          --cr-toggle-unchecked-ripple-color: rgba(var(--google-grey-refresh-300-rgb), 0.4);
        }
      }

      :host([dark]) {
        --cr-toggle-checked-bar-color: var(--google-blue-refresh-300);
        --cr-toggle-checked-button-color: var(--google-blue-refresh-300);
        --cr-toggle-checked-ripple-color: rgba(var(--google-blue-refresh-300-rgb), 0.4);
        --cr-toggle-unchecked-bar-color: var(--google-grey-refresh-500);
        --cr-toggle-unchecked-button-color: var(--google-grey-refresh-300);
        --cr-toggle-unchecked-ripple-color: rgba(var(--google-grey-refresh-300-rgb), 0.4);
      }

      :host([disabled]) {
        cursor: initial;
        opacity: var(--cr-disabled-opacity);
        pointer-events: none;
      }

      #bar {
        background-color: var(--cr-toggle-unchecked-bar-color);
        border-radius: 8px;
        height: 12px;
        left: 3px;
        position: absolute;
        top: 2px;
        transition: background-color linear 80ms;
        width: 28px;
        z-index: 0;
      }

      :host([checked]) #bar {
        background-color: var(--cr-toggle-checked-bar-color);
        opacity: 0.5;
      }

      #knob {
        background-color: var(--cr-toggle-unchecked-button-color);
        border-radius: 50%;
        box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.4);
        display: block;
        height: 16px;
        position: relative;
        transition: transform linear 80ms, background-color linear 80ms;
        width: 16px;
        z-index: 1;
      }

      :host([checked]) #knob {
        background-color: var(--cr-toggle-checked-button-color);
        transform: translate3d(18px, 0, 0);
      }

      :host-context([dir="rtl"]):host([checked]) #knob {
        transform: translate3d(-18px, 0, 0);
      }

      paper-ripple {
        --paper-ripple-opacity: 1;
        color: var(--cr-toggle-unchecked-ripple-color);
        height: 40px;
        left: -12px;
        pointer-events: none;
        top: -12px;
        transition: color linear 80ms;
        width: 40px;
      }

      :host([checked]) paper-ripple {
        color: var(--cr-toggle-checked-ripple-color);
      }

      :host-context([dir="rtl"]) paper-ripple {
        left: auto;
        right: -12px;
      }
    </style>
    <span id="bar"></span>
    <span id="knob"></span>
    <!--_html_template_end_-->`,
  is: "cr-toggle",
  behaviors: [PaperRippleBehavior],
  properties: {
    checked: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      observer: "checkedChanged_",
      notify: true,
    },
    dark: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
    },
    disabled: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      observer: "disabledChanged_",
    },
  },
  hostAttributes: {
    "aria-disabled": "false",
    "aria-pressed": "false",
    role: "button",
    tabindex: 0,
  },
  listeners: {
    blur: "hideRipple_",
    click: "onClick_",
    focus: "onFocus_",
    keydown: "onKeyDown_",
    keyup: "onKeyUp_",
    pointerdown: "onPointerDown_",
    pointerup: "onPointerUp_",
  },
  boundPointerMove_: null,
  MOVE_THRESHOLD_PX: 5,
  handledInPointerMove_: false,
  attached() {
    const direction = this.matches(":host-context([dir=rtl]) cr-toggle") ? -1 : 1;
    this.boundPointerMove_ = (e) => {
      e.preventDefault();
      const diff = e.clientX - this.pointerDownX_;
      if (Math.abs(diff) < this.MOVE_THRESHOLD_PX) {
        return;
      }
      this.handledInPointerMove_ = true;
      const shouldToggle = (diff * direction < 0 && this.checked) || (diff * direction > 0 && !this.checked);
      if (shouldToggle) {
        this.toggleState_(false);
      }
    };
  },
  checkedChanged_() {
    this.setAttribute("aria-pressed", this.checked ? "true" : "false");
  },
  disabledChanged_() {
    this.setAttribute("tabindex", this.disabled ? -1 : 0);
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
  },
  onFocus_() {
    this.getRipple().showAndHoldDown();
  },
  hideRipple_() {
    this.getRipple().clear();
  },
  onPointerUp_() {
    this.removeEventListener("pointermove", this.boundPointerMove_);
    this.hideRipple_();
  },
  onPointerDown_(e) {
    if (e.button !== 0) {
      return;
    }
    this.setPointerCapture(e.pointerId);
    this.pointerDownX_ = e.clientX;
    this.handledInPointerMove_ = false;
    this.addEventListener("pointermove", this.boundPointerMove_);
  },
  onClick_(e) {
    e.stopPropagation();
    e.preventDefault();
    if (this.handledInPointerMove_) {
      return;
    }
    this.toggleState_(false);
  },
  toggleState_(fromKeyboard) {
    if (this.disabled) {
      return;
    }
    if (!fromKeyboard) {
      this.hideRipple_();
    }
    this.checked = !this.checked;
    this.fire("change", this.checked);
  },
  onKeyDown_(e) {
    if (e.key !== " " && e.key !== "Enter") {
      return;
    }
    e.preventDefault();
    e.stopPropagation();
    if (e.repeat) {
      return;
    }
    if (e.key === "Enter") {
      this.toggleState_(true);
    }
  },
  onKeyUp_(e) {
    if (e.key !== " " && e.key !== "Enter") {
      return;
    }
    e.preventDefault();
    e.stopPropagation();
    if (e.key === " ") {
      this.toggleState_(true);
    }
  },
  _createRipple() {
    this._rippleContainer = this.$.knob;
    const ripple = PaperRippleBehavior._createRipple();
    ripple.id = "ink";
    ripple.setAttribute("recenters", "");
    ripple.classList.add("circle", "toggle-ink");
    return ripple;
  },
});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
Polymer({
  _template: html`<!--css-build:shadow--><style scope="paper-tooltip">
      :host {
        display: block;
        position: absolute;
        outline: none;
        z-index: 1002;
        user-select: none;
        cursor: default;
      }

      #tooltip {
        display: block;
        outline: none;
        font-size: 10px;
        line-height: 1;
        background-color: var(--paper-tooltip-background, #616161);
        color: var(--paper-tooltip-text-color, white);
        padding: 8px;
        border-radius: 2px;
        font-size: var(--paper-tooltip_-_font-size, 10px);
        font-weight: var(--paper-tooltip_-_font-weight);
        max-width: var(--paper-tooltip_-_max-width);
        min-width: var(--paper-tooltip_-_min-width);
        padding: var(--paper-tooltip_-_padding, 8px);
      }

      @keyframes keyFrameScaleUp {
        0% {
          transform: scale(0);
        }

        100% {
          transform: scale(1);
        }
      }

      @keyframes keyFrameScaleDown {
        0% {
          transform: scale(1);
        }

        100% {
          transform: scale(0);
        }
      }

      @keyframes keyFrameFadeInOpacity {
        0% {
          opacity: 0;
        }

        100% {
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
      }

      @keyframes keyFrameFadeOutOpacity {
        0% {
          opacity: var(--paper-tooltip-opacity, 0.9);
        }

        100% {
          opacity: 0;
        }
      }

      @keyframes keyFrameSlideDownIn {
        0% {
          transform: translateY(-2000px);
          opacity: 0;
        }

        10% {
          opacity: 0.2;
        }

        100% {
          transform: translateY(0);
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
      }

      @keyframes keyFrameSlideDownOut {
        0% {
          transform: translateY(0);
          opacity: var(--paper-tooltip-opacity, 0.9);
        }

        10% {
          opacity: 0.2;
        }

        100% {
          transform: translateY(-2000px);
          opacity: 0;
        }
      }

      .fade-in-animation {
        opacity: 0;
        animation-delay: var(--paper-tooltip-delay-in, 500ms);
        animation-name: keyFrameFadeInOpacity;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-in, 500ms);
        animation-fill-mode: forwards;
      }

      .fade-out-animation {
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 0ms);
        animation-name: keyFrameFadeOutOpacity;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .scale-up-animation {
        transform: scale(0);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-in, 500ms);
        animation-name: keyFrameScaleUp;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-in, 500ms);
        animation-fill-mode: forwards;
      }

      .scale-down-animation {
        transform: scale(1);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameScaleDown;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .slide-down-animation {
        transform: translateY(-2000px);
        opacity: 0;
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameSlideDownIn;
        animation-iteration-count: 1;
        animation-timing-function: cubic-bezier(0, 0, 0.2, 1);
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .slide-down-animation-out {
        transform: translateY(0);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameSlideDownOut;
        animation-iteration-count: 1;
        animation-timing-function: cubic-bezier(0.4, 0, 1, 1);
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .cancel-animation {
        animation-delay: -30s !important;
      }

      .hidden {
        display: none !important;
      }
    </style>

    <div id="tooltip" class="hidden">
      <slot></slot>
    </div> `,
  is: "paper-tooltip",
  hostAttributes: {
    role: "tooltip",
    tabindex: -1,
  },
  properties: {
    for: {
      type: String,
      observer: "_findTarget",
    },
    manualMode: {
      type: Boolean,
      value: false,
      observer: "_manualModeChanged",
    },
    position: {
      type: String,
      value: "bottom",
    },
    fitToVisibleBounds: {
      type: Boolean,
      value: false,
    },
    offset: {
      type: Number,
      value: 14,
    },
    marginTop: {
      type: Number,
      value: 14,
    },
    animationDelay: {
      type: Number,
      value: 500,
      observer: "_delayChange",
    },
    animationEntry: {
      type: String,
      value: "",
    },
    animationExit: {
      type: String,
      value: "",
    },
    animationConfig: {
      type: Object,
      value: function() {
        return {
          entry: [
            {
              name: "fade-in-animation",
              node: this,
              timing: {
                delay: 0,
              },
            },
          ],
          exit: [
            {
              name: "fade-out-animation",
              node: this,
            },
          ],
        };
      },
    },
    _showing: {
      type: Boolean,
      value: false,
    },
  },
  listeners: {
    webkitAnimationEnd: "_onAnimationEnd",
  },
  get target() {
    if (this._manualTarget) return this._manualTarget;
    var parentNode = dom(this).parentNode;
    var ownerRoot = dom(this).getOwnerRoot();
    var target;
    if (this.for) {
      target = dom(ownerRoot).querySelector("#" + this.for);
    } else {
      target = parentNode.nodeType == Node.DOCUMENT_FRAGMENT_NODE ? ownerRoot.host : parentNode;
    }
    return target;
  },
  set target(target) {
    this._manualTarget = target;
    this._findTarget();
  },
  attached: function() {
    this._findTarget();
  },
  detached: function() {
    if (!this.manualMode) this._removeListeners();
  },
  playAnimation: function(type) {
    if (type === "entry") {
      this.show();
    } else if (type === "exit") {
      this.hide();
    }
  },
  cancelAnimation: function() {
    this.$.tooltip.classList.add("cancel-animation");
  },
  show: function() {
    if (this._showing) return;
    if (dom(this).textContent.trim() === "") {
      var allChildrenEmpty = true;
      var effectiveChildren = dom(this).getEffectiveChildNodes();
      for (var i = 0; i < effectiveChildren.length; i++) {
        if (effectiveChildren[i].textContent.trim() !== "") {
          allChildrenEmpty = false;
          break;
        }
      }
      if (allChildrenEmpty) {
        return;
      }
    }
    this._showing = true;
    this.$.tooltip.classList.remove("hidden");
    this.$.tooltip.classList.remove("cancel-animation");
    this.$.tooltip.classList.remove(this._getAnimationType("exit"));
    this.updatePosition();
    this._animationPlaying = true;
    this.$.tooltip.classList.add(this._getAnimationType("entry"));
  },
  hide: function() {
    if (!this._showing) {
      return;
    }
    if (this._animationPlaying) {
      this._showing = false;
      this._cancelAnimation();
      return;
    } else {
      this._onAnimationFinish();
    }
    this._showing = false;
    this._animationPlaying = true;
  },
  updatePosition: function() {
    if (!this._target || !this.offsetParent) return;
    var offset = this.offset;
    if (this.marginTop != 14 && this.offset == 14) offset = this.marginTop;
    var parentRect = this.offsetParent.getBoundingClientRect();
    var targetRect = this._target.getBoundingClientRect();
    var thisRect = this.getBoundingClientRect();
    var horizontalCenterOffset = (targetRect.width - thisRect.width) / 2;
    var verticalCenterOffset = (targetRect.height - thisRect.height) / 2;
    var targetLeft = targetRect.left - parentRect.left;
    var targetTop = targetRect.top - parentRect.top;
    var tooltipLeft, tooltipTop;
    switch (this.position) {
      case "top":
        tooltipLeft = targetLeft + horizontalCenterOffset;
        tooltipTop = targetTop - thisRect.height - offset;
        break;
      case "bottom":
        tooltipLeft = targetLeft + horizontalCenterOffset;
        tooltipTop = targetTop + targetRect.height + offset;
        break;
      case "left":
        tooltipLeft = targetLeft - thisRect.width - offset;
        tooltipTop = targetTop + verticalCenterOffset;
        break;
      case "right":
        tooltipLeft = targetLeft + targetRect.width + offset;
        tooltipTop = targetTop + verticalCenterOffset;
        break;
    }
    if (this.fitToVisibleBounds) {
      if (parentRect.left + tooltipLeft + thisRect.width > window.innerWidth) {
        this.style.right = "0px";
        this.style.left = "auto";
      } else {
        this.style.left = Math.max(0, tooltipLeft) + "px";
        this.style.right = "auto";
      }
      if (parentRect.top + tooltipTop + thisRect.height > window.innerHeight) {
        this.style.bottom = parentRect.height - targetTop + offset + "px";
        this.style.top = "auto";
      } else {
        this.style.top = Math.max(-parentRect.top, tooltipTop) + "px";
        this.style.bottom = "auto";
      }
    } else {
      this.style.left = tooltipLeft + "px";
      this.style.top = tooltipTop + "px";
    }
  },
  _addListeners: function() {
    if (this._target) {
      this.listen(this._target, "mouseenter", "show");
      this.listen(this._target, "focus", "show");
      this.listen(this._target, "mouseleave", "hide");
      this.listen(this._target, "blur", "hide");
      this.listen(this._target, "tap", "hide");
    }
    this.listen(this.$.tooltip, "animationend", "_onAnimationEnd");
    this.listen(this, "mouseenter", "hide");
  },
  _findTarget: function() {
    if (!this.manualMode) this._removeListeners();
    this._target = this.target;
    if (!this.manualMode) this._addListeners();
  },
  _delayChange: function(newValue) {
    if (newValue !== 500) {
      this.updateStyles({
        "--paper-tooltip-delay-in": newValue + "ms",
      });
    }
  },
  _manualModeChanged: function() {
    if (this.manualMode) this._removeListeners();
    else this._addListeners();
  },
  _cancelAnimation: function() {
    this.$.tooltip.classList.remove(this._getAnimationType("entry"));
    this.$.tooltip.classList.remove(this._getAnimationType("exit"));
    this.$.tooltip.classList.remove("cancel-animation");
    this.$.tooltip.classList.add("hidden");
  },
  _onAnimationFinish: function() {
    if (this._showing) {
      this.$.tooltip.classList.remove(this._getAnimationType("entry"));
      this.$.tooltip.classList.remove("cancel-animation");
      this.$.tooltip.classList.add(this._getAnimationType("exit"));
    }
  },
  _onAnimationEnd: function() {
    this._animationPlaying = false;
    if (!this._showing) {
      this.$.tooltip.classList.remove(this._getAnimationType("exit"));
      this.$.tooltip.classList.add("hidden");
    }
  },
  _getAnimationType: function(type) {
    if (type === "entry" && this.animationEntry !== "") {
      return this.animationEntry;
    }
    if (type === "exit" && this.animationExit !== "") {
      return this.animationExit;
    }
    if (this.animationConfig[type] && typeof this.animationConfig[type][0].name === "string") {
      if (this.animationConfig[type][0].timing && this.animationConfig[type][0].timing.delay && this.animationConfig[type][0].timing.delay !== 0) {
        var timingDelay = this.animationConfig[type][0].timing.delay;
        if (type === "entry") {
          this.updateStyles({
            "--paper-tooltip-delay-in": timingDelay + "ms",
          });
        } else if (type === "exit") {
          this.updateStyles({
            "--paper-tooltip-delay-out": timingDelay + "ms",
          });
        }
      }
      return this.animationConfig[type][0].name;
    }
  },
  _removeListeners: function() {
    if (this._target) {
      this.unlisten(this._target, "mouseenter", "show");
      this.unlisten(this._target, "focus", "show");
      this.unlisten(this._target, "mouseleave", "hide");
      this.unlisten(this._target, "blur", "hide");
      this.unlisten(this._target, "tap", "hide");
    }
    this.unlisten(this.$.tooltip, "animationend", "_onAnimationEnd");
    this.unlisten(this, "mouseenter", "hide");
  },
});
// Copyright 2017 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style" scope="cr-tooltip-icon">
      :host {
        display: flex;
      }

      iron-icon {
        --iron-icon-width: var(--cr-icon-size);
        --iron-icon-height: var(--cr-icon-size);
      }
    </style>
    <iron-icon id="indicator" tabindex="0" aria-label$="[[iconAriaLabel]]" aria-describedby="tooltip" icon="[[iconClass]]"></iron-icon>
    <paper-tooltip id="tooltip" for="indicator" position="[[tooltipPosition]]" fit-to-visible-bounds="" part="tooltip"> [[tooltipText]] </paper-tooltip>
    <!--_html_template_end_-->`,
  is: "cr-tooltip-icon",
  properties: {
    iconAriaLabel: String,
    iconClass: String,
    tooltipText: String,
    tooltipPosition: {
      type: String,
      value: "top",
    },
  },
  getFocusableElement() {
    return this.$.indicator;
  },
});
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class ActionLink extends HTMLAnchorElement {
  connectedCallback() {
    this.tabIndex = this.disabled ? -1 : 0;
    if (!this.hasAttribute("role")) {
      this.setAttribute("role", "link");
    }
    this.addEventListener("keydown", function(e) {
      if (!this.disabled && e.key === "Enter" && !this.href) {
        window.setTimeout(this.click.bind(this), 0);
      }
    });
    function preventDefault(e) {
      e.preventDefault();
    }
    function removePreventDefault() {
      document.removeEventListener("selectstart", preventDefault);
      document.removeEventListener("mouseup", removePreventDefault);
    }
    this.addEventListener("mousedown", function() {
      document.addEventListener("selectstart", preventDefault);
      document.addEventListener("mouseup", removePreventDefault);
      if (document.activeElement !== this) {
        this.classList.add("no-outline");
      }
    });
    this.addEventListener("blur", function() {
      this.classList.remove("no-outline");
    });
  }
  set disabled(disabled) {
    if (disabled) {
      HTMLAnchorElement.prototype.setAttribute.call(this, "disabled", "");
    } else {
      HTMLAnchorElement.prototype.removeAttribute.call(this, "disabled");
    }
    this.tabIndex = disabled ? -1 : 0;
  }
  get disabled() {
    return this.hasAttribute("disabled");
  }
  setAttribute(attr, val) {
    if (attr.toLowerCase() === "disabled") {
      this.disabled = true;
    } else {
      HTMLAnchorElement.prototype.setAttribute.apply(this, arguments);
    }
  }
  removeAttribute(attr) {
    if (attr.toLowerCase() === "disabled") {
      this.disabled = false;
    } else {
      HTMLAnchorElement.prototype.removeAttribute.apply(this, arguments);
    }
  }
}
customElements.define("action-link", ActionLink, {
  extends: "a",
});
const template$7 = document.createElement("template");
template$7.innerHTML = `<dom-module id="action-link" assetpath="chrome://resources/" css-build="shadow">
  <template css-build="shadow">
    <style scope="action-link">[is='action-link'] {
    cursor: pointer;
        display: inline-block;
        text-decoration: none;
}
[is='action-link'], [is='action-link']:active, [is='action-link']:hover, [is='action-link']:visited {
    color: var(--cr-link-color);
}
[is='action-link'][disabled] {
    color: var(--paper-grey-600);
        cursor: default;
        opacity: 0.65;
        pointer-events: none;
}
[is='action-link'].no-outline {
    outline: none;
}
</style>
  </template>
</dom-module>
`;
document.body.appendChild(template$7.content.cloneNode(true));
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const template$8 = html`/* Most common used flex styles*/
  <dom-module id="iron-flex">
    <template>
      <style scope="iron-flex">
        .layout.horizontal,
        .layout.vertical {
          display: flex;
        }

        .layout.inline {
          display: inline-flex;
        }

        .layout.horizontal {
          flex-direction: row;
        }

        .layout.vertical {
          flex-direction: column;
        }

        .layout.wrap {
          flex-wrap: wrap;
        }

        .layout.no-wrap {
          flex-wrap: nowrap;
        }

        .layout.center,
        .layout.center-center {
          align-items: center;
        }

        .layout.center-justified,
        .layout.center-center {
          justify-content: center;
        }

        .flex {
          flex: 1;
          flex-basis: 0.000000001px;
        }

        .flex-auto {
          flex: 1 1 auto;
        }

        .flex-none {
          flex: none;
        }
      </style>
    </template>
  </dom-module>
  /* Basic flexbox reverse styles */
  <dom-module id="iron-flex-reverse">
    <template>
      <style scope="iron-flex-reverse">
        .layout.horizontal-reverse,
        .layout.vertical-reverse {
          display: flex;
        }

        .layout.horizontal-reverse {
          flex-direction: row-reverse;
        }

        .layout.vertical-reverse {
          flex-direction: column-reverse;
        }

        .layout.wrap-reverse {
          flex-wrap: wrap-reverse;
        }
      </style>
    </template>
  </dom-module>
  /* Flexbox alignment */
  <dom-module id="iron-flex-alignment">
    <template>
      <style scope="iron-flex-alignment">
        .layout.start {
          align-items: flex-start;
        }

        .layout.center,
        .layout.center-center {
          align-items: center;
        }

        .layout.end {
          align-items: flex-end;
        }

        .layout.baseline {
          align-items: baseline;
        }

        .layout.start-justified {
          justify-content: flex-start;
        }

        .layout.center-justified,
        .layout.center-center {
          justify-content: center;
        }

        .layout.end-justified {
          justify-content: flex-end;
        }

        .layout.around-justified {
          justify-content: space-around;
        }

        .layout.justified {
          justify-content: space-between;
        }

        .self-start {
          align-self: flex-start;
        }

        .self-center {
          align-self: center;
        }

        .self-end {
          align-self: flex-end;
        }

        .self-stretch {
          align-self: stretch;
        }

        .self-baseline {
          align-self: baseline;
        }

        .layout.start-aligned {
          align-content: flex-start;
        }

        .layout.end-aligned {
          align-content: flex-end;
        }

        .layout.center-aligned {
          align-content: center;
        }

        .layout.between-aligned {
          align-content: space-between;
        }

        .layout.around-aligned {
          align-content: space-around;
        }
      </style>
    </template>
  </dom-module>
  /* Non-flexbox positioning helper styles */
  <dom-module id="iron-flex-factors">
    <template>
      <style scope="iron-flex-factors">
        .flex,
        .flex-1 {
          flex: 1;
          flex-basis: 0.000000001px;
        }

        .flex-2 {
          flex: 2;
        }

        .flex-3 {
          flex: 3;
        }

        .flex-4 {
          flex: 4;
        }

        .flex-5 {
          flex: 5;
        }

        .flex-6 {
          flex: 6;
        }

        .flex-7 {
          flex: 7;
        }

        .flex-8 {
          flex: 8;
        }

        .flex-9 {
          flex: 9;
        }

        .flex-10 {
          flex: 10;
        }

        .flex-11 {
          flex: 11;
        }

        .flex-12 {
          flex: 12;
        }
      </style>
    </template>
  </dom-module>
  <dom-module id="iron-positioning">
    <template>
      <style scope="iron-positioning">
        .block {
          display: block;
        }

        [hidden] {
          display: none !important;
        }

        .invisible {
          visibility: hidden !important;
        }

        .relative {
          position: relative;
        }

        .fit {
          position: absolute;
          top: 0;
          right: 0;
          bottom: 0;
          left: 0;
        }

        body.fullbleed {
          margin: 0;
          height: 100vh;
        }

        .scroll {
          -webkit-overflow-scrolling: touch;
          overflow: auto;
        }

        .fixed-bottom,
        .fixed-left,
        .fixed-right,
        .fixed-top {
          position: fixed;
        }

        .fixed-top {
          top: 0;
          left: 0;
          right: 0;
        }

        .fixed-right {
          top: 0;
          right: 0;
          bottom: 0;
        }

        .fixed-bottom {
          right: 0;
          bottom: 0;
          left: 0;
        }

        .fixed-left {
          top: 0;
          bottom: 0;
          left: 0;
        }
      </style>
    </template>
  </dom-module> `;
template$8.setAttribute("style", "display: none;");
document.head.appendChild(template$8.content);
// Copyright 2017 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-toggle-row",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="extensions-toggle-row">
      :host {
        display: block;
        touch-action: none;
      }

      input {
        display: none;
      }

      label {
        align-items: center;
        box-sizing: border-box;
        cursor: pointer;
        display: flex;
        flex: 1;
        padding: var(--toggle-row-label-vertical-padding, 0) var(--toggle-row-label-horizontal-padding, 0);
        width: 100%;
      }

      cr-toggle {
        display: inline-block;
      }

      :host ::slotted(*) {
        flex: 1;
        margin-inline-end: 20px;
      }
    </style>
    <label id="label">
      <input id="native" type="checkbox" checked="[[checked]]" on-change="onNativeChange_" on-click="onNativeClick_" disabled="[[disabled]]" />
      <slot></slot>
      <cr-toggle id="crToggle" checked="{{checked}}" aria-labelledby="label" on-change="onCrToggleChange_" disabled="[[disabled]]"></cr-toggle>
    </label>
    <!--_html_template_end_-->`,
  properties: {
    checked: Boolean,
    disabled: Boolean,
  },
  getLabel() {
    return this.$.label;
  },
  onNativeClick_(e) {
    e.stopPropagation();
  },
  onNativeChange_(e) {
    e.stopPropagation();
    this.$.crToggle.checked = this.$.native.checked;
    this.checked = this.$.native.checked;
    this.fire("change", this.checked);
  },
  onCrToggleChange_(e) {
    e.stopPropagation();
    this.$.native.checked = e.detail;
    this.fire("change", this.checked);
  },
});
// Copyright 2019 The Chromium Authors. All rights reserved.
const $_documentContainer$2 = document.createElement("template");
$_documentContainer$2.innerHTML = `\x3c!--_html_template_start_--\x3e<custom-style>
<style css-build="shadow">html {
    --error-color: var(--google-red-700);
      --extensions-card-height: 160px;
      --separator-gap: 9px;
}
@media (prefers-color-scheme: dark) {
  html {
    --error-color: var(--google-red-refresh-300);
  }
}
</style>
</custom-style>
\x3c!--_html_template_end_--\x3e`;
document.head.appendChild($_documentContainer$2.content);
// Copyright 2019 The Chromium Authors. All rights reserved.
const template$9 = document.createElement("template");
template$9.innerHTML = `<dom-module id="shared-style">\x3c!--_html_template_start_--\x3e
<template>
<style include="cr-shared-style" scope="shared-style">
a[href] {
  color: var(--cr-link-color);
  text-decoration: none;
}
.activity-message {
  color: var(--md-loading-message-color);
  font-size: 123%;
  font-weight: 500;
  margin-top: 80px;
  text-align: center;
}
.activity-subpage-header {
    display: flex;
    justify-content: flex-end;
    padding: 12px 12px;
}
.activity-table-headings {
  align-items: center;
  display: flex;
  flex-direction: row;
  font-weight: 500;
  margin-inline-end: auto;

  min-height: calc(var(--cr-section-min-height) - var(--separator-gap));
  padding: 0 var(--cr-section-padding);
}
.clear-activities-button {
  margin: 0 8px;
}
.page-container {
  height: 100%;
  overflow: overlay;
}
.page-content {
  background-color: var(--cr-card-background-color);
  box-sizing: border-box;
  min-height: 100%;
  margin: 24px 60px 64px;
  border: 1px solid var(--maxthon-border);
  max-width: 990px;
}
.page-header {
  align-items: center;
  display: flex;
  height: 40px;
  margin-bottom: 12px;
  padding: 8px 12px 0;
}
.link-icon-button {
  align-items: center;
  display: flex;
  justify-content: center;
}
.separator {
  border-inline-start: var(--cr-separator-line);
  flex-shrink: 0;

  height: calc(var(--cr-section-min-height) - var(--separator-gap));
  margin-inline-end: var(--cr-section-padding);

  margin-inline-start: 0;
}
@media (prefers-color-scheme: dark) {
  ::-webkit-scrollbar {
    width: auto;
    height: auto;
  }
  ::-webkit-scrollbar-track {
    background-color: #2b2b2b;
  }
  ::-webkit-scrollbar-thumb {
    background-color: #4f4f4f;
  }
  ::-webkit-scrollbar-thumb:hover {
    background-color: #888;
  }
  ::-webkit-scrollbar-corner {
    background-color: #2b2b2b;
  }
  ::-webkit-scrollbar-button {
    background-size: cover;
  }
  ::-webkit-scrollbar-button:start:increment,
  ::-webkit-scrollbar-button:end:decrement {
    display: none;
  }
  ::-webkit-scrollbar-button:vertical:start:decrement {
    background-image: url('./resources/img/mx-scrollbar-up.png');
  }
  ::-webkit-scrollbar-button:vertical:start:decrement:hover {
    background-image: url('./resources/img/mx-scrollbar-up-hover.png');
  }
  ::-webkit-scrollbar-button:vertical:end:increment {
    background-image: url('./resources/img/mx-scrollbar-down.png');
  }
  ::-webkit-scrollbar-button:vertical:end:increment:hover {
    background-image: url('./resources/img/mx-scrollbar-down-hover.png');
  }
  ::-webkit-scrollbar-button:horizontal:start:decrement {
    background-image: url('./resources/img/mx-scrollbar-left.png');
  }
  ::-webkit-scrollbar-button:horizontal:start:decrement:hover {
    background-image: url('./resources/img/mx-scrollbar-left-hover.png');
  }
  ::-webkit-scrollbar-button:horizontal:end:increment {
    background-image: url('./resources/img/mx-scrollbar-right.png');
  }
  ::-webkit-scrollbar-button:horizontal:end:increment:hover {
    background-image: url('./resources/img/mx-scrollbar-right-hover.png');
  }
}
</style>
</template>
\x3c!--_html_template_end_--\x3e</dom-module>`;
document.body.appendChild(template$9.content.cloneNode(true));
// Copyright 2019 The Chromium Authors. All rights reserved.
const template$a = html`<!--_html_template_start_--><iron-iconset-svg name="extensions-icons" size="24">
    <svg>
      <defs>
        <!-- Custom SVG (bettes). -->
        <g id="unpacked">
          <path class="cls-1" fill="none" d="M0,0H24V24H0V0Z"></path>
          <circle cx="9" cy="12" r="1"></circle>
          <path d="M20,5H4A2,2,0,0,0,2,7V17a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V7A2,2,0,0,0,20,5ZM9,17a5,5,0,1,1,5-5A5,5,0,0,1,9,17Zm11,1a1,1,0,1,1,1-1A1,1,0,0,1,20,18ZM20,8a1,1,0,1,1,1-1A1,1,0,0,1,20,8Z"></path>
        </g>

        <!-- Copied from iron-icons. -->
        <g id="input"><path d="M21 3.01H3c-1.1 0-2 .9-2 2V9h2V4.99h18v14.03H3V15H1v4.01c0 1.1.9 1.98 2 1.98h18c1.1 0 2-.88 2-1.98v-14c0-1.11-.9-2-2-2zM11 16l4-4-4-4v3H1v2h10v3z"></path></g>
        <g id="business"><path d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z"></path></g>
      </defs>
    </svg>
  </iron-iconset-svg>
  <!--_html_template_end_-->`;
document.head.appendChild(template$a.content);
// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const parseHtmlSubset = (function() {
  const allowedAttributes = {
    href(node, value) {
      return node.tagName === "A" && (value.startsWith("chrome://") || value.startsWith("https://"));
    },
    target(node, value) {
      return node.tagName === "A" && value === "_blank";
    },
  };
  const allowedTags = ["A", "B", "SPAN", "STRONG"];
  let untrustedHTMLPolicy;
  if (window.trustedTypes) {
    untrustedHTMLPolicy = trustedTypes.createPolicy("parse-html-subset", {
      createHTML: (untrustedHTML) => {
        return untrustedHTML;
      },
    });
  }
  function merge(var_args) {
    const clone = {};
    for (let i = 0; i < arguments.length; ++i) {
      if (typeof arguments[i] === "object") {
        for (const key in arguments[i]) {
          if (arguments[i].hasOwnProperty(key)) {
            clone[key] = arguments[i][key];
          }
        }
      }
    }
    return clone;
  }
  function walk(n, f) {
    f(n);
    for (let i = 0; i < n.childNodes.length; i++) {
      walk(n.childNodes[i], f);
    }
  }
  function assertElement(tags, node) {
    if (tags.indexOf(node.tagName) === -1) {
      throw Error(node.tagName + " is not supported");
    }
  }
  function assertAttribute(attrs, attrNode, node) {
    const n = attrNode.nodeName;
    const v = attrNode.nodeValue;
    if (!attrs.hasOwnProperty(n) || !attrs[n](node, v)) {
      throw Error(node.tagName + "[" + n + '="' + v + '"] is not supported');
    }
  }
  return function(s, opt_extraTags, opt_extraAttrs) {
    const extraTags = (opt_extraTags || []).map(function(str) {
      return str.toUpperCase();
    });
    const tags = allowedTags.concat(extraTags);
    const attrs = merge(allowedAttributes, opt_extraAttrs || {});
    const doc = document.implementation.createHTMLDocument("");
    const r = doc.createRange();
    r.selectNode(doc.body);
    if (window.trustedTypes) {
      s = untrustedHTMLPolicy.createHTML(s);
    }
    const df = r.createContextualFragment(s);
    walk(df, function(node) {
      switch (node.nodeType) {
        case Node.ELEMENT_NODE:
          assertElement(tags, node);
          const nodeAttrs = node.attributes;
          for (let i = 0; i < nodeAttrs.length; ++i) {
            assertAttribute(attrs, nodeAttrs[i], node);
          }
          break;
        case Node.COMMENT_NODE:
        case Node.DOCUMENT_FRAGMENT_NODE:
        case Node.TEXT_NODE:
          break;
        default:
          throw Error("Node type " + node.nodeType + " is not supported");
      }
    });
    return df;
  };
})();
// Copyright 2015 The Chromium Authors. All rights reserved.
const I18nBehavior = {
  //
  i18nRaw_(id, var_args) {
    return arguments.length === 1 ? loadTimeData.getString(id) : loadTimeData.getStringF.apply(loadTimeData, arguments);
  },
  i18n(id, var_args) {
    const rawString = this.i18nRaw_.apply(this, arguments);
    return parseHtmlSubset("<b>" + rawString + "</b>").firstChild.textContent;
  },
  i18nAdvanced(id, opts) {
    opts = opts || {};
    const args = [id].concat(opts.substitutions || []);
    const rawString = this.i18nRaw_.apply(this, args);
    return loadTimeData.sanitizeInnerHtml(rawString, opts);
  },
  i18nDynamic(locale, id, var_args) {
    return this.i18n.apply(this, Array.prototype.slice.call(arguments, 1));
  },
  i18nRecursive(locale, id, var_args) {
    let args = Array.prototype.slice.call(arguments, 2);
    if (args.length > 0) {
      const self = this;
      args = args.map(function(str) {
        return self.i18nExists(str) ? loadTimeData.getString(str) : str;
      });
    }
    return this.i18nDynamic.apply(this, [locale, id].concat(args));
  },
  i18nExists(id) {
    return loadTimeData.valueExists(id);
  },
};
// Copyright 2017 The Chromium Authors. All rights reserved.
const ItemBehavior = {
  appOrExtension(type, appLabel, extensionLabel) {
    const ExtensionType = chrome.developerPrivate.ExtensionType;
    switch (type) {
      case ExtensionType.HOSTED_APP:
      case ExtensionType.LEGACY_PACKAGED_APP:
      case ExtensionType.PLATFORM_APP:
        return appLabel;
      case ExtensionType.EXTENSION:
      case ExtensionType.SHARED_MODULE:
        return extensionLabel;
    }
    assertNotReached("Item type is not App or Extension.");
  },
};
// Copyright 2017 The Chromium Authors. All rights reserved.
const SourceType = {
  WEBSTORE: "webstore",
  POLICY: "policy",
  SIDELOADED: "sideloaded",
  UNPACKED: "unpacked",
  UNKNOWN: "unknown",
};
const EnableControl = {
  RELOAD: "RELOAD",
  REPAIR: "REPAIR",
  ENABLE_TOGGLE: "ENABLE_TOGGLE",
};
function isEnabled(state) {
    switch (state) {
      case chrome.developerPrivate.ExtensionState.ENABLED:
      case chrome.developerPrivate.ExtensionState.TERMINATED:
          return true;
      case chrome.developerPrivate.ExtensionState.BLACKLISTED:
      case chrome.developerPrivate.ExtensionState.BLOCKLISTED:
      case chrome.developerPrivate.ExtensionState.DISABLED:
          return false;
      default:
        assertNotReached()
    }
}
function userCanChangeEnablement(item) {
  if (!item.userMayModify) {
    return false;
  }
  if (item.disableReasons.corruptInstall || item.disableReasons.suspiciousInstall || item.disableReasons.updateRequired || item.disableReasons.blockedByPolicy) {
    return false;
  }
  if (item.dependentExtensions.length > 0) {
    return false;
  }
  if (item.state === chrome.developerPrivate.ExtensionState.BLACKLISTED) {
    return false;
  }
  return true;
}
function getItemSource(item) {
  if (item.controlledInfo && item.controlledInfo.type === chrome.developerPrivate.ControllerType.POLICY) {
    return SourceType.POLICY;
  }
  switch (item.location) {
    case chrome.developerPrivate.Location.THIRD_PARTY:
      return SourceType.SIDELOADED;
    case chrome.developerPrivate.Location.UNPACKED:
      return SourceType.UNPACKED;
    case chrome.developerPrivate.Location.UNKNOWN:
      return SourceType.UNKNOWN;
    case chrome.developerPrivate.Location.FROM_STORE:
      return SourceType.WEBSTORE;
  }
  assertNotReached(item.location);
}
function getItemSourceString(source) {
  switch (source) {
    case SourceType.POLICY:
      return loadTimeData.getString("itemSourcePolicy");
    case SourceType.SIDELOADED:
      return loadTimeData.getString("itemSourceSideloaded");
    case SourceType.UNPACKED:
      return loadTimeData.getString("itemSourceUnpacked");
    case SourceType.WEBSTORE:
      return loadTimeData.getString("itemSourceWebstore");
    case SourceType.UNKNOWN:
      return "";
  }
  assertNotReached();
}
function computeInspectableViewLabel(view) {
  const url = new URL(view.url);
  let label = view.url;
  if (url.protocol === "chrome-extension:") {
    label = url.pathname.substring(1);
  }
  if (label === "_generated_background_page.html") {
    label = loadTimeData.getString("viewBackgroundPage");
  }
  if (view.incognito) {
    label += " " + loadTimeData.getString("viewIncognito");
  }
  if (view.renderProcessId === -1) {
    label += " " + loadTimeData.getString("viewInactive");
  }
  if (view.isIframe) {
    label += " " + loadTimeData.getString("viewIframe");
  }
  return label;
}
function isTerminated_(state) {
  return state === chrome.developerPrivate.ExtensionState.TERMINATED;
}
function getEnableControl(data) {
  if (isTerminated_(data.state)) {
    return EnableControl.RELOAD;
  }
  if (data.disableReasons.corruptInstall) {
    return EnableControl.REPAIR;
  }
  return EnableControl.ENABLE_TOGGLE;
}
// Copyright 2017 The Chromium Authors. All rights reserved.
const Page = {
  LIST: "items-list",
  DETAILS: "details-view",
  ACTIVITY_LOG: "activity-log",
  SHORTCUTS: "keyboard-shortcuts",
  IMPORT_EXPORT: "import-export",
  ERRORS: "error-page",
};
const Dialog = {
  OPTIONS: "options",
};
function isPageStateEqual(a, b) {
  return a.page === b.page && a.subpage === b.subpage && a.extensionId === b.extensionId;
}
const CANONICAL_PATH_REGEX = /(^\/)([\/-\w]+)(\/$)/;
class NavigationHelper {
  constructor() {
    this.processRoute_();
    this.nextListenerId_ = 1;
    this.listeners_ = new Map();
    this.previousPage_;
    window.addEventListener("popstate", () => {
      this.notifyRouteChanged_(this.getCurrentPage());
    });
  }
  get currentPath_() {
    return location.pathname.replace(CANONICAL_PATH_REGEX, "$1$2");
  }
  processRoute_() {
    if (this.currentPath_ === "/configureCommands" || this.currentPath_ === "/shortcuts") {
      window.history.replaceState(undefined, "", "/shortcuts");
    } else if (this.currentPath_ !== "/") {
      window.history.replaceState(undefined, "", "/");
    }
  }
  getCurrentPage() {
    const search = new URLSearchParams(location.search);
    let id = search.get("id");
    if (id) {
      return {
        page: Page.DETAILS,
        extensionId: id,
      };
    }
    id = search.get("activity");
    if (id) {
      return {
        page: Page.ACTIVITY_LOG,
        extensionId: id,
      };
    }
    id = search.get("options");
    if (id) {
      return {
        page: Page.DETAILS,
        extensionId: id,
        subpage: Dialog.OPTIONS,
      };
    }
    id = search.get("errors");
    if (id) {
      return {
        page: Page.ERRORS,
        extensionId: id,
      };
    }
    if (this.currentPath_ === "/shortcuts") {
      return {
        page: Page.SHORTCUTS,
      };
    }
    if (this.currentPath_ === "/import-export") {
      return {
        page: Page.IMPORT_EXPORT,
      };
    }
    return {
      page: Page.LIST,
    };
  }
  addListener(listener) {
    const nextListenerId = this.nextListenerId_++;
    this.listeners_.set(nextListenerId, listener);
    return nextListenerId;
  }
  removeListener(id) {
    return this.listeners_.delete(id);
  }
  notifyRouteChanged_(newPage) {
    this.listeners_.forEach((listener, id) => {
      listener(newPage);
    });
  }
  navigateTo(newPage) {
    const currentPage = this.getCurrentPage();
    if (currentPage && isPageStateEqual(currentPage, newPage)) {
      return;
    }
    this.updateHistory(newPage, false);
    this.notifyRouteChanged_(newPage);
  }
  replaceWith(newPage) {
    this.updateHistory(newPage, true);
    if (this.previousPage_ && isPageStateEqual(this.previousPage_, newPage)) {
      history.back();
      return;
    }
    this.notifyRouteChanged_(newPage);
  }
  updateHistory(entry, replaceState) {
    let path;
    switch (entry.page) {
      case Page.LIST:
        path = "/";
        break;
      case Page.ACTIVITY_LOG:
        path = "/?activity=" + entry.extensionId;
        break;
      case Page.DETAILS:
        if (entry.subpage) {
          assert(entry.subpage === Dialog.OPTIONS);
          path = "/?options=" + entry.extensionId;
        } else {
          path = "/?id=" + entry.extensionId;
        }
        break;
      case Page.SHORTCUTS:
        path = "/shortcuts";
        break;
      case Page.IMPORT_EXPORT:
        path = "/import-export";
        break;
      case Page.ERRORS:
        path = "/?errors=" + entry.extensionId;
        break;
    }
    assert(path);
    const state = {
      url: path,
    };
    const currentPage = this.getCurrentPage();
    const isDialogNavigation = currentPage.page === entry.page && currentPage.extensionId === entry.extensionId;
    if (replaceState || isDialogNavigation) {
      history.replaceState(state, "", path);
    } else {
      this.previousPage_ = currentPage;
      history.pushState(state, "", path);
    }
  }
}
const navigation = new NavigationHelper();
// Copyright 2015 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-item",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style
      include="iron-flex cr-shared-style cr-hidden-style cr-icons action-link
    shared-style"
      scope="extensions-item"
    >
      .bounded-text,
      .multiline-clippable-text,
      .clippable-flex-text {
        overflow: hidden;
        text-overflow: ellipsis;
      }

      .bounded-text,
      .clippable-flex-text {
        white-space: nowrap;
      }

      .clippable-flex-text {
        flex-shrink: 1;
      }

      cr-tooltip-icon {
        margin-inline-end: 8px;
      }

      #icon-wrapper {
        align-self: flex-start;
        display: flex;
        padding: 6px;
        position: relative;
      }

      #icon {
        height: 36px;
        width: 36px;
      }

      #card {
        background-color: var(--cr-card-background-color);
        display: flex;
        flex-direction: column;
        height: var(--extensions-card-height);
        transition: height 300ms cubic-bezier(0.25, 0.1, 0.25, 1);
        border: 1px solid var(--maxthon-border);
        border-bottom: none;
      }

      #card:last-of-type {
        border-bottom: 1px solid var(--maxthon-border);
      }

      #card.dev-mode {
        height: 208px;
      }

      #main {
        display: flex;
        flex: 1;
        min-height: 0;
        padding: 16px 20px;
      }

      #content {
        display: flex;
        flex: 1;
        flex-direction: column;
        margin-inline-start: 24px;
        overflow: hidden;
      }

      #name-and-version {
        color: var(--cr-primary-text-color);
        margin-bottom: 4px;
      }

      #name {
        margin-inline-end: 8px;
      }

      #description {
        flex: 1;
      }

      #warnings {
        color: var(--error-color);
        flex: 1;
        margin-bottom: 8px;
      }

      #error-icon {
        --iron-icon-fill-color: var(--error-color);
        height: 18px;
        margin-inline-end: 4px;
        width: 18px;
      }

      #extension-id {
        flex-shrink: 0;
      }

      #inspect-views {
        display: flex;
        white-space: nowrap;
      }

      #inspect-views > span {
        margin-inline-end: 4px;
      }

      #button-strip {
        box-sizing: border-box;
        flex-shrink: 0;
        height: var(--cr-section-min-height);
        padding-bottom: 8px;
        padding-inline-end: 20px;
        padding-top: 8px;
      }

      #button-strip cr-button {
        margin-inline-start: 8px;
      }

      #source-indicator {
        margin-inline-start: 24px;
        margin-top: 24px;
        position: absolute;
      }

      .source-icon-wrapper {
        align-items: center;
        background: rgb(241, 89, 43);
        border-radius: 50%;
        box-shadow: 0 1px 1px 0 rgba(0, 0, 0, 0.22), 0 2px 2px 0 rgba(0, 0, 0, 0.12);
        display: flex;
        height: 22px;
        justify-content: center;
        width: 22px;
      }

      #source-indicator iron-icon {
        color: white;
        height: 16px;
        width: 16px;
      }

      paper-tooltip {
        --paper-tooltip-min-width: 0;
      }

      #errors-button {
        color: var(--error-color);
      }

      #dev-reload-button {
        margin-inline-end: 12px;
      }

      #blacklisted-warning:empty {
        display: none;
      }

      #a11yAssociation {
        height: 0;
        overflow: hidden;
      }
    </style>
    <!-- Invisible instead of hidden because VoiceOver refuses to read text of
  element that's hidden when referenced by an aria label.  Unfortunately,
  this text can be found by Ctrl + F because it isn't hidden. -->
    <div id="a11yAssociation" aria-hidden="true">[[a11yAssociation_(data.name)]]</div>
    <div id="card" class$="[[computeClasses_(data.state, inDevMode)]]">
      <div id="main">
        <div id="icon-wrapper">
          <img
            id="icon"
            src="[[data.iconUrl]]"
            aria-describedby="a11yAssociation"
            alt$="[[appOrExtension(
              data.type,
              '___appIcon___',
              '___extensionIcon___')]]"
          />
          <template is="dom-if" if="[[computeSourceIndicatorIcon_(data.*)]]">
            <div id="source-indicator">
              <div class="source-icon-wrapper" role="img" aria-describedby="a11yAssociation" aria-label$="[[computeSourceIndicatorText_(data.*)]]">
                <iron-icon icon="[[computeSourceIndicatorIcon_(data.*)]]"> </iron-icon>
              </div>
            </div>
          </template>
        </div>
        <!-- This needs to be separate from the source-indicator since it can't
         be contained inside of a position:relative parent element. -->
        <template is="dom-if" if="[[computeSourceIndicatorIcon_(data.*)]]">
          <paper-tooltip id="source-indicator-text" for="source-indicator" position="top" fit-to-visible-bounds="" aria-hidden="true"> [[computeSourceIndicatorText_(data.*)]] </paper-tooltip>
        </template>
        <div id="content">
          <!--Note: We wrap inspect-views in a div so that the outer div
          doesn't shrink (because it's not display: flex).-->
          <div>
            <div id="name-and-version" class="layout horizontal center">
              <div id="name" role="heading" aria-level="3" class="clippable-flex-text">[[data.name]]</div>
              <span id="version" class="cr-secondary-text" hidden$="[[!inDevMode]]"> [[data.version]] </span>
            </div>
          </div>
          <div id="description" class="cr-secondary-text multiline-clippable-text" hidden$="[[hasWarnings_(data.disableReasons.*, data.*)]]">[[data.description]]</div>
          <template is="dom-if" if="[[hasWarnings_(data.disableReasons.*, data.*)]]">
            <div id="warnings">
              <iron-icon id="error-icon" icon="cr:error"></iron-icon>
              <span id="runtime-warnings" aria-describedby="a11yAssociation" hidden$="[[!data.runtimeWarnings.length]]">
                <template is="dom-repeat" items="[[data.runtimeWarnings]]"> [[item]] </template>
              </span>
              <span id="suspicious-warning" aria-describedby="a11yAssociation" hidden$="[[!data.disableReasons.suspiciousInstall]]">
                ___itemSuspiciousInstall___
                <a target="_blank" href="___suspiciousInstallHelpUrl___"> ___learnMore___ </a>
              </span>
              <span id="corrupted-warning" aria-describedby="a11yAssociation" hidden$="[[!data.disableReasons.corruptInstall]]"> ___itemCorruptInstall___ </span>
              <span id="blacklisted-warning"
                ><!-- No whitespace
            -->[[data.blacklistText]]<!-- so we can use :empty in css.
         --></span
              >
            </div>
          </template>
          <template is="dom-if" if="[[inDevMode]]">
            <div id="extension-id" class="bounded-text cr-secondary-text">[[data.id]]</div>
            <template is="dom-if" if="[[!computeInspectViewsHidden_(data.views)]]">
              <!--Note: We wrap inspect-views in a div so that the outer div
              doesn't shrink (because it's not display: flex).-->
              <div>
                <div id="inspect-views" class="cr-secondary-text">
                  <span aria-describedby="a11yAssociation"> ___itemInspectViews___ </span>
                  <a class="clippable-flex-text" is="action-link" title="[[computeFirstInspectTitle_(data.views)]]" on-click="onInspectTap_"> [[computeFirstInspectLabel_(data.views)]] </a>
                  <a is="action-link" hidden$="[[computeExtraViewsHidden_(data.views)]]" on-click="onExtraInspectTap_"> [[computeExtraInspectLabel_(data.views)]] </a>
                </div>
              </div>
            </template>
          </template>
        </div>
      </div>
      <div id="button-strip" class="layout horizontal center cr-secondary-text">
        <div class="layout flex horizontal center">
          <cr-button id="detailsButton" on-click="onDetailsTap_" aria-describedby="a11yAssociation"> ___itemDetails___ </cr-button>
          <cr-button id="remove-button" on-click="onRemoveTap_" aria-describedby="a11yAssociation" hidden="[[data.mustRemainInstalled]]"> ___remove___ </cr-button>
          <template is="dom-if" if="[[shouldShowErrorsButton_(data.*)]]">
            <cr-button id="errors-button" on-click="onErrorsTap_" aria-describedby="a11yAssociation"> ___itemErrors___ </cr-button>
          </template>
        </div>
        <template is="dom-if" if="[[!computeDevReloadButtonHidden_(data.*)]]">
          <cr-icon-button id="dev-reload-button" class="icon-refresh no-overlap" aria-label="___itemReload___" aria-describedby="a11yAssociation" on-click="onReloadTap_"></cr-icon-button>
        </template>
        <template is="dom-if" if="[[showRepairButton_(data.disableReasons.corruptInstall)]]">
          <cr-button id="repair-button" class="action-button" aria-describedby="a11yAssociation" on-click="onRepairTap_"> ___itemRepair___ </cr-button>
        </template>
        <template is="dom-if" if="[[showReloadButton_(data.state)]]">
          <cr-button id="terminated-reload-button" on-click="onReloadTap_" aria-describedby="a11yAssociation" class="action-button"> ___itemReload___ </cr-button>
        </template>
        <cr-tooltip-icon id="parentDisabledPermissionsToolTip" hidden$="[[!data.disableReasons.parentDisabledPermissions]]" tooltip-text="___parentDisabledPermissions___" icon-class="cr20:kite" icon-aria-label="___parentDisabledPermissions___"> </cr-tooltip-icon>
        <cr-toggle
          id="enableToggle"
          aria-label$="[[appOrExtension(
            data.type,
            '___appEnabled___',
            '___extensionEnabled___')]]"
          aria-describedby="a11yAssociation"
          checked="[[isEnabled_(data.state)]]"
          on-change="onEnableToggleChange_"
          disabled$="[[!isEnableToggleEnabled_(data.*)]]"
          hidden$="[[!showEnableToggle_(data.*)]]"
        >
        </cr-toggle>
      </div>
    </div>
    <!--_html_template_end_-->`,
  behaviors: [I18nBehavior, ItemBehavior],
  properties: {
    delegate: {
      type: Object,
    },
    inDevMode: {
      type: Boolean,
      value: false,
    },
    data: {
      type: Object,
    },
    showingDetails_: {
      type: Boolean,
      value: false,
    },
  },
  isReloading_: false,
  observers: ["observeIdVisibility_(inDevMode, showingDetails_, data.id)"],
  getDetailsButton() {
    return this.$.detailsButton;
  },
  getErrorsButton() {
    return this.$$("#errors-button");
  },
  a11yAssociation_() {
    return loadTimeData.getStringF("extensionA11yAssociation", this.data.name);
  },
  observeIdVisibility_(inDevMode, showingDetails, id) {
    flush();
    const idElement = this.$$("#extension-id");
    if (idElement) {
      assert(this.data);
      idElement.innerHTML = this.i18n("itemId", this.data.id);
    }
  },
  shouldShowErrorsButton_() {
    if (this.data.installWarnings && this.data.installWarnings.length > 0) {
      return true;
    }
    return this.data.manifestErrors.length > 0 || this.data.runtimeErrors.length > 0;
  },
  onRemoveTap_() {
    this.delegate.deleteItem(this.data.id);
  },
  onEnableToggleChange_() {
    this.delegate.setItemEnabled(this.data.id, this.$.enableToggle.checked);
    this.$.enableToggle.checked = this.isEnabled_();
  },
  onErrorsTap_() {
    if (this.data.installWarnings && this.data.installWarnings.length > 0) {
      this.fire("show-install-warnings", this.data.installWarnings);
      return;
    }
    navigation.navigateTo({
      page: Page.ERRORS,
      extensionId: this.data.id,
    });
  },
  onDetailsTap_() {
    navigation.navigateTo({
      page: Page.DETAILS,
      extensionId: this.data.id,
    });
  },
  onInspectTap_(e) {
    this.delegate.inspectItemView(this.data.id, this.data.views[0]);
  },
  onExtraInspectTap_() {
    navigation.navigateTo({
      page: Page.DETAILS,
      extensionId: this.data.id,
    });
  },
  onReloadTap_() {
    if (this.isReloading_) {
      return;
    }
    this.isReloading_ = true;
    const toastManager = getToastManager();
    toastManager.duration = 0;
    toastManager.show(this.i18n("itemReloading"));
    this.delegate.reloadItem(this.data.id).then(
      () => {
        toastManager.hide();
        toastManager.duration = 3e3;
        toastManager.show(this.i18n("itemReloaded"));
        this.isReloading_ = false;
      },
      (loadError) => {
        this.fire("load-error", loadError);
        toastManager.hide();
        this.isReloading_ = false;
      }
    );
  },
  onRepairTap_() {
    this.delegate.repairItem(this.data.id);
  },
  isEnabled_() {
    return isEnabled(this.data.state);
  },
  isEnableToggleEnabled_() {
    return userCanChangeEnablement(this.data);
  },
  showReloadButton_() {
    return getEnableControl(this.data) === EnableControl.RELOAD;
  },
  showRepairButton_() {
    return getEnableControl(this.data) === EnableControl.REPAIR;
  },
  showEnableToggle_() {
    return getEnableControl(this.data) === EnableControl.ENABLE_TOGGLE;
  },
  computeClasses_() {
    let classes = this.isEnabled_() ? "enabled" : "disabled";
    if (this.inDevMode) {
      classes += " dev-mode";
    }
    return classes;
  },
  computeSourceIndicatorIcon_() {
    switch (getItemSource(this.data)) {
      case SourceType.POLICY:
        return "extensions-icons:business";
      case SourceType.SIDELOADED:
        return "extensions-icons:input";
      case SourceType.UNKNOWN:
        return "extensions-icons:input";
      case SourceType.UNPACKED:
        return "extensions-icons:unpacked";
      case SourceType.WEBSTORE:
        return "";
    }
    assertNotReached();
  },
  computeSourceIndicatorText_() {
    if (this.data.locationText) {
      return this.data.locationText;
    }
    const sourceType = getItemSource(this.data);
    return sourceType === SourceType.WEBSTORE ? "" : getItemSourceString(sourceType);
  },
  computeInspectViewsHidden_() {
    return !this.data.views || this.data.views.length === 0;
  },
  computeFirstInspectTitle_() {
    return this.data.views.length > 0 ? computeInspectableViewLabel(this.data.views[0]) : "";
  },
  computeFirstInspectLabel_() {
    const label = this.computeFirstInspectTitle_();
    return label && this.data.views.length > 1 ? label + "," : label;
  },
  computeExtraViewsHidden_() {
    return this.data.views.length <= 1;
  },
  computeDevReloadButtonHidden_() {
    const showIcon = this.data.location === chrome.developerPrivate.Location.UNPACKED && this.data.state === chrome.developerPrivate.ExtensionState.ENABLED;
    return !showIcon;
  },
  computeExtraInspectLabel_() {
    return this.i18n("itemInspectViewsExtra", (this.data.views.length - 1).toString());
  },
  hasWarnings_() {
    return this.data.disableReasons.corruptInstall || this.data.disableReasons.suspiciousInstall || this.data.runtimeWarnings.length > 0 || !!this.data.blacklistText;
  },
  computeWarningsClasses_() {
    return this.data.blacklistText ? "severe" : "mild";
  },
});
// Copyright 2018 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-host-permissions-toggle-list",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style shared-style" scope="extensions-host-permissions-toggle-list">
      iron-icon {
        --iron-icon-height: var(--cr-icon-size);
        --iron-icon-width: var(--cr-icon-size);
      }

      #section-heading {
        align-items: center;
        color: var(--cr-primary-text-color);
        display: flex;
        justify-content: space-between;
        margin-top: 12px;
      }

      .toggle-section {
        display: flex;
        flex-direction: column;
        justify-content: center;
        min-height: var(--cr-section-min-height);
      }

      .site-toggle {
        border-top: var(--cr-separator-line);
        margin-inline-start: var(--cr-section-indent-width);
      }
    </style>
    <div id="section-heading">
      <span>___hostPermissionsDescription___</span>
      <a id="link-icon-button" aria-label="___learnMore___" href="https://support.google.com/chrome?p=enable_extensions" target="_blank">
        <iron-icon icon="cr:help-outline"></iron-icon>
      </a>
    </div>
    <div class="toggle-section">
      <extensions-toggle-row checked="[[allowedOnAllHosts_(permissions.*)]]" id="allHostsToggle" on-change="onAllHostsToggleChanged_">
        <span>___itemAllowOnFollowingSites___</span>
      </extensions-toggle-row>
    </div>
    <template is="dom-repeat" items="[[getSortedHosts_(permissions.*)]]">
      <div class="toggle-section site-toggle">
        <extensions-toggle-row checked="[[item.granted]]" class="host-toggle no-end-padding" disabled="[[allowedOnAllHosts_(permissions.*)]]" host="[[item.host]]" on-change="onHostAccessChanged_">
          <span>[[item.host]]</span>
        </extensions-toggle-row>
      </div>
    </template>
    <!--_html_template_end_-->`,
  properties: {
    permissions: Object,
    itemId: String,
    delegate: Object,
  },
  allowedOnAllHosts_() {
    return this.permissions.hostAccess === chrome.developerPrivate.HostAccess.ON_ALL_SITES;
  },
  getSortedHosts_() {
    return this.permissions.hosts.sort((a, b) => {
      if (a.host < b.host) {
        return -1;
      }
      if (a.host > b.host) {
        return 1;
      }
      return 0;
    });
  },
  onAllHostsToggleChanged_() {
    this.delegate.setItemHostAccess(this.itemId, this.$.allHostsToggle.checked ? chrome.developerPrivate.HostAccess.ON_ALL_SITES : chrome.developerPrivate.HostAccess.ON_SPECIFIC_SITES);
  },
  onHostAccessChanged_(e) {
    const host = e.target.host;
    const checked = e.target.checked;
    if (checked) {
      this.delegate.addRuntimeHostPermission(this.itemId, host);
    } else {
      this.delegate.removeRuntimeHostPermission(this.itemId, host);
    }
  },
});
// Copyright 2014 The Chromium Authors. All rights reserved.
class FocusRow {
  constructor(root, boundary, delegate) {
    this.root = root;
    this.boundary_ = boundary || document.documentElement;
    this.delegate = delegate;
    this.eventTracker = new EventTracker();
  }
  static isFocusable(element) {
    if (!element || element.disabled) {
      return false;
    }
    let current = element;
    while (true) {
      assertInstanceof(current, Element);
      const style = window.getComputedStyle(current);
      if (style.visibility === "hidden" || style.display === "none") {
        return false;
      }
      const parent = current.parentNode;
      if (!parent) {
        return false;
      }
      if (parent === current.ownerDocument || parent instanceof DocumentFragment) {
        return true;
      }
      current = parent;
    }
  }
  static getFocusableElement(element) {
    if (element.getFocusableElement) {
      return element.getFocusableElement();
    }
    return element;
  }
  addItem(type, selectorOrElement) {
    assert(type);
    let element;
    if (typeof selectorOrElement === "string") {
      element = this.root.querySelector(selectorOrElement);
    } else {
      element = selectorOrElement;
    }
    if (!element) {
      return false;
    }
    element.setAttribute("focus-type", type);
    element.tabIndex = this.isActive() ? 0 : -1;
    this.eventTracker.add(element, "blur", this.onBlur_.bind(this));
    this.eventTracker.add(element, "focus", this.onFocus_.bind(this));
    this.eventTracker.add(element, "keydown", this.onKeydown_.bind(this));
    this.eventTracker.add(element, "mousedown", this.onMousedown_.bind(this));
    return true;
  }
  destroy() {
    this.eventTracker.removeAll();
  }
  getCustomEquivalent(sampleElement) {
    return assert(this.getFirstFocusable());
  }
  getElements() {
    return Array.from(this.root.querySelectorAll("[focus-type]")).map(FocusRow.getFocusableElement);
  }
  getEquivalentElement(sampleElement) {
    if (this.getFocusableElements().indexOf(sampleElement) >= 0) {
      return sampleElement;
    }
    const sampleFocusType = this.getTypeForElement(sampleElement);
    if (sampleFocusType) {
      const sameType = this.getFirstFocusable(sampleFocusType);
      if (sameType) {
        return sameType;
      }
    }
    return this.getCustomEquivalent(sampleElement);
  }
  getFirstFocusable(opt_type) {
    const element = this.getFocusableElements().find((el) => !opt_type || el.getAttribute("focus-type") === opt_type);
    return element || null;
  }
  getFocusableElements() {
    return this.getElements().filter(FocusRow.isFocusable);
  }
  getTypeForElement(element) {
    return element.getAttribute("focus-type") || "";
  }
  isActive() {
    return this.root.classList.contains(FocusRow.ACTIVE_CLASS);
  }
  makeActive(active) {
    if (active === this.isActive()) {
      return;
    }
    this.getElements().forEach(function(element) {
      element.tabIndex = active ? 0 : -1;
    });
    this.root.classList.toggle(FocusRow.ACTIVE_CLASS, active);
  }
  onBlur_(e) {
    if (!this.boundary_.contains(e.relatedTarget)) {
      return;
    }
    const currentTarget = e.currentTarget;
    if (this.getFocusableElements().indexOf(currentTarget) >= 0) {
      this.makeActive(false);
    }
  }
  onFocus_(e) {
    if (this.delegate) {
      this.delegate.onFocus(this, e);
    }
  }
  onMousedown_(e) {
    if (e.button) {
      return;
    }
    if (!e.currentTarget.disabled) {
      e.currentTarget.tabIndex = 0;
    }
  }
  onKeydown_(e) {
    const elements = this.getFocusableElements();
    const currentElement = FocusRow.getFocusableElement(e.currentTarget);
    const elementIndex = elements.indexOf(currentElement);
    assert(elementIndex >= 0);
    if (this.delegate && this.delegate.onKeydown(this, e)) {
      return;
    }
    const isShiftTab = !e.altKey && !e.ctrlKey && !e.metaKey && e.shiftKey && e.key === "Tab";
    if (hasKeyModifiers(e) && !isShiftTab) {
      return;
    }
    let index = -1;
    let shouldStopPropagation = true;
    if (isShiftTab) {
      index = elementIndex - 1;
      if (index < 0) {
        return;
      }
    } else if (e.key === "ArrowLeft") {
      index = elementIndex + (isRTL() ? 1 : -1);
    } else if (e.key === "ArrowRight") {
      index = elementIndex + (isRTL() ? -1 : 1);
    } else if (e.key === "Home") {
      index = 0;
    } else if (e.key === "End") {
      index = elements.length - 1;
    } else {
      shouldStopPropagation = false;
    }
    const elementToFocus = elements[index];
    if (elementToFocus) {
      this.getEquivalentElement(elementToFocus).focus();
      e.preventDefault();
    }
    if (shouldStopPropagation) {
      e.stopPropagation();
    }
  }
}
FocusRow.ACTIVE_CLASS = "focus-row-active";
// Copyright 2017 The Chromium Authors. All rights reserved.
let hideInk = false;
assert(!isIOS, "pointerdown doesn't work on iOS");
document.addEventListener(
  "pointerdown",
  function() {
    hideInk = true;
  },
  true
);
document.addEventListener(
  "keydown",
  function() {
    hideInk = false;
  },
  true
);
const focusWithoutInk = function(toFocus) {
  if (!("noink" in toFocus) || !hideInk) {
    toFocus.focus();
    return;
  }
  assert(document === toFocus.ownerDocument);
  const { noink: noink } = toFocus;
  toFocus.noink = true;
  toFocus.focus();
  toFocus.noink = noink;
};
// Copyright 2016 The Chromium Authors. All rights reserved.
const AnchorAlignment = {
  BEFORE_START: -2,
  AFTER_START: -1,
  CENTER: 0,
  BEFORE_END: 1,
  AFTER_END: 2,
};
const DROPDOWN_ITEM_CLASS = "dropdown-item";
const AFTER_END_OFFSET = 10;
function getStartPointWithAnchor(start, end, menuLength, anchorAlignment, min, max) {
  let startPoint = 0;
  switch (anchorAlignment) {
    case AnchorAlignment.BEFORE_START:
      startPoint = -menuLength;
      break;
    case AnchorAlignment.AFTER_START:
      startPoint = start;
      break;
    case AnchorAlignment.CENTER:
      startPoint = (start + end - menuLength) / 2;
      break;
    case AnchorAlignment.BEFORE_END:
      startPoint = end - menuLength;
      break;
    case AnchorAlignment.AFTER_END:
      startPoint = end;
      break;
  }
  if (startPoint + menuLength > max) {
    startPoint = end - menuLength;
  }
  if (startPoint < min) {
    startPoint = start;
  }
  startPoint = Math.max(min, Math.min(startPoint, max - menuLength));
  return startPoint;
}
function getDefaultShowConfig() {
  return {
    top: 0,
    left: 0,
    height: 0,
    width: 0,
    anchorAlignmentX: AnchorAlignment.AFTER_START,
    anchorAlignmentY: AnchorAlignment.AFTER_START,
    minX: 0,
    minY: 0,
    maxX: 0,
    maxY: 0,
  };
}
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="cr-action-menu">
      :host dialog {
        background-color: var(--cr-menu-background-color);
        border: none;
        border-radius: 4px;
        box-shadow: var(--cr-menu-shadow);
        margin: 0;
        min-width: 128px;
        outline: none;
        padding: 0;
      }

      :host dialog::backdrop {
        background-color: transparent;
      }

      :host ::slotted(.dropdown-item) {
        -webkit-tap-highlight-color: transparent;
        background: none;
        border: none;
        border-radius: 0;
        box-sizing: border-box;
        color: var(--cr-primary-text-color);
        font: inherit;
        min-height: 32px;
        padding: 0 24px;
        text-align: start;
        user-select: none;
        width: 100%;
      }

      :host ::slotted(.dropdown-item:not([hidden])) {
        align-items: center;
        display: flex;
      }

      :host ::slotted(.dropdown-item[disabled]) {
        opacity: var(--cr-action-menu-disabled-item-opacity, 0.65);
      }

      :host ::slotted(.dropdown-item:not([disabled])) {
        cursor: pointer;
      }

      :host ::slotted(.dropdown-item:focus) {
        background-color: var(--cr-menu-background-focus-color);
        outline: none;
      }

      .item-wrapper {
        background: var(--cr-menu-background-sheen);
        outline: none;
        padding: 8px 0;
      }
    </style>
    <dialog id="dialog" on-close="onNativeDialogClose_" role="application" aria-roledescription$="[[roleDescription]]">
      <div id="wrapper" class="item-wrapper" role="menu" tabindex="-1">
        <slot id="contentNode"></slot>
      </div>
    </dialog>
    <!--_html_template_end_-->`,
  is: "cr-action-menu",
  anchorElement_: null,
  boundClose_: null,
  hasMousemoveListener_: false,
  contentObserver_: null,
  resizeObserver_: null,
  lastConfig_: null,
  properties: {
    autoReposition: {
      type: Boolean,
      value: false,
    },
    open: {
      type: Boolean,
      value: false,
    },
    roleDescription: String,
  },
  listeners: {
    keydown: "onKeyDown_",
    mouseover: "onMouseover_",
    click: "onClick_",
  },
  detached() {
    this.removeListeners_();
  },
  getDialog() {
    return this.$.dialog;
  },
  removeListeners_() {
    window.removeEventListener("resize", this.boundClose_);
    window.removeEventListener("popstate", this.boundClose_);
    if (this.contentObserver_) {
      dom(this.$.contentNode).unobserveNodes(this.contentObserver_);
      this.contentObserver_ = null;
    }
    if (this.resizeObserver_) {
      this.resizeObserver_.disconnect();
      this.resizeObserver_ = null;
    }
  },
  onNativeDialogClose_(e) {
    if (e.target !== this.$.dialog) {
      return;
    }
    e.stopPropagation();
    this.fire("close");
  },
  onClick_(e) {
    if (e.target === this) {
      this.close();
      e.stopPropagation();
    }
  },
  onKeyDown_(e) {
    e.stopPropagation();
    if (e.key === "Tab" || e.key === "Escape") {
      this.close();
      if (e.key === "Tab") {
        this.fire("tabkeyclose", {
          shiftKey: e.shiftKey,
        });
      }
      e.preventDefault();
      return;
    }
    if (e.key !== "Enter" && e.key !== "ArrowUp" && e.key !== "ArrowDown") {
      return;
    }
    const query = ".dropdown-item:not([disabled]):not([hidden])";
    const options = Array.from(this.querySelectorAll(query));
    if (options.length === 0) {
      return;
    }
    const focused = getDeepActiveElement();
    const index = options.findIndex((option) => FocusRow.getFocusableElement(option) === focused);
    if (e.key === "Enter") {
      if (index !== -1) {
        return;
      }
      if (isWindows || isMac) {
        this.close();
        e.preventDefault();
        return;
      }
    }
    e.preventDefault();
    this.updateFocus_(options, index, e.key !== "ArrowUp");
    if (!this.hasMousemoveListener_) {
      this.hasMousemoveListener_ = true;
      this.addEventListener(
        "mousemove",
        (e) => {
          this.onMouseover_(e);
          this.hasMousemoveListener_ = false;
        },
        {
          once: true,
        }
      );
    }
  },
  onMouseover_(e) {
    const query = ".dropdown-item:not([disabled])";
    const item = e.composedPath().find((el) => el.matches && el.matches(query));
    (item || this.$.wrapper).focus();
  },
  updateFocus_(options, focusedIndex, next) {
    const numOptions = options.length;
    assert(numOptions > 0);
    let index;
    if (focusedIndex === -1) {
      index = next ? 0 : numOptions - 1;
    } else {
      const delta = next ? 1 : -1;
      index = (numOptions + focusedIndex + delta) % numOptions;
    }
    options[index].focus();
  },
  close() {
    this.removeListeners_();
    this.$.dialog.close();
    this.open = false;
    if (this.anchorElement_) {
      focusWithoutInk(assert(this.anchorElement_));
      this.anchorElement_ = null;
    }
    if (this.lastConfig_) {
      this.lastConfig_ = null;
    }
  },
  showAt(anchorElement, opt_config) {
    this.anchorElement_ = anchorElement;
    this.anchorElement_.scrollIntoViewIfNeeded();
    const rect = this.anchorElement_.getBoundingClientRect();
    let height = rect.height;
    if (opt_config && !opt_config.noOffset && opt_config.anchorAlignmentY === AnchorAlignment.AFTER_END) {
      height -= AFTER_END_OFFSET;
    }
    this.showAtPosition(
      Object.assign(
        {
          top: rect.top,
          left: rect.left,
          height: height,
          width: rect.width,
          anchorAlignmentX: AnchorAlignment.BEFORE_END,
        },
        opt_config
      )
    );
    this.$.wrapper.focus();
  },
  showAtPosition(config) {
    const doc = document.scrollingElement;
    const scrollLeft = doc.scrollLeft;
    const scrollTop = doc.scrollTop;
    this.resetStyle_();
    this.$.dialog.showModal();
    this.open = true;
    config.top += scrollTop;
    config.left += scrollLeft;
    this.positionDialog_(
      Object.assign(
        {
          minX: scrollLeft,
          minY: scrollTop,
          maxX: scrollLeft + doc.clientWidth,
          maxY: scrollTop + doc.clientHeight,
        },
        config
      )
    );
    doc.scrollTop = scrollTop;
    doc.scrollLeft = scrollLeft;
    this.addListeners_();
  },
  resetStyle_() {
    this.$.dialog.style.left = "";
    this.$.dialog.style.right = "";
    this.$.dialog.style.top = "0";
  },
  positionDialog_(config) {
    this.lastConfig_ = config;
    const c = Object.assign(getDefaultShowConfig(), config);
    const top = c.top;
    const left = c.left;
    const bottom = top + c.height;
    const right = left + c.width;
    const rtl = getComputedStyle(this).direction === "rtl";
    if (rtl) {
      c.anchorAlignmentX *= -1;
    }
    const offsetWidth = this.$.dialog.offsetWidth;
    const menuLeft = getStartPointWithAnchor(left, right, offsetWidth, c.anchorAlignmentX, c.minX, c.maxX);
    if (rtl) {
      const menuRight = document.scrollingElement.clientWidth - menuLeft - offsetWidth;
      this.$.dialog.style.right = menuRight + "px";
    } else {
      this.$.dialog.style.left = menuLeft + "px";
    }
    const menuTop = getStartPointWithAnchor(top, bottom, this.$.dialog.offsetHeight, c.anchorAlignmentY, c.minY, c.maxY);
    this.$.dialog.style.top = menuTop + "px";
  },
  addListeners_() {
    this.boundClose_ =
      this.boundClose_ ||
      function() {
        if (this.$.dialog.open) {
          this.close();
        }
      }.bind(this);
    window.addEventListener("resize", this.boundClose_);
    window.addEventListener("popstate", this.boundClose_);
    this.contentObserver_ = dom(this.$.contentNode).observeNodes((info) => {
      info.addedNodes.forEach((node) => {
        if (node.classList && node.classList.contains(DROPDOWN_ITEM_CLASS) && !node.getAttribute("role")) {
          node.setAttribute("role", "menuitem");
        }
      });
    });
    if (this.autoReposition) {
      this.resizeObserver_ = new ResizeObserver(() => {
        if (this.lastConfig_) {
          this.positionDialog_(this.lastConfig_);
          this.fire("cr-action-menu-repositioned");
        }
      });
      this.resizeObserver_.observe(this.$.dialog);
    }
  },
});
// Copyright 2018 The Chromium Authors. All rights reserved.
const CrRadioButtonBehaviorImpl = {
  properties: {
    checked: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
    },
    disabled: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      notify: true,
    },
    focusable: {
      type: Boolean,
      value: false,
      observer: "onFocusableChanged_",
    },
    label: {
      type: String,
      value: "",
    },
    name: {
      type: String,
      notify: true,
      reflectToAttribute: true,
    },
    buttonTabIndex_: {
      type: Number,
      computed: "getTabIndex_(focusable)",
    },
  },
  listeners: {
    blur: "hideRipple_",
    focus: "onFocus_",
    up: "hideRipple_",
  },
  focus() {
    this.$.button.focus();
  },
  onFocusableChanged_() {
    const links = this.querySelectorAll("a");
    links.forEach((link) => {
      link.tabIndex = this.checked ? 0 : -1;
    });
  },
  onFocus_() {
    this.getRipple().showAndHoldDown();
  },
  hideRipple_() {
    this.getRipple().clear();
  },
  getAriaChecked_() {
    return this.checked ? "true" : "false";
  },
  getAriaDisabled_() {
    return this.disabled ? "true" : "false";
  },
  getTabIndex_() {
    return this.focusable ? 0 : -1;
  },
  onInputKeydown_(e) {
    if (e.shiftKey && e.key === "Tab") {
      this.focus();
    }
  },
  _createRipple() {
    this._rippleContainer = this.$$(".disc-wrapper");
    const ripple = PaperRippleBehavior._createRipple();
    ripple.id = "ink";
    ripple.setAttribute("recenters", "");
    ripple.classList.add("circle", "toggle-ink");
    return ripple;
  },
};
const CrRadioButtonBehavior = [PaperRippleBehavior, CrRadioButtonBehaviorImpl];
const template$b = document.createElement("template");
template$b.innerHTML = `<dom-module id="cr-radio-button-style" assetpath="chrome://resources/">
  <template>
    <style scope="cr-radio-button-style">:host {
    --cr-radio-button-checked-color: var(--google-blue-600);
        --cr-radio-button-checked-ripple-color:
            rgba(var(--google-blue-600-rgb), .2);
        --cr-radio-button-ink-size: 40px;
        --cr-radio-button-size: 16px;
        --cr-radio-button-unchecked-color: var(--google-grey-refresh-700);
        --cr-radio-button-unchecked-ripple-color:
            rgba(var(--google-grey-600-rgb), .15);
        --ink-to-circle: calc((var(--cr-radio-button-ink-size) -
                               var(--cr-radio-button-size)) / 2);
        align-items: center;
        display: flex;
        flex-shrink: 0;
        outline: none;
}
@media (prefers-color-scheme: dark) {
  :host {
    --cr-radio-button-checked-color: var(--google-blue-refresh-300);
    --cr-radio-button-checked-ripple-color: rgba(var(--google-blue-refresh-300-rgb), .4);
    --cr-radio-button-unchecked-color: var(--google-grey-refresh-500);
    --cr-radio-button-unchecked-ripple-color: rgba(var(--google-grey-refresh-300-rgb), .4);
  }
}
:host([disabled]) {
    opacity: var(--cr-disabled-opacity);

        pointer-events: none;
}
:host(:not([disabled])) {
    cursor: pointer;
}
#labelWrapper {
    flex: 1;
        margin-inline-start: var(--cr-radio-button-label-spacing, 20px);
}
#label {
    color: inherit;
}
.disc-border, .disc, .disc-wrapper, paper-ripple {
    border-radius: 50%;
}
.disc-wrapper {
    height: var(--cr-radio-button-size);
        margin-block-start: var(--cr-radio-button-disc-margin-block-start, 0);
        position: relative;
        width: var(--cr-radio-button-size);
}
.disc-border, .disc {
    box-sizing: border-box;
        height: var(--cr-radio-button-size);
        width: var(--cr-radio-button-size);
}
.disc-border {
    border: 2px solid var(--cr-radio-button-unchecked-color);
}
:host([checked]) .disc-border {
    border-color: var(--cr-radio-button-checked-color);
}
#button:focus {
    outline: none;
}
.disc {
    background-color: transparent;
        position: absolute;
        top: 0;
        transform: scale(0);
        transition: border-color 200ms, transform 200ms;
}
:host([checked]) .disc {
    background-color: var(--cr-radio-button-checked-color);
        transform: scale(0.5);
}
paper-ripple {
    --paper-ripple-opacity: 1;
        color: var(--cr-radio-button-unchecked-ripple-color);
        height: var(--cr-radio-button-ink-size);
        left: calc(-1 * var(--ink-to-circle));
        pointer-events: none;
        position: absolute;
        top: calc(-1 * var(--ink-to-circle));
        transition: color linear 80ms;
        width: var(--cr-radio-button-ink-size);
}
:host-context([dir=rtl]) paper-ripple {
    left: auto;
        right: calc(-1 * var(--ink-to-circle));
}
:host([checked]) paper-ripple {
    color: var(--cr-radio-button-checked-ripple-color);
}
</style>
  </template>
</dom-module>
`;
document.body.appendChild(template$b.content.cloneNode(true));
// Copyright 2018 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-radio-button-style cr-hidden-style" scope="cr-radio-button"></style>

    <div aria-checked$="[[getAriaChecked_(checked)]]" aria-describedby="slotted-content" aria-disabled$="[[getAriaDisabled_(disabled)]]" aria-labelledby="label" class="disc-wrapper" id="button" role="radio" tabindex$="[[buttonTabIndex_]]" on-keydown="onInputKeydown_">
      <div class="disc-border"></div>
      <div class="disc"></div>
    </div>

    <div id="labelWrapper">
      <span id="label" hidden$="[[!label]]" aria-hidden="true">[[label]]</span>
      <span id="slotted-content">
        <slot></slot>
      </span>
    </div>
    <!--_html_template_end_-->`,
  is: "cr-radio-button",
  behaviors: [CrRadioButtonBehavior],
});
// Copyright 2018 The Chromium Authors. All rights reserved.
function isEnabled$1(radio) {
  return radio.matches(":not([disabled]):not([hidden])") && radio.style.display !== "none" && radio.style.visibility !== "hidden";
}
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="cr-radio-group">
      :host {
        display: inline-block;
      }

      :host ::slotted(*) {
        padding: var(--cr-radio-group-item-padding, 12px);
      }

      :host([disabled]) {
        cursor: initial;
        pointer-events: none;
        user-select: none;
      }

      :host([disabled]) ::slotted(*) {
        opacity: var(--cr-disabled-opacity);
      }
    </style>
    <slot></slot>
    <!--_html_template_end_-->`,
  is: "cr-radio-group",
  properties: {
    disabled: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      observer: "update_",
    },
    selected: {
      type: String,
      notify: true,
      observer: "update_",
    },
    selectableElements: {
      type: String,
      value: "cr-radio-button, controlled-radio-button",
    },
    selectableRegExp_: {
      value: Object,
      computed: "computeSelectableRegExp_(selectableElements)",
    },
  },
  listeners: {
    keydown: "onKeyDown_",
    click: "onClick_",
  },
  hostAttributes: {
    "aria-disabled": "false",
    role: "radiogroup",
  },
  buttons_: null,
  buttonEventTracker_: null,
  deltaKeyMap_: null,
  isRtl_: false,
  observer_: null,
  populateBound_: null,
  attached() {
    this.isRtl_ = this.matches(":host-context([dir=rtl]) cr-radio-group");
    this.deltaKeyMap_ = new Map([
      ["ArrowDown", 1],
      ["ArrowLeft", this.isRtl_ ? 1 : -1],
      ["ArrowRight", this.isRtl_ ? -1 : 1],
      ["ArrowUp", -1],
      ["PageDown", 1],
      ["PageUp", -1],
    ]);
    this.buttonEventTracker_ = new EventTracker();
    this.populateBound_ = () => this.populate_();
    if (Polymer.DomIf) {
      this.$$("slot").addEventListener("slotchange", this.populateBound_);
    } else {
      this.observer_ = dom(this).observeNodes(this.populateBound_);
    }
    this.populate_();
  },
  detached() {
    if (Polymer.DomIf) {
      this.$$("slot").removeEventListener("slotchange", this.populateBound_);
    } else if (this.observer_) {
      dom(this).unobserveNodes(this.observer_);
    }
    this.buttonEventTracker_.removeAll();
  },
  focus() {
    if (this.disabled || !this.buttons_) {
      return;
    }
    const radio = this.buttons_.find((radio) => this.isButtonEnabledAndSelected_(radio));
    if (radio) {
      radio.focus();
    }
  },
  onKeyDown_(event) {
    if (this.disabled) {
      return;
    }
    if (event.ctrlKey || event.shiftKey || event.metaKey || event.altKey) {
      return;
    }
    const targetElement = event.target;
    if (!this.buttons_.includes(targetElement)) {
      return;
    }
    if (event.key === " " || event.key === "Enter") {
      event.preventDefault();
      this.select_(event.target);
      return;
    }
    const enabledRadios = this.buttons_.filter(isEnabled$1);
    if (enabledRadios.length === 0) {
      return;
    }
    let selectedIndex;
    const max = enabledRadios.length - 1;
    if (event.key === "Home") {
      selectedIndex = 0;
    } else if (event.key === "End") {
      selectedIndex = max;
    } else if (this.deltaKeyMap_.has(event.key)) {
      const delta = this.deltaKeyMap_.get(event.key);
      const lastSelection = enabledRadios.findIndex((radio) => radio.checked);
      selectedIndex = Math.max(0, lastSelection) + delta;
      if (selectedIndex > max) {
        selectedIndex = 0;
      } else if (selectedIndex < 0) {
        selectedIndex = max;
      }
    } else {
      return;
    }
    const radio = enabledRadios[selectedIndex];
    const name = `${radio.name}`;
    if (this.selected !== name) {
      event.preventDefault();
      this.selected = name;
      radio.focus();
    }
  },
  computeSelectableRegExp_() {
    const tags = this.selectableElements.split(", ").join("|");
    return new RegExp(`^(${tags})$`, "i");
  },
  onClick_(event) {
    const path = event.composedPath();
    if (path.some((target) => /^a$/i.test(target.tagName))) {
      return;
    }
    const target = path.find((n) => this.selectableRegExp_.test(n.tagName));
    if (target && this.buttons_.includes(target)) {
      this.select_(target);
    }
  },
  populate_() {
    this.buttons_ = Polymer.DomIf
      ? this.$$("slot")
        .assignedNodes({
          flatten: true,
        })
        .filter((n) => this.selectableRegExp_.test(n.tagName))
      : this.queryAllEffectiveChildren(this.selectableElements);
    this.buttonEventTracker_.removeAll();
    this.buttons_.forEach((el) => {
      this.buttonEventTracker_.add(el, "disabled-changed", () => this.populate_());
      this.buttonEventTracker_.add(el, "name-changed", () => this.populate_());
    });
    this.update_();
  },
  select_(button) {
    if (!isEnabled$1(button)) {
      return;
    }
    const name = `${button.name}`;
    if (this.selected !== name) {
      this.selected = name;
    }
  },
  isButtonEnabledAndSelected_(button) {
    return !this.disabled && button.checked && isEnabled$1(button);
  },
  update_() {
    if (!this.buttons_) {
      return;
    }
    let noneMadeFocusable = true;
    this.buttons_.forEach((radio) => {
      radio.checked = this.selected !== undefined && `${radio.name}` === `${this.selected}`;
      const disabled = this.disabled || !isEnabled$1(radio);
      const canBeFocused = radio.checked && !disabled;
      if (canBeFocused) {
        radio.focusable = true;
        noneMadeFocusable = false;
      } else {
        radio.focusable = false;
      }
      radio.setAttribute("aria-disabled", `${disabled}`);
    });
    this.setAttribute("aria-disabled", `${this.disabled}`);
    if (noneMadeFocusable && !this.disabled) {
      const radio = this.buttons_.find(isEnabled$1);
      if (radio) {
        radio.focusable = true;
      }
    }
  },
});
const template$c = document.createElement("template");
template$c.innerHTML = `<dom-module id="md-select" assetpath="chrome://resources/">
  <template>
    <style scope="md-select">.md-select {
    --md-arrow-width: 10px;
        --md-select-bg-color: var(--google-grey-refresh-100);
        --md-select-focus-shadow-color: rgba(var(--google-blue-600-rgb), .4);
        --md-select-option-bg-color: white;
        --md-select-side-padding: 8px;
        --md-select-text-color: var(--google-grey-900);
        -webkit-appearance: none;
        background: url(chrome://resources/images/arrow_down.svg)
            calc(100% - var(--md-select-side-padding))
            center no-repeat;
        background-color: var(--md-select-bg-color);
        background-size: var(--md-arrow-width);
        border: none;
        border-radius: 4px;
        color: var(--md-select-text-color);
        cursor: pointer;
        font-family: inherit;
        font-size: inherit;
        line-height: inherit;
        max-width: 100%;
        outline: none;
        padding-bottom: 6px;

        padding-inline-end: calc(var(--md-select-side-padding) +
            var(--md-arrow-width) + 3px);
        padding-inline-start: var(--md-select-side-padding);
        padding-top: 6px;
        width: var(--md-select-width, 200px);
}
@media (prefers-color-scheme: dark) {
  .md-select {
    --md-select-bg-color: rgba(0, 0, 0, .3);
    --md-select-focus-shadow-color: rgba(var(--google-blue-refresh-300-rgb), .5);
    --md-select-option-bg-color: var(--maxthon-bg-base);
    --md-select-text-color: var(--cr-primary-text-color);
    background-image: url(chrome://resources/images/dark/arrow_down.svg);
  }
}
.md-select :-webkit-any(option, optgroup) {
    background-color: var(--md-select-option-bg-color);
}
.md-select[disabled] {
    opacity: var(--cr-disabled-opacity);
        pointer-events: none;
}
.md-select:focus {
    box-shadow: 0 0 0 2px var(--md-select-focus-shadow-color);
}
.md-select:active {
    box-shadow: none;
}
:host-context([dir=rtl]) .md-select {
    background-position-x: var(--md-select-side-padding);
}
</style>
  </template>
</dom-module>
`;
document.body.appendChild(template$c.content.cloneNode(true));
// Copyright 2017 The Chromium Authors. All rights reserved.
const CrContainerShadowSide = {
  TOP: "top",
  BOTTOM: "bottom",
};
const CrContainerShadowBehavior = {
  intersectionObserver_: null,
  dropShadows_: null,
  intersectionProbes_: null,
  sides_: null,
  ready() {
    this.dropShadows_ = new Map();
    this.intersectionProbes_ = new Map();
  },
  attached() {
    const hasBottomShadow = this.$.container.hasAttribute("show-bottom-shadow");
    this.sides_ = hasBottomShadow ? [CrContainerShadowSide.TOP, CrContainerShadowSide.BOTTOM] : [CrContainerShadowSide.TOP];
    this.sides_.forEach((side) => {
      const shadow = document.createElement("div");
      shadow.id = `cr-container-shadow-${side}`;
      shadow.classList.add("cr-container-shadow");
      this.dropShadows_.set(side, shadow);
      this.intersectionProbes_.set(side, document.createElement("div"));
    });
    this.$.container.parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.TOP), this.$.container);
    this.$.container.prepend(this.intersectionProbes_.get(CrContainerShadowSide.TOP));
    if (hasBottomShadow) {
      this.$.container.parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.BOTTOM), this.$.container.nextSibling);
      this.$.container.append(this.intersectionProbes_.get(CrContainerShadowSide.BOTTOM));
    }
    this.enableShadowBehavior(true);
  },
  detached() {
    this.enableShadowBehavior(false);
  },
  getIntersectionObserver_() {
    const callback = (entries) => {
      for (const entry of entries) {
        const target = entry.target;
        this.sides_.forEach((side) => {
          if (target === this.intersectionProbes_.get(side)) {
            this.dropShadows_.get(side).classList.toggle("has-shadow", entry.intersectionRatio === 0);
          }
        });
      }
    };
    return new IntersectionObserver(callback, {
      root: this.$.container,
      threshold: 0,
    });
  },
  enableShadowBehavior(enable) {
    if (enable === !!this.intersectionObserver_) {
      return;
    }
    if (!enable) {
      this.intersectionObserver_.disconnect();
      this.intersectionObserver_ = null;
      return;
    }
    this.intersectionObserver_ = this.getIntersectionObserver_();
    window.setTimeout(() => {
      if (this.intersectionObserver_) {
        this.intersectionProbes_.forEach((probe) => {
          this.intersectionObserver_.observe(probe);
        });
      }
    });
  },
  showDropShadows() {
    assert(!this.intersectionObserver_);
    assert(this.sides_);
    for (const side of this.sides_) {
      this.dropShadows_.get(side).classList.toggle("has-shadow", true);
    }
  },
};
// Copyright 2016 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-hidden-style cr-icons" scope="cr-dialog">
      dialog {
        --scroll-border-color: var(--paper-grey-300);
        --scroll-border: 1px solid var(--scroll-border-color);
        border: 0;
        bottom: 50%;
        box-shadow: 0 0 16px rgba(0, 0, 0, 0.12), 0 16px 16px rgba(0, 0, 0, 0.24);
        color: inherit;
        overflow-y: hidden;
        padding: 0;
        top: 50%;
        width: 512px;
      }

      @media (prefers-color-scheme: dark) {
        dialog {
          --scroll-border-color: var(--google-grey-refresh-700);
          background-color: var(--google-grey-900);

          background-image: linear-gradient(rgba(255, 255, 255, 0.04), rgba(255, 255, 255, 0.04));
        }
      }

      dialog[open] #content-wrapper {
        display: flex;
        flex-direction: column;
        max-height: 100vh;
        overflow: auto;
      }

      .top-container,
      :host ::slotted([slot="button-container"]),
      :host ::slotted([slot="footer"]) {
        flex-shrink: 0;
      }

      dialog::backdrop {
        background-color: rgba(0, 0, 0, 0.6);
        bottom: 0;
        left: 0;
        position: fixed;
        right: 0;
        top: 0;
      }

      :host ::slotted([slot="body"]) {
        color: var(--cr-secondary-text-color);
        padding: 0 20px;
      }

      :host ::slotted([slot="title"]) {
        color: var(--cr-primary-text-color);
        flex: 1;
        font-size: calc(15 / 13 * 100%);
        line-height: 1;
        padding-bottom: 16px;
        padding-inline-end: 20px;
        padding-inline-start: 20px;
        padding-top: 20px;
      }

      :host ::slotted([slot="button-container"]) {
        display: flex;
        justify-content: flex-end;
        padding-bottom: 16px;
        padding-inline-end: 16px;
        padding-inline-start: 16px;
        padding-top: 24px;
      }

      :host ::slotted([slot="footer"]) {
        border-bottom-left-radius: inherit;
        border-bottom-right-radius: inherit;
        border-top: 1px solid #dbdbdb;
        margin: 0;
        padding: 16px 20px;
      }

      @media (prefers-color-scheme: dark) {
        :host ::slotted([slot="footer"]) {
          border-top-color: var(--cr-separator-color);
        }
      }

      .body-container {
        box-sizing: border-box;
        display: flex;
        flex-direction: column;
        min-height: 1.375rem;
        overflow: auto;
      }

      :host {
        --transparent-border: 1px solid transparent;
      }

      #cr-container-shadow-top {
        border-bottom: var(--cr-dialog-body-border-top, var(--transparent-border));
      }

      #cr-container-shadow-bottom {
        border-bottom: var(--cr-dialog-body-border-bottom, var(--transparent-border));
      }

      #cr-container-shadow-top.has-shadow,
      #cr-container-shadow-bottom.has-shadow {
        border-bottom: var(--scroll-border);
      }

      .top-container {
        align-items: flex-start;
        display: flex;
        min-height: var(--cr-dialog-top-container-min-height, 31px);
      }

      .title-container {
        display: flex;
        flex: 1;
        outline: none;
      }

      #close {
        align-self: flex-start;
        margin-inline-end: 4px;
        margin-top: 4px;
      }
    </style>
    <dialog id="dialog" on-close="onNativeDialogClose_" on-cancel="onNativeDialogCancel_" part="dialog" aria-labelledby="title">
      <!-- This wrapper is necessary, such that the "pulse" animation is not
        erroneously played when the user clicks on the outer-most scrollbar. -->
      <div id="content-wrapper" part="wrapper">
        <div class="top-container">
          <div id="title" class="title-container" tabindex="-1">
            <slot name="title"></slot>
          </div>
          <cr-icon-button id="close" class="icon-clear" hidden$="[[!showCloseButton]]" aria-label$="[[closeText]]" on-click="cancel" on-keypress="onCloseKeypress_"> </cr-icon-button>
        </div>
        <slot name="header"></slot>
        <div class="body-container" id="container" show-bottom-shadow="" part="body-container">
          <slot name="body"></slot>
        </div>
        <slot name="button-container"></slot>
        <slot name="footer"></slot>
      </div>
    </dialog>
    <!--_html_template_end_-->`,
  is: "cr-dialog",
  behaviors: [CrContainerShadowBehavior],
  properties: {
    open: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
    },
    closeText: String,
    ignorePopstate: {
      type: Boolean,
      value: false,
    },
    ignoreEnterKey: {
      type: Boolean,
      value: false,
    },
    consumeKeydownEvent: {
      type: Boolean,
      value: false,
    },
    noCancel: {
      type: Boolean,
      value: false,
    },
    showCloseButton: {
      type: Boolean,
      value: false,
    },
    showOnAttach: {
      type: Boolean,
      value: false,
    },
  },
  listeners: {
    pointerdown: "onPointerdown_",
  },
  intersectionObserver_: null,
  mutationObserver_: null,
  boundKeydown_: null,
  ready() {
    window.addEventListener(
      "popstate",
      function() {
        if (!this.ignorePopstate && this.$.dialog.open) {
          this.cancel();
        }
      }.bind(this)
    );
    if (!this.ignoreEnterKey) {
      this.addEventListener("keypress", this.onKeypress_.bind(this));
    }
  },
  attached() {
    const mutationObserverCallback = function() {
      if (this.$.dialog.open) {
        this.enableShadowBehavior(true);
        this.addKeydownListener_();
      } else {
        this.enableShadowBehavior(false);
        this.removeKeydownListener_();
      }
    }.bind(this);
    this.mutationObserver_ = new MutationObserver(mutationObserverCallback);
    this.mutationObserver_.observe(this.$.dialog, {
      attributes: true,
      attributeFilter: ["open"],
    });
    mutationObserverCallback();
    if (this.showOnAttach) {
      this.showModal();
    }
  },
  detached() {
    this.removeKeydownListener_();
    if (this.mutationObserver_) {
      this.mutationObserver_.disconnect();
      this.mutationObserver_ = null;
    }
  },
  addKeydownListener_() {
    if (!this.consumeKeydownEvent) {
      return;
    }
    this.boundKeydown_ = this.boundKeydown_ || this.onKeydown_.bind(this);
    this.addEventListener("keydown", this.boundKeydown_);
    document.body.addEventListener("keydown", this.boundKeydown_);
  },
  removeKeydownListener_() {
    if (!this.boundKeydown_) {
      return;
    }
    this.removeEventListener("keydown", this.boundKeydown_);
    document.body.removeEventListener("keydown", this.boundKeydown_);
    this.boundKeydown_ = null;
  },
  showModal() {
    this.$.dialog.showModal();
    assert(this.$.dialog.open);
    this.open = true;
    this.fire("cr-dialog-open");
  },
  cancel() {
    this.fire("cancel");
    this.$.dialog.close();
    assert(!this.$.dialog.open);
    this.open = false;
  },
  close() {
    this.$.dialog.close("success");
    assert(!this.$.dialog.open);
    this.open = false;
  },
  setTitleAriaLabel(title) {
    this.$.dialog.removeAttribute("aria-labelledby");
    this.$.dialog.setAttribute("aria-label", title);
  },
  onCloseKeypress_(e) {
    e.stopPropagation();
  },
  onNativeDialogClose_(e) {
    if (e.target !== this.getNative()) {
      return;
    }
    e.stopPropagation();
    this.fire("close");
  },
  onNativeDialogCancel_(e) {
    if (e.target !== this.getNative()) {
      return;
    }
    if (this.noCancel) {
      e.preventDefault();
      return;
    }
    this.open = false;
    this.fire("cancel");
  },
  getNative() {
    return this.$.dialog;
  },
  onKeypress_(e) {
    if (e.key !== "Enter") {
      return;
    }
    const accept = e.target === this || e.composedPath().some((el) => el.tagName === "CR-INPUT" && el.type !== "search");
    if (!accept) {
      return;
    }
    const actionButton = this.querySelector(".action-button:not([disabled]):not([hidden])");
    if (actionButton) {
      actionButton.click();
      e.preventDefault();
    }
  },
  onKeydown_(e) {
    assert(this.consumeKeydownEvent);
    if (!this.getNative().open) {
      return;
    }
    if (this.ignoreEnterKey && e.key === "Enter") {
      return;
    }
    e.stopPropagation();
  },
  onPointerdown_(e) {
    if (e.button !== 0 || e.composedPath()[0].tagName !== "DIALOG") {
      return;
    }
    this.$.dialog.animate(
      [
        {
          transform: "scale(1)",
          offset: 0,
        },
        {
          transform: "scale(1.02)",
          offset: 0.4,
        },
        {
          transform: "scale(1.02)",
          offset: 0.6,
        },
        {
          transform: "scale(1)",
          offset: 1,
        },
      ],
      {
        duration: 180,
        easing: "ease-in-out",
        iterations: 1,
      }
    );
    e.preventDefault();
  },
  focus() {
    this.$$(".title-container").focus();
  },
});
const template$d = document.createElement("template");
template$d.innerHTML = `<dom-module id="cr-input-style" assetpath="chrome://resources/">
  <template>
    <style scope="cr-input-style">:host {
    --cr-input-background-color: var(--google-grey-refresh-100);
        --cr-input-color: var(--cr-primary-text-color);
        --cr-input-error-color: var(--google-red-600);
        --cr-input-focus-color: var(--google-blue-600);
        --cr-input-placeholder-color: var(--cr-secondary-text-color);
        display: block;

        outline: none;
}
@media (prefers-color-scheme: dark) {
  :host {
    --cr-input-background-color: rgba(0, 0, 0, .3);
    --cr-input-error-color: var(--google-red-refresh-300);
    --cr-input-focus-color: var(--google-blue-refresh-300);
  }
}
:host([focused_]:not([readonly]):not([invalid])) #label {
    color: var(--cr-input-focus-color);
}
#input-container {
    border-radius: var(--cr-input-border-radius, 4px);
        overflow: hidden;
        position: relative;
        width: var(--cr-input-width, 100%);
}
#inner-input-container {
    background-color: var(--cr-input-background-color);
        box-sizing: border-box;
        padding: 0;
}
#input {
    -webkit-appearance: none;

        background-color: transparent;
        border: none;
        box-sizing: border-box;
        caret-color: var(--cr-input-focus-color);
        color: var(--cr-input-color);
        font-family: inherit;
        font-size: inherit;
        line-height: inherit;
        min-height: var(--cr-input-min-height, auto);
        outline: none;

        padding-bottom: var(--cr-input-padding-bottom, 6px);
        padding-inline-end: var(--cr-input-padding-end, 8px);
                padding-inline-start: var(--cr-input-padding-start, 8px);
                padding-top: var(--cr-input-padding-top, 6px);
                text-align: inherit;
                text-overflow: ellipsis;
                width: 100%;

                 ;
      }
        #underline {
            border-bottom: 2px solid var(--cr-input-focus-color);
                  bottom: 0;
                  box-sizing: border-box;
                  left: 0;
                  margin: auto;
                  opacity: 0;
                  position: absolute;
                  right: 0;
                  transition: opacity 120ms ease-out, width 0s linear 180ms;
                  width: 0;
        }
        :host([invalid]) #underline, :host([force-underline]) #underline, :host([focused_]:not([readonly])) #underline {
            opacity: 1;
                  transition: opacity 120ms ease-in, width 180ms ease-out;
                  width: 100%;
        }
        </style>
          </template>
        </dom-module>
        `;
document.body.appendChild(template$d.content.cloneNode(true));
// Copyright 2018 The Chromium Authors. All rights reserved.
const SUPPORTED_INPUT_TYPES = new Set(["number", "password", "search", "text", "url"]);
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-hidden-style cr-input-style cr-shared-style" scope="cr-input">
      :host([disabled]) :-webkit-any(#label, #error, #input-container) {
        opacity: var(--cr-disabled-opacity);
        pointer-events: none;
      }

      :host ::slotted(cr-button[slot="suffix"]) {
        margin-inline-start: var(--cr-button-edge-spacing) !important;
      }

      :host([invalid]) #label {
        color: var(--cr-input-error-color);
      }

      #input {
        border-bottom: var(--cr-input-border-bottom, none);
        letter-spacing: var(--cr-input-letter-spacing);
      }

      #input::placeholder {
        color: var(--cr-input-placeholder-color);
        letter-spacing: var(--cr-input-placeholder-letter-spacing);
      }

      :host([invalid]) #input {
        caret-color: var(--cr-input-error-color);
      }

      :host([readonly]) #input {
        opacity: 0.6;
      }

      :host([invalid]) #underline {
        border-color: var(--cr-input-error-color);
      }

      #error {
        color: var(--cr-input-error-color);
        display: var(--cr-input-error-display, block);
        font-size: var(--cr-form-field-label-font-size);
        height: var(--cr-form-field-label-height);
        line-height: var(--cr-form-field-label-line-height);
        margin: 8px 0;
        visibility: hidden;
      }

      :host([invalid]) #error {
        visibility: visible;
      }

      #row-container,
      #inner-input-container {
        align-items: center;
        display: flex;

        justify-content: space-between;
        position: relative;
      }

      #input[type="search"]::-webkit-search-cancel-button {
        -webkit-appearance: none;
      }

      :host-context([dir="rtl"]) #input[type="url"] {
        text-align: right;
      }

      #input[type="url"] {
        direction: ltr;
      }
    </style>
    <div id="label" class="cr-form-field-label" hidden="[[!label]]" aria-hidden="true">[[label]]</div>
    <div id="row-container" part="row-container">
      <div id="input-container">
        <div id="inner-input-container">
          <slot name="inline-prefix"></slot>
          <!-- Only attributes that are named inconsistently between html and js
              need to use attr$="", such as |tabindex| vs .tabIndex and
              |readonly| vs .readOnly. -->
          <input id="input" disabled="[[disabled]]" autofocus="[[autofocus]]" value="{{value::input}}" tabindex$="[[tabindex]]" type="[[type]]" readonly$="[[readonly]]" maxlength$="[[maxlength]]" pattern$="[[pattern]]" required="[[required]]" minlength$="[[minlength]]" inputmode$="[[inputmode]]" aria-label$="[[getAriaLabel_(ariaLabel, label, placeholder)]]" aria-invalid$="[[getAriaInvalid_(invalid)]]" max="[[max]]" min="[[min]]" on-focus="onInputFocus_" on-blur="onInputBlur_" on-change="onInputChange_" on-keydown="onInputKeydown_" part="input" />
          <slot name="inline-suffix"></slot>
        </div>
        <div id="underline"></div>
      </div>
      <slot name="suffix"></slot>
    </div>
    <!--
      Note: role="alert" is not working as expected because screen readers
      expect live regions to be in the DOM at time of document loading.
      cr-input will automatically fire iron-announce for the error message.
      Also aria-hidden="true" to avoid noise for screen reader users.
    -->
    <div id="error" aria-hidden="true">[[errorMessage]]</div>
    <!--_html_template_end_-->`,
  is: "cr-input",
  properties: {
    ariaLabel: {
      type: String,
      value: "",
    },
    autofocus: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
    },
    autoValidate: Boolean,
    disabled: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      observer: "disabledChanged_",
    },
    errorMessage: {
      type: String,
      value: "",
      observer: "errorMessageChanged_",
    },
    focused_: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
    },
    invalid: {
      type: Boolean,
      value: false,
      notify: true,
      reflectToAttribute: true,
    },
    max: {
      type: Number,
      reflectToAttribute: true,
    },
    min: {
      type: Number,
      reflectToAttribute: true,
    },
    maxlength: {
      type: Number,
      reflectToAttribute: true,
    },
    minlength: {
      type: Number,
      reflectToAttribute: true,
    },
    pattern: {
      type: String,
      reflectToAttribute: true,
    },
    inputmode: String,
    label: {
      type: String,
      value: "",
    },
    placeholder: {
      type: String,
      value: null,
      observer: "placeholderChanged_",
    },
    readonly: {
      type: Boolean,
      reflectToAttribute: true,
    },
    required: {
      type: Boolean,
      reflectToAttribute: true,
    },
    tabindex: {
      type: Number,
      value: 0,
      reflectToAttribute: true,
    },
    type: {
      type: String,
      value: "text",
      observer: "onTypeChanged_",
    },
    value: {
      type: String,
      value: "",
      notify: true,
      observer: "onValueChanged_",
    },
  },
  hostAttributes: {
    "aria-disabled": "false",
  },
  listeners: {
    focus: "onFocus_",
    pointerdown: "onPointerDown_",
  },
  originalTabIndex_: null,
  attached() {
    if (this.disabled) {
      this.reconcileTabindex_();
    }
  },
  onTypeChanged_() {
    assert(SUPPORTED_INPUT_TYPES.has(this.type));
  },
  get inputElement() {
    return this.$.input;
  },
  getAriaLabel_(ariaLabel, label, placeholder) {
    return ariaLabel || label || placeholder;
  },
  getAriaInvalid_(invalid) {
    return invalid ? "true" : "false";
  },
  disabledChanged_(current, previous) {
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
    this.focused_ = false;
    if (previous !== undefined) {
      this.reconcileTabindex_();
    }
  },
  errorMessageChanged_() {
    IronA11yAnnouncer.requestAvailability();
    this.fire("iron-announce", {
      text: this.errorMessage,
    });
  },
  reconcileTabindex_() {
    if (this.disabled) {
      this.recordAndUnsetTabIndex_();
    } else {
      this.restoreTabIndex_();
    }
  },
  placeholderChanged_() {
    if (this.placeholder || this.placeholder === "") {
      this.inputElement.setAttribute("placeholder", this.placeholder);
    } else {
      this.inputElement.removeAttribute("placeholder");
    }
  },
  onFocus_() {
    if (!this.focusInput()) {
      return;
    }
    this.inputElement.select();
  },
  focusInput() {
    if (this.shadowRoot.activeElement === this.inputElement) {
      return false;
    }
    this.inputElement.focus();
    return true;
  },
  recordAndUnsetTabIndex_() {
    if (this.originalTabIndex_ === null) {
      this.originalTabIndex_ = this.tabindex;
    }
    this.tabindex = null;
  },
  restoreTabIndex_() {
    this.tabindex = this.originalTabIndex_;
    this.originalTabIndex_ = null;
  },
  onPointerDown_(e) {
    if (this.disabled) {
      return;
    }
    if (e.path[0].tagName !== "INPUT") {
      this.recordAndUnsetTabIndex_();
      setTimeout(() => {
        if (!this.disabled) {
          this.restoreTabIndex_();
        }
      }, 0);
    }
  },
  onInputKeydown_(e) {
    if (e.shiftKey && e.key === "Tab") {
      this.focus();
    }
  },
  onValueChanged_(newValue, oldValue) {
    if (!newValue && !oldValue) {
      return;
    }
    if (this.autoValidate) {
      this.validate();
    }
  },
  onInputChange_(e) {
    this.fire("change", {
      sourceEvent: e,
    });
  },
  onInputFocus_() {
    this.focused_ = true;
  },
  onInputBlur_() {
    this.focused_ = false;
  },
  select(start, end) {
    this.focusInput();
    if (start !== undefined && end !== undefined) {
      this.inputElement.setSelectionRange(start, end);
    } else {
      assert(start === undefined && end === undefined);
      this.inputElement.select();
    }
  },
  validate() {
    this.invalid = !this.inputElement.checkValidity();
    return !this.invalid;
  },
});
// Copyright 2018 The Chromium Authors. All rights reserved.
const patternRegExp = new RegExp("^" + "((http|https|\\*)://)?" + "(\\*\\.)?" + "([a-z0-9\\.-]+\\.[a-z0-9]+|localhost)" + "(:[0-9]+)?" + "(\\/\\*|\\/)?" + "$");
function getPatternFromSite(site) {
  const res = patternRegExp.exec(site);
  assert(res);
  const scheme = res[1] || "*://";
  const host = (res[3] || "") + res[4];
  const port = res[5] || "";
  const path = "/*";
  return scheme + host + port + path;
}
Polymer({
  is: "extensions-runtime-hosts-dialog",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style" scope="extensions-runtime-hosts-dialog"></style>
    <cr-dialog id="dialog" close-text="___close___">
      <div slot="title">[[computeDialogTitle_(currentSite)]]</div>
      <div slot="body">
        <cr-input id="input" label="___runtimeHostsDialogInputLabel___" placeholder="http://example.com" value="{{site_}}" on-input="validate_" invalid="[[inputInvalid_]]" error-message="___runtimeHostsDialogInputError___" spellcheck="false" autofocus=""> </cr-input>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCancelTap_"> ___cancel___ </cr-button>
        <cr-button class="action-button" id="submit" on-click="onSubmitTap_" disabled="[[computeSubmitButtonDisabled_(inputInvalid_, site_)]]"> [[computeSubmitButtonLabel_(currentSite)]] </cr-button>
      </div>
    </cr-dialog>
    <!--_html_template_end_-->`,
  properties: {
    delegate: Object,
    itemId: String,
    currentSite: {
      type: String,
      value: null,
    },
    updateHostAccess: {
      type: Boolean,
      value: false,
    },
    site_: String,
    inputInvalid_: {
      type: Boolean,
      value: false,
    },
  },
  attached() {
    if (this.currentSite !== null && this.currentSite !== undefined) {
      this.site_ = this.currentSite;
      this.validate_();
    }
    this.$.dialog.showModal();
  },
  isOpen() {
    return this.$.dialog.open;
  },
  validate_() {
    if (this.site_.trim().length === 0) {
      this.inputInvalid_ = false;
      return;
    }
    const valid = patternRegExp.test(this.site_);
    this.inputInvalid_ = !valid;
  },
  computeDialogTitle_() {
    const stringId = this.currentSite === null ? "runtimeHostsDialogTitle" : "hostPermissionsEdit";
    return loadTimeData.getString(stringId);
  },
  computeSubmitButtonDisabled_() {
    return this.inputInvalid_ || this.site_ === undefined || this.site_.trim().length === 0;
  },
  computeSubmitButtonLabel_() {
    const stringId = this.currentSite === null ? "add" : "save";
    return loadTimeData.getString(stringId);
  },
  onCancelTap_() {
    this.$.dialog.cancel();
  },
  onSubmitTap_() {
    if (this.currentSite !== null) {
      this.handleEdit_();
    } else {
      this.handleAdd_();
    }
  },
  handleAdd_() {
    assert(!this.currentSite);
    if (this.updateHostAccess) {
      this.delegate.setItemHostAccess(this.itemId, chrome.developerPrivate.HostAccess.ON_SPECIFIC_SITES);
    }
    this.addPermission_();
  },
  handleEdit_() {
    assert(this.currentSite);
    assert(!this.updateHostAccess, "Editing host permissions should only be possible if the host " + "access is already set to specific sites.");
    if (this.currentSite === this.site_) {
      this.$.dialog.close();
      return;
    }
    this.delegate.removeRuntimeHostPermission(this.itemId, this.currentSite).then(() => {
      this.addPermission_();
    });
  },
  addPermission_() {
    const pattern = getPatternFromSite(this.site_);
    this.delegate.addRuntimeHostPermission(this.itemId, pattern).then(
      () => {
        this.$.dialog.close();
      },
      () => {
        this.inputInvalid_ = true;
      }
    );
  },
});
// Copyright 2018 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-runtime-host-permissions",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style action-link md-select shared-style" scope="extensions-runtime-host-permissions">
      iron-icon {
        --iron-icon-height: var(--cr-icon-size);
        --iron-icon-width: var(--cr-icon-size);
      }

      #section-heading {
        align-items: center;
        display: flex;
        justify-content: space-between;
      }

      #host-access {
        margin-inline-start: 20px;
        width: 100%;
      }

      #hosts {
        margin-bottom: 0;
        padding: 0;
      }

      #hosts li {
        align-items: center;
        border-bottom: var(--cr-separator-line);
        display: flex;
        height: var(--cr-section-min-height);
        justify-content: space-between;
      }

      #hosts li:last-child {
        border-bottom: none;
      }

      #add-host {
        font-weight: 500;
        width: 100%;
      }

      #permissions-mode {
        color: var(--cr-primary-text-color);
        margin-top: 12px;
      }

      cr-radio-button.multi-row {
        align-items: normal;
      }

      cr-icon-button {
        margin: 0;
      }
    </style>
    <div id="permissions-mode">
      <div id="section-heading">
        <span>___hostPermissionsHeading___</span>
        <a class="link-icon-button" aria-label="___learnMore___" href="https://support.google.com/chrome?p=enable_extensions" target="_blank">
          <iron-icon icon="cr:help-outline"></iron-icon>
        </a>
      </div>
      <cr-radio-group id="host-access" selected="[[permissions.hostAccess]]" on-selected-changed="onHostAccessChange_">
        <cr-radio-button name="[[HostAccess_.ON_CLICK]]"> ___hostAccessOnClick___ </cr-radio-button>
        <cr-radio-button name="[[HostAccess_.ON_SPECIFIC_SITES]]" class="multi-row">
          <div>___hostAccessOnSpecificSites___</div>
          <template is="dom-if" if="[[showSpecificSites_(permissions.*)]]">
            <ul id="hosts">
              <template is="dom-repeat" items="[[getRuntimeHosts_(permissions.hosts)]]">
                <li>
                  <div>[[item]]</div>
                  <cr-icon-button class="icon-more-vert edit-host" on-click="onEditHostClick_" title="___hostPermissionsEdit___"></cr-icon-button>
                </li>
              </template>
              <li>
                <a id="add-host" is="action-link" on-click="onAddHostClick_"> ___itemSiteAccessAddHost___ </a>
              </li>
            </ul>
          </template>
        </cr-radio-button>
        <cr-radio-button name="[[HostAccess_.ON_ALL_SITES]]"> ___hostAccessOnAllSites___ </cr-radio-button>
      </cr-radio-group>
    </div>
    <cr-action-menu id="hostActionMenu" role-description="___menu___" on-close="onActionMenuClose_">
      <button class="dropdown-item" id="action-menu-edit" on-click="onActionMenuEditClick_">___hostPermissionsEdit___</button>
      <button class="dropdown-item" id="action-menu-remove" on-click="onActionMenuRemoveClick_">___remove___</button>
    </cr-action-menu>
    <template is="dom-if" if="[[showHostDialog_]]" restamp="">
      <extensions-runtime-hosts-dialog delegate="[[delegate]]" item-id="[[itemId]]" current-site="[[hostDialogModel_]]" update-host-access="[[dialogShouldUpdateHostAccess_(oldHostAccess_)]]" on-close="onHostDialogClose_" on-cancel="onHostDialogCancel_"> </extensions-runtime-hosts-dialog>
    </template>
    <!--_html_template_end_-->`,
  properties: {
    permissions: Object,
    itemId: String,
    delegate: Object,
    showHostDialog_: Boolean,
    hostDialogModel_: {
      type: String,
      value: null,
    },
    hostDialogAnchorElement_: {
      type: Object,
      value: null,
    },
    actionMenuModel_: {
      type: String,
      value: null,
    },
    actionMenuAnchorElement_: {
      type: Object,
      value: null,
    },
    oldHostAccess_: {
      type: String,
      value: null,
    },
    HostAccess_: {
      type: Object,
      value: chrome.developerPrivate.HostAccess,
    },
  },
  onHostAccessChange_(event) {
    const group = this.$["host-access"];
    const access = group.selected;
    if (access === chrome.developerPrivate.HostAccess.ON_SPECIFIC_SITES && this.permissions.hostAccess !== chrome.developerPrivate.HostAccess.ON_SPECIFIC_SITES) {
      this.oldHostAccess_ = this.permissions.hostAccess;
      this.doShowHostDialog_(group, null);
    } else {
      this.delegate.setItemHostAccess(this.itemId, access);
    }
  },
  showSpecificSites_() {
    return this.permissions.hostAccess === chrome.developerPrivate.HostAccess.ON_SPECIFIC_SITES;
  },
  getRuntimeHosts_() {
    if (!this.permissions.hosts) {
      return [];
    }
    return this.permissions.hosts
      .filter((control) => control.granted)
      .map((control) => control.host)
      .sort();
  },
  onAddHostClick_(e) {
    const target = e.target;
    this.doShowHostDialog_(target, null);
  },
  doShowHostDialog_(anchorElement, currentSite) {
    this.hostDialogAnchorElement_ = anchorElement;
    this.hostDialogModel_ = currentSite;
    this.showHostDialog_ = true;
  },
  onHostDialogClose_() {
    this.hostDialogModel_ = null;
    this.showHostDialog_ = false;
    focusWithoutInk(assert(this.hostDialogAnchorElement_, "Host Anchor"));
    this.hostDialogAnchorElement_ = null;
    this.oldHostAccess_ = null;
  },
  onHostDialogCancel_() {
    if (this.oldHostAccess_) {
      assert(this.permissions.hostAccess === this.oldHostAccess_);
      this.$["host-access"].selected = this.oldHostAccess_;
      this.oldHostAccess_ = null;
    }
  },
  dialogShouldUpdateHostAccess_() {
    return !!this.oldHostAccess_;
  },
  onEditHostClick_(e) {
    this.actionMenuModel_ = e.model.item;
    this.actionMenuAnchorElement_ = e.target;
    const actionMenu = this.$.hostActionMenu;
    actionMenu.showAt(e.target);
  },
  onActionMenuEditClick_() {
    const site = this.actionMenuModel_;
    const anchorElement = assert(this.actionMenuAnchorElement_, "Menu Anchor");
    this.actionMenuAnchorElement_ = null;
    this.closeActionMenu_();
    this.doShowHostDialog_(anchorElement, site);
  },
  onActionMenuRemoveClick_() {
    this.delegate.removeRuntimeHostPermission(this.itemId, assert(this.actionMenuModel_, "Action Menu Model"));
    this.closeActionMenu_();
  },
  closeActionMenu_() {
    const menu = this.$.hostActionMenu;
    assert(menu.open);
    menu.close();
  },
  onActionMenuClose_() {
    this.actionMenuModel_ = null;
    this.actionMenuAnchorElement_ = null;
  },
});
// Copyright 2016 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-detail-view",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style
      include="iron-flex cr-shared-style cr-icons action-link
    shared-style"
      scope="extensions-detail-view"
    >
      :host {
        --iron-icon-fill-color: var(--cr-secondary-text-color);
        display: block;
        height: 100%;
      }

      #enable-section {
        margin-bottom: 8px;
      }

      #enable-section cr-tooltip-icon {
        margin-inline-end: 20px;
      }

      #enable-section span {
        color: var(--cr-secondary-text-color);
        font-weight: 500;
      }

      #enable-section .enabled-text {
        color: var(--google-blue-500);
      }

      @media (prefers-color-scheme: dark) {
        #enable-section .enabled-text {
          color: var(--google-blue-refresh-300);
        }
      }

      #icon {
        height: 24px;
        margin-inline-end: 12px;
        margin-inline-start: 16px;
        width: 24px;
      }

      #name {
        flex-grow: 1;
      }

      .section {
        box-sizing: border-box;
        padding: var(--cr-section-vertical-padding) var(--cr-section-padding);
      }

      .cr-row.control-line {
        justify-content: space-between;
      }

      .section-content {
        color: var(--cr-secondary-text-color);
      }

      .actionable {
        cursor: pointer;
      }

      .inspectable-view {
        height: 20px;
        width: auto;
      }

      @media (prefers-color-scheme: light) {
        .warning .action-button {
          background: white;
          color: var(--google-blue-500);
        }

        #reload-button {
          color: var(--google-blue-500);
        }
      }

      .warning span {
        color: var(--error-color);
        flex: 1;
      }

      .warning-icon {
        --iron-icon-fill-color: var(--error-color);
        flex-shrink: 0;
        height: 18px;
        margin-inline-end: 8px;
        width: 18px;
      }

      ul {
        margin: 0;
        padding-inline-start: 20px;
      }

      #options-section .control-line:first-child {
        border-top: var(--cr-separator-line);
      }

      extensions-toggle-row {
        box-sizing: border-box;
        padding-inline-end: 0;
        padding-inline-start: 0;
        --toggle-row-label-horizontal-padding: var(--cr-section-padding);
        --toggle-row-label-vertical-padding: var(--cr-section-vertical-padding);
      }

      #load-path {
        word-break: break-all;
      }

      #load-path > a[is="action-link"] {
        display: inline;
      }

      #size {
        align-items: center;
        display: flex;
      }

      paper-spinner-lite {
        height: var(--cr-icon-size);
        width: var(--cr-icon-size);
      }
    </style>
    <div class="page-container" id="container">
      <div class="page-content">
        <div class="page-header">
          <cr-icon-button class="icon-arrow-back no-overlap" id="closeButton" aria-label="___back___" on-click="onCloseButtonTap_"> </cr-icon-button>
          <img
            id="icon"
            src="[[data.iconUrl]]"
            alt$="[[appOrExtension(
              data.type,
              '___appIcon___',
              '___extensionIcon___')]]"
          />
          <span id="name" class="cr-title-text" role="heading" aria-level="1"> [[data.name]] </span>
        </div>
        <div class="cr-row first control-line" id="enable-section">
          <span class$="[[computeEnabledStyle_(data.state)]]"> [[computeEnabledText_(data.state, '___itemOn___', '___itemOff___')]] </span>
          <div class="layout horizontal">
            <cr-tooltip-icon hidden$="[[!data.controlledInfo]]" tooltip-text="[[data.controlledInfo.text]]" icon-class="[[getIndicatorIcon_(data.controlledInfo.type)]]" icon-aria-label="[[data.controlledInfo.type]]"> </cr-tooltip-icon>
            <template is="dom-if" if="[[showReloadButton_(data.state)]]">
              <cr-button id="terminated-reload-button" class="action-button" on-click="onReloadTap_"> ___itemReload___ </cr-button>
            </template>
            <cr-tooltip-icon id="parentDisabledPermissionsToolTip" hidden$="[[!data.disableReasons.parentDisabledPermissions]]" tooltip-text="___parentDisabledPermissions___" icon-class="cr20:kite" icon-aria-label="___parentDisabledPermissions___"> </cr-tooltip-icon>
            <cr-toggle
              id="enableToggle"
              aria-label$="[[appOrExtension(
                data.type,
                '___appEnabled___',
                '___extensionEnabled___')]]"
              aria-describedby="name"
              checked="[[isEnabled_(data.state)]]"
              on-change="onEnableToggleChange_"
              disabled$="[[!isEnableToggleEnabled_(data.*)]]"
              hidden$="[[!showEnableToggle_(data.*)]]"
            >
            </cr-toggle>
          </div>
        </div>
        <div id="warnings" hidden$="[[!hasWarnings_(data.*)]]">
          <div id="runtime-warnings" hidden$="[[!data.runtimeWarnings.length]]" class="cr-row continuation warning control-line">
            <iron-icon class="warning-icon" icon="cr:error"></iron-icon>
            <span>
              <template is="dom-repeat" items="[[data.runtimeWarnings]]"> [[item]] </template>
            </span>
            <template is="dom-if" if="[[!showReloadButton_(data.state)]]">
              <cr-button id="warnings-reload-button" class="action-button" on-click="onReloadTap_"> ___itemReload___ </cr-button>
            </template>
          </div>
          <div class="cr-row continuation warning" id="suspicious-warning" hidden$="[[!data.disableReasons.suspiciousInstall]]">
            <iron-icon class="warning-icon" icon="cr:warning"></iron-icon>
            <span>
              ___itemSuspiciousInstall___
              <a target="_blank" href="___suspiciousInstallHelpUrl___"> ___learnMore___ </a>
            </span>
          </div>
          <div class="cr-row continuation warning control-line" id="corrupted-warning" hidden$="[[!showRepairButton_(data.disableReasons.corruptInstall)]]">
            <iron-icon class="warning-icon" icon="cr:warning"></iron-icon>
            <span>___itemCorruptInstall___</span>
            <cr-button id="repair-button" class="action-button" on-click="onRepairTap_"> ___itemRepair___ </cr-button>
          </div>
          <div class="cr-row continuation warning" id="blacklisted-warning" hidden$="[[!data.blacklistText]]">
            <iron-icon class="warning-icon" icon="cr:warning"></iron-icon>
            <span>___itemCorruptInstall___</span>
          </div>
          <div class="cr-row continuation warning" id="update-required-warning" hidden$="[[!data.disableReasons.updateRequired]]">
            <iron-icon class="warning-icon" icon="cr:warning"></iron-icon>
            <span>___updateRequiredByPolicy___</span>
          </div>
        </div>
        <div class="section">
          <div class="section-title" role="heading" aria-level="2">___itemDescriptionLabel___</div>
          <div class="section-content" id="description">[[getDescription_(data.description, '___noDescription___')]]</div>
        </div>
        <div class="section hr">
          <div class="section-title" role="heading" aria-level="2">___itemVersion___</div>
          <div class="section-content">[[data.version]]</div>
        </div>
        <div class="section hr">
          <div class="section-title" role="heading" aria-level="2">___itemSize___</div>
          <div class="section-content" id="size">
            <span>[[size_]]</span>
            <paper-spinner-lite active="[[!size_]]" hidden="[[size_]]"> </paper-spinner-lite>
          </div>
        </div>
        <div class="section hr" id="id-section" hidden$="[[!inDevMode]]">
          <div class="section-title" role="heading" aria-level="2">ID</div>
          <div class="section-content">[[data.id]]</div>
        </div>
        <template is="dom-if" if="[[inDevMode]]">
          <div class="section hr" id="inspectable-views">
            <div class="section-title" role="heading" aria-level="2">___itemInspectViews___</div>
            <div class="section-content">
              <ul id="inspect-views">
                <li hidden="[[data.views.length]]">___noActiveViews___</li>
                <template is="dom-repeat" items="[[data.views]]">
                  <li>
                    <a is="action-link" class="inspectable-view" on-click="onInspectTap_"> [[computeInspectLabel_(item)]] </a>
                  </li>
                </template>
              </ul>
            </div>
          </div>
        </template>
        <div class="section hr">
          <div class="section-title" role="heading" aria-level="2">___itemPermissions___</div>
          <div class="section-content">
            <span id="no-permissions" hidden$="[[hasPermissions_(data.*)]]"> ___itemPermissionsEmpty___ </span>
            <ul id="permissions-list" hidden$="[[!data.permissions.simplePermissions.length]]">
              <template is="dom-repeat" items="[[data.permissions.simplePermissions]]">
                <li>
                  [[item.message]]
                  <ul hidden="[[!item.submessages.length]]">
                    <template is="dom-repeat" items="[[item.submessages]]">
                      <li>[[item]]</li>
                    </template>
                  </ul>
                </li>
              </template>
            </ul>
          </div>
        </div>
        <div class="section hr">
          <div class="section-title" role="heading" aria-level="2">___itemSiteAccess___</div>
          <div class="section-content">
            <span id="no-site-access" hidden$="[[showSiteAccessContent_(data.*)]]"> ___itemSiteAccessEmpty___ </span>
            <template is="dom-if" if="[[showFreeformRuntimeHostPermissions_(data.*)]]">
              <extensions-runtime-host-permissions permissions="[[data.permissions.runtimeHostPermissions]]" delegate="[[delegate]]" item-id="[[data.id]]"> </extensions-runtime-host-permissions>
            </template>
            <template is="dom-if" if="[[showHostPermissionsToggleList_(data.*)]]">
              <extensions-host-permissions-toggle-list permissions="[[data.permissions.runtimeHostPermissions]]" delegate="[[delegate]]" item-id="[[data.id]]"> </extensions-host-permissions-toggle-list>
            </template>
          </div>
        </div>
        <template is="dom-if" if="[[showUserScriptSectionToggle_(data.*)]]">
          <extensions-toggle-row id="allow-user-scripts" checked="[[data.userScriptsAccess.isActive]]" class="hr" on-change="onAllowUserScriptsChange_">
            <div>
              <div>___itemAllowUserScripts___</div>
              <div class="section-content">___userScriptsWarning___</div>
            </div>
          </extensions-toggle-row>
        </template>
        <template is="dom-if" if="[[hasDependentExtensions_(data.dependentExtensions.splices)]]">
          <div class="section hr">
            <div class="section-title" role="heading" aria-level="2">___itemDependencies___</div>
            <div class="section-content">
              <ul id="dependent-extensions-list">
                <template is="dom-repeat" items="[[data.dependentExtensions]]">
                  <li>[[computeDependentEntry_(item)]]</li>
                </template>
              </ul>
            </div>
          </div>
        </template>
        <template is="dom-if" if="[[shouldShowOptionsSection_(data.*)]]">
          <div id="options-section">
            <template
              is="dom-if"
              if="[[shouldShowIncognitoOption_(
              data.incognitoAccess.isEnabled, incognitoAvailable)]]"
            >
              <extensions-toggle-row id="allow-incognito" checked="[[data.incognitoAccess.isActive]]" class="hr" on-change="onAllowIncognitoChange_">
                <div>
                  <div>___itemAllowIncognito___</div>
                  <div class="section-content">___incognitoInfoWarning___</div>
                </div>
              </extensions-toggle-row>
            </template>
            <template is="dom-if" if="[[data.fileAccess.isEnabled]]">
              <extensions-toggle-row id="allow-on-file-urls" checked="[[data.fileAccess.isActive]]" class="hr" on-change="onAllowOnFileUrlsChange_">
                <span>___itemAllowOnFileUrls___</span>
              </extensions-toggle-row>
            </template>
            <template is="dom-if" if="[[data.errorCollection.isEnabled]]">
              <extensions-toggle-row id="collect-errors" checked="[[data.errorCollection.isActive]]" class="hr" on-change="onCollectErrorsChange_">
                <span>___itemCollectErrors___</span>
              </extensions-toggle-row>
            </template>
          </div>
        </template>
        <cr-link-row class="hr" id="extensions-options" disabled="[[!isEnabled_(data.state)]]" hidden="[[!shouldShowOptionsLink_(data.*)]]" label="___itemOptions___" on-click="onExtensionOptionsTap_" external=""></cr-link-row>
        <cr-link-row class="hr" id="extensionsActivityLogLink" hidden$="[[!showActivityLog]]" label="___viewActivityLog___" on-click="onActivityLogTap_"> </cr-link-row>
        <cr-link-row class="hr" hidden="[[!data.manifestHomePageUrl.length]]" id="extensionWebsite" label="___extensionWebsite___" on-click="onExtensionWebSiteTap_" external=""></cr-link-row>
        <cr-link-row class="hr" hidden="[[!data.webStoreUrl.length]]" id="viewInStore" label="___viewInStore___" on-click="onViewInStoreTap_" external=""></cr-link-row>
        <div class="section hr">
          <div class="section-title" role="heading" aria-level="2">___itemSource___</div>
          <div id="source" class="section-content">[[computeSourceString_(data.*)]]</div>
          <div id="load-path" class="section-content" hidden$="[[!data.prettifiedPath]]">
            <span>___itemExtensionPath___</span>
            <a is="action-link" on-click="onLoadPathTap_"> [[data.prettifiedPath]] </a>
          </div>
        </div>
        <cr-link-row class="hr" id="remove-extension" hidden="[[data.mustRemainInstalled]]" label="___itemRemoveExtension___" on-click="onRemoveTap_"> </cr-link-row>
      </div>
    </div>
    <!--_html_template_end_-->`,
  behaviors: [CrContainerShadowBehavior, ItemBehavior],
  properties: {
    data: Object,
    size_: String,
    delegate: Object,
    inDevMode: Boolean,
    incognitoAvailable: Boolean,
    showActivityLog: Boolean,
    fromActivityLog: Boolean,
  },
  observers: ["onItemIdChanged_(data.id, delegate)"],
  listeners: {
    "view-enter-start": "onViewEnterStart_",
  },
  focusOptionsButton() {
    this.$$("#extensions-options").focus();
  },
  onViewEnterStart_() {
    const elementToFocus = this.fromActivityLog ? this.$.extensionsActivityLogLink : this.$.closeButton;
    afterNextRender(this, () => focusWithoutInk(elementToFocus));
  },
  onItemIdChanged_() {
    this.size_ = "";
    this.delegate.getExtensionSize(this.data.id).then((size) => {
      this.size_ = size;
    });
  },
  onActivityLogTap_() {
    navigation.navigateTo({
      page: Page.ACTIVITY_LOG,
      extensionId: this.data.id,
    });
  },
  getDescription_(description, fallback) {
    return description || fallback;
  },
  onCloseButtonTap_() {
    navigation.navigateTo({
      page: Page.LIST,
    });
  },
  isEnabled_() {
    return isEnabled(this.data.state);
  },
  isEnableToggleEnabled_() {
    return userCanChangeEnablement(this.data);
  },
  hasDependentExtensions_() {
    return this.data.dependentExtensions.length > 0;
  },
  hasWarnings_() {
    return this.data.disableReasons.corruptInstall || this.data.disableReasons.suspiciousInstall || this.data.disableReasons.updateRequired || !!this.data.blacklistText || this.data.runtimeWarnings.length > 0;
  },
  computeEnabledStyle_() {
    return this.isEnabled_() ? "enabled-text" : "";
  },
  computeEnabledText_(state, onText, offText) {
    return isEnabled(state) ? onText : offText;
  },
  computeInspectLabel_(view) {
    return computeInspectableViewLabel(view);
  },
  shouldShowOptionsLink_() {
    return !!this.data.optionsPage;
  },
  showUserScriptSectionToggle_() {
    return this.data.userScriptsAccess.isEnabled
  },
  shouldShowOptionsSection_() {
    return this.data.incognitoAccess.isEnabled || this.data.fileAccess.isEnabled || this.data.errorCollection.isEnabled;
  },
  shouldShowIncognitoOption_() {
    return this.data.incognitoAccess.isEnabled && this.incognitoAvailable;
  },
  onEnableToggleChange_() {
    this.delegate.setItemEnabled(this.data.id, this.$.enableToggle.checked);
    this.$.enableToggle.checked = this.isEnabled_();
  },
  onInspectTap_(e) {
    this.delegate.inspectItemView(this.data.id, e.model.item);
  },
  onExtensionOptionsTap_() {
    this.delegate.showItemOptionsPage(this.data);
  },
  onReloadTap_() {
    this.delegate.reloadItem(this.data.id).catch((loadError) => {
      this.fire("load-error", loadError);
    });
  },
  onRemoveTap_() {
    this.delegate.deleteItem(this.data.id);
  },
  onRepairTap_() {
    this.delegate.repairItem(this.data.id);
  },
  onLoadPathTap_() {
    this.delegate.showInFolder(this.data.id);
  },
  onAllowUserScriptsChange_() {
    this.delegate.setItemAllowedUserScripts(this.data.id, this.shadowRoot.querySelector("#allow-user-scripts").checked)
  },
  onAllowIncognitoChange_() {
    this.delegate.setItemAllowedIncognito(this.data.id, this.$$("#allow-incognito").checked);
  },
  onAllowOnFileUrlsChange_() {
    this.delegate.setItemAllowedOnFileUrls(this.data.id, this.$$("#allow-on-file-urls").checked);
  },
  onCollectErrorsChange_() {
    this.delegate.setItemCollectsErrors(this.data.id, this.$$("#collect-errors").checked);
  },
  onExtensionWebSiteTap_() {
    this.delegate.openUrl(this.data.manifestHomePageUrl);
  },
  onViewInStoreTap_() {
    this.delegate.openUrl(this.data.webStoreUrl);
  },
  computeDependentEntry_(item) {
    return loadTimeData.getStringF("itemDependentEntry", item.name, item.id);
  },
  computeSourceString_() {
    return this.data.locationText || getItemSourceString(getItemSource(this.data));
  },
  getIndicatorIcon_(type) {
    switch (type) {
      case "POLICY":
        return "cr20:domain";
      default:
        return "";
    }
  },
  hasPermissions_() {
    return this.data.permissions.simplePermissions.length > 0 || this.hasRuntimeHostPermissions_();
  },
  hasRuntimeHostPermissions_() {
    return !!this.data.permissions.runtimeHostPermissions;
  },
  showSiteAccessContent_() {
    return this.showFreeformRuntimeHostPermissions_() || this.showHostPermissionsToggleList_();
  },
  showFreeformRuntimeHostPermissions_() {
    return this.hasRuntimeHostPermissions_() && this.data.permissions.runtimeHostPermissions.hasAllHosts;
  },
  showHostPermissionsToggleList_() {
    return this.hasRuntimeHostPermissions_() && !this.data.permissions.runtimeHostPermissions.hasAllHosts;
  },
  showReloadButton_() {
    return getEnableControl(this.data) === EnableControl.RELOAD;
  },
  showRepairButton_() {
    return getEnableControl(this.data) === EnableControl.REPAIR;
  },
  showEnableToggle_() {
    const enableControl = getEnableControl(this.data);
    return enableControl === EnableControl.ENABLE_TOGGLE || enableControl === EnableControl.REPAIR;
  },
});
// Copyright (c) 2011 The Chromium Authors. All rights reserved.
class DragWrapper {
  constructor(target, delegate) {
    this.dragEnters_ = 0;
    this.target_ = target;
    this.delegate_ = delegate;
    target.addEventListener("dragenter", (e) => this.onDragEnter_(e));
    target.addEventListener("dragover", (e) => this.onDragOver_(e));
    target.addEventListener("drop", (e) => this.onDrop_(e));
    target.addEventListener("dragleave", (e) => this.onDragLeave_(e));
  }
  get isCurrentDragTarget() {
    return this.target_.classList.contains("drag-target");
  }
  onDragEnter_(e) {
    if (++this.dragEnters_ === 1) {
      if (this.delegate_.shouldAcceptDrag(e)) {
        this.target_.classList.add("drag-target");
        this.delegate_.doDragEnter(e);
      }
    } else {
      this.onDragOver_(e);
    }
  }
  onDragOver_(e) {
    if (!this.target_.classList.contains("drag-target")) {
      return;
    }
    this.delegate_.doDragOver(e);
  }
  onDrop_(e) {
    this.dragEnters_ = 0;
    if (!this.target_.classList.contains("drag-target")) {
      return;
    }
    this.target_.classList.remove("drag-target");
    this.delegate_.doDrop(e);
  }
  onDragLeave_(e) {
    if (--this.dragEnters_ > 0) {
      return;
    }
    this.target_.classList.remove("drag-target");
    this.delegate_.doDragLeave(e);
  }
}
// Copyright 2016 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style" scope="cr-search-field">
      :host {
        display: flex;
        user-select: none;
      }

      #searchIcon {
        align-self: center;
        height: 16px;
        padding: 4px;
        vertical-align: middle;
        width: 16px;
      }

      #searchInput {
        --cr-input-background-color: transparent;
        --cr-input-border-bottom: 1px solid var(--cr-secondary-text-color);
        --cr-input-border-radius: 0;
        --cr-input-error-display: none;
        --cr-input-min-height: 24px;
        --cr-input-padding-end: 0;
        --cr-input-padding-start: 0;
        --cr-input-padding-bottom: 2px;
        --cr-input-padding-top: 2px;
        align-self: stretch;
        color: var(--cr-primary-text-color);
        display: block;
        font-size: 92.3076923%;
        width: 160px;
      }

      :host([has-search-text]) #searchInput {
        --cr-input-padding-end: 20px;
      }

      #clearSearch {
        --cr-icon-button-icon-size: 16px;
        --cr-icon-button-size: 24px;
        margin-inline-end: -4px;
        margin-inline-start: 4px;
        position: absolute;
        right: 0;
      }

      :host-context([dir="rtl"]) #clearSearch {
        left: 0;
        right: auto;
      }
    </style>
    <iron-icon id="searchIcon" icon="cr:search"></iron-icon>
    <cr-input id="searchInput" on-search="onSearchTermSearch" on-input="onSearchTermInput" aria-label$="[[label]]" type="search" autofocus="[[autofocus]]" placeholder="[[label]]" spellcheck="false">
      <cr-icon-button id="clearSearch" class="icon-cancel" hidden$="[[!hasSearchText]]" slot="suffix" on-click="onTapClear_" title="[[clearLabel]]"> </cr-icon-button>
    </cr-input>
    <!--_html_template_end_-->`,
  is: "cr-search-field",
  behaviors: [CrSearchFieldBehavior],
  properties: {
    autofocus: {
      type: Boolean,
      value: false,
    },
  },
  getSearchInput() {
    return this.$.searchInput;
  },
  onTapClear_() {
    this.setValue("");
    setTimeout(() => {
      this.$.searchInput.focus();
    });
  },
});
// Copyright 2016 The Chromium Authors. All rights reserved.
var PromiseResolver = class {
  constructor() {
    this.resolve_;
    this.reject_;
    this.isFulfilled_ = false;
    this.promise_ = new Promise((resolve, reject) => {
      this.resolve_ = (resolution) => {
        resolve(resolution);
        this.isFulfilled_ = true;
      };
      this.reject_ = (reason) => {
        reject(reason);
        this.isFulfilled_ = true;
      };
    });
  }
  get isFulfilled() {
    return this.isFulfilled_;
  }
  set isFulfilled(i) {
    assertNotReached();
  }
  get promise() {
    return this.promise_;
  }
  set promise(p) {
    assertNotReached();
  }
  get resolve() {
    return this.resolve_;
  }
  set resolve(r) {
    assertNotReached();
  }
  get reject() {
    return this.reject_;
  }
  set reject(s) {
    assertNotReached();
  }
};
// Copyright 2015 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="cr-expand-button">
      :host {
        align-items: center;
        cursor: pointer;
        display: flex;
        outline: none;
      }

      :host([disabled]) {
        opacity: 0.65;
        pointer-events: none;
      }

      :host([disabled]) cr-icon-button {
        display: var(--cr-expand-button-disabled-display, initial);
      }

      #label {
        flex: 1;
        padding: var(--cr-section-vertical-padding) 0;
      }

      cr-icon-button {
        --cr-icon-button-size: var(--cr-expand-button-size, 36px);
      }
    </style>

    <div id="label"><slot></slot></div>
    <cr-icon-button id="icon" aria-labelledby="label" disabled="[[disabled]]" tabindex="[[tabIndex]]"></cr-icon-button>
    <!--_html_template_end_-->`,
  is: "cr-expand-button",
  properties: {
    expanded: {
      type: Boolean,
      value: false,
      notify: true,
      observer: "onExpandedChange_",
    },
    disabled: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
    },
    alt: {
      type: String,
      observer: "onAltChange_",
    },
    tabIndex: {
      type: Number,
      value: 0,
    },
  },
  observers: ["updateAriaExpanded_(disabled, expanded)"],
  listeners: {
    click: "toggleExpand_",
  },
  get noink() {
    return this.$.icon.noink;
  },
  set noink(value) {
    this.$.icon.noink = value;
  },
  focus() {
    this.$.icon.focus();
  },
  onAltChange_() {
    if (this.alt) {
      this.$.icon.removeAttribute("aria-labelledby");
      this.$.icon.setAttribute("aria-label", this.alt);
    } else {
      this.$.icon.removeAttribute("aria-label");
      this.$.icon.setAttribute("aria-labelledby", "label");
    }
  },
  onExpandedChange_() {
    this.$.icon.ironIcon = this.expanded ? "cr:expand-less" : "cr:expand-more";
  },
  toggleExpand_(event) {
    event.stopPropagation();
    event.preventDefault();
    this.scrollIntoViewIfNeeded();
    this.expanded = !this.expanded;
    focusWithoutInk(this.$.icon);
  },
  updateAriaExpanded_() {
    if (this.disabled) {
      this.$.icon.removeAttribute("aria-expanded");
    } else {
      this.$.icon.setAttribute("aria-expanded", this.expanded);
    }
  },
});
// Copyright 2019 The Chromium Authors. All rights reserved.
Polymer({
  is: "activity-log-history-item",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-icons cr-shared-style shared-style" scope="activity-log-history-item">
      :host {
        border-top: var(--cr-separator-line);
        display: block;

        padding-bottom: 8px;
        padding-inline-end: 8px;
        padding-inline-start: var(--cr-section-padding);
        padding-top: 8px;
      }

      #activity-item-main-row {
        align-items: center;
        display: flex;
        flex-direction: row;

        min-height: calc(var(--cr-section-min-height) - var(--separator-gap));
      }

      #activity-item-main-row .separator {
        margin: 0 calc(var(--cr-section-padding) + var(--cr-icon-ripple-margin));
      }

      #activity-item-main-row cr-expand-button {
        margin-inline-end: 6px;
      }

      #activity-call-and-count {
        display: flex;
        flex: 1;
        flex-direction: row;
        margin-inline-end: auto;
        max-width: var(--activity-log-call-and-count-width);
      }

      #activity-delete {
        margin: 0;
      }

      #activity-type {
        flex: 0 var(--activity-type-width);
      }

      #activity-key {
        flex: 1;
        margin-inline-start: 10px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
      }

      #activity-count {
        flex: 0 var(--activity-count-width);
        text-align: end;
      }

      .page-url {
        display: flex;
        flex-direction: row;
        margin-bottom: 10px;
        max-width: var(--activity-log-call-and-count-width);
      }

      .page-url-link {
        flex-grow: 1;
        margin-inline-end: 20px;
        margin-inline-start: 16px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
      }
    </style>
    <div actionable$="[[isExpandable_]]" id="activity-item-main-row" on-click="onExpandTap_">
      <div id="activity-call-and-count">
        <span id="activity-type">[[data.activityType]]</span>
        <span id="activity-key" title="[[data.key]]">[[data.key]]</span>
        <span id="activity-count">[[data.count]]</span>
      </div>
      <cr-expand-button expanded="{{data.expanded}}" hidden$="[[!isExpandable_]]"> </cr-expand-button>
      <div class="separator" hidden$="[[!isExpandable_]]"></div>
      <cr-icon-button id="activity-delete" class="icon-delete-gray" aria-describedby="api-call" aria-label="___clearEntry___" on-click="onDeleteTap_"></cr-icon-button>
    </div>
    <div id="page-url-list" hidden$="[[!data.expanded]]">
      <template is="dom-repeat" items="[[getPageUrls_(data)]]">
        <div class="page-url">
          <a class="page-url-link" href="[[item.page]]" target="_blank" title="[[item.page]]">[[item.page]]</a>
          <span class="page-url-count" hidden$="[[!shouldShowPageUrlCount_(data)]]"> [[item.count]] </span>
        </div>
      </template>
    </div>
    <!--_html_template_end_-->`,
  properties: {
    data: Object,
    isExpandable_: {
      type: Boolean,
      computed: "computeIsExpandable_(data.countsByUrl)",
    },
  },
  computeIsExpandable_() {
    return this.data.countsByUrl.size > 0;
  },
  getPageUrls_() {
    return Array.from(this.data.countsByUrl.entries())
      .map((e) => ({
        page: e[0],
        count: e[1],
      }))
      .sort(function(a, b) {
        if (a.count !== b.count) {
          return b.count - a.count;
        }
        return a.page < b.page ? -1 : a.page > b.page ? 1 : 0;
      });
  },
  onDeleteTap_(e) {
    e.stopPropagation();
    this.fire("delete-activity-log-item", Array.from(this.data.activityIds.values()));
  },
  onExpandTap_() {
    if (this.isExpandable_) {
      this.set("data.expanded", !this.data.expanded);
    }
  },
  shouldShowPageUrlCount_() {
    return this.data.countsByUrl.size > 1;
  },
});
// Copyright 2019 The Chromium Authors. All rights reserved.
const ActivityLogPageState = {
  LOADING: "loading",
  LOADED: "loaded",
};
function getActivityGroupKeysForContentScript_(activity) {
  assert(activity.activityType === chrome.activityLogPrivate.ExtensionActivityType.CONTENT_SCRIPT);
  if (!activity.args) {
    return [];
  }
  const parsedArgs = JSON.parse(activity.args);
  assert(Array.isArray(parsedArgs), "Invalid API data.");
  return parsedArgs;
}
function getActivityGroupKeysForWebRequest_(activity) {
  assert(activity.activityType === chrome.activityLogPrivate.ExtensionActivityType.WEB_REQUEST);
  const apiCall = activity.apiCall;
  const other = activity.other;
  if (!other || !other.webRequest) {
    return [apiCall];
  }
  const webRequest = JSON.parse(other.webRequest);
  assert(typeof webRequest === "object", "Invalid API data");
  return Object.keys(webRequest).length === 0 ? [apiCall] : Object.keys(webRequest).map((field) => `${apiCall} (${field})`);
}
function groupActivities(activityData) {
  const groupedActivities = new Map();
  for (const activity of activityData) {
    const activityId = activity.activityId;
    const activityType = activity.activityType;
    const count = activity.count;
    const pageUrl = activity.pageUrl;
    const isContentScript = activityType === chrome.activityLogPrivate.ExtensionActivityType.CONTENT_SCRIPT;
    const isWebRequest = activityType === chrome.activityLogPrivate.ExtensionActivityType.WEB_REQUEST;
    let activityGroupKeys = [activity.apiCall];
    if (isContentScript) {
      activityGroupKeys = getActivityGroupKeysForContentScript_(activity);
    } else if (isWebRequest) {
      activityGroupKeys = getActivityGroupKeysForWebRequest_(activity);
    }
    for (const key of activityGroupKeys) {
      if (!groupedActivities.has(key)) {
        const activityGroup = {
          activityIds: new Set([activityId]),
          key: key,
          count: count,
          activityType: activityType,
          countsByUrl: pageUrl ? new Map([[pageUrl, count]]) : new Map(),
          expanded: false,
        };
        groupedActivities.set(key, activityGroup);
      } else {
        const activityGroup = groupedActivities.get(key);
        activityGroup.activityIds.add(activityId);
        activityGroup.count += count;
        if (pageUrl) {
          const currentCount = activityGroup.countsByUrl.get(pageUrl) || 0;
          activityGroup.countsByUrl.set(pageUrl, currentCount + count);
        }
      }
    }
  }
  return groupedActivities;
}
function sortActivitiesByCallCount(groupedActivities) {
  return Array.from(groupedActivities.values()).sort((a, b) => {
    if (a.count !== b.count) {
      return b.count - a.count;
    }
    if (a.key < b.key) {
      return -1;
    }
    if (a.key > b.key) {
      return 1;
    }
    return 0;
  });
}
Polymer({
  is: "activity-log-history",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="shared-style" scope="activity-log-history">
      :host {
        --activity-log-call-and-count-width: 514px;
        --activity-type-width: 85px;
        --activity-count-width: 100px;

        display: flex;
        flex-direction: column;
      }

      cr-search-field {
        align-self: center;
        margin-inline-end: auto;
      }

      cr-icon-button {
        margin: 0;
      }

      .activity-table-headings {
        width: var(--activity-log-call-and-count-width);
      }

      #activity-list {
        overflow-y: auto;
      }

      #activity-type {
        flex: 0 var(--activity-type-width);
      }

      #activity-key {
        flex: 1;
        margin-inline-start: 10px;
      }

      #activity-count {
        flex: 0 var(--activity-count-width);
        text-align: end;
      }
    </style>
    <div class="activity-subpage-header">
      <cr-search-field label="___activityLogSearchLabel___" on-search-changed="onSearchChanged_"> </cr-search-field>
      <cr-button class="clear-activities-button" on-click="onClearActivitiesClick_"> ___clearActivities___ </cr-button>
      <cr-icon-button id="more-actions" iron-icon="cr:more-vert" title="___activityLogMoreActionsLabel___" on-click="onMoreActionsClick_"></cr-icon-button>
      <cr-action-menu role-description="___menu___">
        <button id="expand-all-button" class="dropdown-item" on-click="onExpandAllClick_">___activityLogExpandAll___</button>
        <button id="collapse-all-button" class="dropdown-item" on-click="onCollapseAllClick_">___activityLogCollapseAll___</button>
        <button id="export-button" class="dropdown-item" on-click="onExportClick_">___activityLogExportHistory___</button>
      </cr-action-menu>
    </div>
    <div
      id="loading-activities"
      class="activity-message"
      hidden$="[[!shouldShowLoadingMessage_(
        pageState_)]]"
    >
      <span>___loadingActivities___</span>
    </div>
    <div
      id="no-activities"
      class="activity-message"
      hidden$="[[!shouldShowEmptyActivityLogMessage_(
        pageState_, activityData_)]]"
    >
      <span>___noActivities___</span>
    </div>
    <div class="activity-table-headings" hidden$="[[!shouldShowActivities_(pageState_, activityData_)]]">
      <span id="activity-type">___activityLogTypeColumn___</span>
      <span id="activity-key">___activityLogNameColumn___</span>
      <span id="activity-count">___activityLogCountColumn___</span>
    </div>
    <div id="activity-list" hidden$="[[!shouldShowActivities_(pageState_, activityData_)]]">
      <template is="dom-repeat" items="[[activityData_]]">
        <activity-log-history-item data="[[item]]"> </activity-log-history-item>
      </template>
    </div>
    <!--_html_template_end_-->`,
  properties: {
    extensionId: String,
    delegate: Object,
    activityData_: {
      type: Array,
      value: () => [],
    },
    pageState_: {
      type: String,
      value: ActivityLogPageState.LOADING,
    },
    lastSearch_: {
      type: String,
      value: "",
    },
  },
  listeners: {
    "delete-activity-log-item": "deleteItem_",
  },
  dataFetchedResolver_: null,
  rawActivities_: "",
  whenDataFetched() {
    return this.dataFetchedResolver_.promise;
  },
  attached() {
    this.dataFetchedResolver_ = new PromiseResolver();
    this.refreshActivities_();
  },
  shouldShowEmptyActivityLogMessage_() {
    return this.pageState_ === ActivityLogPageState.LOADED && this.activityData_.length === 0;
  },
  shouldShowLoadingMessage_() {
    return this.pageState_ === ActivityLogPageState.LOADING;
  },
  shouldShowActivities_() {
    return this.pageState_ === ActivityLogPageState.LOADED && this.activityData_.length > 0;
  },
  onClearActivitiesClick_() {
    this.delegate.deleteActivitiesFromExtension(this.extensionId).then(() => {
      this.processActivities_([]);
    });
  },
  onMoreActionsClick_() {
    this.$$("cr-action-menu").showAt(assert(this.$$("cr-icon-button")));
  },
  expandItems_(expanded) {
    this.activityData_.forEach((item, index) => {
      if (item.countsByUrl.size > 0) {
        this.set(`activityData_.${index}.expanded`, expanded);
      }
    });
    this.$$("cr-action-menu").close();
  },
  onExpandAllClick_() {
    this.expandItems_(true);
  },
  onCollapseAllClick_() {
    this.expandItems_(false);
  },
  onExportClick_() {
    const fileName = `exported_activity_log_${this.extensionId}.json`;
    this.delegate.downloadActivities(this.rawActivities_, fileName);
  },
  deleteItem_(e) {
    const activityIds = e.detail;
    this.delegate.deleteActivitiesById(activityIds).then(() => {
      this.refreshActivities_();
    });
  },
  processActivities_(activityData) {
    this.pageState_ = ActivityLogPageState.LOADED;
    activityData.sort((a, b) => a.time - b.time);
    this.rawActivities_ = JSON.stringify(activityData);
    this.activityData_ = sortActivitiesByCallCount(groupActivities(activityData));
    if (!this.dataFetchedResolver_.isFulfilled) {
      this.dataFetchedResolver_.resolve();
    }
  },
  refreshActivities_() {
    if (this.lastSearch_ === "") {
      return this.getActivityLog_();
    }
    return this.getFilteredActivityLog_(this.lastSearch_);
  },
  getActivityLog_() {
    this.pageState_ = ActivityLogPageState.LOADING;
    return this.delegate.getExtensionActivityLog(this.extensionId).then((result) => {
      this.processActivities_(result.activities);
    });
  },
  getFilteredActivityLog_(searchTerm) {
    this.pageState_ = ActivityLogPageState.LOADING;
    return this.delegate.getFilteredExtensionActivityLog(this.extensionId, searchTerm).then((result) => {
      this.processActivities_(result.activities);
    });
  },
  onSearchChanged_(e) {
    const searchTerm = e.detail.replace(/\s+/g, "");
    if (searchTerm === this.lastSearch_) {
      return;
    }
    this.lastSearch_ = searchTerm;
    this.refreshActivities_();
  },
});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
var ORPHANS = new Set();
const IronResizableBehavior = {
  properties: {
    _parentResizable: {
      type: Object,
      observer: "_parentResizableChanged",
    },
    _notifyingDescendant: {
      type: Boolean,
      value: false,
    },
  },
  listeners: {
    "iron-request-resize-notifications": "_onIronRequestResizeNotifications",
  },
  created: function() {
    this._interestedResizables = [];
    this._boundNotifyResize = this.notifyResize.bind(this);
    this._boundOnDescendantIronResize = this._onDescendantIronResize.bind(this);
  },
  attached: function() {
    this._requestResizeNotifications();
  },
  detached: function() {
    if (this._parentResizable) {
      this._parentResizable.stopResizeNotificationsFor(this);
    } else {
      ORPHANS.delete(this);
      window.removeEventListener("resize", this._boundNotifyResize);
    }
    this._parentResizable = null;
  },
  notifyResize: function() {
    if (!this.isAttached) {
      return;
    }
    this._interestedResizables.forEach(function(resizable) {
      if (this.resizerShouldNotify(resizable)) {
        this._notifyDescendant(resizable);
      }
    }, this);
    this._fireResize();
  },
  assignParentResizable: function(parentResizable) {
    if (this._parentResizable) {
      this._parentResizable.stopResizeNotificationsFor(this);
    }
    this._parentResizable = parentResizable;
    if (parentResizable && parentResizable._interestedResizables.indexOf(this) === -1) {
      parentResizable._interestedResizables.push(this);
      parentResizable._subscribeIronResize(this);
    }
  },
  stopResizeNotificationsFor: function(target) {
    var index = this._interestedResizables.indexOf(target);
    if (index > -1) {
      this._interestedResizables.splice(index, 1);
      this._unsubscribeIronResize(target);
    }
  },
  _subscribeIronResize: function(target) {
    target.addEventListener("iron-resize", this._boundOnDescendantIronResize);
  },
  _unsubscribeIronResize: function(target) {
    target.removeEventListener("iron-resize", this._boundOnDescendantIronResize);
  },
  resizerShouldNotify: function(element) {
    return true;
  },
  _onDescendantIronResize: function(event) {
    if (this._notifyingDescendant) {
      event.stopPropagation();
      return;
    }
    if (!useShadow) {
      this._fireResize();
    }
  },
  _fireResize: function() {
    this.fire("iron-resize", null, {
      node: this,
      bubbles: false,
    });
  },
  _onIronRequestResizeNotifications: function(event) {
    var target = dom(event).rootTarget;
    if (target === this) {
      return;
    }
    target.assignParentResizable(this);
    this._notifyDescendant(target);
    event.stopPropagation();
  },
  _parentResizableChanged: function(parentResizable) {
    if (parentResizable) {
      window.removeEventListener("resize", this._boundNotifyResize);
    }
  },
  _notifyDescendant: function(descendant) {
    if (!this.isAttached) {
      return;
    }
    this._notifyingDescendant = true;
    descendant.notifyResize();
    this._notifyingDescendant = false;
  },
  _requestResizeNotifications: function() {
    if (!this.isAttached) {
      return;
    }
    if (document.readyState === "loading") {
      var _requestResizeNotifications = this._requestResizeNotifications.bind(this);
      document.addEventListener("readystatechange", function readystatechanged() {
        document.removeEventListener("readystatechange", readystatechanged);
        _requestResizeNotifications();
      });
    } else {
      this._findParent();
      if (!this._parentResizable) {
        ORPHANS.forEach(function(orphan) {
          if (orphan !== this) {
            orphan._findParent();
          }
        }, this);
        window.addEventListener("resize", this._boundNotifyResize);
        this.notifyResize();
      } else {
        this._parentResizable._interestedResizables.forEach(function(resizable) {
          if (resizable !== this) {
            resizable._findParent();
          }
        }, this);
      }
    }
  },
  _findParent: function() {
    this.assignParentResizable(null);
    this.fire("iron-request-resize-notifications", null, {
      node: this,
      bubbles: true,
      cancelable: true,
    });
    if (!this._parentResizable) {
      ORPHANS.add(this);
    } else {
      ORPHANS.delete(this);
    }
  },
};
/**
@license
Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const IronScrollTargetBehavior = {
  properties: {
    scrollTarget: {
      type: HTMLElement,
      value: function() {
        return this._defaultScrollTarget;
      },
    },
  },
  observers: ["_scrollTargetChanged(scrollTarget, isAttached)"],
  _shouldHaveListener: true,
  _scrollTargetChanged: function(scrollTarget, isAttached) {
    if (this._oldScrollTarget) {
      this._toggleScrollListener(false, this._oldScrollTarget);
      this._oldScrollTarget = null;
    }
    if (!isAttached) {
      return;
    }
    if (scrollTarget === "document") {
      this.scrollTarget = this._doc;
    } else if (typeof scrollTarget === "string") {
      var domHost = this.domHost;
      this.scrollTarget = domHost && domHost.$ ? domHost.$[scrollTarget] : dom(this.ownerDocument).querySelector("#" + scrollTarget);
    } else if (this._isValidScrollTarget()) {
      this._oldScrollTarget = scrollTarget;
      this._toggleScrollListener(this._shouldHaveListener, scrollTarget);
    }
  },
  _scrollHandler: function scrollHandler() { },
  get _defaultScrollTarget() {
    return this._doc;
  },
  get _doc() {
    return this.ownerDocument.documentElement;
  },
  get _scrollTop() {
    if (this._isValidScrollTarget()) {
      return this.scrollTarget === this._doc ? window.pageYOffset : this.scrollTarget.scrollTop;
    }
    return 0;
  },
  get _scrollLeft() {
    if (this._isValidScrollTarget()) {
      return this.scrollTarget === this._doc ? window.pageXOffset : this.scrollTarget.scrollLeft;
    }
    return 0;
  },
  set _scrollTop(top) {
    if (this.scrollTarget === this._doc) {
      window.scrollTo(window.pageXOffset, top);
    } else if (this._isValidScrollTarget()) {
      this.scrollTarget.scrollTop = top;
    }
  },
  set _scrollLeft(left) {
    if (this.scrollTarget === this._doc) {
      window.scrollTo(left, window.pageYOffset);
    } else if (this._isValidScrollTarget()) {
      this.scrollTarget.scrollLeft = left;
    }
  },
  scroll: function(leftOrOptions, top) {
    var left;
    if (typeof leftOrOptions === "object") {
      left = leftOrOptions.left;
      top = leftOrOptions.top;
    } else {
      left = leftOrOptions;
    }
    left = left || 0;
    top = top || 0;
    if (this.scrollTarget === this._doc) {
      window.scrollTo(left, top);
    } else if (this._isValidScrollTarget()) {
      this.scrollTarget.scrollLeft = left;
      this.scrollTarget.scrollTop = top;
    }
  },
  get _scrollTargetWidth() {
    if (this._isValidScrollTarget()) {
      return this.scrollTarget === this._doc ? window.innerWidth : this.scrollTarget.offsetWidth;
    }
    return 0;
  },
  get _scrollTargetHeight() {
    if (this._isValidScrollTarget()) {
      return this.scrollTarget === this._doc ? window.innerHeight : this.scrollTarget.offsetHeight;
    }
    return 0;
  },
  _isValidScrollTarget: function() {
    return this.scrollTarget instanceof HTMLElement;
  },
  _toggleScrollListener: function(yes, scrollTarget) {
    var eventTarget = scrollTarget === this._doc ? window : scrollTarget;
    if (yes) {
      if (!this._boundScrollHandler) {
        this._boundScrollHandler = this._scrollHandler.bind(this);
        eventTarget.addEventListener("scroll", this._boundScrollHandler);
      }
    } else {
      if (this._boundScrollHandler) {
        eventTarget.removeEventListener("scroll", this._boundScrollHandler);
        this._boundScrollHandler = null;
      }
    }
  },
  toggleScrollListener: function(yes) {
    this._shouldHaveListener = yes;
    this._toggleScrollListener(yes, this.scrollTarget);
  },
};
/**
@license
Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
var IOS = navigator.userAgent.match(/iP(?:hone|ad;(?: U;)? CPU) OS (\d+)/);
var IOS_TOUCH_SCROLLING = IOS && IOS[1] >= 8;
var DEFAULT_PHYSICAL_COUNT = 3;
var HIDDEN_Y = "-10000px";
var SECRET_TABINDEX = -100;
Polymer({
  _template: html`<!--css-build:shadow--><style scope="iron-list">
      :host {
        display: block;
      }

      @media only screen and (-webkit-max-device-pixel-ratio: 1) {
        :host {
          will-change: transform;
        }
      }

      #items {
        position: relative;
      }

      :host(:not([grid])) #items > ::slotted(*) {
        width: 100%;
      }

      #items > ::slotted(*) {
        box-sizing: border-box;
        margin: 0;
        position: absolute;
        top: 0;
        will-change: transform;
      }
    </style>

    <array-selector id="selector" items="{{items}}" selected="{{selectedItems}}" selected-item="{{selectedItem}}"></array-selector>

    <div id="items">
      <slot></slot>
    </div> `,
  is: "iron-list",
  properties: {
    items: {
      type: Array,
    },
    as: {
      type: String,
      value: "item",
    },
    indexAs: {
      type: String,
      value: "index",
    },
    selectedAs: {
      type: String,
      value: "selected",
    },
    grid: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      observer: "_gridChanged",
    },
    selectionEnabled: {
      type: Boolean,
      value: false,
    },
    selectedItem: {
      type: Object,
      notify: true,
    },
    selectedItems: {
      type: Object,
      notify: true,
    },
    multiSelection: {
      type: Boolean,
      value: false,
    },
    scrollOffset: {
      type: Number,
      value: 0,
    },
    preserveFocus: {
      type: Boolean,
      value: false,
    },
  },
  observers: ["_itemsChanged(items.*)", "_selectionEnabledChanged(selectionEnabled)", "_multiSelectionChanged(multiSelection)", "_setOverflow(scrollTarget, scrollOffset)"],
  behaviors: [Templatizer, IronResizableBehavior, IronScrollTargetBehavior, OptionalMutableDataBehavior],
  _ratio: 0.5,
  _scrollerPaddingTop: 0,
  _scrollPosition: 0,
  _physicalSize: 0,
  _physicalAverage: 0,
  _physicalAverageCount: 0,
  _physicalTop: 0,
  _virtualCount: 0,
  _estScrollHeight: 0,
  _scrollHeight: 0,
  _viewportHeight: 0,
  _viewportWidth: 0,
  _physicalItems: null,
  _physicalSizes: null,
  _firstVisibleIndexVal: null,
  _lastVisibleIndexVal: null,
  _maxPages: 2,
  _focusedItem: null,
  _focusedVirtualIndex: -1,
  _focusedPhysicalIndex: -1,
  _offscreenFocusedItem: null,
  _focusBackfillItem: null,
  _itemsPerRow: 1,
  _itemWidth: 0,
  _rowHeight: 0,
  _templateCost: 0,
  _parentModel: true,
  get _physicalBottom() {
    return this._physicalTop + this._physicalSize;
  },
  get _scrollBottom() {
    return this._scrollPosition + this._viewportHeight;
  },
  get _virtualEnd() {
    return this._virtualStart + this._physicalCount - 1;
  },
  get _hiddenContentSize() {
    var size = this.grid ? this._physicalRows * this._rowHeight : this._physicalSize;
    return size - this._viewportHeight;
  },
  get _itemsParent() {
    return dom(dom(this._userTemplate).parentNode);
  },
  get _maxScrollTop() {
    return this._estScrollHeight - this._viewportHeight + this._scrollOffset;
  },
  get _maxVirtualStart() {
    var virtualCount = this._convertIndexToCompleteRow(this._virtualCount);
    return Math.max(0, virtualCount - this._physicalCount);
  },
  set _virtualStart(val) {
    val = this._clamp(val, 0, this._maxVirtualStart);
    if (this.grid) {
      val = val - (val % this._itemsPerRow);
    }
    this._virtualStartVal = val;
  },
  get _virtualStart() {
    return this._virtualStartVal || 0;
  },
  set _physicalStart(val) {
    val = val % this._physicalCount;
    if (val < 0) {
      val = this._physicalCount + val;
    }
    if (this.grid) {
      val = val - (val % this._itemsPerRow);
    }
    this._physicalStartVal = val;
  },
  get _physicalStart() {
    return this._physicalStartVal || 0;
  },
  get _physicalEnd() {
    return (this._physicalStart + this._physicalCount - 1) % this._physicalCount;
  },
  set _physicalCount(val) {
    this._physicalCountVal = val;
  },
  get _physicalCount() {
    return this._physicalCountVal || 0;
  },
  get _optPhysicalSize() {
    return this._viewportHeight === 0 ? Infinity : this._viewportHeight * this._maxPages;
  },
  get _isVisible() {
    return Boolean(this.offsetWidth || this.offsetHeight);
  },
  get firstVisibleIndex() {
    var idx = this._firstVisibleIndexVal;
    if (idx == null) {
      var physicalOffset = this._physicalTop + this._scrollOffset;
      idx =
        this._iterateItems(function(pidx, vidx) {
          physicalOffset += this._getPhysicalSizeIncrement(pidx);
          if (physicalOffset > this._scrollPosition) {
            return this.grid ? vidx - (vidx % this._itemsPerRow) : vidx;
          }
          if (this.grid && this._virtualCount - 1 === vidx) {
            return vidx - (vidx % this._itemsPerRow);
          }
        }) || 0;
      this._firstVisibleIndexVal = idx;
    }
    return idx;
  },
  get lastVisibleIndex() {
    var idx = this._lastVisibleIndexVal;
    if (idx == null) {
      if (this.grid) {
        idx = Math.min(this._virtualCount, this.firstVisibleIndex + this._estRowsInView * this._itemsPerRow - 1);
      } else {
        var physicalOffset = this._physicalTop + this._scrollOffset;
        this._iterateItems(function(pidx, vidx) {
          if (physicalOffset < this._scrollBottom) {
            idx = vidx;
          }
          physicalOffset += this._getPhysicalSizeIncrement(pidx);
        });
      }
      this._lastVisibleIndexVal = idx;
    }
    return idx;
  },
  get _defaultScrollTarget() {
    return this;
  },
  get _virtualRowCount() {
    return Math.ceil(this._virtualCount / this._itemsPerRow);
  },
  get _estRowsInView() {
    return Math.ceil(this._viewportHeight / this._rowHeight);
  },
  get _physicalRows() {
    return Math.ceil(this._physicalCount / this._itemsPerRow);
  },
  get _scrollOffset() {
    return this._scrollerPaddingTop + this.scrollOffset;
  },
  ready: function() {
    this.addEventListener("focus", this._didFocus.bind(this), true);
  },
  attached: function() {
    this._debounce("_render", this._render, animationFrame);
    this.listen(this, "iron-resize", "_resizeHandler");
    this.listen(this, "keydown", "_keydownHandler");
  },
  detached: function() {
    this.unlisten(this, "iron-resize", "_resizeHandler");
    this.unlisten(this, "keydown", "_keydownHandler");
  },
  _setOverflow: function(scrollTarget) {
    this.style.webkitOverflowScrolling = scrollTarget === this ? "touch" : "";
    this.style.overflowY = scrollTarget === this ? "auto" : "";
    this._lastVisibleIndexVal = null;
    this._firstVisibleIndexVal = null;
    this._debounce("_render", this._render, animationFrame);
  },
  updateViewportBoundaries: function() {
    var styles = window.getComputedStyle(this);
    this._scrollerPaddingTop = this.scrollTarget === this ? 0 : parseInt(styles["padding-top"], 10);
    this._isRTL = Boolean(styles.direction === "rtl");
    this._viewportWidth = this.$.items.offsetWidth;
    this._viewportHeight = this._scrollTargetHeight;
    this.grid && this._updateGridMetrics();
  },
  _scrollHandler: function() {
    var scrollTop = Math.max(0, Math.min(this._maxScrollTop, this._scrollTop));
    var delta = scrollTop - this._scrollPosition;
    var isScrollingDown = delta >= 0;
    this._scrollPosition = scrollTop;
    this._firstVisibleIndexVal = null;
    this._lastVisibleIndexVal = null;
    if (Math.abs(delta) > this._physicalSize && this._physicalSize > 0) {
      delta = delta - this._scrollOffset;
      var idxAdjustment = Math.round(delta / this._physicalAverage) * this._itemsPerRow;
      this._virtualStart = this._virtualStart + idxAdjustment;
      this._physicalStart = this._physicalStart + idxAdjustment;
      this._physicalTop = Math.min(Math.floor(this._virtualStart / this._itemsPerRow) * this._physicalAverage, this._scrollPosition);
      this._update();
    } else if (this._physicalCount > 0) {
      var reusables = this._getReusables(isScrollingDown);
      if (isScrollingDown) {
        this._physicalTop = reusables.physicalTop;
        this._virtualStart = this._virtualStart + reusables.indexes.length;
        this._physicalStart = this._physicalStart + reusables.indexes.length;
      } else {
        this._virtualStart = this._virtualStart - reusables.indexes.length;
        this._physicalStart = this._physicalStart - reusables.indexes.length;
      }
      this._update(reusables.indexes, isScrollingDown ? null : reusables.indexes);
      this._debounce("_increasePoolIfNeeded", this._increasePoolIfNeeded.bind(this, 0), microTask);
    }
  },
  _getReusables: function(fromTop) {
    var ith, lastIth, offsetContent, physicalItemHeight;
    var idxs = [];
    var protectedOffsetContent = this._hiddenContentSize * this._ratio;
    var virtualStart = this._virtualStart;
    var virtualEnd = this._virtualEnd;
    var physicalCount = this._physicalCount;
    var top = this._physicalTop + this._scrollOffset;
    var bottom = this._physicalBottom + this._scrollOffset;
    var scrollTop = this._scrollPosition;
    var scrollBottom = this._scrollBottom;
    if (fromTop) {
      ith = this._physicalStart;
      lastIth = this._physicalEnd;
      offsetContent = scrollTop - top;
    } else {
      ith = this._physicalEnd;
      lastIth = this._physicalStart;
      offsetContent = bottom - scrollBottom;
    }
    while (true) {
      physicalItemHeight = this._getPhysicalSizeIncrement(ith);
      offsetContent = offsetContent - physicalItemHeight;
      if (idxs.length >= physicalCount || offsetContent <= protectedOffsetContent) {
        break;
      }
      if (fromTop) {
        if (virtualEnd + idxs.length + 1 >= this._virtualCount) {
          break;
        }
        if (top + physicalItemHeight >= scrollTop - this._scrollOffset) {
          break;
        }
        idxs.push(ith);
        top = top + physicalItemHeight;
        ith = (ith + 1) % physicalCount;
      } else {
        if (virtualStart - idxs.length <= 0) {
          break;
        }
        if (top + this._physicalSize - physicalItemHeight <= scrollBottom) {
          break;
        }
        idxs.push(ith);
        top = top - physicalItemHeight;
        ith = ith === 0 ? physicalCount - 1 : ith - 1;
      }
    }
    return {
      indexes: idxs,
      physicalTop: top - this._scrollOffset,
    };
  },
  _update: function(itemSet, movingUp) {
    if ((itemSet && itemSet.length === 0) || this._physicalCount === 0) {
      return;
    }
    this._manageFocus();
    this._assignModels(itemSet);
    this._updateMetrics(itemSet);
    if (movingUp) {
      while (movingUp.length) {
        var idx = movingUp.pop();
        this._physicalTop -= this._getPhysicalSizeIncrement(idx);
      }
    }
    this._positionItems();
    this._updateScrollerSize();
  },
  _createPool: function(size) {
    this._ensureTemplatized();
    var i, inst;
    var physicalItems = new Array(size);
    for (i = 0; i < size; i++) {
      inst = this.stamp(null);
      physicalItems[i] = inst.root.querySelector("*");
      this._itemsParent.appendChild(inst.root);
    }
    return physicalItems;
  },
  _isClientFull: function() {
    return this._scrollBottom != 0 && this._physicalBottom - 1 >= this._scrollBottom && this._physicalTop <= this._scrollPosition;
  },
  _increasePoolIfNeeded: function(count) {
    var nextPhysicalCount = this._clamp(this._physicalCount + count, DEFAULT_PHYSICAL_COUNT, this._virtualCount - this._virtualStart);
    nextPhysicalCount = this._convertIndexToCompleteRow(nextPhysicalCount);
    if (this.grid) {
      var correction = nextPhysicalCount % this._itemsPerRow;
      if (correction && nextPhysicalCount - correction <= this._physicalCount) {
        nextPhysicalCount += this._itemsPerRow;
      }
      nextPhysicalCount -= correction;
    }
    var delta = nextPhysicalCount - this._physicalCount;
    var nextIncrease = Math.round(this._physicalCount * 0.5);
    if (delta < 0) {
      return;
    }
    if (delta > 0) {
      var ts = window.performance.now();
      [].push.apply(this._physicalItems, this._createPool(delta));
      for (var i = 0; i < delta; i++) {
        this._physicalSizes.push(0);
      }
      this._physicalCount = this._physicalCount + delta;
      if (this._physicalStart > this._physicalEnd && this._isIndexRendered(this._focusedVirtualIndex) && this._getPhysicalIndex(this._focusedVirtualIndex) < this._physicalEnd) {
        this._physicalStart = this._physicalStart + delta;
      }
      this._update();
      this._templateCost = (window.performance.now() - ts) / delta;
      nextIncrease = Math.round(this._physicalCount * 0.5);
    }
    if (this._virtualEnd >= this._virtualCount - 1 || nextIncrease === 0);
    else if (!this._isClientFull()) {
      this._debounce("_increasePoolIfNeeded", this._increasePoolIfNeeded.bind(this, nextIncrease), microTask);
    } else if (this._physicalSize < this._optPhysicalSize) {
      this._debounce("_increasePoolIfNeeded", this._increasePoolIfNeeded.bind(this, this._clamp(Math.round(50 / this._templateCost), 1, nextIncrease)), idlePeriod);
    }
  },
  _render: function() {
    if (!this.isAttached || !this._isVisible) {
      return;
    }
    if (this._physicalCount !== 0) {
      var reusables = this._getReusables(true);
      this._physicalTop = reusables.physicalTop;
      this._virtualStart = this._virtualStart + reusables.indexes.length;
      this._physicalStart = this._physicalStart + reusables.indexes.length;
      this._update(reusables.indexes);
      this._update();
      this._increasePoolIfNeeded(0);
    } else if (this._virtualCount > 0) {
      this.updateViewportBoundaries();
      this._increasePoolIfNeeded(DEFAULT_PHYSICAL_COUNT);
    }
  },
  _ensureTemplatized: function() {
    if (this.ctor) {
      return;
    }
    this._userTemplate = this.queryEffectiveChildren("template");
    if (!this._userTemplate) {
      console.warn("iron-list requires a template to be provided in light-dom");
    }
    var instanceProps = {};
    instanceProps.__key__ = true;
    instanceProps[this.as] = true;
    instanceProps[this.indexAs] = true;
    instanceProps[this.selectedAs] = true;
    instanceProps.tabIndex = true;
    this._instanceProps = instanceProps;
    this.templatize(this._userTemplate, this.mutableData);
  },
  _gridChanged: function(newGrid, oldGrid) {
    if (typeof oldGrid === "undefined") return;
    this.notifyResize();
    flush();
    newGrid && this._updateGridMetrics();
  },
  _getFocusedElement: function() {
    function doSearch(node, query) {
      let result = null;
      let type = node.nodeType;
      if (type == Node.ELEMENT_NODE || type == Node.DOCUMENT_FRAGMENT_NODE) result = node.querySelector(query);
      if (result) return result;
      let child = node.firstChild;
      while (child !== null && result === null) {
        result = doSearch(child, query);
        child = child.nextSibling;
      }
      if (result) return result;
      const shadowRoot = node.shadowRoot;
      return shadowRoot ? doSearch(shadowRoot, query) : null;
    }
    const focusWithin = doSearch(this, ":focus-within");
    return focusWithin ? doSearch(focusWithin, ":focus") : null;
  },
  _itemsChanged: function(change) {
    var rendering = /^items(\.splices){0,1}$/.test(change.path);
    var lastFocusedIndex, focusedElement;
    if (rendering && this.preserveFocus) {
      lastFocusedIndex = this._focusedVirtualIndex;
      focusedElement = this._getFocusedElement();
    }
    var preservingFocus = rendering && this.preserveFocus && focusedElement;
    if (change.path === "items") {
      this._virtualStart = 0;
      this._physicalTop = 0;
      this._virtualCount = this.items ? this.items.length : 0;
      this._physicalIndexForKey = {};
      this._firstVisibleIndexVal = null;
      this._lastVisibleIndexVal = null;
      this._physicalCount = this._physicalCount || 0;
      this._physicalItems = this._physicalItems || [];
      this._physicalSizes = this._physicalSizes || [];
      this._physicalStart = 0;
      if (this._scrollTop > this._scrollOffset && !preservingFocus) {
        this._resetScrollPosition(0);
      }
      this._removeFocusedItem();
      this._debounce("_render", this._render, animationFrame);
    } else if (change.path === "items.splices") {
      this._adjustVirtualIndex(change.value.indexSplices);
      this._virtualCount = this.items ? this.items.length : 0;
      var itemAddedOrRemoved = change.value.indexSplices.some(function(splice) {
        return splice.addedCount > 0 || splice.removed.length > 0;
      });
      if (itemAddedOrRemoved) {
        var activeElement = this._getActiveElement();
        if (this.contains(activeElement)) {
          activeElement.blur();
        }
      }
      var affectedIndexRendered = change.value.indexSplices.some(function(splice) {
        return splice.index + splice.addedCount >= this._virtualStart && splice.index <= this._virtualEnd;
      }, this);
      if (!this._isClientFull() || affectedIndexRendered) {
        this._debounce("_render", this._render, animationFrame);
      }
    } else if (change.path !== "items.length") {
      this._forwardItemPath(change.path, change.value);
    }
    if (preservingFocus) {
      flush();
      focusedElement.blur();
      this._focusPhysicalItem(Math.min(this.items.length - 1, lastFocusedIndex));
      if (!this._isIndexVisible(this._focusedVirtualIndex)) {
        this.scrollToIndex(this._focusedVirtualIndex);
      }
    }
  },
  _forwardItemPath: function(path, value) {
    path = path.slice(6);
    var dot = path.indexOf(".");
    if (dot === -1) {
      dot = path.length;
    }
    var isIndexRendered;
    var pidx;
    var inst;
    var offscreenInstance = this.modelForElement(this._offscreenFocusedItem);
    var vidx = parseInt(path.substring(0, dot), 10);
    isIndexRendered = this._isIndexRendered(vidx);
    if (isIndexRendered) {
      pidx = this._getPhysicalIndex(vidx);
      inst = this.modelForElement(this._physicalItems[pidx]);
    } else if (offscreenInstance) {
      inst = offscreenInstance;
    }
    if (!inst || inst[this.indexAs] !== vidx) {
      return;
    }
    path = path.substring(dot + 1);
    path = this.as + (path ? "." + path : "");
    inst._setPendingPropertyOrPath(path, value, false, true);
    inst._flushProperties && inst._flushProperties();
    if (isIndexRendered) {
      this._updateMetrics([pidx]);
      this._positionItems();
      this._updateScrollerSize();
    }
  },
  _adjustVirtualIndex: function(splices) {
    splices.forEach(function(splice) {
      splice.removed.forEach(this._removeItem, this);
      if (splice.index < this._virtualStart) {
        var delta = Math.max(splice.addedCount - splice.removed.length, splice.index - this._virtualStart);
        this._virtualStart = this._virtualStart + delta;
        if (this._focusedVirtualIndex >= 0) {
          this._focusedVirtualIndex = this._focusedVirtualIndex + delta;
        }
      }
    }, this);
  },
  _removeItem: function(item) {
    this.$.selector.deselect(item);
    if (this._focusedItem && this.modelForElement(this._focusedItem)[this.as] === item) {
      this._removeFocusedItem();
    }
  },
  _iterateItems: function(fn, itemSet) {
    var pidx, vidx, rtn, i;
    if (arguments.length === 2 && itemSet) {
      for (i = 0; i < itemSet.length; i++) {
        pidx = itemSet[i];
        vidx = this._computeVidx(pidx);
        if ((rtn = fn.call(this, pidx, vidx)) != null) {
          return rtn;
        }
      }
    } else {
      pidx = this._physicalStart;
      vidx = this._virtualStart;
      for (; pidx < this._physicalCount; pidx++, vidx++) {
        if ((rtn = fn.call(this, pidx, vidx)) != null) {
          return rtn;
        }
      }
      for (pidx = 0; pidx < this._physicalStart; pidx++, vidx++) {
        if ((rtn = fn.call(this, pidx, vidx)) != null) {
          return rtn;
        }
      }
    }
  },
  _computeVidx: function(pidx) {
    if (pidx >= this._physicalStart) {
      return this._virtualStart + (pidx - this._physicalStart);
    }
    return this._virtualStart + (this._physicalCount - this._physicalStart) + pidx;
  },
  _assignModels: function(itemSet) {
    this._iterateItems(function(pidx, vidx) {
      var el = this._physicalItems[pidx];
      var item = this.items && this.items[vidx];
      if (item != null) {
        var inst = this.modelForElement(el);
        inst.__key__ = null;
        this._forwardProperty(inst, this.as, item);
        this._forwardProperty(inst, this.selectedAs, this.$.selector.isSelected(item));
        this._forwardProperty(inst, this.indexAs, vidx);
        this._forwardProperty(inst, "tabIndex", this._focusedVirtualIndex === vidx ? 0 : -1);
        this._physicalIndexForKey[inst.__key__] = pidx;
        inst._flushProperties && inst._flushProperties(true);
        el.removeAttribute("hidden");
      } else {
        el.setAttribute("hidden", "");
      }
    }, itemSet);
  },
  _updateMetrics: function(itemSet) {
    flush();
    var newPhysicalSize = 0;
    var oldPhysicalSize = 0;
    var prevAvgCount = this._physicalAverageCount;
    var prevPhysicalAvg = this._physicalAverage;
    this._iterateItems(function(pidx, vidx) {
      oldPhysicalSize += this._physicalSizes[pidx];
      this._physicalSizes[pidx] = this._physicalItems[pidx].offsetHeight;
      newPhysicalSize += this._physicalSizes[pidx];
      this._physicalAverageCount += this._physicalSizes[pidx] ? 1 : 0;
    }, itemSet);
    if (this.grid) {
      this._updateGridMetrics();
      this._physicalSize = Math.ceil(this._physicalCount / this._itemsPerRow) * this._rowHeight;
    } else {
      oldPhysicalSize = this._itemsPerRow === 1 ? oldPhysicalSize : Math.ceil(this._physicalCount / this._itemsPerRow) * this._rowHeight;
      this._physicalSize = this._physicalSize + newPhysicalSize - oldPhysicalSize;
      this._itemsPerRow = 1;
    }
    if (this._physicalAverageCount !== prevAvgCount) {
      this._physicalAverage = Math.round((prevPhysicalAvg * prevAvgCount + newPhysicalSize) / this._physicalAverageCount);
    }
  },
  _updateGridMetrics: function() {
    this._itemWidth = this._physicalCount > 0 ? this._physicalItems[0].getBoundingClientRect().width : 200;
    this._rowHeight = this._physicalCount > 0 ? this._physicalItems[0].offsetHeight : 200;
    this._itemsPerRow = this._itemWidth ? Math.floor(this._viewportWidth / this._itemWidth) : this._itemsPerRow;
  },
  _positionItems: function() {
    this._adjustScrollPosition();
    var y = this._physicalTop;
    if (this.grid) {
      var totalItemWidth = this._itemsPerRow * this._itemWidth;
      var rowOffset = (this._viewportWidth - totalItemWidth) / 2;
      this._iterateItems(function(pidx, vidx) {
        var modulus = vidx % this._itemsPerRow;
        var x = Math.floor(modulus * this._itemWidth + rowOffset);
        if (this._isRTL) {
          x = x * -1;
        }
        this.translate3d(x + "px", y + "px", 0, this._physicalItems[pidx]);
        if (this._shouldRenderNextRow(vidx)) {
          y += this._rowHeight;
        }
      });
    } else {
      const order = [];
      this._iterateItems(function(pidx, vidx) {
        const item = this._physicalItems[pidx];
        this.translate3d(0, y + "px", 0, item);
        y += this._physicalSizes[pidx];
        const itemId = item.id;
        if (itemId) {
          order.push(itemId);
        }
      });
      if (order.length) {
        this.setAttribute("aria-owns", order.join(" "));
      }
    }
  },
  _getPhysicalSizeIncrement: function(pidx) {
    if (!this.grid) {
      return this._physicalSizes[pidx];
    }
    if (this._computeVidx(pidx) % this._itemsPerRow !== this._itemsPerRow - 1) {
      return 0;
    }
    return this._rowHeight;
  },
  _shouldRenderNextRow: function(vidx) {
    return vidx % this._itemsPerRow === this._itemsPerRow - 1;
  },
  _adjustScrollPosition: function() {
    var deltaHeight = this._virtualStart === 0 ? this._physicalTop : Math.min(this._scrollPosition + this._physicalTop, 0);
    if (deltaHeight !== 0) {
      this._physicalTop = this._physicalTop - deltaHeight;
      var scrollTop = this._scrollPosition;
      if (!IOS_TOUCH_SCROLLING && scrollTop > 0) {
        this._resetScrollPosition(scrollTop - deltaHeight);
      }
    }
  },
  _resetScrollPosition: function(pos) {
    if (this.scrollTarget && pos >= 0) {
      this._scrollTop = pos;
      this._scrollPosition = this._scrollTop;
    }
  },
  _updateScrollerSize: function(forceUpdate) {
    if (this.grid) {
      this._estScrollHeight = this._virtualRowCount * this._rowHeight;
    } else {
      this._estScrollHeight = this._physicalBottom + Math.max(this._virtualCount - this._physicalCount - this._virtualStart, 0) * this._physicalAverage;
    }
    forceUpdate = forceUpdate || this._scrollHeight === 0;
    forceUpdate = forceUpdate || this._scrollPosition >= this._estScrollHeight - this._physicalSize;
    forceUpdate = forceUpdate || (this.grid && this.$.items.style.height < this._estScrollHeight);
    if (forceUpdate || Math.abs(this._estScrollHeight - this._scrollHeight) >= this._viewportHeight) {
      this.$.items.style.height = this._estScrollHeight + "px";
      this._scrollHeight = this._estScrollHeight;
    }
  },
  scrollToItem: function(item) {
    return this.scrollToIndex(this.items.indexOf(item));
  },
  scrollToIndex: function(idx) {
    if (typeof idx !== "number" || idx < 0 || idx > this.items.length - 1) {
      return;
    }
    flush();
    if (this._physicalCount === 0) {
      return;
    }
    idx = this._clamp(idx, 0, this._virtualCount - 1);
    if (!this._isIndexRendered(idx) || idx >= this._maxVirtualStart) {
      this._virtualStart = this.grid ? idx - this._itemsPerRow * 2 : idx - 1;
    }
    this._manageFocus();
    this._assignModels();
    this._updateMetrics();
    this._physicalTop = Math.floor(this._virtualStart / this._itemsPerRow) * this._physicalAverage;
    var currentTopItem = this._physicalStart;
    var currentVirtualItem = this._virtualStart;
    var targetOffsetTop = 0;
    var hiddenContentSize = this._hiddenContentSize;
    while (currentVirtualItem < idx && targetOffsetTop <= hiddenContentSize) {
      targetOffsetTop = targetOffsetTop + this._getPhysicalSizeIncrement(currentTopItem);
      currentTopItem = (currentTopItem + 1) % this._physicalCount;
      currentVirtualItem++;
    }
    this._updateScrollerSize(true);
    this._positionItems();
    this._resetScrollPosition(this._physicalTop + this._scrollOffset + targetOffsetTop);
    this._increasePoolIfNeeded(0);
    this._firstVisibleIndexVal = null;
    this._lastVisibleIndexVal = null;
  },
  _resetAverage: function() {
    this._physicalAverage = 0;
    this._physicalAverageCount = 0;
  },
  _resizeHandler: function() {
    this._debounce(
      "_render",
      function() {
        this._firstVisibleIndexVal = null;
        this._lastVisibleIndexVal = null;
        if (this._isVisible) {
          this.updateViewportBoundaries();
          this.toggleScrollListener(true);
          this._resetAverage();
          this._render();
        } else {
          this.toggleScrollListener(false);
        }
      },
      animationFrame
    );
  },
  selectItem: function(item) {
    return this.selectIndex(this.items.indexOf(item));
  },
  selectIndex: function(index) {
    if (index < 0 || index >= this._virtualCount) {
      return;
    }
    if (!this.multiSelection && this.selectedItem) {
      this.clearSelection();
    }
    if (this._isIndexRendered(index)) {
      var model = this.modelForElement(this._physicalItems[this._getPhysicalIndex(index)]);
      if (model) {
        model[this.selectedAs] = true;
      }
      this.updateSizeForIndex(index);
    }
    this.$.selector.selectIndex(index);
  },
  deselectItem: function(item) {
    return this.deselectIndex(this.items.indexOf(item));
  },
  deselectIndex: function(index) {
    if (index < 0 || index >= this._virtualCount) {
      return;
    }
    if (this._isIndexRendered(index)) {
      var model = this.modelForElement(this._physicalItems[this._getPhysicalIndex(index)]);
      model[this.selectedAs] = false;
      this.updateSizeForIndex(index);
    }
    this.$.selector.deselectIndex(index);
  },
  toggleSelectionForItem: function(item) {
    return this.toggleSelectionForIndex(this.items.indexOf(item));
  },
  toggleSelectionForIndex: function(index) {
    var isSelected = this.$.selector.isIndexSelected ? this.$.selector.isIndexSelected(index) : this.$.selector.isSelected(this.items[index]);
    isSelected ? this.deselectIndex(index) : this.selectIndex(index);
  },
  clearSelection: function() {
    this._iterateItems(function(pidx, vidx) {
      this.modelForElement(this._physicalItems[pidx])[this.selectedAs] = false;
    });
    this.$.selector.clearSelection();
  },
  _selectionEnabledChanged: function(selectionEnabled) {
    var handler = selectionEnabled ? this.listen : this.unlisten;
    handler.call(this, this, "tap", "_selectionHandler");
  },
  _selectionHandler: function(e) {
    var model = this.modelForElement(e.target);
    if (!model) {
      return;
    }
    var modelTabIndex, activeElTabIndex;
    var target = dom(e).path[0];
    var activeEl = this._getActiveElement();
    var physicalItem = this._physicalItems[this._getPhysicalIndex(model[this.indexAs])];
    if (target.localName === "input" || target.localName === "button" || target.localName === "select") {
      return;
    }
    modelTabIndex = model.tabIndex;
    model.tabIndex = SECRET_TABINDEX;
    activeElTabIndex = activeEl ? activeEl.tabIndex : -1;
    model.tabIndex = modelTabIndex;
    if (activeEl && physicalItem !== activeEl && physicalItem.contains(activeEl) && activeElTabIndex !== SECRET_TABINDEX) {
      return;
    }
    this.toggleSelectionForItem(model[this.as]);
  },
  _multiSelectionChanged: function(multiSelection) {
    this.clearSelection();
    this.$.selector.multi = multiSelection;
  },
  updateSizeForItem: function(item) {
    return this.updateSizeForIndex(this.items.indexOf(item));
  },
  updateSizeForIndex: function(index) {
    if (!this._isIndexRendered(index)) {
      return null;
    }
    this._updateMetrics([this._getPhysicalIndex(index)]);
    this._positionItems();
    return null;
  },
  _manageFocus: function() {
    var fidx = this._focusedVirtualIndex;
    if (fidx >= 0 && fidx < this._virtualCount) {
      if (this._isIndexRendered(fidx)) {
        this._restoreFocusedItem();
      } else {
        this._createFocusBackfillItem();
      }
    } else if (this._virtualCount > 0 && this._physicalCount > 0) {
      this._focusedPhysicalIndex = this._physicalStart;
      this._focusedVirtualIndex = this._virtualStart;
      this._focusedItem = this._physicalItems[this._physicalStart];
    }
  },
  _convertIndexToCompleteRow: function(idx) {
    this._itemsPerRow = this._itemsPerRow || 1;
    return this.grid ? Math.ceil(idx / this._itemsPerRow) * this._itemsPerRow : idx;
  },
  _isIndexRendered: function(idx) {
    return idx >= this._virtualStart && idx <= this._virtualEnd;
  },
  _isIndexVisible: function(idx) {
    return idx >= this.firstVisibleIndex && idx <= this.lastVisibleIndex;
  },
  _getPhysicalIndex: function(vidx) {
    return (this._physicalStart + (vidx - this._virtualStart)) % this._physicalCount;
  },
  focusItem: function(idx) {
    this._focusPhysicalItem(idx);
  },
  _focusPhysicalItem: function(idx) {
    if (idx < 0 || idx >= this._virtualCount) {
      return;
    }
    this._restoreFocusedItem();
    if (!this._isIndexRendered(idx)) {
      this.scrollToIndex(idx);
    }
    var physicalItem = this._physicalItems[this._getPhysicalIndex(idx)];
    var model = this.modelForElement(physicalItem);
    var focusable;
    model.tabIndex = SECRET_TABINDEX;
    if (physicalItem.tabIndex === SECRET_TABINDEX) {
      focusable = physicalItem;
    }
    if (!focusable) {
      focusable = dom(physicalItem).querySelector('[tabindex="' + SECRET_TABINDEX + '"]');
    }
    model.tabIndex = 0;
    this._focusedVirtualIndex = idx;
    focusable && focusable.focus();
  },
  _removeFocusedItem: function() {
    if (this._offscreenFocusedItem) {
      this._itemsParent.removeChild(this._offscreenFocusedItem);
    }
    this._offscreenFocusedItem = null;
    this._focusBackfillItem = null;
    this._focusedItem = null;
    this._focusedVirtualIndex = -1;
    this._focusedPhysicalIndex = -1;
  },
  _createFocusBackfillItem: function() {
    var fpidx = this._focusedPhysicalIndex;
    if (this._offscreenFocusedItem || this._focusedVirtualIndex < 0) {
      return;
    }
    if (!this._focusBackfillItem) {
      var inst = this.stamp(null);
      this._focusBackfillItem = inst.root.querySelector("*");
      this._itemsParent.appendChild(inst.root);
    }
    this._offscreenFocusedItem = this._physicalItems[fpidx];
    this.modelForElement(this._offscreenFocusedItem).tabIndex = 0;
    this._physicalItems[fpidx] = this._focusBackfillItem;
    this._focusedPhysicalIndex = fpidx;
    this.translate3d(0, HIDDEN_Y, 0, this._offscreenFocusedItem);
  },
  _restoreFocusedItem: function() {
    if (!this._offscreenFocusedItem || this._focusedVirtualIndex < 0) {
      return;
    }
    this._assignModels();
    var fpidx = (this._focusedPhysicalIndex = this._getPhysicalIndex(this._focusedVirtualIndex));
    var onScreenItem = this._physicalItems[fpidx];
    if (!onScreenItem) {
      return;
    }
    var onScreenInstance = this.modelForElement(onScreenItem);
    var offScreenInstance = this.modelForElement(this._offscreenFocusedItem);
    if (onScreenInstance[this.as] === offScreenInstance[this.as]) {
      this._focusBackfillItem = onScreenItem;
      onScreenInstance.tabIndex = -1;
      this._physicalItems[fpidx] = this._offscreenFocusedItem;
      this.translate3d(0, HIDDEN_Y, 0, this._focusBackfillItem);
    } else {
      this._removeFocusedItem();
      this._focusBackfillItem = null;
    }
    this._offscreenFocusedItem = null;
  },
  _didFocus: function(e) {
    var targetModel = this.modelForElement(e.target);
    var focusedModel = this.modelForElement(this._focusedItem);
    var hasOffscreenFocusedItem = this._offscreenFocusedItem !== null;
    var fidx = this._focusedVirtualIndex;
    if (!targetModel) {
      return;
    }
    if (focusedModel === targetModel) {
      if (!this._isIndexVisible(fidx)) {
        this.scrollToIndex(fidx);
      }
    } else {
      this._restoreFocusedItem();
      if (focusedModel) {
        focusedModel.tabIndex = -1;
      }
      targetModel.tabIndex = 0;
      fidx = targetModel[this.indexAs];
      this._focusedVirtualIndex = fidx;
      this._focusedPhysicalIndex = this._getPhysicalIndex(fidx);
      this._focusedItem = this._physicalItems[this._focusedPhysicalIndex];
      if (hasOffscreenFocusedItem && !this._offscreenFocusedItem) {
        this._update();
      }
    }
  },
  _keydownHandler: function(e) {
    switch (e.keyCode) {
      case 40:
        if (this._focusedVirtualIndex < this._virtualCount - 1) e.preventDefault();
        this._focusPhysicalItem(this._focusedVirtualIndex + (this.grid ? this._itemsPerRow : 1));
        break;
      case 39:
        if (this.grid) this._focusPhysicalItem(this._focusedVirtualIndex + (this._isRTL ? -1 : 1));
        break;
      case 38:
        if (this._focusedVirtualIndex > 0) e.preventDefault();
        this._focusPhysicalItem(this._focusedVirtualIndex - (this.grid ? this._itemsPerRow : 1));
        break;
      case 37:
        if (this.grid) this._focusPhysicalItem(this._focusedVirtualIndex + (this._isRTL ? 1 : -1));
        break;
      case 13:
        this._focusPhysicalItem(this._focusedVirtualIndex);
        if (this.selectionEnabled) this._selectionHandler(e);
        break;
    }
  },
  _clamp: function(v, min, max) {
    return Math.min(max, Math.max(min, v));
  },
  _debounce: function(name, cb, asyncModule) {
    this._debouncers = this._debouncers || {};
    this._debouncers[name] = Debouncer.debounce(this._debouncers[name], asyncModule, cb.bind(this));
    enqueueDebouncer(this._debouncers[name]);
  },
  _forwardProperty: function(inst, name, value) {
    inst._setPendingProperty(name, value);
  },
  _forwardHostPropV2: function(prop, value) {
    (this._physicalItems || []).concat([this._offscreenFocusedItem, this._focusBackfillItem]).forEach(function(item) {
      if (item) {
        this.modelForElement(item).forwardHostProp(prop, value);
      }
    }, this);
  },
  _notifyInstancePropV2: function(inst, prop, value) {
    if (matches(this.as, prop)) {
      var idx = inst[this.indexAs];
      if (prop == this.as) {
        this.items[idx] = value;
      }
      this.notifyPath(translate(this.as, "items." + idx, prop), value);
    }
  },
  _getStampedChildren: function() {
    return this._physicalItems;
  },
  _forwardInstancePath: function(inst, path, value) {
    if (path.indexOf(this.as + ".") === 0) {
      this.notifyPath("items." + inst.__key__ + "." + path.slice(this.as.length + 1), value);
    }
  },
  _forwardParentPath: function(path, value) {
    (this._physicalItems || []).concat([this._offscreenFocusedItem, this._focusBackfillItem]).forEach(function(item) {
      if (item) {
        this.modelForElement(item).notifyPath(path, value);
      }
    }, this);
  },
  _forwardParentProp: function(prop, value) {
    (this._physicalItems || []).concat([this._offscreenFocusedItem, this._focusBackfillItem]).forEach(function(item) {
      if (item) {
        this.modelForElement(item)[prop] = value;
      }
    }, this);
  },
  _getActiveElement: function() {
    var itemsHost = this._itemsParent.node.domHost;
    return dom(itemsHost ? itemsHost.root : document).activeElement;
  },
});
// Copyright 2019 The Chromium Authors. All rights reserved.
const ARG_URL_PLACEHOLDER = "<arg_url>";
const ARG_URL_PLACEHOLDER_REGEX = /"<arg_url>"/g;
Polymer({
  is: "activity-log-stream-item",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-icons cr-shared-style shared-style" scope="activity-log-stream-item">
      :host {
        border-top: var(--cr-separator-line);
        display: block;
        padding: 8px var(--cr-section-padding);
      }

      cr-expand-button {
        --cr-expand-button-disabled-display: none;

        height: calc(var(--cr-section-min-height) - var(--separator-gap));
      }

      cr-expand-button[disabled] {
        opacity: 1;
      }

      #activity-call-and-time {
        display: flex;
        flex: 1;
        flex-direction: row;
        margin-inline-end: auto;
        max-width: var(--activity-log-call-and-time-width);
      }

      #activity-type {
        min-width: var(--activity-type-width);
      }

      #activity-name {
        flex: 1;
        margin-inline-start: 10px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
      }

      #activity-time {
        min-width: var(--activity-time-width);
        text-align: end;
      }

      #expanded-data {
        display: flex;
        flex-direction: column;
        margin-inline-start: 16px;
        max-width: var(--activity-log-call-and-time-width);
      }

      #page-url-link {
        margin-bottom: 10px;
        margin-inline-end: auto;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
        width: 100%;
      }

      #args-list,
      #web-request-section {
        display: flex;
        flex-direction: column;
        margin-bottom: 10px;
      }

      .expanded-data-heading {
        font-weight: 500;
      }

      .list-item {
        display: flex;
        margin-top: 10px;
      }

      .index {
        min-width: 3em;
      }

      .arg,
      #web-request-details {
        overflow: hidden;
        overflow-wrap: break-word;
      }

      #web-request-details {
        margin-top: 10px;
      }
    </style>
    <cr-expand-button expanded="[[data.expanded]]" disabled="[[!isExpandable_]]" on-click="onExpandClick_">
      <div id="activity-call-and-time">
        <span id="activity-type">[[data.activityType]]</span>
        <span id="activity-name" title="[[data.name]]">[[data.name]]</span>
        <span id="activity-time">[[getFormattedTime_(data.timeStamp)]]</span>
      </div>
    </cr-expand-button>
    <div id="expanded-data" hidden$="[[!data.expanded]]">
      <a id="page-url-link" href="[[data.pageUrl]]" target="_blank" hidden$="[[!hasPageUrl_(data.pageUrl)]]" title="[[data.pageUrl]]">[[data.pageUrl]]</a>
      <div id="args-list" hidden$="[[!hasArgs_(argsList_)]]">
        <span class="expanded-data-heading"> ___activityArgumentsHeading___ </span>
        <template is="dom-repeat" items="[[argsList_]]">
          <div class="list-item">
            <span class="index">[[item.index]]</span>
            <span class="arg">[[item.arg]]</span>
          </div>
        </template>
      </div>
      <div id="web-request-section" hidden$="[[!hasWebRequestInfo_(data.webRequestInfo)]]">
        <span class="expanded-data-heading">___webRequestInfoHeading___</span>
        <span id="web-request-details">[[data.webRequestInfo]]</span>
      </div>
    </div>
    <!--_html_template_end_-->`,
  properties: {
    data: Object,
    argsList_: {
      type: Array,
      computed: "computeArgsList_(data.args)",
    },
    isExpandable_: {
      type: Boolean,
      computed: "computeIsExpandable_(data)",
    },
  },
  computeIsExpandable_() {
    return this.hasPageUrl_() || this.hasArgs_() || this.hasWebRequestInfo_();
  },
  getFormattedTime_() {
    const activityDate = new Date(this.data.timestamp);
    const timeString = activityDate.toLocaleTimeString(undefined, {
      hour12: false,
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
    });
    const ms = activityDate.getMilliseconds().toString().padStart(3, "0");
    return `${timeString}.${ms}`;
  },
  hasPageUrl_() {
    return !!this.data.pageUrl;
  },
  hasArgs_() {
    return this.argsList_.length > 0;
  },
  hasWebRequestInfo_() {
    return !!this.data.webRequestInfo && this.data.webRequestInfo !== "{}";
  },
  computeArgsList_() {
    const parsedArgs = JSON.parse(this.data.args);
    if (!Array.isArray(parsedArgs)) {
      return [];
    }
    return parsedArgs.map((arg, i) => ({
      arg: JSON.stringify(arg).replace(ARG_URL_PLACEHOLDER_REGEX, `"${this.data.argUrl}"`),
      index: i + 1,
    }));
  },
  onExpandClick_() {
    if (this.isExpandable_) {
      this.set("data.expanded", !this.data.expanded);
      this.fire("resize-stream");
    }
  },
});
// Copyright 2019 The Chromium Authors. All rights reserved.
function processActivityForStream(activity) {
  const activityType = activity.activityType;
  const timestamp = activity.time;
  const isContentScript = activityType === chrome.activityLogPrivate.ExtensionActivityType.CONTENT_SCRIPT;
  const args = isContentScript ? JSON.stringify([]) : activity.args;
  let streamItemNames = [activity.apiCall];
  if (isContentScript) {
    streamItemNames = activity.args ? JSON.parse(activity.args) : [];
    assert(Array.isArray(streamItemNames), "Invalid data for script names.");
  }
  const other = activity.other;
  const webRequestInfo = other && other.webRequest;
  return streamItemNames.map((name) => ({
    args: args,
    argUrl: activity.argUrl,
    activityType: activityType,
    name: name,
    pageUrl: activity.pageUrl,
    timestamp: timestamp,
    webRequestInfo: webRequestInfo,
    expanded: false,
  }));
}
Polymer({
  is: "activity-log-stream",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="shared-style" scope="activity-log-stream">
      :host {
        --activity-log-call-and-time-width: 575px;
        --activity-type-width: 85px;
        --activity-time-width: 100px;

        display: flex;
        flex-direction: column;
      }

      cr-search-field {
        align-self: center;
        margin-inline-end: auto;
      }

      .activity-table-headings {
        width: var(--activity-log-call-and-time-width);
      }

      #activity-type {
        flex: 0 var(--activity-type-width);
      }

      #activity-key {
        flex: 1;
        margin-inline-start: 10px;
      }

      #activity-time {
        flex: 0 var(--activity-time-width);
        text-align: end;
      }

      iron-list {
        flex: 1;
      }
    </style>
    <div class="activity-subpage-header">
      <cr-search-field label="___activityLogSearchLabel___" on-search-changed="onSearchChanged_"> </cr-search-field>
      <cr-button id="toggle-stream-button" on-click="onToggleButtonClick_">
        <span hidden$="[[isStreamOn_]]"> ___startActivityStream___ </span>
        <span hidden$="[[!isStreamOn_]]"> ___stopActivityStream___ </span>
      </cr-button>
      <cr-button class="clear-activities-button" on-click="clearStream"> ___clearActivities___ </cr-button>
    </div>
    <div id="empty-stream-message" class="activity-message" hidden$="[[!isStreamEmpty_(activityStream_.length)]]">
      <span id="stream-stopped-message" hidden$="[[isStreamOn_]]"> ___emptyStreamStopped___ </span>
      <span id="stream-started-message" hidden$="[[!isStreamOn_]]"> ___emptyStreamStarted___ </span>
    </div>
    <div
      id="empty-search-message"
      class="activity-message"
      hidden$="[[!shouldShowEmptySearchMessage_(
        activityStream_.length, filteredActivityStream_.length)]]"
    >
      ___noSearchResults___
    </div>
    <div class="activity-table-headings" hidden$="[[isFilteredStreamEmpty_(filteredActivityStream_.length)]]">
      <span id="activity-type">___activityLogTypeColumn___</span>
      <span id="activity-key">___activityLogNameColumn___</span>
      <span id="activity-time">___activityLogTimeColumn___</span>
    </div>
    <iron-list items="[[filteredActivityStream_]]">
      <template>
        <activity-log-stream-item data="[[item]]"></activity-log-stream-item>
      </template>
    </iron-list>
    <!--_html_template_end_-->`,
  properties: {
    extensionId: String,
    delegate: Object,
    isStreamOn_: {
      type: Boolean,
      value: false,
    },
    activityStream_: {
      type: Array,
      value: () => [],
    },
    filteredActivityStream_: {
      type: Array,
      computed: "computeFilteredActivityStream_(activityStream_.*, lastSearch_)",
    },
    lastSearch_: {
      type: String,
      value: "",
    },
  },
  listeners: {
    "resize-stream": "onResizeStream_",
  },
  listenerInstance_: () => { },
  attached() {
    this.listenerInstance_ = this.extensionActivityListener_.bind(this);
    this.startStream();
  },
  onResizeStream_(e) {
    this.$$("iron-list").notifyResize();
  },
  clearStream() {
    this.splice("activityStream_", 0, this.activityStream_.length);
  },
  startStream() {
    if (this.isStreamOn_) {
      return;
    }
    this.isStreamOn_ = true;
    this.delegate.getOnExtensionActivity().addListener(this.listenerInstance_);
  },
  pauseStream() {
    if (!this.isStreamOn_) {
      return;
    }
    this.delegate.getOnExtensionActivity().removeListener(this.listenerInstance_);
    this.isStreamOn_ = false;
  },
  onToggleButtonClick_() {
    if (this.isStreamOn_) {
      this.pauseStream();
    } else {
      this.startStream();
    }
  },
  isStreamEmpty_() {
    return this.activityStream_.length === 0;
  },
  isFilteredStreamEmpty_() {
    return this.filteredActivityStream_.length === 0;
  },
  shouldShowEmptySearchMessage_() {
    return !this.isStreamEmpty_() && this.isFilteredStreamEmpty_();
  },
  extensionActivityListener_(activity) {
    if (activity.extensionId !== this.extensionId) {
      return;
    }
    this.splice("activityStream_", this.activityStream_.length, 0, ...processActivityForStream(activity));
    this.$$("iron-list").notifyResize();
  },
  onSearchChanged_(e) {
    const searchTerm = e.detail.replace(/\s+/g, "").toLowerCase();
    if (searchTerm === this.lastSearch_) {
      return;
    }
    this.lastSearch_ = searchTerm;
  },
  computeFilteredActivityStream_() {
    if (!this.lastSearch_) {
      return this.activityStream_.slice();
    }
    const propNames = ["name", "pageUrl", "activityType"];
    return this.activityStream_.filter((act) => {
      return propNames.some((prop) => {
        return act[prop] && act[prop].toLowerCase().includes(this.lastSearch_);
      });
    });
  },
});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
Polymer({
  _template: html`<!--css-build:shadow--><style scope="iron-collapse">
      :host {
        display: block;
        transition-duration: var(--iron-collapse-transition-duration, 300ms);

        overflow: visible;
      }

      :host(.iron-collapse-closed) {
        display: none;
      }

      :host(:not(.iron-collapse-opened)) {
        overflow: hidden;
      }
    </style>

    <slot></slot> `,
  is: "iron-collapse",
  behaviors: [IronResizableBehavior],
  properties: {
    horizontal: {
      type: Boolean,
      value: false,
      observer: "_horizontalChanged",
    },
    opened: {
      type: Boolean,
      value: false,
      notify: true,
      observer: "_openedChanged",
    },
    transitioning: {
      type: Boolean,
      notify: true,
      readOnly: true,
    },
    noAnimation: {
      type: Boolean,
    },
    _desiredSize: {
      type: String,
      value: "",
    },
  },
  get dimension() {
    return this.horizontal ? "width" : "height";
  },
  get _dimensionMax() {
    return this.horizontal ? "maxWidth" : "maxHeight";
  },
  get _dimensionMaxCss() {
    return this.horizontal ? "max-width" : "max-height";
  },
  hostAttributes: {
    role: "group",
    "aria-hidden": "true",
  },
  listeners: {
    transitionend: "_onTransitionEnd",
  },
  toggle: function() {
    this.opened = !this.opened;
  },
  show: function() {
    this.opened = true;
  },
  hide: function() {
    this.opened = false;
  },
  updateSize: function(size, animated) {
    size = size === "auto" ? "" : size;
    var willAnimate = animated && !this.noAnimation && this.isAttached && this._desiredSize !== size;
    this._desiredSize = size;
    this._updateTransition(false);
    if (willAnimate) {
      var startSize = this._calcSize();
      if (size === "") {
        this.style[this._dimensionMax] = "";
        size = this._calcSize();
      }
      this.style[this._dimensionMax] = startSize;
      this.scrollTop = this.scrollTop;
      this._updateTransition(true);
      willAnimate = size !== startSize;
    }
    this.style[this._dimensionMax] = size;
    if (!willAnimate) {
      this._transitionEnd();
    }
  },
  enableTransition: function(enabled) {
    Base._warn("`enableTransition()` is deprecated, use `noAnimation` instead.");
    this.noAnimation = !enabled;
  },
  _updateTransition: function(enabled) {
    this.style.transitionDuration = enabled && !this.noAnimation ? "" : "0s";
  },
  _horizontalChanged: function() {
    this.style.transitionProperty = this._dimensionMaxCss;
    var otherDimension = this._dimensionMax === "maxWidth" ? "maxHeight" : "maxWidth";
    this.style[otherDimension] = "";
    this.updateSize(this.opened ? "auto" : "0px", false);
  },
  _openedChanged: function() {
    this.setAttribute("aria-hidden", !this.opened);
    this._setTransitioning(true);
    this.toggleClass("iron-collapse-closed", false);
    this.toggleClass("iron-collapse-opened", false);
    this.updateSize(this.opened ? "auto" : "0px", true);
    if (this.opened) {
      this.focus();
    }
  },
  _transitionEnd: function() {
    this.style[this._dimensionMax] = this._desiredSize;
    this.toggleClass("iron-collapse-closed", !this.opened);
    this.toggleClass("iron-collapse-opened", this.opened);
    this._updateTransition(false);
    this.notifyResize();
    this._setTransitioning(false);
  },
  _onTransitionEnd: function(event) {
    if (dom(event).rootTarget === this) {
      this._transitionEnd();
    }
  },
  _calcSize: function() {
    return this.getBoundingClientRect()[this.dimension] + "px";
  },
});
// Copyright 2016 The Chromium Authors. All rights reserved.
function visibleLineCount(totalCount, oppositeCount) {
  const MAX_VISIBLE_LINES = 1e3;
  const max = Math.max(MAX_VISIBLE_LINES / 2, MAX_VISIBLE_LINES - oppositeCount);
  return Math.min(max, totalCount);
}
Polymer({
  is: "extensions-code-section",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-hidden-style" scope="extensions-code-section">
      :host {
        --container-bg: white;
        --line-bg: var(--paper-grey-300);
        --main-color: var(--paper-grey-800);
        display: block;
      }

      @media (prefers-color-scheme: dark) {
        :host {
          --container-bg: rgba(0, 0, 0, 0.4);
          --line-bg: var(--google-grey-800);
          --main-color: var(--cr-primary-text-color);
        }
      }

      #scroll-container {
        background: var(--container-bg);
        height: 100%;
        overflow: auto;
        position: relative;
      }

      @media (prefers-color-scheme: light) {
        #scroll-container {
          border: 1px solid var(--paper-grey-500);
        }
      }

      #main {
        color: var(--main-color);
        display: flex;
        font-family: monospace;
        min-height: 100%;
      }

      #line-numbers {
        background: var(--line-bg);
        display: flex;
        flex-direction: column;
        padding: 0 8px;
        text-align: end;
      }

      @media (prefers-color-scheme: light) {
        #line-numbers {
          border-inline-end: 1px solid var(--paper-grey-500);
        }
      }

      #source {
        display: flex;
        flex-direction: column;
        margin-inline-start: 4px;
      }

      #line-numbers span,
      #source span {
        white-space: pre;
      }

      #no-code {
        text-align: center;
      }

      @media (prefers-color-scheme: light) {
        #no-code {
          color: var(--paper-grey-800);
        }

        .more-code {
          color: var(--paper-grey-500);
        }
      }

      #highlight-description {
        height: 0;
        overflow: hidden;
      }

      @media (prefers-color-scheme: dark) {
        mark {
          background-color: var(--google-yellow-refresh-300);
          color: var(--google-grey-900);
        }
      }
    </style>
    <div id="scroll-container" hidden="[[!highlighted_]]" dir="ltr">
      <div id="main">
        <!-- Line numbers are not useful to a screenreader -->
        <div id="line-numbers" aria-hidden="true">
          <div class="more-code before" hidden="[[!truncatedBefore_]]">...</div>
          <span>[[lineNumbers_]]</span>
          <div class="more-code after" hidden="[[!truncatedAfter_]]">...</div>
        </div>
        <div id="source">
          <div class="more-code before" hidden="[[!truncatedBefore_]]">[[getLinesNotShownLabel_( truncatedBefore_, '___errorLinesNotShownSingular___', '___errorLinesNotShownPlural___')]]</div>
          <span
            ><!-- Whitespace is preserved in this span. Ignore new lines.
        --><span>[[before_]]</span
            ><!--
        --><mark aria-label$="[[highlighted_]]" aria-describedby="highlight-description"
              ><!--
          --><span aria-hidden="true">[[highlighted_]]</span
              ><!--
        --></mark
            ><!--
        --><span>[[after_]]</span
            ><!--
      --></span>
          <div class="more-code after" hidden="[[!truncatedAfter_]]">[[getLinesNotShownLabel_( truncatedAfter_, '___errorLinesNotShownSingular___', '___errorLinesNotShownPlural___')]]</div>
        </div>
      </div>
    </div>
    <div id="no-code" hidden="[[!showNoCode_]]">[[couldNotDisplayCode]]</div>
    <div id="highlight-description" aria-hidden="true">[[highlightDescription_]]</div>
    <!--_html_template_end_-->`,
  behaviors: [I18nBehavior],
  properties: {
    code: {
      type: Object,
      value: null,
    },
    isActive: Boolean,
    highlighted_: String,
    before_: String,
    after_: String,
    showNoCode_: {
      type: Boolean,
      computed: "computeShowNoCode_(isActive, highlighted_)",
    },
    highlightDescription_: String,
    lineNumbers_: String,
    truncatedBefore_: Number,
    truncatedAfter_: Number,
    couldNotDisplayCode: String,
  },
  observers: ["onCodeChanged_(code.*)"],
  onCodeChanged_() {
    if (!this.code || (!this.code.beforeHighlight && !this.code.highlight && !this.code.afterHighlight)) {
      this.highlighted_ = "";
      this.highlightDescription_ = "";
      this.before_ = "";
      this.after_ = "";
      this.lineNumbers_ = "";
      return;
    }
    const before = this.code.beforeHighlight;
    const highlight = this.code.highlight;
    const after = this.code.afterHighlight;
    const linesBefore = before ? before.split("\n") : [];
    const linesAfter = after ? after.split("\n") : [];
    const visibleLineCountBefore = visibleLineCount(linesBefore.length, linesAfter.length);
    const visibleLineCountAfter = visibleLineCount(linesAfter.length, linesBefore.length);
    const visibleBefore = linesBefore.slice(linesBefore.length - visibleLineCountBefore).join("\n");
    let visibleAfter = linesAfter.slice(0, visibleLineCountAfter).join("\n");
    if (visibleAfter.charAt(visibleAfter.length - 1) === "\n") {
      visibleAfter += " ";
    }
    this.highlighted_ = highlight;
    this.highlightDescription_ = this.getAccessibilityHighlightDescription_(linesBefore.length, highlight.split("\n").length);
    this.before_ = visibleBefore;
    this.after_ = visibleAfter;
    this.truncatedBefore_ = linesBefore.length - visibleLineCountBefore;
    this.truncatedAfter_ = linesAfter.length - visibleLineCountAfter;
    const visibleCode = visibleBefore + highlight + visibleAfter;
    this.setLineNumbers_(this.truncatedBefore_ + 1, this.truncatedBefore_ + visibleCode.split("\n").length);
    this.scrollToHighlight_(visibleLineCountBefore);
  },
  getLinesNotShownLabel_(lineCount, stringSingular, stringPluralTemplate) {
    return lineCount === 1 ? stringSingular : loadTimeData.substituteString(stringPluralTemplate, lineCount);
  },
  setLineNumbers_(start, end) {
    let lineNumbers = "";
    for (let i = start; i <= end; ++i) {
      lineNumbers += i + "\n";
    }
    this.lineNumbers_ = lineNumbers;
  },
  scrollToHighlight_(linesBeforeHighlight) {
    const CSS_LINE_HEIGHT = 20;
    const highlightTop = linesBeforeHighlight * CSS_LINE_HEIGHT;
    const targetTop = highlightTop - this.clientHeight * 0.5;
    this.$["scroll-container"].scrollTo({
      top: targetTop,
    });
  },
  getAccessibilityHighlightDescription_(lineStart, numLines) {
    if (numLines > 1) {
      return this.i18n("accessibilityErrorMultiLine", lineStart.toString(), (lineStart + numLines - 1).toString());
    } else {
      return this.i18n("accessibilityErrorLine", lineStart.toString());
    }
  },
  computeShowNoCode_() {
    return this.isActive && !this.highlighted_;
  },
});
// Copyright 2016 The Chromium Authors. All rights reserved.
function getRelativeUrl(url, error) {
  const fullUrl = "chrome-extension://" + error.extensionId + "/";
  return url.startsWith(fullUrl) ? url.substring(fullUrl.length) : url;
}
function getErrorSeverityText_(item, log, warn, error) {
  if (item.type === chrome.developerPrivate.ErrorType.RUNTIME) {
    switch (item.severity) {
      case chrome.developerPrivate.ErrorLevel.LOG:
        return log;
      case chrome.developerPrivate.ErrorLevel.WARN:
        return warn;
      case chrome.developerPrivate.ErrorLevel.ERROR:
        return error;
    }
    assertNotReached();
  }
  assert(item.type === chrome.developerPrivate.ErrorType.MANIFEST);
  return warn;
}
Polymer({
  is: "extensions-error-page",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-icons cr-shared-style shared-style" scope="extensions-error-page">
      :host {
        display: block;
        height: 100%;
      }

      iron-icon {
        --iron-icon-fill-color: var(--google-grey-refresh-700);
        flex-shrink: 0;
        height: var(--cr-icon-size);
        width: var(--cr-icon-size);
      }

      iron-icon[icon="cr:warning"] {
        --iron-icon-fill-color: var(--paper-orange-500);
      }

      iron-icon[icon="cr:error"] {
        --iron-icon-fill-color: var(--error-color);
      }

      .section {
        padding: 0 var(--cr-section-padding);
      }

      #heading {
        align-items: center;
        display: flex;
        height: 40px;
        margin-bottom: 30px;
        padding: 8px 12px 0;
      }

      #heading span {
        flex: 1;
        margin: 0 10px;
      }

      #errorsList {
        min-height: 100px;
      }

      .error-item {
        padding-inline-start: 0;
      }

      .error-item cr-icon-button {
        margin: 0;
      }

      .error-item.selected {
        background-color: rgba(0, 0, 0, 0.08);
      }

      .error-item .start {
        align-items: center;
        align-self: stretch;
        display: flex;
        flex: 1;
        padding: 0 var(--cr-section-padding);
      }

      .error-message {
        flex-grow: 1;
        margin-inline-start: 10px;
        word-break: break-word;
      }

      .devtools-controls {
        padding: 0 var(--cr-section-padding);
      }

      .details-heading {
        align-items: center;
        display: flex;
        height: var(--cr-section-min-height);
      }

      .stack-trace-container {
        list-style: none;
        margin-top: 0;
        padding: 0;
      }

      .stack-trace-container li {
        cursor: pointer;
        font-family: monospace;
        padding: 4px;
      }

      .stack-trace-container li.selected,
      .stack-trace-container li:hover {
        background: var(--google-blue-100);
        color: var(--google-grey-900);
      }

      extensions-code-section {
        height: 200px;
        margin-bottom: 20px;
      }

      :host-context(.focus-outline-visible) .start:focus {
        outline: -webkit-focus-ring-color auto 5px;
      }

      .start:focus {
        outline: none;
      }

      .context-url {
        word-wrap: break-word;
      }
    </style>
    <div class="page-container" id="container">
      <div class="page-content">
        <div id="heading" class="cr-title-text">
          <cr-icon-button class="icon-arrow-back no-overlap" id="closeButton" aria-label="___back___" on-click="onCloseButtonTap_"> </cr-icon-button>
          <span role="heading" aria-level="2">___errorsPageHeading___</span>
          <cr-button on-click="onClearAllTap_" hidden="[[!entries_.length]]"> ___clearAll___ </cr-button>
        </div>
        <div class="section">
          <div id="errorsList">
            <template is="dom-repeat" items="[[entries_]]">
              <div class="item-container">
                <div
                  class$="cr-row error-item
                [[computeErrorClass_(item, selectedEntry_)]]"
                >
                  <div
                    actionable=""
                    class="start"
                    on-click="onErrorItemAction_"
                    on-keydown="onErrorItemAction_"
                    tabindex="0"
                    role="button"
                    aria-expanded$="[[isAriaExpanded_(
                      index, selectedEntry_)]]"
                  >
                    <iron-icon icon$="cr:[[computeErrorIcon_(item)]]" title$="[[computeErrorTypeLabel_(item)]]"> </iron-icon>
                    <div id$="[[item.id]]" class="error-message">[[item.message]]</div>
                    <div class$="cr-icon [[iconName_(index, selectedEntry_)]]"></div>
                  </div>
                  <div class="separator"></div>
                  <cr-icon-button class="icon-delete-gray" on-click="onDeleteErrorAction_" aria-describedby$="[[item.id]]" aria-label="___clearEntry___"></cr-icon-button>
                </div>
                <iron-collapse opened="[[isOpened_(index, selectedEntry_)]]">
                  <div class="devtools-controls">
                    <template is="dom-if" if="[[computeIsRuntimeError_(item)]]">
                      <div class="details-heading cr-title-text" role="heading" aria-level="3">___errorContext___</div>
                      <span class="context-url"> [[getContextUrl_( item, '___errorContextUnknown___')]] </span>
                      <div class="details-heading cr-title-text" role="heading" aria-level="3">___stackTrace___</div>
                      <ul class="stack-trace-container" on-keydown="onStackKeydown_">
                        <template is="dom-repeat" items="[[item.stackTrace]]">
                          <li
                            on-click="onStackFrameTap_"
                            tabindex$="[[getStackFrameTabIndex_(item,
                              selectedStackFrame_)]]"
                            hidden="[[!shouldDisplayFrame_(item.url)]]"
                            class$="[[getStackFrameClass_(item,
                              selectedStackFrame_)]]"
                          >
                            [[getStackTraceLabel_(item)]]
                          </li>
                        </template>
                      </ul>
                    </template>
                    <extensions-code-section code="[[code_]]" is-active="[[isOpened_(index, selectedEntry_)]]" could-not-display-code="___noErrorsToShow___"> </extensions-code-section>
                  </div>
                </iron-collapse>
              </div>
            </template>
          </div>
        </div>
      </div>
    </div>
    <!--_html_template_end_-->`,
  behaviors: [CrContainerShadowBehavior],
  properties: {
    data: Object,
    delegate: Object,
    inDevMode: {
      type: Boolean,
      value: false,
    },
    entries_: Array,
    code_: Object,
    selectedEntry_: {
      type: Number,
      observer: "onSelectedErrorChanged_",
    },
    selectedStackFrame_: {
      type: Object,
      value() {
        return null;
      },
    },
  },
  observers: ["observeDataChanges_(data.*)"],
  listeners: {
    "view-enter-start": "onViewEnterStart_",
  },
  ready() {
    FocusOutlineManager.forDocument(document);
  },
  getSelectedError() {
    return this.entries_[this.selectedEntry_];
  },
  onViewEnterStart_() {
    afterNextRender(this, () => focusWithoutInk(this.$.closeButton));
    chrome.metricsPrivate.recordUserAction("Options_ViewExtensionErrors");
  },
  getContextUrl_(error, unknown) {
    return error.contextUrl ? getRelativeUrl(error.contextUrl, error) : unknown;
  },
  observeDataChanges_() {
    const errors = this.data.manifestErrors.concat(this.data.runtimeErrors);
    this.entries_ = errors;
    this.selectedEntry_ = -1;
    if (this.entries_.length) {
      this.selectedEntry_ = 0;
    }
  },
  onCloseButtonTap_() {
    navigation.navigateTo({
      page: Page.LIST,
    });
  },
  onClearAllTap_() {
    const ids = this.entries_.map((entry) => entry.id);
    this.delegate.deleteErrors(this.data.id, ids);
  },
  computeErrorIcon_(error) {
    return getErrorSeverityText_(error, "info", "warning", "error");
  },
  computeErrorTypeLabel_(error) {
    return getErrorSeverityText_(error, loadTimeData.getString("logLevel"), loadTimeData.getString("warnLevel"), loadTimeData.getString("errorLevel"));
  },
  onDeleteErrorAction_(e) {
    this.delegate.deleteErrors(this.data.id, [e.model.item.id]);
    e.stopPropagation();
  },
  onInDevModeChanged_() {
    if (!this.inDevMode) {
      this.async(() => {
        this.onCloseButtonTap_();
      });
    }
  },
  onSelectedErrorChanged_() {
    this.code_ = null;
    if (this.selectedEntry_ < 0) {
      return;
    }
    const error = this.getSelectedError();
    const args = {
      extensionId: error.extensionId,
      message: error.message,
    };
    switch (error.type) {
      case chrome.developerPrivate.ErrorType.MANIFEST:
        args.pathSuffix = error.source;
        args.manifestKey = error.manifestKey;
        args.manifestSpecific = error.manifestSpecific;
        break;
      case chrome.developerPrivate.ErrorType.RUNTIME:
        args.pathSuffix = new URL(error.source).pathname.slice(1);
        args.lineNumber = error.stackTrace && error.stackTrace[0] ? error.stackTrace[0].lineNumber : 0;
        this.selectedStackFrame_ = error.stackTrace && error.stackTrace[0] ? error.stackTrace[0] : null;
        break;
    }
    this.delegate.requestFileSource(args).then((code) => (this.code_ = code));
  },
  computeIsRuntimeError_(item) {
    return item.type === chrome.developerPrivate.ErrorType.RUNTIME;
  },
  getStackTraceLabel_(frame) {
    let description = getRelativeUrl(frame.url, this.getSelectedError()) + ":" + frame.lineNumber;
    if (frame.functionName) {
      const functionName = frame.functionName === "(anonymous function)" ? loadTimeData.getString("anonymousFunction") : frame.functionName;
      description += " (" + functionName + ")";
    }
    return description;
  },
  getStackFrameClass_(frame) {
    return frame === this.selectedStackFrame_ ? "selected" : "";
  },
  getStackFrameTabIndex_(frame) {
    return frame === this.selectedStackFrame_ ? 0 : -1;
  },
  shouldDisplayFrame_(url) {
    return !/^extensions::/.test(url);
  },
  updateSelected_(frame) {
    this.selectedStackFrame_ = assert(frame);
    const selectedError = this.getSelectedError();
    this.delegate
      .requestFileSource({
        extensionId: selectedError.extensionId,
        message: selectedError.message,
        pathSuffix: getRelativeUrl(frame.url, selectedError),
        lineNumber: frame.lineNumber,
      })
      .then((code) => (this.code_ = code));
  },
  onStackFrameTap_(e) {
    const frame = e.model.item;
    this.updateSelected_(frame);
  },
  onStackKeydown_(e) {
    let direction = 0;
    if (e.key === "ArrowDown") {
      direction = 1;
    } else if (e.key === "ArrowUp") {
      direction = -1;
    } else {
      return;
    }
    e.preventDefault();
    const list = e.target.parentElement.querySelectorAll("li");
    for (let i = 0; i < list.length; ++i) {
      if (list[i].classList.contains("selected")) {
        const polymerEvent = e;
        const frame = polymerEvent.model.item.stackTrace[i + direction];
        if (frame) {
          this.updateSelected_(frame);
          list[i + direction].focus();
        }
        return;
      }
    }
  },
  computeErrorClass_(index) {
    return index === this.selectedEntry_ ? "selected" : "";
  },
  iconName_(index) {
    return index === this.selectedEntry_ ? "icon-expand-less" : "icon-expand-more";
  },
  isOpened_(index) {
    return index === this.selectedEntry_;
  },
  isAriaExpanded_(index) {
    return this.isOpened_(index).toString();
  },
  onErrorItemAction_(e) {
    if (e.type === "keydown" && !(e.code === "Space" || e.code === "Enter")) {
      return;
    }
    e.preventDefault();
    this.selectedEntry_ = this.selectedEntry_ === e.model.index ? -1 : e.model.index;
  },
});
// Copyright 2017 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-load-error",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style" scope="extensions-load-error">
      .description-row {
        display: flex;
      }

      .row-label {
        display: block;
        width: 104px;
      }

      paper-spinner-lite {
        margin-inline-end: 8px;
      }
    </style>
    <cr-dialog id="dialog" close-text="___close___">
      <div slot="title">___loadErrorHeading___</div>
      <div slot="body">
        <div id="info">
          <div id="file" class="description-row">
            <span class="row-label">___loadErrorFileLabel___</span>
            <span class="row-value">[[loadError.path]]</span>
          </div>
          <div id="error" class="description-row">
            <span class="row-label">___loadErrorErrorLabel___</span>
            <span class="row-value">[[loadError.error]]</span>
          </div>
        </div>
        <extensions-code-section id="code" could-not-display-code="___loadErrorCouldNotLoadManifest___"> </extensions-code-section>
      </div>
      <div slot="button-container">
        <paper-spinner-lite active="[[retrying_]]"></paper-spinner-lite>
        <cr-button class="cancel-button" on-click="close"> ___cancel___ </cr-button>
        <cr-button class="action-button" disabled="[[retrying_]]" on-click="onRetryTap_"> ___loadErrorRetry___ </cr-button>
      </div>
    </cr-dialog>
    <!--_html_template_end_-->`,
  properties: {
    delegate: Object,
    loadError: Object,
    retrying_: Boolean,
  },
  observers: ["observeLoadErrorChanges_(loadError)"],
  show() {
    this.$.dialog.showModal();
  },
  close() {
    this.$.dialog.close();
  },
  onRetryTap_() {
    this.retrying_ = true;
    this.delegate.retryLoadUnpacked(this.loadError.retryGuid).then(
      () => {
        this.close();
      },
      (loadError) => {
        this.loadError = loadError;
        this.retrying_ = false;
      }
    );
  },
  observeLoadErrorChanges_() {
    assert(this.loadError);
    const source = this.loadError.source;
    const codeSectionProperties = {
      beforeHighlight: source ? source.beforeHighlight : "",
      highlight: source ? source.highlight : "",
      afterHighlight: source ? source.afterHighlight : "",
      title: "",
      message: this.loadError.error,
    };
    this.$.code.code = codeSectionProperties;
  },
});
// Copyright 2017 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-pack-dialog-alert",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style" scope="extensions-pack-dialog-alert">
      .body {
        white-space: pre-wrap;
        word-break: break-word;
      }
    </style>

    <cr-dialog id="dialog" close-text="___close___">
      <div class="title" slot="title">[[title_]]</div>
      <!-- No whitespace or new-lines allowed within the div.body tag. -->
      <div class="body" slot="body">[[model.message]]</div>
      <div class="button-container" slot="button-container">
        <cr-button class$="[[getCancelButtonClass_(confirmLabel_)]]" on-click="onCancelTap_" hidden="[[!cancelLabel_]]"> [[cancelLabel_]] </cr-button>
        <cr-button class="action-button" on-click="onConfirmTap_" hidden="[[!confirmLabel_]]"> [[confirmLabel_]] </cr-button>
      </div>
    </cr-dialog>
    <!--_html_template_end_-->`,
  properties: {
    model: Object,
    title_: String,
    message_: String,
    cancelLabel_: String,
    confirmLabel_: {
      type: String,
      value: "",
    },
  },
  get returnValue() {
    return this.$.dialog.getNative().returnValue;
  },
  ready() {
    this.cancelLabel_ = null;
    this.confirmLabel_ = null;
    switch (this.model.status) {
      case chrome.developerPrivate.PackStatus.WARNING:
        this.title_ = loadTimeData.getString("packDialogWarningTitle");
        this.cancelLabel_ = loadTimeData.getString("cancel");
        this.confirmLabel_ = loadTimeData.getString("packDialogProceedAnyway");
        break;
      case chrome.developerPrivate.PackStatus.ERROR:
        this.title_ = loadTimeData.getString("packDialogErrorTitle");
        this.cancelLabel_ = loadTimeData.getString("ok");
        break;
      case chrome.developerPrivate.PackStatus.SUCCESS:
        this.title_ = loadTimeData.getString("packDialogTitle");
        this.cancelLabel_ = loadTimeData.getString("ok");
        break;
      default:
        assertNotReached();
        return;
    }
  },
  attached() {
    this.$.dialog.showModal();
  },
  getCancelButtonClass_() {
    return this.confirmLabel_ ? "cancel-button" : "action-button";
  },
  onCancelTap_() {
    this.$.dialog.cancel();
  },
  onConfirmTap_() {
    assert(this.model.status === chrome.developerPrivate.PackStatus.WARNING);
    this.$.dialog.close();
  },
});
// Copyright 2016 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-pack-dialog",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style" scope="extensions-pack-dialog">
      cr-input {
        margin-top: var(--cr-form-field-bottom-spacing);
        --cr-input-error-display: none;
      }

      cr-button[slot="suffix"] {
        margin-inline-start: 10px;
      }

      cr-input {
        margin-bottom: 2px;
      }
    </style>
    <cr-dialog id="dialog" close-text="___close___">
      <div slot="title">___packDialogConfirm___</div>
      <div slot="body">
        <div>___packDialogContent___</div>
        <cr-input id="root-dir" label="___packDialogExtensionRoot___" value="{{packDirectory_}}">
          <cr-button id="root-dir-browse" on-click="onRootBrowse_" slot="suffix"> ___packDialogBrowse___ </cr-button>
        </cr-input>
        <cr-input id="key-file" label="___packDialogKeyFile___" value="{{keyFile_}}">
          <cr-button id="key-file-browse" on-click="onKeyBrowse_" slot="suffix"> ___packDialogBrowse___ </cr-button>
        </cr-input>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCancelTap_"> ___cancel___ </cr-button>
        <cr-button class="action-button" on-click="onConfirmTap_" disabled="[[!packDirectory_]]"> ___packDialogConfirm___ </cr-button>
      </div>
    </cr-dialog>
    <template is="dom-if" if="[[lastResponse_]]" restamp="">
      <extensions-pack-dialog-alert model="[[lastResponse_]]" on-close="onAlertClose_"> </extensions-pack-dialog-alert>
    </template>
    <!--_html_template_end_-->`,
  properties: {
    delegate: Object,
    packDirectory_: {
      type: String,
      value: "",
    },
    keyFile_: String,
    lastResponse_: Object,
  },
  attached() {
    this.$.dialog.showModal();
  },
  onRootBrowse_() {
    this.delegate.choosePackRootDirectory().then((path) => {
      if (path) {
        this.set("packDirectory_", path);
      }
    });
  },
  onKeyBrowse_() {
    this.delegate.choosePrivateKeyPath().then((path) => {
      if (path) {
        this.set("keyFile_", path);
      }
    });
  },
  onCancelTap_() {
    this.$.dialog.cancel();
  },
  onConfirmTap_() {
    this.delegate.packExtension(this.packDirectory_, this.keyFile_, 0, this.onPackResponse_.bind(this));
  },
  onPackResponse_(response) {
    this.lastResponse_ = response;
  },
  onAlertClose_(e) {
    e.stopPropagation();
    if (this.lastResponse_.status === chrome.developerPrivate.PackStatus.SUCCESS) {
      this.$.dialog.close();
      return;
    }
    if (this.$$("extensions-pack-dialog-alert").returnValue === "success") {
      this.delegate.packExtension(this.lastResponse_.item_path, this.lastResponse_.pem_path, this.lastResponse_.override_flags, this.onPackResponse_.bind(this));
    }
    this.lastResponse_ = null;
  },
});
// Copyright 2017 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-toolbar",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-hidden-style" scope="extensions-toolbar">
      :host {
        --border-bottom-height: 1px;
        --button-row-height: calc(2 * var(--padding-top-bottom) + var(--cr-button-height));
        --drawer-transition: 0.3s cubic-bezier(0.25, 0.1, 0.25, 1);
        --padding-top-bottom: 10px;
      }

      @media (prefers-color-scheme: light) {
        cr-toolbar cr-toggle {
          --cr-toggle-checked-ripple-color: rgba(255, 255, 255, 0.2);
          --cr-toggle-unchecked-bar-color: var(--google-grey-600);
          --cr-toggle-unchecked-ripple-color: rgba(255, 255, 255, 0.15);
        }
      }

      cr-tooltip-icon {
        margin-inline-end: 20px;
      }

      #devDrawer[expanded] #buttonStrip {
        top: 0;
      }

      #devDrawer {
        background: #fff;
        border-bottom: 1px solid var(--google-grey-300);
        height: 0;
        overflow-x: hidden;
        overflow-y: auto;
        position: relative;
        transition: height var(--drawer-transition);
      }

      @media (prefers-color-scheme: dark) {
        #devDrawer {
          background: none;
          border-bottom-color: var(--cr-separator-color);
        }
      }

      #devDrawer[expanded] {
        height: calc(var(--button-row-height) + var(--border-bottom-height));
      }

      #buttonStrip {
        margin-inline-end: auto;
        margin-inline-start: 24px;
        padding: var(--padding-top-bottom) 0;
        transition: top var(--drawer-transition);
        user-select: none;
        width: 100%;
        white-space: nowrap;
      }

      #buttonStrip cr-button {
        margin-inline-end: 16px;
        border-color: #458ff3;
      }
      #buttonStrip cr-button:hover {
        background: rgba(69, 143, 243, 0.1);
      }

      .more-actions {
        align-items: center;
        display: flex;
        justify-content: flex-start;
      }

      .more-actions span {
        margin-inline-end: 16px;
        flex-shrink: 0;
      }

      .split-line {
        margin: 0 24px;
        width: 1px;
        height: 16px;
        background: var(--maxthon-border);
      }
    </style>
    <cr-toolbar page-name="___toolbarTitle___" search-prompt="___search___" clear-label="___clearSearch___" menu-label="___mainMenu___" show-menu="" narrow-threshold="1000">
      <div class="more-actions">
        <div class="split-line"></div>
        <span id="devModeLabel">___toolbarDevMode___</span>
        <cr-tooltip-icon
          hidden="[[!shouldDisableDevMode_(
        devModeControlledByPolicy, isSupervised)]]"
          tooltip-text="[[getTooltipText_(isSupervised)]]"
          icon-class="[[getIcon_(isSupervised)]]"
          icon-aria-label="[[getTooltipText_(isSupervised)]]"
        >
        </cr-tooltip-icon>
        <cr-toggle
          id="devMode"
          on-change="onDevModeToggleChange_"
          disabled="[[shouldDisableDevMode_(
            devModeControlledByPolicy, isSupervised)]]"
          checked="[[inDevMode]]"
          aria-labelledby="devModeLabel"
        >
        </cr-toggle>
        <template is="dom-if" if="[[inDevMode]]">
          <div id="buttonStrip">
            <cr-button hidden$="[[!canLoadUnpacked]]" id="loadUnpacked" on-click="onLoadUnpackedTap_"> ___toolbarLoadUnpacked___ </cr-button>
            <cr-button id="packExtensions" on-click="onPackTap_"> ___toolbarPack___ </cr-button>
            <cr-button id="updateNow" on-click="onUpdateNowTap_" title="___toolbarUpdateNowTooltip___"> ___toolbarUpdateNow___ </cr-button>
          </div>
        </template>
      </div>
    </cr-toolbar>
    <template is="dom-if" if="[[showPackDialog_]]" restamp="">
      <extensions-pack-dialog delegate="[[delegate]]" on-close="onPackDialogClose_"> </extensions-pack-dialog>
    </template>
    <!--_html_template_end_-->`,
  properties: {
    extensions: Array,
    delegate: Object,
    inDevMode: {
      type: Boolean,
      value: false,
      observer: "onInDevModeChanged_",
      reflectToAttribute: true,
    },
    devModeControlledByPolicy: Boolean,
    isSupervised: Boolean,
    canLoadUnpacked: Boolean,
    expanded_: Boolean,
    showPackDialog_: Boolean,
    isUpdating_: {
      type: Boolean,
      value: false,
    },
  },
  behaviors: [I18nBehavior],
  hostAttributes: {
    role: "banner",
  },
  shouldDisableDevMode_() {
    return this.devModeControlledByPolicy || this.isSupervised;
  },
  getTooltipText_() {
    return this.i18n(this.isSupervised ? "controlledSettingChildRestriction" : "controlledSettingPolicy");
  },
  getIcon_() {
    return this.isSupervised ? "cr20:kite" : "cr20:domain";
  },
  onDevModeToggleChange_(e) {
    this.delegate.setProfileInDevMode(e.detail);
    chrome.metricsPrivate.recordUserAction("Options_ToggleDeveloperMode_" + (e.detail ? "Enabled" : "Disabled"));
  },
  onLoadUnpackedTap_() {
    this.delegate.loadUnpacked().catch((loadError) => {
      this.fire("load-error", loadError);
    });
    chrome.metricsPrivate.recordUserAction("Options_LoadUnpackedExtension");
  },
  onPackTap_() {
    chrome.metricsPrivate.recordUserAction("Options_PackExtension");
    this.showPackDialog_ = true;
  },
  onPackDialogClose_() {
    this.showPackDialog_ = false;
    this.$.packExtensions.focus();
  },
  onUpdateNowTap_() {
    if (this.isUpdating_) {
      return;
    }
    this.isUpdating_ = true;
    const toastManager = getToastManager();
    toastManager.duration = 0;
    toastManager.show(this.i18n("toolbarUpdatingToast"));
    this.delegate.updateAllExtensions(this.extensions).then(
      () => {
        toastManager.hide();
        toastManager.duration = 3e3;
        toastManager.show(this.i18n("toolbarUpdateDone"));
        this.isUpdating_ = false;
      },
      (loadError) => {
        this.fire("load-error", loadError);
        toastManager.hide();
        this.isUpdating_ = false;
      }
    );
  },
});
// Copyright 2015 The Chromium Authors. All rights reserved.
class Service {
  constructor() {
    this.isDeleting_ = false;
    this.eventsToIgnoreOnce_ = new Set();
  }
  getProfileConfiguration() {
    return new Promise(function(resolve, reject) {
      chrome.developerPrivate.getProfileConfiguration(resolve);
    });
  }
  getItemStateChangedTarget() {
    return chrome.developerPrivate.onItemStateChanged;
  }
  shouldIgnoreUpdate(extensionId, eventType) {
    return this.eventsToIgnoreOnce_.delete(`${extensionId}_${eventType}`);
  }
  ignoreNextEvent(extensionId, eventType) {
    this.eventsToIgnoreOnce_.add(`${extensionId}_${eventType}`);
  }
  getProfileStateChangedTarget() {
    return chrome.developerPrivate.onProfileStateChanged;
  }
  getExtensionsInfo() {
    return new Promise(function(resolve, reject) {
      chrome.developerPrivate.getExtensionsInfo(
        {
          includeDisabled: true,
          includeTerminated: true,
        },
        resolve
      );
    });
  }
  getExtensionSize(id) {
    return new Promise(function(resolve, reject) {
      chrome.developerPrivate.getExtensionSize(id, resolve);
    });
  }
  addRuntimeHostPermission(id, host) {
    return new Promise((resolve, reject) => {
      chrome.developerPrivate.addHostPermission(id, host, () => {
        if (chrome.runtime.lastError) {
          reject(chrome.runtime.lastError.message);
          return;
        }
        resolve();
      });
    });
  }
  removeRuntimeHostPermission(id, host) {
    return new Promise((resolve, reject) => {
      chrome.developerPrivate.removeHostPermission(id, host, () => {
        if (chrome.runtime.lastError) {
          reject(chrome.runtime.lastError.message);
          return;
        }
        resolve();
      });
    });
  }
  chooseFilePath_(selectType, fileType) {
    return new Promise(function(resolve, reject) {
      chrome.developerPrivate.choosePath(selectType, fileType, function(path) {
        if (chrome.runtime.lastError && chrome.runtime.lastError.message !== "File selection was canceled.") {
          reject(chrome.runtime.lastError);
        } else {
          resolve(path || "");
        }
      });
    });
  }
  updateExtensionCommandKeybinding(extensionId, commandName, keybinding) {
    chrome.developerPrivate.updateExtensionCommand({
      extensionId: extensionId,
      commandName: commandName,
      keybinding: keybinding,
    });
  }
  updateExtensionCommandScope(extensionId, commandName, scope) {
    this.ignoreNextEvent(extensionId, chrome.developerPrivate.EventType.COMMAND_REMOVED);
    chrome.developerPrivate.updateExtensionCommand({
      extensionId: extensionId,
      commandName: commandName,
      scope: scope,
    });
  }
  setShortcutHandlingSuspended(isCapturing) {
    chrome.developerPrivate.setShortcutHandlingSuspended(isCapturing);
  }
  loadUnpackedHelper_(opt_options) {
    return new Promise(function(resolve, reject) {
      const options = Object.assign(
        {
          failQuietly: true,
          populateError: true,
        },
        opt_options
      );
      chrome.developerPrivate.loadUnpacked(options, (loadError) => {
        if (chrome.runtime.lastError && chrome.runtime.lastError.message !== "File selection was canceled.") {
          throw new Error(chrome.runtime.lastError.message);
        }
        if (loadError) {
          return reject(loadError);
        }
        resolve();
      });
    });
  }
  deleteItem(id) {
    if (this.isDeleting_) {
      return;
    }
    chrome.metricsPrivate.recordUserAction("Extensions.RemoveExtensionClick");
    this.isDeleting_ = true;
    chrome.management.uninstall(
      id,
      {
        showConfirmDialog: true,
      },
      () => {
        chrome.runtime.lastError;
        this.isDeleting_ = false;
      }
    );
  }
  setItemEnabled(id, isEnabled) {
    chrome.metricsPrivate.recordUserAction(isEnabled ? "Extensions.ExtensionEnabled" : "Extensions.ExtensionDisabled");
    chrome.management.setEnabled(id, isEnabled);
  }
  setItemAllowedUserScripts(id, isAllowedUserScripts) {
    chrome.developerPrivate.updateExtensionConfiguration({
      extensionId: id,
      userScriptsAccess: isAllowedUserScripts
    })
  }
  setItemAllowedIncognito(id, isAllowedIncognito) {
    chrome.developerPrivate.updateExtensionConfiguration({
      extensionId: id,
      incognitoAccess: isAllowedIncognito,
    });
  }
  setItemAllowedOnFileUrls(id, isAllowedOnFileUrls) {
    chrome.developerPrivate.updateExtensionConfiguration({
      extensionId: id,
      fileAccess: isAllowedOnFileUrls,
    });
  }
  setItemHostAccess(id, hostAccess) {
    chrome.developerPrivate.updateExtensionConfiguration({
      extensionId: id,
      hostAccess: hostAccess,
    });
  }
  setItemCollectsErrors(id, collectsErrors) {
    chrome.developerPrivate.updateExtensionConfiguration({
      extensionId: id,
      errorCollection: collectsErrors,
    });
  }
  inspectItemView(id, view) {
    chrome.developerPrivate.openDevTools({
      extensionId: id,
      renderProcessId: view.renderProcessId,
      renderViewId: view.renderViewId,
      incognito: view.incognito,
    });
  }
  openUrl(url) {
    window.open(url);
  }
  reloadItem(id) {
    return new Promise(function(resolve, reject) {
      chrome.developerPrivate.reload(
        id,
        {
          failQuietly: true,
          populateErrorForUnpacked: true,
        },
        (loadError) => {
          if (loadError) {
            reject(loadError);
            return;
          }
          resolve();
        }
      );
    });
  }
  repairItem(id) {
    chrome.developerPrivate.repairExtension(id);
  }
  showItemOptionsPage(extension) {
    assert(extension && extension.optionsPage);
    if (extension.optionsPage.openInTab) {
      chrome.developerPrivate.showOptions(extension.id);
    } else {
      navigation.navigateTo({
        page: Page.DETAILS,
        subpage: Dialog.OPTIONS,
        extensionId: extension.id,
      });
    }
  }
  setProfileInDevMode(inDevMode) {
    chrome.developerPrivate.updateProfileConfiguration({
      inDeveloperMode: inDevMode,
    });
  }
  loadUnpacked() {
    return this.loadUnpackedHelper_();
  }
  retryLoadUnpacked(retryGuid) {
    return this.loadUnpackedHelper_({
      retryGuid: retryGuid,
    });
  }
  choosePackRootDirectory() {
    return this.chooseFilePath_(chrome.developerPrivate.SelectType.FOLDER, chrome.developerPrivate.FileType.LOAD);
  }
  choosePrivateKeyPath() {
    return this.chooseFilePath_(chrome.developerPrivate.SelectType.FILE, chrome.developerPrivate.FileType.PEM);
  }
  packExtension(rootPath, keyPath, flag, callback) {
    chrome.developerPrivate.packDirectory(rootPath, keyPath, flag, callback);
  }
  updateAllExtensions(extensions) {
    return new Promise((resolve) => {
      chrome.developerPrivate.autoUpdate(resolve);
      chrome.metricsPrivate.recordUserAction("Options_UpdateExtensions");
    }).then(() => {
      return new Promise((resolve, reject) => {
        const loadLocalExtensions = async () => {
          for (const extension of extensions) {
            if (extension.location === "UNPACKED") {
              try {
                await this.reloadItem(extension.id);
              } catch (loadError) {
                reject(loadError);
                break;
              }
            }
          }
          resolve("Loaded local extensions.");
        };
        loadLocalExtensions();
      });
    });
  }
  deleteErrors(extensionId, errorIds, type) {
    chrome.developerPrivate.deleteExtensionErrors({
      extensionId: extensionId,
      errorIds: errorIds,
      type: type,
    });
  }
  requestFileSource(args) {
    return new Promise(function(resolve, reject) {
      chrome.developerPrivate.requestFileSource(args, resolve);
    });
  }
  showInFolder(id) {
    console.log(id);
    chrome.developerPrivate.showPath(id);
  }
  getExtensionActivityLog(extensionId) {
    return new Promise(function(resolve, reject) {
      chrome.activityLogPrivate.getExtensionActivities(
        {
          activityType: chrome.activityLogPrivate.ExtensionActivityFilter.ANY,
          extensionId: extensionId,
        },
        resolve
      );
    });
  }
  getFilteredExtensionActivityLog(extensionId, searchTerm) {
    const anyType = chrome.activityLogPrivate.ExtensionActivityFilter.ANY;
    const activityLogFilters = [
      {
        activityType: anyType,
        extensionId: extensionId,
        apiCall: `%${searchTerm}%`,
      },
      {
        activityType: anyType,
        extensionId: extensionId,
        pageUrl: `%${searchTerm}%`,
      },
      {
        activityType: anyType,
        extensionId: extensionId,
        argUrl: `%${searchTerm}%`,
      },
    ];
    const promises = activityLogFilters.map(
      (filter) =>
        new Promise(function(resolve, reject) {
          chrome.activityLogPrivate.getExtensionActivities(filter, resolve);
        })
    );
    return Promise.all(promises).then((results) => {
      const activitiesById = new Map();
      for (const result of results) {
        for (const activity of result.activities) {
          activitiesById.set(activity.activityId, activity);
        }
      }
      return {
        activities: Array.from(activitiesById.values()),
      };
    });
  }
  deleteActivitiesById(activityIds) {
    return new Promise(function(resolve, reject) {
      chrome.activityLogPrivate.deleteActivities(activityIds, resolve);
    });
  }
  deleteActivitiesFromExtension(extensionId) {
    return new Promise(function(resolve, reject) {
      chrome.activityLogPrivate.deleteActivitiesByExtension(extensionId, resolve);
    });
  }
  getOnExtensionActivity() {
    return chrome.activityLogPrivate.onExtensionActivity;
  }
  downloadActivities(rawActivityData, fileName) {
    const blob = new Blob([rawActivityData], {
      type: "application/json",
    });
    const url = URL.createObjectURL(blob);
    const a = document.createElement("a");
    a.href = url;
    a.download = fileName;
    a.click();
  }
  loadUnpackedFromDrag() {
    return this.loadUnpackedHelper_({
      useDraggedPath: true,
    });
  }
  installDroppedFile() {
    chrome.developerPrivate.installDroppedFile();
  }
  notifyDragInstallInProgress() {
    chrome.developerPrivate.notifyDragInstallInProgress();
  }
}
addSingletonGetter(Service);
// Copyright 2016 The Chromium Authors. All rights reserved.
class DragAndDropHandler {
  constructor(dragEnabled, target) {
    this.dragEnabled = dragEnabled;
    this.eventTarget_ = target;
  }
  shouldAcceptDrag(e) {
    if (!this.dragEnabled) {
      return false;
    }
    return !!e.dataTransfer.types && e.dataTransfer.types.indexOf("Files") > -1;
  }
  doDragEnter() {
    Service.getInstance().notifyDragInstallInProgress();
    this.eventTarget_.dispatchEvent(new CustomEvent("extension-drag-started"));
  }
  doDragLeave() {
    this.fireDragEnded_();
  }
  doDragOver(e) {
    e.preventDefault();
  }
  doDrop(e) {
    this.fireDragEnded_();
    if (e.dataTransfer.files.length !== 1) {
      return;
    }
    let handled = false;
    const item = e.dataTransfer.items[0];
    if (item.kind === "file" && item.webkitGetAsEntry().isDirectory) {
      handled = true;
      this.handleDirectoryDrop_();
    } else if (/\.(crx|user\.js|zip)$/i.test(e.dataTransfer.files[0].name)) {
      handled = true;
      this.handleFileDrop_();
    }
    if (handled) {
      e.preventDefault();
    }
  }
  handleFileDrop_() {
    Service.getInstance().installDroppedFile();
  }
  handleDirectoryDrop_() {
    Service.getInstance()
      .loadUnpackedFromDrag()
      .catch((loadError) => {
        this.eventTarget_.dispatchEvent(
          new CustomEvent("drag-and-drop-load-error", {
            detail: loadError,
          })
        );
      });
  }
  fireDragEnded_() {
    this.eventTarget_.dispatchEvent(new CustomEvent("extension-drag-ended"));
  }
}
// Copyright 2016 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-drop-overlay",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-hidden-style" scope="extensions-drop-overlay">
      :host {
        align-items: center;
        background-color: rgba(241, 241, 241, 0.9);
        color: var(--cr-secondary-text-color);
        display: flex;
        height: 100%;
        justify-content: center;
        position: absolute;
        width: 100%;
        z-index: 10;
      }

      @media (prefers-color-scheme: dark) {
        :host {
          background-color: rgba(0, 0, 0, 0.6);
        }
      }

      #container {
        align-items: center;
        display: flex;
        flex-direction: column;
      }

      iron-icon {
        height: 64px;
        margin-bottom: 16px;
        width: 64px;
      }

      #text {
        color: #6e6e6e;
        font-size: 123.1%;
        font-weight: 500;
      }
    </style>
    <div id="container">
      <iron-icon icon="cr:extension"></iron-icon>
      <div id="text">___dropToInstall___</div>
    </div>
    <!--_html_template_end_-->`,
  properties: {
    dragEnabled: {
      type: Boolean,
      observer: "dragEnabledChanged_",
    },
  },
  created() {
    this.hidden = true;
    const dragTarget = document.documentElement;
    this.dragWrapperHandler_ = new DragAndDropHandler(true, dragTarget);
    dragTarget.addEventListener("extension-drag-started", () => {
      this.hidden = false;
    });
    dragTarget.addEventListener("extension-drag-ended", () => {
      this.hidden = true;
    });
    dragTarget.addEventListener("drag-and-drop-load-error", (e) => {
      this.fire("load-error", e.detail);
    });
    this.dragWrapper_ = new DragWrapper(dragTarget, this.dragWrapperHandler_);
  },
  dragEnabledChanged_(dragEnabled) {
    this.dragWrapperHandler_.dragEnabled = dragEnabled;
  },
});
// Copyright 2017 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-install-warnings-dialog",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style" scope="extensions-install-warnings-dialog">
      div[slot="body"] ul {
        background-color: var(--paper-red-50);
        margin: 0;
        padding-bottom: 10px;
        padding-inline-end: 10px;
        padding-top: 10px;
      }

      @media (prefers-color-scheme: dark) {
        div[slot="body"] ul {
          background-color: rgba(0, 0, 0, 0.3);
          color: var(--error-color);
        }
      }
    </style>
    <cr-dialog id="dialog" close-text="___close___">
      <div slot="title">___installWarnings___</div>
      <div slot="body">
        <ul>
          <template is="dom-repeat" items="[[installWarnings]]">
            <li>[[item]]</li>
          </template>
        </ul>
      </div>
      <div slot="button-container">
        <cr-button class="action-button" on-click="onOkTap_"> ___ok___ </cr-button>
      </div>
    </cr-dialog>
    <!--_html_template_end_-->`,
  properties: {
    installWarnings: Array,
  },
  attached() {
    this.$.dialog.showModal();
  },
  onOkTap_() {
    this.$.dialog.close();
  },
});
// Copyright 2016 The Chromium Authors. All rights reserved.
var WebUIListenerBehavior = {
  properties: {
    webUIListeners_: {
      type: Array,
      value() {
        return [];
      },
    },
  },
  addWebUIListener(eventName, callback) {
    this.webUIListeners_.push(addWebUIListener(eventName, callback));
  },
  detached() {
    while (this.webUIListeners_.length > 0) {
      removeWebUIListener(this.webUIListeners_.pop());
    }
  },
};
// Copyright 2018 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="managed-footnote">
      :host {
        align-items: center;
        border-top: 1px solid var(--cr-separator-color);
        color: var(--cr-secondary-text-color);
        display: none;

        font-size: 0.8125rem;
        justify-content: center;
        padding: 0 24px;
      }

      :host([is-managed_]) {
        display: flex;
      }

      a[href] {
        color: var(--cr-link-color);
        text-decoration: none;
      }

      iron-icon {
        align-self: flex-start;
        flex-shrink: 0;
        height: 20px;
        padding-inline-end: var(--managed-footnote-icon-padding, 8px);
        width: 20px;
      }
    </style>

    <template is="dom-if" if="[[isManaged_]]">
      <iron-icon icon="cr:domain"></iron-icon>
      <div id="content" inner-h-t-m-l="[[getManagementString_(showDeviceInfo)]]"></div>
    </template>
    <!--_html_template_end_-->`,
  is: "managed-footnote",
  behaviors: [I18nBehavior, WebUIListenerBehavior],
  properties: {
    isManaged_: {
      reflectToAttribute: true,
      type: Boolean,
      value() {
        return loadTimeData.getBoolean("isManaged");
      },
    },
    showDeviceInfo: {
      type: Boolean,
      value: false,
    },
  },
  ready() {
    this.addWebUIListener("is-managed-changed", (managed) => {
      loadTimeData.overrideValues({
        isManaged: managed,
      });
      this.isManaged_ = managed;
    });
  },
  getManagementString_() {
    //
    return this.i18nAdvanced("browserManagedByOrg");
  },
});
chrome.send("observeManagedUI");
// Copyright 2019 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-checkup",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-shared-style iron-flex shared-style" scope="extensions-checkup">
      :host {
        --checkup-card-margin: 24px;
        --banner-img-height: 115px;
        --banner-img-width: 298px;
      }

      #card {
        background-color: var(--cr-card-background-color);
        border-radius: var(--cr-card-border-radius);
        box-shadow: var(--cr-card-shadow);
        overflow: hidden;
        padding: var(--checkup-card-margin);
        transition: height var(--drawer-transition);
      }

      #banner-img {
        background: url(checkup_image.svg);
        background-repeat: no-repeat;
        display: inline-block;
        float: right;

        height: var(--banner-img-height);
        width: var(--banner-img-width);
      }

      #banner-description {
        flex-basis: var(--extensions-card-width);
        text-overflow: ellipsis;
      }

      #banner-title {
        color: var(--cr-primary-text-color);
        font-size: 123%;
      }

      @media (max-width: 931px) {
        #banner-img {
          display: block;
          float: initial;
          margin: 12px auto 0;
        }
      }

      @media (prefers-color-scheme: dark) {
        #banner-img {
          background: url(checkup_image_dark.svg);
        }
      }
    </style>
    <div id="card">
      <div id="banner-title" class="cr-title-text"></div>
      <div id="banner-img"></div>
      <div id="banner-description" class="cr-secondary-text">
        <p></p>
        <p></p>
      </div>
    </div>
    <!--_html_template_end_-->`,
});
// Copyright 2015 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-item-list",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="shared-style" scope="extensions-item-list">
      .items-container,
      #content-wrapper {
        --extensions-card-width: 792px;
      }

      #container {
        box-sizing: border-box;
        height: 100%;
        overflow: overlay;
      }

      #content-wrapper {
        min-width: var(--extensions-card-width);
        padding: 24px 60px 64px;
        background: var(--maxthon-bg-base);
      }

      .empty-list-message {
        color: #6e6e6e;
        font-size: 123%;
        font-weight: 500;
        margin-top: 80px;
        text-align: center;
      }

      @media (prefers-color-scheme: dark) {
        .empty-list-message {
          color: var(--cr-secondary-text-color);
        }
      }

      .items-container {
        display: grid;
        grid-row-gap: 16px;
        grid-template-columns: 792px;
      }

      #checkup-container {
        grid-column: 1 / -1;

        min-height: var(--extensions-card-height);
      }

      extensions-item {
        grid-column-start: auto;
        grid-row-start: auto;
      }

      #app-title {
        color: var(--cr-primary-text-color);
        font-size: 123%;
        font-weight: 400;
        letter-spacing: 0.25px;
        margin-bottom: 12px;
        margin-top: 21px;
        padding-bottom: 4px;
        padding-top: 8px;
      }

      managed-footnote {
        border-top: none;

        margin-bottom: -24px;
        padding-bottom: 12px;
        padding-top: 12px;

        z-index: 1;
      }
    </style>
    <div id="container">
      <managed-footnote hidden="[[filter]]"></managed-footnote>
      <div id="content-wrapper" style="--max-columns: [[maxColumns_]];">
        <div
          id="no-items"
          class="empty-list-message"
          hidden$="[[!shouldShowEmptyItemsMessage_(apps.length, extensions.length)]]"
        >
          <span on-click="onNoExtensionsTap_"> ___noExtensionsOrApps___ </span>
        </div>
        <div
          id="no-search-results"
          class="empty-list-message"
          hidden$="[[!shouldShowEmptySearchMessage_(shownAppsCount_, shownExtensionsCount_, apps, extensions)]]"
        >
          <span>___noSearchResults___</span>
        </div>
        <div class="items-container" hidden="[[!shownExtensionsCount_]]">
          <div id="checkup-container" hidden="[[!showCheckup_]]">
            <extensions-checkup id="checkup" slot="view"> </extensions-checkup>
          </div>
          <!-- Render only a few items first, to improve initial render time,
        then render the remaining items on a different frame. Value of 3
        was chosen by experimentation, and it is a good trade-off between
        initial render time and total render time. -->
          <template is="dom-repeat" items="[[extensions]]" initial-count="3" filter="[[computedFilter_]]" rendered-item-count="{{shownExtensionsCount_::dom-change}}">
            <extensions-item id="[[item.id]]" data="[[item]]" delegate="[[delegate]]" in-dev-mode="[[inDevMode]]"> </extensions-item>
          </template>
        </div>
        <div hidden="[[!shownAppsCount_]]">
          <!-- app-title needs to left-align with the grid content below, and
           the easiest way to achieve this is to make it a grid as well. -->
          <h2 id="app-title" class="items-container">Maxthon Apps</h2>
          <div class="items-container">
            <template is="dom-repeat" items="[[apps]]" initial-count="3" filter="[[computedFilter_]]" rendered-item-count="{{shownAppsCount_::dom-change}}">
              <extensions-item id="[[item.id]]" data="[[item]]" delegate="[[delegate]]" in-dev-mode="[[inDevMode]]"> </extensions-item>
            </template>
          </div>
        </div>
      </div>
    </div>
    <!--_html_template_end_-->`,
  behaviors: [CrContainerShadowBehavior, I18nBehavior],
  properties: {
    apps: Array,
    extensions: Array,
    delegate: Object,
    inDevMode: {
      type: Boolean,
      value: false,
    },
    filter: {
      type: String,
    },
    computedFilter_: {
      type: String,
      computed: "computeFilter_(filter)",
      observer: "announceSearchResults_",
    },
    maxColumns_: {
      type: Number,
      value: () => 1,
    },
    showCheckup_: {
      type: Boolean,
      value: () => loadTimeData.getBoolean("showCheckup"),
    },
    shownAppsCount_: {
      type: Number,
      value: 0,
    },
    shownExtensionsCount_: {
      type: Number,
      value: 0,
    },
  },
  getDetailsButton(id) {
    const item = this.$$(`#${id}`);
    return item && item.getDetailsButton();
  },
  getErrorsButton(id) {
    const item = this.$$(`#${id}`);
    return item && item.getErrorsButton();
  },
  computeFilter_() {
    const formattedFilter = this.filter.trim().toLowerCase();
    return formattedFilter ? (i) => i.name.toLowerCase().includes(formattedFilter) : null;
  },
  shouldShowEmptyItemsMessage_() {
    if (!this.apps || !this.extensions) {
      return;
    }
    return this.apps.length === 0 && this.extensions.length === 0;
  },
  shouldShowEmptySearchMessage_() {
    return !this.shouldShowEmptyItemsMessage_() && this.shownAppsCount_ === 0 && this.shownExtensionsCount_ === 0;
  },
  onNoExtensionsTap_(e) {
    if (e.target.tagName === "A") {
      chrome.metricsPrivate.recordUserAction("Options_GetMoreExtensions");
    }
  },
  announceSearchResults_() {
    if (this.computedFilter_) {
      IronA11yAnnouncer.requestAvailability();
      this.async(() => {
        const total = this.shownAppsCount_ + this.shownExtensionsCount_;
        this.fire("iron-announce", {
          text: this.shouldShowEmptySearchMessage_() ? this.i18n("noSearchResults") : total === 1 ? this.i18n("searchResultsSingular", this.filter) : this.i18n("searchResultsPlural", total.toString(), this.filter),
        });
      });
    }
  },
});
// Copyright 2016 The Chromium Authors. All rights reserved.
const Key = {
  Comma: 188,
  Del: 46,
  Down: 40,
  End: 35,
  Escape: 27,
  Home: 36,
  Ins: 45,
  Left: 37,
  MediaNextTrack: 176,
  MediaPlayPause: 179,
  MediaPrevTrack: 177,
  MediaStop: 178,
  PageDown: 34,
  PageUp: 33,
  Period: 190,
  Right: 39,
  Space: 32,
  Tab: 9,
  Up: 38,
};
const ModifierPolicy = {
  NOT_ALLOWED: 0,
  REQUIRED: 1,
};
function getModifierPolicy(keyCode) {
  switch (keyCode) {
    case Key.MediaNextTrack:
    case Key.MediaPlayPause:
    case Key.MediaPrevTrack:
    case Key.MediaStop:
      return ModifierPolicy.NOT_ALLOWED;
    default:
      return ModifierPolicy.REQUIRED;
  }
}
function hasModifier(e, countShiftAsModifier) {
  return e.ctrlKey || e.altKey || (isMac && e.metaKey) || (isChromeOS && e.metaKey) || (countShiftAsModifier && e.shiftKey);
}
function isValidKeyCode(keyCode) {
  if (keyCode === Key.Escape) {
    return false;
  }
  for (const k in Key) {
    if (Key[k] === keyCode) {
      return true;
    }
  }
  return (keyCode >= "A".charCodeAt(0) && keyCode <= "Z".charCodeAt(0)) || (keyCode >= "0".charCodeAt(0) && keyCode <= "9".charCodeAt(0));
}
function keystrokeToString(e) {
  const output = [];
  if (isMac && e.metaKey) {
    output.push("Command");
  }
  if (isChromeOS && e.metaKey) {
    output.push("Search");
  }
  if (e.ctrlKey) {
    output.push("Ctrl");
  }
  if (!e.ctrlKey && e.altKey) {
    output.push("Alt");
  }
  if (e.shiftKey) {
    output.push("Shift");
  }
  const keyCode = e.keyCode;
  if (isValidKeyCode(keyCode)) {
    if ((keyCode >= "A".charCodeAt(0) && keyCode <= "Z".charCodeAt(0)) || (keyCode >= "0".charCodeAt(0) && keyCode <= "9".charCodeAt(0))) {
      output.push(String.fromCharCode(keyCode));
    } else {
      switch (keyCode) {
        case Key.Comma:
          output.push("Comma");
          break;
        case Key.Del:
          output.push("Delete");
          break;
        case Key.Down:
          output.push("Down");
          break;
        case Key.End:
          output.push("End");
          break;
        case Key.Home:
          output.push("Home");
          break;
        case Key.Ins:
          output.push("Insert");
          break;
        case Key.Left:
          output.push("Left");
          break;
        case Key.MediaNextTrack:
          output.push("MediaNextTrack");
          break;
        case Key.MediaPlayPause:
          output.push("MediaPlayPause");
          break;
        case Key.MediaPrevTrack:
          output.push("MediaPrevTrack");
          break;
        case Key.MediaStop:
          output.push("MediaStop");
          break;
        case Key.PageDown:
          output.push("PageDown");
          break;
        case Key.PageUp:
          output.push("PageUp");
          break;
        case Key.Period:
          output.push("Period");
          break;
        case Key.Right:
          output.push("Right");
          break;
        case Key.Space:
          output.push("Space");
          break;
        case Key.Tab:
          output.push("Tab");
          break;
        case Key.Up:
          output.push("Up");
          break;
      }
    }
  }
  return output.join("+");
}
function hasValidModifiers(e) {
  switch (getModifierPolicy(e.keyCode)) {
    case ModifierPolicy.REQUIRED:
      return hasModifier(e, false);
    case ModifierPolicy.NOT_ALLOWED:
      return !hasModifier(e, true);
  }
  assertNotReached();
}
// Copyright 2016 The Chromium Authors. All rights reserved.
const ShortcutError = {
  NO_ERROR: 0,
  INCLUDE_START_MODIFIER: 1,
  TOO_MANY_MODIFIERS: 2,
  NEED_CHARACTER: 3,
};
Polymer({
  is: "extensions-shortcut-input",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-icons cr-hidden-style" scope="extensions-shortcut-input">
      #main {
        position: relative;
        width: 200px;
      }

      #clear {
        --cr-icon-button-size: 28px;
        position: absolute;
        right: 2px;
      }

      :host-context([dir="rtl"]) #clear {
        left: -2px;
        right: inherit;
      }

      [invisible] {
        opacity: 0;
      }
    </style>
    <div id="main">
      <cr-input
        id="input"
        placeholder="___shortcutTypeAShortcut___"
        invalid="[[getIsInvalid_(error_)]]"
        error-message="[[getErrorString_(error_,
          '___shortcutIncludeStartModifier___',
          '___shortcutTooManyModifiers___',
          '___shortcutNeedCharacter___')]]"
        value="[[computeText_(capturing_, shortcut, pendingShortcut_)]]"
      >
        <cr-icon-button id="clear" aria-label="___clear___" slot="suffix" class="icon-cancel no-overlap" invisible$="[[computeClearInvisible_(capturing_, shortcut)]]" hidden$="[[computeClearHidden_(shortcut)]]" on-click="onClearTap_"></cr-icon-button>
      </cr-input>
    </div>
    <!--_html_template_end_-->`,
  behaviors: [I18nBehavior],
  properties: {
    delegate: Object,
    item: {
      type: String,
      value: "",
    },
    commandName: {
      type: String,
      value: "",
    },
    shortcut: {
      type: String,
      value: "",
    },
    capturing_: {
      type: Boolean,
      value: false,
    },
    error_: {
      type: Number,
      value: ShortcutError.NO_ERROR,
    },
    pendingShortcut_: {
      type: String,
      value: "",
    },
  },
  ready() {
    const node = this.$.input;
    node.addEventListener("mouseup", this.startCapture_.bind(this));
    node.addEventListener("blur", this.endCapture_.bind(this));
    node.addEventListener("focus", this.startCapture_.bind(this));
    node.addEventListener("keydown", this.onKeyDown_.bind(this));
    node.addEventListener("keyup", this.onKeyUp_.bind(this));
  },
  startCapture_() {
    if (this.capturing_) {
      return;
    }
    this.capturing_ = true;
    this.delegate.setShortcutHandlingSuspended(true);
  },
  endCapture_() {
    if (!this.capturing_) {
      return;
    }
    this.pendingShortcut_ = "";
    this.capturing_ = false;
    const input = this.$.input;
    input.blur();
    this.error_ = ShortcutError.NO_ERROR;
    this.delegate.setShortcutHandlingSuspended(false);
  },
  onKeyDown_(e) {
    if (e.target === this.$.clear) {
      return;
    }
    if (e.keyCode === Key.Escape) {
      if (!this.capturing_) {
        return;
      }
      this.endCapture_();
      e.preventDefault();
      e.stopPropagation();
      return;
    }
    if (e.keyCode === Key.Tab) {
      return;
    }
    if (!this.capturing_) {
      this.startCapture_();
    }
    this.handleKey_(e);
  },
  onKeyUp_(e) {
    if (e.target === this.$.clear || e.key === "Enter") {
      return;
    }
    if (e.keyCode === Key.Escape || e.keyCode === Key.Tab) {
      return;
    }
    this.handleKey_(e);
  },
  getErrorString_(error, includeStartModifier, tooManyModifiers, needCharacter) {
    switch (this.error_) {
      case ShortcutError.INCLUDE_START_MODIFIER:
        return includeStartModifier;
      case ShortcutError.TOO_MANY_MODIFIERS:
        return tooManyModifiers;
      case ShortcutError.NEED_CHARACTER:
        return needCharacter;
      default:
        assert(this.error_ === ShortcutError.NO_ERROR);
        return "";
    }
  },
  handleKey_(e) {
    e.preventDefault();
    e.stopPropagation();
    if (e.ctrlKey && e.altKey) {
      this.error_ = ShortcutError.TOO_MANY_MODIFIERS;
      return;
    }
    if (!hasValidModifiers(e)) {
      this.pendingShortcut_ = "";
      this.error_ = ShortcutError.INCLUDE_START_MODIFIER;
      return;
    }
    this.pendingShortcut_ = keystrokeToString(e);
    if (!isValidKeyCode(e.keyCode)) {
      this.error_ = ShortcutError.NEED_CHARACTER;
      return;
    }
    this.error_ = ShortcutError.NO_ERROR;
    IronA11yAnnouncer.requestAvailability();
    this.fire("iron-announce", {
      text: this.i18n("shortcutSet", this.computeText_()),
    });
    this.commitPending_();
    this.endCapture_();
  },
  commitPending_() {
    this.shortcut = this.pendingShortcut_;
    this.delegate.updateExtensionCommandKeybinding(this.item, this.commandName, this.shortcut);
  },
  computeText_() {
    const shortcutString = this.capturing_ ? this.pendingShortcut_ : this.shortcut;
    return shortcutString.split("+").join(" + ");
  },
  computeClearInvisible_() {
    return this.capturing_ && !!this.shortcut;
  },
  computeClearHidden_() {
    return !this.shortcut;
  },
  getIsInvalid_() {
    return this.error_ !== ShortcutError.NO_ERROR;
  },
  onClearTap_() {
    assert(this.shortcut);
    this.pendingShortcut_ = "";
    this.commitPending_();
    this.endCapture_();
  },
});
// Copyright 2016 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-keyboard-shortcuts",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="md-select cr-shared-style" scope="extensions-keyboard-shortcuts">
      :host {
        height: 100%;
        --cr-toolbar-field-width: 792px;
      }

      .shortcut-card {
        background-color: var(--cr-card-background-color);
        color: var(--cr-primary-text-color);
        padding-bottom: 8px;
        width: var(--cr-toolbar-field-width);
        border: 1px solid var(--maxthon-border);
        border-bottom: none;
      }

      .shortcut-card:last-of-type {
        margin-bottom: 64px;
        border-bottom: 1px solid var(--maxthon-border);
      }

      #container {
        box-sizing: border-box;
        height: 100%;
        overflow: overlay;
        padding-top: 24px;
        padding-left: 33px;
      }

      .command-entry {
        align-items: start;
        display: flex;

        margin-bottom: -8px;
        padding-top: 16px;
      }

      .command-name {
        flex: 1;
        margin-top: 6px;
      }

      .command-entry .md-select {
        line-height: 22px;
        margin-inline-start: var(--cr-section-padding);
      }

      .card-title {
        align-items: center;
        border-bottom: var(--cr-separator-line);
        display: flex;
        margin-bottom: 9px;
        padding: 16px var(--cr-section-padding);
      }

      .icon {
        height: 20px;
        margin-inline-end: 20px;
        width: 20px;
      }

      .card-controls {
        margin-inline-end: 20px;
        margin-inline-start: 60px;
      }
    </style>
    <div id="container">
      <template is="dom-repeat" items="[[calculateShownItems_(items.*)]]">
        <div class="shortcut-card">
          <div class="card-title cr-title-text">
            <img
              class="icon"
              src="[[item.iconUrl]]"
              alt$="[[appOrExtension(
              item.type,
              '___appIcon___',
              '___extensionIcon___')]]"
            />
            <span role="heading" aria-level="2">[[item.name]]</span>
          </div>
          <div class="card-controls">
            <template is="dom-repeat" items="[[item.commands]]" as="command">
              <div class="command-entry" command="[[command]]">
                <span class="command-name">[[command.description]]</span>
                <extensions-shortcut-input delegate="[[delegate]]" item="[[item.id]]" shortcut="[[command.keybinding]]" command-name="[[command.name]]"> </extensions-shortcut-input>
                <!-- Binding "value" to triggerScopeChange_ to trigger update
                only after CommandScope_ becomes available. -->
                <select
                  class="md-select"
                  on-change="onScopeChanged_"
                  disabled$="[[computeScopeDisabled_(command)]]"
                  value="[[
                    triggerScopeChange_(command.scope, CommandScope_)]]"
                >
                  <option value$="[[CommandScope_.CHROME]]">___shortcutScopeInChrome___</option>
                  <option value$="[[CommandScope_.GLOBAL]]">___shortcutScopeGlobal___</option>
                </select>
              </div>
            </template>
          </div>
        </div>
      </template>
    </div>
    <!--_html_template_end_-->`,
  behaviors: [CrContainerShadowBehavior, ItemBehavior],
  properties: {
    delegate: Object,
    items: Array,
    CommandScope_: {
      type: Object,
      value: chrome.developerPrivate.CommandScope,
    },
  },
  listeners: {
    "view-enter-start": "onViewEnter_",
  },
  onViewEnter_() {
    chrome.metricsPrivate.recordUserAction("Options_ExtensionCommands");
  },
  calculateShownItems_() {
    return this.items.filter(function(item) {
      return item.commands.length > 0;
    });
  },
  hasKeybinding_(keybinding) {
    return !!keybinding;
  },
  computeScopeDisabled_(command) {
    return command.isExtensionAction || !command.isActive;
  },
  triggerScopeChange_(scope) {
    return scope;
  },
  onCloseButtonClick_() {
    this.fire("close");
  },
  onScopeChanged_(event) {
    this.delegate.updateExtensionCommandScope(event.model.get("item.id"), event.model.get("command.name"), event.target.value);
  },
});

// 导入导出
Polymer({
  is: "extensions-import-export",
  _template: html` <!--css-build:shadow-->
    <!--_html_template_start_-->
    <style include="md-select cr-shared-style" scope="extensions-import-export">
      :host {
        height: 100%;
        --cr-toolbar-field-width: 792px;
      }

      #container {
        box-sizing: border-box;
        display: flex;
        height: 100%;
        overflow: overlay;
        padding-top: 31px;
        padding-left: 40px;
        line-height: 24px;
        background-color: var(--cr-card-background-color);
      }

      .import-export-label {
        flex: none;
        color: var(--cr-title-text-color);
        font-size: 15px;
        font-weight: bold;
      }

      .import-export-controls {
        flex: auto;
        margin-left: 35px;
      }

      .import-export-title {
        display: flex;
        margin-bottom: 20px;
        font-size: 13px;
        user-select: none;
      }

      .import-export-title-text {
        display: inline-flex;
        align-items: center;
        color: var(--cr-title-text-color);
        font-weight: bold;
        cursor: pointer;
      }
      .import-export-title-text::after {
        width: 16px;
        height: 16px;
        margin-left: 8px;
        background-size: cover;
        background-image: url("./resources/img/action.svg");
        content: '';
      }
      .import-export-title-text:hover::after {
        background-image: url("./resources/img/action-hover.svg");
      }

      .import-export-title.loading .import-export-title-text {
        cursor: not-allowed;
      }

      .import-export-title-status {
        margin-left: 40px;
        padding-right: 20px;
        color: #9e9e9e;
        background-position: right center;
        background-repeat: no-repeat;
        background-size: 12px;
      }

      .import-export-title.loading .import-export-title-status {
        background-image: url("./resources/img/status-loading.png");
      }

      .import-export-title.success .import-export-title-status {
        background-image: url("./resources/img/status-success.png");
      }

      .import-export-title.fail .import-export-title-status {
        background-image: url("./resources/img/status-fail.png");
      }

      .import-export-title-btn {
        color: #458ff3;
        margin-left: 15px;
        cursor: pointer;
      }

      .import-export-title-error {
        margin-left: 15px;
        color: #9e9e9e;
      }

      .import-export-info {
        color: #9e9e9e;
        font-size: 13px;
        margin-bottom: 40px;
      }
    </style>
    <div id="container">
      <div class="import-export-label">___ext_exportOrImport___</div>
      <div class="import-export-controls">
        <div class$="import-export-title [[exportStatus]]">
          <span class="import-export-title-text" on-click="onExportClick">___ext_export___</span>
          <span class="import-export-title-status">[[exportText]]</span>
          <span class="import-export-title-btn" on-click="onExportOpenFolder">[[exportBtn]]</span>
        </div>
        <div class="import-export-info">___ext_exportDesc___</div>
        <div class$="import-export-title [[importStatus]]">
          <span class="import-export-title-text" on-click="onImportClick">___ext_import___</span>
          <span class="import-export-title-status">[[importText]]</span>
          <span class="import-export-title-error">[[importErrorText]]</span>
        </div>
        <div class="import-export-info">___ext_importDesc___</div>
      </div>
    </div>
    <!--_html_template_end_-->`,
  behaviors: [I18nBehavior, WebUIListenerBehavior],
  properties: {
    exportStatus: {
      type: String,
      value: undefined, // loading-正在保存 fail-失败 success-成功
    },
    exportText: {
      type: String,
      value: undefined,
    },
    exportBtn: {
      type: String,
      value: undefined,
    },
    exportPath: {
      type: String,
      value: undefined,
    },
    importStatus: {
      type: String,
      value: undefined,
    },
    importText: {
      type: String,
      value: undefined,
    },
    importErrorText: {
      type: String,
      value: undefined,
    },
  },
  ready() {
    this.getStatus();
    this.onExporting();
    this.onImporting();
  },
  // 查询当前状态
  getStatus() {
    const _this = this;
    window.isDuringExport = function(isExporting) {
      if (isExporting) {
        _this.onExportStart();
      }
    };
    window.isDuringImport = function(isImporting) {
      if (isImporting) {
        _this.onImportStart();
      }
    };
    chrome.send("isDuringImportOrExportExtensions", ["isDuringExport", 0]);
    chrome.send("isDuringImportOrExportExtensions", ["isDuringImport", 1]);
  },
  // 点击导出按钮
  onExportClick() {
    if (this.exportStatus === "loading") {
      return;
    }
    chrome.send("exportExtensions", []);
  },
  // 正在导出的状态
  onExportStart() {
    this.exportStatus = "loading";
    this.exportText = this.i18n("ext_exportSaving");
    this.exportBtn = undefined;
    this.exportPath = undefined;
  },
  // 监听导出结果
  onExporting() {
    this.addWebUIListener("maxthon_extensions_export", (managed) => {
      console.log(managed);
      switch (managed.event) {
        case 0: // 开始
          this.onExportStart();
          break;
        case 1: // 取消
          break;
        case 2: // 成功
          this.exportStatus = "success";
          this.exportText = this.i18n("ext_exportSucceed");
          this.exportBtn = this.i18n("ext_showExportFile");
          this.exportPath = managed.msg;
          break;
        case 3: // 失败
          this.exportStatus = "fail";
          this.exportText = this.i18n("ext_exportFailed");
          this.exportBtn = undefined;
          this.exportPath = undefined;
          break;
        default:
      }
    });
  },
  // 打开导出文件
  onExportOpenFolder() {
    chrome.send("openFolder", [this.exportPath]);
  },
  // 点击导入按钮
  onImportClick() {
    if (this.importStatus === "loading") {
      return;
    }
    chrome.send("importExtensions", []);
  },
  // 正在导入的状态
  onImportStart() {
    this.importStatus = "loading";
    this.importText = this.i18n("ext_importDlgImporting");
    this.importErrorText = undefined;
  },
  // 监听导入结果
  onImporting() {
    this.addWebUIListener("maxthon_extensions_import", (managed) => {
      console.log(managed);
      switch (managed.event) {
        case 0: // 开始
          this.onImportStart();
          break;
        case 1: // 取消
          break;
        case 2: // 成功
          this.importStatus = "success";
          this.importText = this.i18n("ext_importDlgSucceed");
          this.importErrorText = undefined;
          break;
        case 3: // 失败
          this.importStatus = "fail";
          this.importText = this.i18n("ext_importDlgFailed");
          this.importErrorText = this.i18n("ext_importDlgFailedDesc");
          break;
        default:
      }
    });
  },
});

// Copyright 2016 The Chromium Authors. All rights reserved.
function whenDocumentReady() {
  if (document.readyState === "complete") {
    return Promise.resolve();
  }
  return new Promise(function(resolve) {
    document.addEventListener("readystatechange", function f() {
      if (document.readyState === "complete") {
        document.removeEventListener("readystatechange", f);
        resolve();
      }
    });
  });
}
const OptionsDialogMinWidth = 400;
const OptionsDialogMaxHeight = 640;
Polymer({
  is: "extensions-options-dialog",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style scope="extensions-options-dialog">
      #icon {
        height: 32px;
        margin-inline-end: 10px;
        width: 32px;
      }

      #icon-and-name-wrapper {
        align-items: center;
        display: flex;
      }

      ExtensionOptions {
        display: block;
        height: 100%;
        overflow: hidden;
      }

      cr-dialog::part(dialog) {
        height: var(--dialog-height);
        opacity: var(--dialog-opacity, 0);

        transition: opacity 100ms ease 100ms;
        width: var(--dialog-width);
      }

      cr-dialog::part(wrapper) {
        height: 100%;
        max-height: initial;
        overflow: hidden;
      }

      cr-dialog #body {
        height: 100%;
        padding: 0;
      }

      cr-dialog {
        --cr-dialog-body-border-bottom: none;
        --cr-dialog-body-border-top: none;
        --scroll-border: none;
      }

      cr-dialog::part(body-container) {
        height: 100%;
        min-height: initial;
      }
    </style>

    <cr-dialog id="dialog" close-text="___close___" on-close="onClose_" show-close-button="">
      <div slot="title">
        <div id="icon-and-name-wrapper">
          <img
            id="icon"
            src="[[data_.iconUrl]]"
            alt$="[[appOrExtension(
              data.type,
              '___appIcon___',
              '___extensionIcon___')]]"
          />
          <span>[[data_.name]]</span>
        </div>
      </div>
      <div slot="body" id="body"></div>
    </cr-dialog>
    <!--_html_template_end_-->`,
  behaviors: [ItemBehavior],
  properties: {
    extensionOptions_: Object,
    data_: Object,
  },
  boundUpdateDialogSize_: null,
  preferredSize_: null,
  get open() {
    return this.$.dialog.open;
  },
  updateDialogSize_() {
    const headerHeight = this.$.body.offsetTop;
    const maxHeight = Math.min(0.9 * window.innerHeight, OptionsDialogMaxHeight);
    const effectiveHeight = Math.min(maxHeight, headerHeight + this.preferredSize_.height);
    const effectiveWidth = Math.max(OptionsDialogMinWidth, this.preferredSize_.width);
    this.$.dialog.style.setProperty("--dialog-height", `${effectiveHeight}px`);
    this.$.dialog.style.setProperty("--dialog-width", `${effectiveWidth}px`);
    this.$.dialog.style.setProperty("--dialog-opacity", "1");
  },
  show(data) {
    this.data_ = data;
    whenDocumentReady().then(() => {
      if (!this.extensionOptions_) {
        this.extensionOptions_ = document.createElement("ExtensionOptions");
      }
      this.extensionOptions_.extension = this.data_.id;
      this.extensionOptions_.onclose = () => this.$.dialog.close();
      const boundUpdateDialogSize = this.updateDialogSize_.bind(this);
      this.boundUpdateDialogSize_ = boundUpdateDialogSize;
      this.extensionOptions_.onpreferredsizechanged = (e) => {
        if (!this.$.dialog.open) {
          this.$.dialog.showModal();
        }
        this.preferredSize_ = e;
        this.debounce("updateDialogSize_", boundUpdateDialogSize, 50);
      };
      window.addEventListener("resize", this.boundUpdateDialogSize_);
      this.$.body.appendChild(this.extensionOptions_);
    });
  },
  onClose_() {
    this.extensionOptions_.onpreferredsizechanged = null;
    if (this.boundUpdateDialogSize_) {
      window.removeEventListener("resize", this.boundUpdateDialogSize_);
      this.boundUpdateDialogSize_ = null;
    }
    const currentPage = navigation.getCurrentPage();
    if (currentPage && currentPage.page === Page.DETAILS) {
      navigation.navigateTo({
        page: Page.DETAILS,
        extensionId: currentPage.extensionId,
      });
    }
  },
});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
class IronSelection {
  constructor(selectCallback) {
    this.selection = [];
    this.selectCallback = selectCallback;
  }
  get() {
    return this.multi ? this.selection.slice() : this.selection[0];
  }
  clear(excludes) {
    this.selection.slice().forEach(function(item) {
      if (!excludes || excludes.indexOf(item) < 0) {
        this.setItemSelected(item, false);
      }
    }, this);
  }
  isSelected(item) {
    return this.selection.indexOf(item) >= 0;
  }
  setItemSelected(item, isSelected) {
    if (item != null) {
      if (isSelected !== this.isSelected(item)) {
        if (isSelected) {
          this.selection.push(item);
        } else {
          var i = this.selection.indexOf(item);
          if (i >= 0) {
            this.selection.splice(i, 1);
          }
        }
        if (this.selectCallback) {
          this.selectCallback(item, isSelected);
        }
      }
    }
  }
  select(item) {
    if (this.multi) {
      this.toggle(item);
    } else if (this.get() !== item) {
      this.setItemSelected(this.get(), false);
      this.setItemSelected(item, true);
    }
  }
  toggle(item) {
    this.setItemSelected(item, !this.isSelected(item));
  }
}
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const IronSelectableBehavior = {
  properties: {
    attrForSelected: {
      type: String,
      value: null,
    },
    selected: {
      type: String,
      notify: true,
    },
    selectedItem: {
      type: Object,
      readOnly: true,
      notify: true,
    },
    activateEvent: {
      type: String,
      value: "tap",
      observer: "_activateEventChanged",
    },
    selectable: String,
    selectedClass: {
      type: String,
      value: "iron-selected",
    },
    selectedAttribute: {
      type: String,
      value: null,
    },
    fallbackSelection: {
      type: String,
      value: null,
    },
    items: {
      type: Array,
      readOnly: true,
      notify: true,
      value: function() {
        return [];
      },
    },
    _excludedLocalNames: {
      type: Object,
      value: function() {
        return {
          template: 1,
          "dom-bind": 1,
          "dom-if": 1,
          "dom-repeat": 1,
        };
      },
    },
  },
  observers: ["_updateAttrForSelected(attrForSelected)", "_updateSelected(selected)", "_checkFallback(fallbackSelection)"],
  created: function() {
    this._bindFilterItem = this._filterItem.bind(this);
    this._selection = new IronSelection(this._applySelection.bind(this));
  },
  attached: function() {
    this._observer = this._observeItems(this);
    this._addListener(this.activateEvent);
  },
  detached: function() {
    if (this._observer) {
      dom(this).unobserveNodes(this._observer);
    }
    this._removeListener(this.activateEvent);
  },
  indexOf: function(item) {
    return this.items ? this.items.indexOf(item) : -1;
  },
  select: function(value) {
    this.selected = value;
  },
  selectPrevious: function() {
    var length = this.items.length;
    var index = length - 1;
    if (this.selected !== undefined) {
      index = (Number(this._valueToIndex(this.selected)) - 1 + length) % length;
    }
    this.selected = this._indexToValue(index);
  },
  selectNext: function() {
    var index = 0;
    if (this.selected !== undefined) {
      index = (Number(this._valueToIndex(this.selected)) + 1) % this.items.length;
    }
    this.selected = this._indexToValue(index);
  },
  selectIndex: function(index) {
    this.select(this._indexToValue(index));
  },
  forceSynchronousItemUpdate: function() {
    if (this._observer && typeof this._observer.flush === "function") {
      this._observer.flush();
    } else {
      this._updateItems();
    }
  },
  get _shouldUpdateSelection() {
    return this.selected != null;
  },
  _checkFallback: function() {
    this._updateSelected();
  },
  _addListener: function(eventName) {
    this.listen(this, eventName, "_activateHandler");
  },
  _removeListener: function(eventName) {
    this.unlisten(this, eventName, "_activateHandler");
  },
  _activateEventChanged: function(eventName, old) {
    this._removeListener(old);
    this._addListener(eventName);
  },
  _updateItems: function() {
    var nodes = dom(this).queryDistributedElements(this.selectable || "*");
    nodes = Array.prototype.filter.call(nodes, this._bindFilterItem);
    this._setItems(nodes);
  },
  _updateAttrForSelected: function() {
    if (this.selectedItem) {
      this.selected = this._valueForItem(this.selectedItem);
    }
  },
  _updateSelected: function() {
    this._selectSelected(this.selected);
  },
  _selectSelected: function(selected) {
    if (!this.items) {
      return;
    }
    var item = this._valueToItem(this.selected);
    if (item) {
      this._selection.select(item);
    } else {
      this._selection.clear();
    }
    if (this.fallbackSelection && this.items.length && this._selection.get() === undefined) {
      this.selected = this.fallbackSelection;
    }
  },
  _filterItem: function(node) {
    return !this._excludedLocalNames[node.localName];
  },
  _valueToItem: function(value) {
    return value == null ? null : this.items[this._valueToIndex(value)];
  },
  _valueToIndex: function(value) {
    if (this.attrForSelected) {
      for (var i = 0, item; (item = this.items[i]); i++) {
        if (this._valueForItem(item) == value) {
          return i;
        }
      }
    } else {
      return Number(value);
    }
  },
  _indexToValue: function(index) {
    if (this.attrForSelected) {
      var item = this.items[index];
      if (item) {
        return this._valueForItem(item);
      }
    } else {
      return index;
    }
  },
  _valueForItem: function(item) {
    if (!item) {
      return null;
    }
    if (!this.attrForSelected) {
      var i = this.indexOf(item);
      return i === -1 ? null : i;
    }
    var propValue = item[dashToCamelCase(this.attrForSelected)];
    return propValue != undefined ? propValue : item.getAttribute(this.attrForSelected);
  },
  _applySelection: function(item, isSelected) {
    if (this.selectedClass) {
      this.toggleClass(this.selectedClass, isSelected, item);
    }
    if (this.selectedAttribute) {
      this.toggleAttribute(this.selectedAttribute, isSelected, item);
    }
    this._selectionChange();
    this.fire("iron-" + (isSelected ? "select" : "deselect"), {
      item: item,
    });
  },
  _selectionChange: function() {
    this._setSelectedItem(this._selection.get());
  },
  _observeItems: function(node) {
    return dom(node).observeNodes(function(mutation) {
      this._updateItems();
      this._updateSelected();
      this.fire("iron-items-changed", mutation, {
        bubbles: false,
        cancelable: false,
      });
    });
  },
  _activateHandler: function(e) {
    var t = e.target;
    var items = this.items;
    while (t && t != this) {
      var i = items.indexOf(t);
      if (i >= 0) {
        var value = this._indexToValue(i);
        this._itemActivate(value, t);
        return;
      }
      t = t.parentNode;
    }
  },
  _itemActivate: function(value, item) {
    if (
      !this.fire(
        "iron-activate",
        {
          selected: value,
          item: item,
        },
        {
          cancelable: true,
        }
      ).defaultPrevented
    ) {
      this.select(value);
    }
  },
};
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
const IronMultiSelectableBehaviorImpl = {
  properties: {
    multi: {
      type: Boolean,
      value: false,
      observer: "multiChanged",
    },
    selectedValues: {
      type: Array,
      notify: true,
      value: function() {
        return [];
      },
    },
    selectedItems: {
      type: Array,
      readOnly: true,
      notify: true,
      value: function() {
        return [];
      },
    },
  },
  observers: ["_updateSelected(selectedValues.splices)"],
  select: function(value) {
    if (this.multi) {
      this._toggleSelected(value);
    } else {
      this.selected = value;
    }
  },
  multiChanged: function(multi) {
    this._selection.multi = multi;
    this._updateSelected();
  },
  get _shouldUpdateSelection() {
    return this.selected != null || (this.selectedValues != null && this.selectedValues.length);
  },
  _updateAttrForSelected: function() {
    if (!this.multi) {
      IronSelectableBehavior._updateAttrForSelected.apply(this);
    } else if (this.selectedItems && this.selectedItems.length > 0) {
      this.selectedValues = this.selectedItems
        .map(function(selectedItem) {
          return this._indexToValue(this.indexOf(selectedItem));
        }, this)
        .filter(function(unfilteredValue) {
          return unfilteredValue != null;
        }, this);
    }
  },
  _updateSelected: function() {
    if (this.multi) {
      this._selectMulti(this.selectedValues);
    } else {
      this._selectSelected(this.selected);
    }
  },
  _selectMulti: function(values) {
    values = values || [];
    var selectedItems = (this._valuesToItems(values) || []).filter(function(item) {
      return item !== null && item !== undefined;
    });
    this._selection.clear(selectedItems);
    for (var i = 0; i < selectedItems.length; i++) {
      this._selection.setItemSelected(selectedItems[i], true);
    }
    if (this.fallbackSelection && !this._selection.get().length) {
      var fallback = this._valueToItem(this.fallbackSelection);
      if (fallback) {
        this.select(this.fallbackSelection);
      }
    }
  },
  _selectionChange: function() {
    var s = this._selection.get();
    if (this.multi) {
      this._setSelectedItems(s);
      this._setSelectedItem(s.length ? s[0] : null);
    } else {
      if (s !== null && s !== undefined) {
        this._setSelectedItems([s]);
        this._setSelectedItem(s);
      } else {
        this._setSelectedItems([]);
        this._setSelectedItem(null);
      }
    }
  },
  _toggleSelected: function(value) {
    var i = this.selectedValues.indexOf(value);
    var unselected = i < 0;
    if (unselected) {
      this.push("selectedValues", value);
    } else {
      this.splice("selectedValues", i, 1);
    }
  },
  _valuesToItems: function(values) {
    return values == null
      ? null
      : values.map(function(value) {
        return this._valueToItem(value);
      }, this);
  },
};
const IronMultiSelectableBehavior = [IronSelectableBehavior, IronMultiSelectableBehaviorImpl];
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
Polymer({
  is: "iron-selector",
  behaviors: [IronMultiSelectableBehavior],
});
// Copyright 2015 The Chromium Authors. All rights reserved.
Polymer({
  is: "extensions-sidebar",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-icons" scope="extensions-sidebar">
      :host {
        --sidebar-inactive-color: rgba(0, 0, 0, 0.54);
        color: var(--sidebar-inactive-color);
        display: flex;
        flex-direction: column;
        height: 100%;
        justify-content: space-between;
        overflow-x: hidden;
        overflow-y: auto;
        width: 200px;
        padding: 16px 0;
        background-color: var(--maxthon-bg-base);
        border-right: 1px solid var(--maxthon-border);
      }

      @media (prefers-color-scheme: dark) {
        :host {
          --sidebar-inactive-color: var(--cr-primary-text-color);
        }
      }

      #sectionMenu {
        user-select: none;
      }

      .section-item {
        align-items: center;
        color: var(--cr-primary-text-color);
        display: flex;
        font-size: 15px;
        min-height: 50px;
        padding-inline-start: 24px;
        padding-inline-end: 24px;
        position: relative;
        text-decoration: none;
        justify-content: flex-end;
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
      }
      .section-item:hover {
        background-color: var(--maxthon-bg-hover);
      }
      .section-item.iron-selected {
        background-color: var(--maxthon-bg-active);
      }

      .separator {
        border-top: 1px solid var(--maxthon-border);
        margin: 10px 0;
      }

      #more-extensions {
        align-items: center;
        display: flex;
        justify-content: flex-end;
        margin-bottom: 8px;
        padding-inline-end: 8px;
      }

      #more-extensions span {
        flex: 1;
        width: 0;
        text-align: right;
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
      }

      .icon-external {
        -webkit-mask-image: none;
        margin-inline-end: calc(var(--cr-section-padding) - var(--cr-icon-ripple-padding));
        width: 24px;
        height: 24px;
        margin: 8px;
        background: url("/resources/img/link.svg") center no-repeat;
      }
    </style>
    <iron-selector id="sectionMenu">
      <!-- Values for "data-path" attribute must match the "Page" enum. -->
      <a
        class="section-item"
        id="sections-extensions"
        href="/"
        on-click="onLinkTap_"
        data-path="items-list"
      >___sidebarExtensions___([[extensions.length]])</a>
      <a
        class="section-item"
        id="sections-shortcuts"
        href="/shortcuts"
        on-click="onLinkTap_"
        data-path="keyboard-shortcuts"
      >___keyboardShortcuts___</a>
      <a
        class="section-item"
        id="sections-import-export"
        href="/import-export"
        on-click="onLinkTap_"
        data-path="import-export"
      >___ext_exportOrImport___</a>
      <div class="separator"></div>
      <a
        class="section-item"
        id="more-extensions"
        href="https://go.mxfast.com/webstore/"
        target="_blank"
        on-click="onMoreExtensionsTap_"
      >
        <span>___openChromeWebStore___</span>
        <div class="cr-icon icon-external"></div>
      </a>
    </iron-selector>
    <!--_html_template_end_-->`,
  properties: {
    apps: Array,
    extensions: Array
  },
  hostAttributes: {
    role: "navigation",
  },
  attached() {
    this.$.sectionMenu.select(navigation.getCurrentPage().page === Page.SHORTCUTS ? 1 : 0);
  },
  onLinkTap_(e) {
    e.preventDefault();
    navigation.navigateTo({
      page: e.target.dataset.path,
    });
    this.fire("close-drawer");
  },
  onMoreExtensionsTap_() {
    chrome.metricsPrivate.recordUserAction("Options_GetMoreExtensions");
  },
});
// Copyright 2019 The Chromium Authors. All rights reserved.
Polymer({
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-hidden-style" scope="cr-tabs">
      :host {
        --cr-tabs-height: 48px;
        cursor: pointer;
        display: flex;
        flex-direction: row;
        font-size: var(--cr-tabs-font-size, 14px);
        font-weight: 500;
        height: var(--cr-tabs-height);
        position: relative;
        user-select: none;
      }

      .tab {
        align-items: center;
        color: var(--cr-secondary-text-color);
        display: flex;
        flex: auto;
        height: 100%;
        justify-content: center;
        opacity: 0.8;
        transition: opacity 100ms cubic-bezier(0.4, 0, 1, 1);
      }

      :host(:not(.keyboard-focus)) .tab {
        outline: none;
      }

      .selected {
        color: var(--google-blue-600);
        opacity: 1;
      }

      @media (prefers-color-scheme: dark) {
        .selected {
          color: var(--google-blue-refresh-300);
        }
      }

      .selected:focus {
        font-weight: 700;
      }

      #selectionBar {
        --cr-tabs-selection-bar-width: 2px;
        border-bottom-color: var(--google-blue-600);
        border-bottom-style: solid;
        border-bottom-width: var(--cr-tabs-selection-bar-width);
        height: 0;
        left: 0;
        position: absolute;
        right: 0;
        top: calc(var(--cr-tabs-height) - var(--cr-tabs-selection-bar-width));
        transform: scale(0);
        transform-origin: left center;
        transition: transform;
      }

      @media (prefers-color-scheme: dark) {
        #selectionBar {
          border-bottom-color: var(--google-blue-refresh-300);
        }
      }

      #selectionBar.expand {
        transition-duration: 150ms;
        transition-timing-function: cubic-bezier(0.4, 0, 1, 1);
      }

      #selectionBar.contract {
        transition-duration: 180ms;
        transition-timing-function: cubic-bezier(0, 0, 0.2, 1);
      }
    </style>
    <template is="dom-repeat" items="[[tabNames]]" on-dom-change="updateUi_">
      <div class="tab" role="tab" on-click="onTabClick_">[[item]]</div>
    </template>
    <div id="selectionBar"></div>
    <!--_html_template_end_-->`,
  is: "cr-tabs",
  properties: {
    tabNames: {
      type: Array,
      value: () => [],
    },
    selected: {
      type: Number,
      notify: true,
      observer: "updateUi_",
    },
  },
  hostAttributes: {
    role: "tablist",
  },
  listeners: {
    keydown: "onKeyDown_",
    mousedown: "onMouseDown_",
  },
  isRtl_: false,
  lastSelected_: null,
  attached() {
    this.isRtl_ = this.matches(":host-context([dir=rtl]) cr-tabs");
  },
  onMouseDown_() {
    this.classList.remove("keyboard-focus");
  },
  onKeyDown_(e) {
    this.classList.add("keyboard-focus");
    const count = this.tabNames.length;
    let newSelection;
    if (e.key === "Home") {
      newSelection = 0;
    } else if (e.key === "End") {
      newSelection = count - 1;
    } else if (e.key === "ArrowLeft" || e.key === "ArrowRight") {
      const delta = e.key === "ArrowLeft" ? (this.isRtl_ ? 1 : -1) : this.isRtl_ ? -1 : 1;
      newSelection = (count + this.selected + delta) % count;
    } else {
      return;
    }
    e.preventDefault();
    e.stopPropagation();
    this.selected = newSelection;
  },
  onSelectionBarTransitionEnd_() {
    this.$.selectionBar.classList.replace("expand", "contract");
    const tab = this.$$(`.tab:nth-of-type(${this.selected + 1})`);
    if (!tab) {
      this.$.selectionBar.style.transform = "scaleX(0)";
      return;
    }
    this.updateSelectionBar_(tab.offsetLeft, tab.offsetWidth);
  },
  onTabClick_({ model: { index: index } }) {
    this.selected = index;
  },
  updateSelectionBar_(left, width) {
    const containerWidth = this.offsetWidth;
    const leftPercent = (100 * left) / containerWidth;
    const widthRatio = width / containerWidth;
    if (this.$.selectionBar.style.transform === "translateX(0%) scaleX(1)" && leftPercent === 0 && widthRatio === 1) {
      this.onSelectionBarTransitionEnd_();
      return;
    }
    this.$.selectionBar.style.transform = `translateX(${leftPercent}%) scaleX(${widthRatio})`;
  },
  updateUi_() {
    const tabs = this.shadowRoot.querySelectorAll(".tab");
    if (tabs.length === 0) {
      return;
    }
    tabs.forEach((tab, i) => {
      const isSelected = this.selected === i;
      if (isSelected) {
        tab.focus();
      }
      tab.classList.toggle("selected", isSelected);
      tab.setAttribute("aria-selected", isSelected);
      tab.setAttribute("tabindex", isSelected ? 0 : -1);
    });
    if (this.selected === undefined) {
      return;
    }
    this.$.selectionBar.classList.remove("expand", "contract");
    const oldValue = this.lastSelected_;
    this.lastSelected_ = this.selected;
    if (oldValue === null || oldValue === this.selected) {
      setTimeout(() => {
        const { offsetLeft: offsetLeft, offsetWidth: offsetWidth } = tabs[this.selected];
        this.updateSelectionBar_(offsetLeft, offsetWidth);
      });
      return;
    }
    this.$.selectionBar.classList.add("expand");
    this.$.selectionBar.addEventListener("transitionend", () => this.onSelectionBarTransitionEnd_(), {
      once: true,
    });
    const { offsetLeft: newLeft, offsetWidth: newWidth } = tabs[this.selected];
    const { offsetLeft: oldLeft, offsetWidth: oldWidth } = tabs[oldValue];
    const left = Math.min(newLeft, oldLeft);
    const right = Math.max(newLeft + newWidth, oldLeft + oldWidth);
    this.updateSelectionBar_(left, right - left);
  },
});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
Polymer({
  _template: html`<!--css-build:shadow--><style scope="iron-pages">
      :host {
        display: block;
      }

      :host > ::slotted(:not(slot):not(.iron-selected)) {
        display: none !important;
      }
    </style>

    <slot></slot> `,
  is: "iron-pages",
  behaviors: [IronResizableBehavior, IronSelectableBehavior],
  properties: {
    activateEvent: {
      type: String,
      value: null,
    },
  },
  observers: ["_selectedPageChanged(selected)"],
  _selectedPageChanged: function(selected, old) {
    this.async(this.notifyResize);
  },
});
// Copyright 2019 The Chromium Authors. All rights reserved.
const ActivityLogSubpage = {
  NONE: -1,
  HISTORY: 0,
  STREAM: 1,
};
Polymer({
  is: "extensions-activity-log",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-icons cr-shared-style shared-style" scope="extensions-activity-log">
      #clear-activities-button {
        margin-inline-start: 8px;
      }

      #closeButton {
        margin-inline-end: 16px;
      }

      #icon {
        height: 24px;
        margin-inline-end: 12px;
        width: 24px;
      }

      cr-tabs {
        --cr-tabs-font-size: inherit;
        --cr-tabs-height: 40px;
        border-bottom: 1px solid var(--google-grey-refresh-300);
      }

      .page-content {
        display: flex;
        flex-direction: column;
        padding-bottom: 0;
      }

      iron-pages {
        flex: 1;
        position: relative;
      }

      activity-log-history,
      activity-log-stream {
        bottom: 0;
        position: absolute;
        top: 0;
        width: 100%;
      }
    </style>
    <div class="page-container" id="container">
      <div class="page-content">
        <div class="page-header">
          <cr-icon-button class="icon-arrow-back no-overlap" id="closeButton" aria-label="后退" on-click="onCloseButtonTap_"> </cr-icon-button>
          <template is="dom-if" if="[[!extensionInfo.isPlaceholder]]">
            <img
              id="icon"
              src="[[extensionInfo.iconUrl]]"
              alt$="[[appOrExtension(
                extensionInfo.type,
                '___appIcon___',
                '___extensionIcon___')]]"
            />
          </template>
          <div class="cr-title-text">[[getActivityLogHeading_(extensionInfo)]]</div>
        </div>
        <cr-tabs selected="{{selectedSubpage_}}" tab-names="[[tabNames_]]"> </cr-tabs>
        <iron-pages selected="[[selectedSubpage_]]">
          <div>
            <template is="dom-if" if="[[isHistoryTabSelected_(selectedSubpage_)]]" restamp="">
              <activity-log-history extension-id="[[extensionInfo.id]]" delegate="[[delegate]]"> </activity-log-history>
            </template>
          </div>
          <div>
            <template is="dom-if" if="[[isStreamTabSelected_(selectedSubpage_)]]">
              <activity-log-stream extension-id="[[extensionInfo.id]]" delegate="[[delegate]]"> </activity-log-stream>
            </template>
          </div>
        </iron-pages>
      </div>
    </div>
    <!--_html_template_end_-->`,
  behaviors: [CrContainerShadowBehavior, I18nBehavior, ItemBehavior],
  properties: {
    extensionInfo: Object,
    delegate: Object,
    selectedSubpage_: {
      type: Number,
      value: ActivityLogSubpage.NONE,
      observer: "onSelectedSubpageChanged_",
    },
    tabNames_: {
      type: Array,
      value: () => [loadTimeData.getString("activityLogHistoryTabHeading"), loadTimeData.getString("activityLogStreamTabHeading")],
    },
  },
  listeners: {
    "view-enter-start": "onViewEnterStart_",
    "view-exit-finish": "onViewExitFinish_",
  },
  onViewEnterStart_() {
    this.selectedSubpage_ = ActivityLogSubpage.HISTORY;
    afterNextRender(this, () => focusWithoutInk(this.$.closeButton));
  },
  onViewExitFinish_() {
    this.selectedSubpage_ = ActivityLogSubpage.NONE;
    const activityLogStream = this.$$("activity-log-stream");
    if (activityLogStream) {
      activityLogStream.clearStream();
    }
  },
  getActivityLogHeading_() {
    const headingName = this.extensionInfo.isPlaceholder ? this.i18n("missingOrUninstalledExtension") : this.extensionInfo.name;
    return this.i18n("activityLogPageHeading", headingName);
  },
  isHistoryTabSelected_() {
    return this.selectedSubpage_ === ActivityLogSubpage.HISTORY;
  },
  isStreamTabSelected_() {
    return this.selectedSubpage_ === ActivityLogSubpage.STREAM;
  },
  onSelectedSubpageChanged_(newTab, oldTab) {
    const activityLogStream = this.$$("activity-log-stream");
    if (activityLogStream) {
      if (newTab === ActivityLogSubpage.STREAM) {
        activityLogStream.startStream();
      } else if (oldTab === ActivityLogSubpage.STREAM) {
        activityLogStream.pauseStream();
      }
    }
  },
  onCloseButtonTap_() {
    if (this.extensionInfo.isPlaceholder) {
      navigation.navigateTo({
        page: Page.LIST,
      });
    } else {
      navigation.navigateTo({
        page: Page.DETAILS,
        extensionId: this.extensionInfo.id,
      });
    }
  },
});
// Copyright 2015 The Chromium Authors. All rights reserved.
const compareExtensions = function(a, b) {
  function compare(x, y) {
    return x < y ? -1 : x > y ? 1 : 0;
  }
  function compareLocation(x, y) {
    if (x.location === y.location) {
      return 0;
    }
    if (x.location === chrome.developerPrivate.Location.UNPACKED) {
      return -1;
    }
    if (y.location === chrome.developerPrivate.Location.UNPACKED) {
      return 1;
    }
    return 0;
  }
  return compareLocation(a, b) || compare(a.name.toLowerCase(), b.name.toLowerCase()) || compare(a.id, b.id);
};
Polymer({
  is: "extensions-manager",
  _template: html`<!--css-build:shadow--><!--_html_template_start_--><style include="cr-hidden-style" scope="extensions-manager">
      :host {
        color: var(--cr-primary-text-color);
        display: flex;
        flex-direction: column;
        height: 100%;
        --cr-toolbar-field-width: 680px;
      }

      extensions-sidebar {
        flex-basis: 200px;
      }

      .extensions-layout {
        display: flex;
        flex: 1;
      }

      #viewManager {
        flex: 1;
        position: relative;
        background-color: var(--maxthon-bg-base);
      }

      extensions-item {
        display: inline-block;
      }
    </style>
    <extensions-drop-overlay drag-enabled="[[inDevMode]]"> </extensions-drop-overlay>
    <extensions-toolbar
      in-dev-mode="[[inDevMode]]"
      can-load-unpacked="[[canLoadUnpacked]]"
      is-supervised="[[isSupervised_]]"
      dev-mode-controlled-by-policy="[[devModeControlledByPolicy]]"
      delegate="[[delegate]]"
      on-cr-toolbar-menu-tap="onMenuButtonTap_"
      on-search-changed="onFilterChanged_"
      extensions="[[extensions_]]"
    ></extensions-toolbar>
    <div class="extensions-layout">
      <extensions-sidebar
        id="sidebar"
        apps="[[apps_]]"
        extensions="[[extensions_]]"
      ></extensions-sidebar>
      <cr-view-manager id="viewManager" role="main">
        <extensions-item-list
          id="items-list"
          delegate="[[delegate]]"
          in-dev-mode="[[inDevMode]]"
          filter="[[filter]]"
          hidden$="[[!didInitPage_]]"
          slot="view"
          apps="[[apps_]]"
          extensions="[[extensions_]]"
          on-show-install-warnings="onShowInstallWarnings_"
        ></extensions-item-list>
        <cr-lazy-render id="details-view">
          <template>
            <extensions-detail-view delegate="[[delegate]]" slot="view" in-dev-mode="[[inDevMode]]" from-activity-log="[[fromActivityLog_]]" show-activity-log="[[showActivityLog]]" incognito-available="[[incognitoAvailable_]]" data="[[detailViewItem_]]"> </extensions-detail-view>
          </template>
        </cr-lazy-render>
        <cr-lazy-render id="activity-log">
          <template>
            <extensions-activity-log delegate="[[delegate]]" slot="view" extension-info="[[activityLogItem_]]"> </extensions-activity-log>
          </template>
        </cr-lazy-render>
        <cr-lazy-render id="keyboard-shortcuts">
          <template>
            <extensions-keyboard-shortcuts delegate="[[delegate]]" slot="view" items="[[extensions_]]"> </extensions-keyboard-shortcuts>
          </template>
        </cr-lazy-render>
        <cr-lazy-render id="import-export">
          <template>
            <extensions-import-export delegate="[[delegate]]" slot="view"> </extensions-import-export>
          </template>
        </cr-lazy-render>
        <cr-lazy-render id="error-page">
          <template>
            <extensions-error-page data="[[errorPageItem_]]" slot="view" delegate="[[delegate]]" in-dev-mode="[[inDevMode]]"> </extensions-error-page>
          </template>
        </cr-lazy-render>
      </cr-view-manager>
    </div>
    <template is="dom-if" if="[[showOptionsDialog_]]" restamp="">
      <extensions-options-dialog id="options-dialog" on-close="onOptionsDialogClose_"> </extensions-options-dialog>
    </template>
    <template is="dom-if" if="[[showLoadErrorDialog_]]" restamp="">
      <extensions-load-error id="load-error" delegate="[[delegate]]" on-close="onLoadErrorDialogClose_"> </extensions-load-error>
    </template>

    <template is="dom-if" if="[[showInstallWarningsDialog_]]" restamp="">
      <extensions-install-warnings-dialog on-close="onInstallWarningsDialogClose_" install-warnings="[[installWarnings_]]"> </extensions-install-warnings-dialog>
    </template>
    <cr-toast-manager></cr-toast-manager>
    <!--_html_template_end_-->`,
  properties: {
    canLoadUnpacked: {
      type: Boolean,
      value: false,
    },
    delegate: {
      type: Object,
      value() {
        return Service.getInstance();
      },
    },
    inDevMode: {
      type: Boolean,
      value: () => loadTimeData.getBoolean("inDevMode"),
    },
    showActivityLog: {
      type: Boolean,
      value: () => loadTimeData.getBoolean("showActivityLog"),
    },
    devModeControlledByPolicy: {
      type: Boolean,
      value: false,
    },
    isSupervised_: {
      type: Boolean,
      value: false,
    },
    incognitoAvailable_: {
      type: Boolean,
      value: false,
    },
    filter: {
      type: String,
      value: "",
    },
    errorPageItem_: Object,
    detailViewItem_: Object,
    activityLogItem_: Object,
    extensions_: Array,
    apps_: Array,
    didInitPage_: {
      type: Boolean,
      value: false,
    },
    showDrawer_: Boolean,
    showLoadErrorDialog_: Boolean,
    showInstallWarningsDialog_: Boolean,
    installWarnings_: Array,
    showOptionsDialog_: Boolean,
    fromActivityLog_: Boolean,
  },
  listeners: {
    "load-error": "onLoadError_",
    "view-enter-start": "onViewEnterStart_",
    "view-exit-start": "onViewExitStart_",
    "view-exit-finish": "onViewExitFinish_",
  },
  currentPage_: null,
  navigationListener_: null,
  ready() {
    const service = Service.getInstance();
    const onProfileStateChanged = (profileInfo) => {
      this.isSupervised_ = profileInfo.isSupervised;
      this.incognitoAvailable_ = profileInfo.isIncognitoAvailable;
      this.devModeControlledByPolicy = profileInfo.isDeveloperModeControlledByPolicy;
      this.inDevMode = profileInfo.inDeveloperMode;
      this.canLoadUnpacked = profileInfo.canLoadUnpacked;
    };
    service.getProfileStateChangedTarget().addListener(onProfileStateChanged);
    service.getProfileConfiguration().then(onProfileStateChanged);
    service.getExtensionsInfo().then((extensionsAndApps) => {
      this.initExtensionsAndApps_(extensionsAndApps);
      this.initPage_();
      service.getItemStateChangedTarget().addListener(this.onItemStateChanged_.bind(this));
    });
  },
  attached() {
    document.documentElement.classList.remove("loading");
    document.fonts.load("bold 12px Roboto");
    this.navigationListener_ = navigation.addListener((newPage) => {
      this.changePage_(newPage);
    });
  },
  detached() {
    assert(navigation.removeListener(this.navigationListener_));
    this.navigationListener_ = null;
  },
  initPage_() {
    this.didInitPage_ = true;
    this.changePage_(navigation.getCurrentPage());
  },
  onItemStateChanged_(eventData) {
    const EventType = chrome.developerPrivate.EventType;
    switch (eventData.event_type) {
      case EventType.VIEW_REGISTERED:
      case EventType.VIEW_UNREGISTERED:
      case EventType.INSTALLED:
      case EventType.LOADED:
      case EventType.UNLOADED:
      case EventType.ERROR_ADDED:
      case EventType.ERRORS_REMOVED:
      case EventType.PREFS_CHANGED:
      case EventType.WARNINGS_CHANGED:
      case EventType.COMMAND_ADDED:
      case EventType.COMMAND_REMOVED:
      case EventType.PERMISSIONS_CHANGED:
        if (!eventData.extensionInfo) {
          break;
        }
        if (this.delegate.shouldIgnoreUpdate(eventData.extensionInfo.id, eventData.event_type)) {
          break;
        }
        const listId = this.getListId_(eventData.extensionInfo);
        const currentIndex = this[listId].findIndex((item) => item.id === eventData.extensionInfo.id);
        if (currentIndex >= 0) {
          this.updateItem_(listId, currentIndex, eventData.extensionInfo);
        } else {
          this.addItem_(listId, eventData.extensionInfo);
        }
        break;
      case EventType.UNINSTALLED:
        this.removeItem_(eventData.item_id);
        break;
      default:
        assertNotReached();
    }
  },
  onFilterChanged_(event) {
    if (this.currentPage_.page !== Page.LIST) {
      navigation.navigateTo({
        page: Page.LIST,
      });
    }
    this.filter = event.detail;
  },
  onMenuButtonTap_() {
    this.showDrawer_ = true;
    this.async(() => {
      this.$$("#drawer").openDrawer();
    });
  },
  getListId_(item) {
    const ExtensionType = chrome.developerPrivate.ExtensionType;
    switch (item.type) {
      case ExtensionType.HOSTED_APP:
      case ExtensionType.LEGACY_PACKAGED_APP:
      case ExtensionType.PLATFORM_APP:
        return "apps_";
      case ExtensionType.EXTENSION:
      case ExtensionType.SHARED_MODULE:
        return "extensions_";
      case ExtensionType.THEME:
        assertNotReached("Don't send themes to the chrome://extensions page");
        break;
    }
    assertNotReached();
  },
  getIndexInList_(listId, itemId) {
    return this[listId].findIndex(function(item) {
      return item.id === itemId;
    });
  },
  getData_(id) {
    return this.extensions_[this.getIndexInList_("extensions_", id)] || this.apps_[this.getIndexInList_("apps_", id)];
  },
  initExtensionsAndApps_(extensionsAndApps) {
    extensionsAndApps.sort(compareExtensions);
    const apps = [];
    const extensions = [];
    for (const i of extensionsAndApps) {
      const list = this.getListId_(i) === "apps_" ? apps : extensions;
      list.push(i);
    }
    this.apps_ = apps;
    this.extensions_ = extensions;
  },
  addItem_(listId, item) {
    assert(this.getIndexInList_(listId, item.id) === -1);
    let insertBeforeChild = this[listId].findIndex(function(listEl) {
      return compareExtensions(listEl, item) > 0;
    });
    if (insertBeforeChild === -1) {
      insertBeforeChild = this[listId].length;
    }
    this.splice(listId, insertBeforeChild, 0, item);
  },
  updateItem_(listId, index, item) {
    assert(index >= 0);
    this.set([listId, index], item);
    if (this.detailViewItem_ && this.detailViewItem_.id === item.id && this.currentPage_.page === Page.DETAILS) {
      this.detailViewItem_ = item;
    } else if (this.errorPageItem_ && this.errorPageItem_.id === item.id && this.currentPage_.page === Page.ERRORS) {
      this.errorPageItem_ = item;
    } else if (this.activityLogItem_ && this.activityLogItem_.id === item.id && this.currentPage_.page === Page.ACTIVITY_LOG) {
      this.activityLogItem_ = item;
    }
  },
  removeItem_(itemId) {
    let listId = "extensions_";
    let index = this.getIndexInList_(listId, itemId);
    if (index === -1) {
      listId = "apps_";
      index = this.getIndexInList_(listId, itemId);
    }
    assert(index >= 0);
    this.splice(listId, index, 1);
    if ((this.currentPage_.page === Page.ACTIVITY_LOG || this.currentPage_.page === Page.DETAILS || this.currentPage_.page === Page.ERRORS) && this.currentPage_.extensionId === itemId) {
      navigation.replaceWith({
        page: Page.LIST,
      });
    }
  },
  onLoadError_(e) {
    this.showLoadErrorDialog_ = true;
    this.async(() => {
      const dialog = this.$$("#load-error");
      dialog.loadError = e.detail;
      dialog.show();
    });
  },
  changePage_(newPage) {
    this.onCloseDrawer_();
    const optionsDialog = this.$$("#options-dialog");
    if (optionsDialog && optionsDialog.open) {
      this.showOptionsDialog_ = false;
    }
    const fromPage = this.currentPage_ ? this.currentPage_.page : null;
    const toPage = newPage.page;
    let data;
    let activityLogPlaceholder;
    if (newPage.extensionId) {
      data = this.getData_(newPage.extensionId);
      if (!data) {
        if (this.showActivityLog && toPage === Page.ACTIVITY_LOG) {
          activityLogPlaceholder = {
            id: newPage.extensionId,
            isPlaceholder: true,
          };
        } else {
          navigation.replaceWith({
            page: Page.LIST,
          });
          return;
        }
      }
    }
    if (toPage === Page.DETAILS) {
      this.detailViewItem_ = assert(data);
    } else if (toPage === Page.ERRORS) {
      this.errorPageItem_ = assert(data);
    } else if (toPage === Page.ACTIVITY_LOG) {
      if (!this.showActivityLog) {
        navigation.replaceWith({
          page: Page.DETAILS,
          extensionId: newPage.extensionId,
        });
        return;
      }
      this.activityLogItem_ = data ? assert(data) : activityLogPlaceholder;
    }
    if (fromPage !== toPage) {
      this.$.viewManager.switchView(toPage);
    }
    if (newPage.subpage) {
      assert(newPage.subpage === Dialog.OPTIONS);
      assert(newPage.extensionId);
      this.showOptionsDialog_ = true;
      this.async(() => {
        this.$$("#options-dialog").show(data);
      });
    }
    document.title = toPage === Page.DETAILS ? `${loadTimeData.getString("title")} - ${this.detailViewItem_.name}` : loadTimeData.getString("title");
    this.currentPage_ = newPage;
  },
  onDrawerClose_() {
    this.showDrawer_ = false;
  },
  onCloseDrawer_() {
    const drawer = this.$$("#drawer");
    if (drawer && drawer.open) {
      drawer.close();
    }
  },
  onLoadErrorDialogClose_() {
    this.showLoadErrorDialog_ = false;
  },
  onOptionsDialogClose_() {
    this.showOptionsDialog_ = false;
    this.$$("extensions-detail-view").focusOptionsButton();
  },
  onViewEnterStart_() {
    this.fromActivityLog_ = false;
  },
  onViewExitStart_(e) {
    const viewType = e.composedPath()[0].tagName;
    this.fromActivityLog_ = viewType === "EXTENSIONS-ACTIVITY-LOG";
  },
  onViewExitFinish_(e) {
    const viewType = e.composedPath()[0].tagName;
    if (viewType === "EXTENSIONS-ITEM-LIST" || viewType === "EXTENSIONS-KEYBOARD-SHORTCUTS" || viewType === "EXTENSIONS-IMPORT-EXPORT" || viewType === "EXTENSIONS-ACTIVITY-LOG") {
      return;
    }
    const extensionId = e.composedPath()[0].data.id;
    const list = this.$$("extensions-item-list");
    const button = viewType === "EXTENSIONS-DETAIL-VIEW" ? list.getDetailsButton(extensionId) : list.getErrorsButton(extensionId);
    if (button) {
      button.focus();
    }
  },
  onShowInstallWarnings_(e) {
    this.installWarnings_ = e.detail;
    this.showInstallWarningsDialog_ = true;
  },
  onInstallWarningsDialogClose_() {
    this.installWarnings_ = null;
    this.showInstallWarningsDialog_ = false;
  },
});
export { ARG_URL_PLACEHOLDER, ActivityLogPageState, Dialog, Key, NavigationHelper, OptionsDialogMaxHeight, OptionsDialogMinWidth, Page, Service, getPatternFromSite, getToastManager, isValidKeyCode, keystrokeToString, navigation };
