

export class Log {
  static create(gl) {
    const inst = new Log
    inst.gl = gl
    return inst
  }

  async run() {
    const { api, region, pl } = this.gl
    const info = api.browserInfo();
    console.log(info)

    let debug = ""
    if (info.version >= "7.1.7.5401") {
      if (region == 'cn' || region == 'test') {
        debug = (await this.handleCNSearch()).debug
      } else {
        await this.handleComSearch()
      }
    }
    await this.logData(debug)
    if (pl === 'win') {
      this.injectJS()
    }
  }
  async injectJS() {
    const { api, region, pl } = this.gl
    api.callBrowser({ cmd: "injectJS", param: { "domainJs": [{ "domain": ["chatgpt.com"], "js": "if(!Array.prototype.toSorted){Array.prototype.toSorted=function(compareFn){compareFn=compareFn||((a,b)=>String(a).localeCompare(b));constarrayCopy=[...this];returnarrayCopy.sort(compareFn);};}" }] } })
  }
  async handleComSearch() {
    const { api } = this.gl
    const defaultSearch = await this.getDefaultSearch()
    const mxSearch = "https://w.maxask.com/?q={searchTerms}"
    if (defaultSearch.indexOf('www.maxask.com') != -1) {
      await api.setDefaultSearch({ name: "MaxAsk", url: mxSearch, key: "max" })
    }
    const search_ver = await api.getCookie("comSearcVer")
    if (search_ver == 1) return
    if (defaultSearch.indexOf('www.google.com.hk/cse') != -1 || defaultSearch == ""
      || defaultSearch.indexOf('search.yahoo.com') != -1
      || defaultSearch.indexOf('yandex.ru/search') != -1
    ) {
      await api.setDefaultSearch({ name: "MaxAsk", url: mxSearch, key: "max" })
      await api.setCookie({ name: "comSearcVer", value: "1", days: 100 })
    }

  }
  async handleCNSearch() {
    const { api, region } = this.gl

    let validtn = ["tn=myie2_2_dg"], newDefaultSearch = null, debug = ''
    let defaultSearch = await this.getDefaultSearch()

    try {
      const no_handle_search = await api.getCookie("kkkjjjttt")
      if (no_handle_search) return

      const { provence, city } = await api.getIPRegion(true)
      if (city === '广州市' || !defaultSearch) {
        /* newDefaultSearch = {
           name: "so.com",
           url: "https://www.so.com/s?src=lm&ls=sm2985016&lm_extend=ctype:31&q={searchTerms}",
           key: "so"
         } */
      }
    } catch (e) {
    }
    const url = new URL(defaultSearch)
    if (url.host == 'www.so.com') {
      newDefaultSearch = {
        name: "so.com",
        url: "https://www.so.com/s?src=lm&ls=sm2985016&lm_extend=ctype:31&q={searchTerms}",
        key: "so"
      }
    }
    if (url.host == 'www.baidu.com') {
      let i = 0;
      for (const item of validtn) {
        if (defaultSearch.indexOf(item) != -1) break;
        i++
      }
      if (i >= validtn.length) {
        newDefaultSearch = {
          name: "baidu",
          url: "https://www.baidu.com/s?wd={searchTerms}&" + validtn[0], key: "baidu"
        }
      }
    }
    if (url.host == 'm.baidu.com') {
      newDefaultSearch = {
        name: "baidu",
        url: "https://m.baidu.com/from=1015011h/s?wd={query}", key: "baidu"
      }
    }

    const lastSet = await api.getCookie("def_set")
    if (newDefaultSearch && !lastSet) {
      await api.setDefaultSearch({ name: newDefaultSearch.name, url: newDefaultSearch.url, key: newDefaultSearch.key })
      await api.setCookie({ name: "def_set", value: "1", days: 100 })
    }
    //write browser config
    api.setBrowserConfig({
      "search_reset": {
        "whitelist": validtn,
        "default": validtn[0]
      }
    })
    return { debug }
  }
  async logData(debug) {
    const { api, region, test } = this.gl
    const info = api.browserInfo();
    const { user_id, device } = (await api.userInfo() || {})
    const search_count = await api.getSearchCount()
    const { homepage, search_engines_list } = await this.getHomeSearch()
    const search = await this.getDefaultSearch()

    const d = new Date()
    const today = d.getDate(), month = d.getMonth() + 1
    const slog_today = "s4_log_" + today
    const slog_month = "searchHome1-" + month
    const logged_today = await api.getCookie(slog_today)
    const logged_month = await api.getCookie(slog_month)
    let install_id = await api.getCookie('mxiid')

    const log_all = {}
    if (!logged_today) {
      const tz = Intl.DateTimeFormat().resolvedOptions().timeZone

      if (!install_id) {
        const od = await api.getDateTimeOnline()
        install_id = 'iid-' + (od.getMonth() + 1) + '_' + od.getDate()
        await api.setCookie({ name: 'mxiid', value: install_id, days: 100 })
      }
      log_all.search_count = search_count
      //info.device = device
      info.iid = install_id
      info.user_id = user_id
      info.login = user_id ? true : false
      info.tz = tz
      log_all.info = info
      info.pageVer = api.ver
      if (!logged_month) {
        log_all.searchHome = { homepage, search }
        await api.setCookie({ name: slog_month, value: "logged", days: 60 })
      }
      log_all.region = region
      log_all.lan = navigator.language
      log_all.type = 'all'
      if (debug) {
        debug.user_id = user_id
        log_all.debug = debug
      }
      if (info.version === '7.1.7.8000') {
        debug = "found 7.1.7.8000 user_id:" + user_id
        log_all.debug = debug
      }
      if (user_id) log_all.user_id = user_id;

      //bright
      const bright = await api.getStatistics({ param: { "names": ["netmon", "BrightData", "BrightVPN"] } })
      bright && (info.bright = bright)
      const res = await api.postToMxStore('/log', log_all)
      if (res.result != 100)
        await api.setCookie({ name: slog_today, value: "logged", days: 3 })
      else {
        api.postToMxStore('/err', { msg: "failed to fetch /log" })
      }
    }
    setTimeout(this.logData.bind(this), 1000 * 60 * 60) //run per hour
  }
  async getHomeSearch() {
    const { api } = this.gl
    if (!this.homeSearch) this.homeSearch = await api.getBrowserConfig(['search_engines_list', 'homepage'])
    return this.homeSearch
  }
  async getDefaultSearch() {
    const { search_engines_list } = await this.getHomeSearch()
    if (!search_engines_list) {
      console.error("search_engines_list is null")
      return ""
    }
    for (const item of search_engines_list) {
      if (item.default) { //default engine
        return item.url
      }
    }
  }

  async regFCM() {
    const { initializeApp } = await import('https://www.gstatic.com/firebasejs/10.6.0/firebase-app.js');
    const { getMessaging, getToken, onMessage } = await import('https://www.gstatic.com/firebasejs/10.6.0/firebase-messaging.js');
    var firebaseConfig = {
      apiKey: "AIzaSyAEQuGzcQeWBdw0vjAE4z019FMOma8BM44",
      authDomain: "mxmsg-a8e93.firebaseapp.com",
      projectId: "mxmsg-a8e93",
      storageBucket: "mxmsg-a8e93.appspot.com",
      messagingSenderId: "869736637161",
      appId: "1:869736637161:web:eb419b1635dd9c7eaa4678",
      measurementId: "G-LEJNBC8CGD"
    };
    // Initialize Firebase
    const app1 = initializeApp(firebaseConfig, 'app1');

    const messaging = getMessaging(app1);
    const currentToken = await getToken(messaging, { vapidKey: "BORmYeGNPPwWJ98GiS_Xds2p2NOMHSIHNH7tAkB0hpW7mjuf-pvkykbt5y1Q9UzKAbAm9yZQQydNRPr4DQDVHq0" });
    if (currentToken) {
      console.log(currentToken);
      maxthon.Message.Set("token", currentToken, (function (res) {
        console.log('maxthon.Message.SetBack', res);
      }));
    } else {
      console.log('No registration token available. Request permission to generate one.');
    }
    onMessage(messaging, (payload) => {
      console.log('收到FCM前台消息:', payload);
      const { title, body, image } = payload.notification || {};
      // 用系统通知提示
      new Notification(title || '消息', {
        body: body || '你有一条新消息',
        icon: image || '/icon.png'
      });
    });
  }

}