//const syncAPI = "http://localhost:17000"
const syncAPI = "https://syncapi.maxthon.com"
//const syncAPI = "https://mxsync.mxfast.com"

async function mxSync_Call(para) {
    console.log("mxSync_Call:", para)
    const { mxsync } = MxSync.gl
    return await mxsync.onCall(para)
}

export class MxSync {
    static async create(gl) {
        if (await import("/lib/compressJson.min.js")) {
            gl.compressJson = window.compressJson
        } else {
            console.error("loading compressJson failed")
        }
        const inst = new MxSync
        MxSync.gl = gl
        inst.gl = gl
        gl.mxsync = inst
        window.mxSync_Call = mxSync_Call
        return inst
    }
    async run() {
        const { api } = this.gl
        const { user_id } = await api.userInfo()
        if (api.browserInfo().version >= "7.1.8.7100") {
            this.names = { settings: {}, bookmarks: {} }
        }
        api.registerReceiver({ name: "mxsync", client: this })
        if (!user_id || user_id == 'undefined') {
            console.error("User not login. mxsync quit")
            return
        }
        //this.syncOnce()
    }
    async onPeerNotify(data) {
        if (data.type === 'dataUpdate') {
            await this.syncOnce({ names: [data.name] })
        }
    }
    async onCall(para) {
        const { cmd, param } = para
        const { api } = this.gl
        //  const mxtoken = api.getCookie("MXTOKEN")
        //  if (!mxtoken) return { code: 100, err: "not logged-in" }

        switch (cmd) {
            case 'updateData': return await this.onUpdateData(param);
            case 'syncOnce': return await this.syncOnce(param)
        }
    }
    async syncOnce(param) {
        const { api } = this.gl
        let user_id = param?.uid, names = param?.names
        if (this.syncing) {
            console.error("still in syncing")
            return { code: 100, msg: "still in syncing" }
        }
        if (!names) {
            console.error("no names")
            //return { code: 100, msg: "no names" }
            names = Object.keys(this.names)
        }
        console.log("syncOnce checking")
        if (!user_id)
            ({ user_id } = await api.userInfo())
        if (!user_id) {
            console.error("user not login, quit")
            return { code: 101, msg: 'user not login' }
        }
        this.syncing = true
        let remote = null
        try {
            await this.reportStat('start')
            remote = await this.getAllRemoteVersions(names)
            const local = await this.getLocalVersions(names || Object.keys(names))
            const toDownload = []
            const toUpload = []
            for (const key of names) {
                const vl = local[key]?.ver   //local version
                const vr = remote[key]?.ver //remote version
                if (typeof vl == 'undefined' || typeof vr === 'undefined') continue
                console.log(key, " vl:", vl, "vr:", vr)
                if (vr === 0 && vl != 0) { //upload
                    console.log("need upload")
                    toUpload.push(key)
                    continue
                }
                if (vr === 0 && vl === 0) { //both are 0, try to see if it has old data
                    toDownload.push(key)
                    continue
                }

                if (vr <= vl) continue
                console.log("need download")
                toDownload.push(key)
            }
            if (toDownload.length > 0) {
                await this.downloadData({ names: toDownload, uid: user_id })
            }
            if (toUpload.length > 0) {
                const items = await this.getLocalData(toUpload)
                await this.uploadData({ items, incVer: false })
            }
            await this.reportStat('end')
        } catch (e) {
            api.postError("syncOnce exception:" + e.message)
        }
        this.syncing = false
        return { code: 0, msg: "sync finish", remote }
    }
    async updateMaxthonData(param) {
        const { api } = this.gl
        api.debug('updateMaxthonData:', param)
        const res = await this.gl.api.callBrowser({ from: "mxsync_js", cmd: "newData", param })
        return res
    }
    async reportStat(stat) {
        const res = await this.gl.api.callBrowser({ from: "mxsync_js", cmd: "stats", param: { stat } })
        return res
    }
    async getLocalData(names) {
        const ret = {}
        for (const name of names) {
            const res = await this.gl.api.callBrowser({ from: "mxsync_js", cmd: "getData", param: { name } })
            if (res.code != 0) {
                console.error(res)
                continue
            }
            ret[name] = res.values
        }
        return ret
    }
    async getLocalVersions(names) {
        const res = await this.gl.api.callBrowser({ from: "mxsync_js", cmd: "getVersions", param: { names } })
        if (res.code != 0) console.error(res)
        return res.values
    }
    async getAllRemoteVersions(param) {
        const names = param
        if (!names) {
            console.error("no names 1")
            return {}
        }
        const result = await this._postData({ path: 'vers', body: { names } })
        return result
    }
    async onUpdateData({ ver, uid, name, data }) {
        const { api } = this.gl
        api.debug("onUpdateData:", ver, uid, name, data)
        if (typeof ver === 'undefined') return { code: 100, err: "ver is missing" }
        const items = { [name]: { ver, data } }
        const res = await this.uploadData({ items })
        api.debug("uploadData return:", res)
        return res[name]
    }

    async mergeData({ name, data, datal }) {
        const { api } = this.gl
        if (typeof data === 'string') data = JSON.parse(data)
        if (typeof datal === 'string') datal = JSON.parse(datal)
        return api.merger.mergeAdvanced(data, datal)
    }
    async uploadData({ items, incVer = true }) {
        const { api } = this.gl
        api.debug('uploadData:', items)
        const { user_id } = await api.userInfo()

        for (const name in items) {
            let { data } = items[name]
            if (typeof data === 'string') {
                const data1 = api.parseJson(data)
                if (!data1) {
                    console.error("invalid data", data)
                    delete items[name]
                    continue
                }
                data = data1
            }
            items[name].data = compressJson.compress(data)
        }
        if (Object.keys(items).length === 0) return { code: 100, err: "no items" }
        const ret = await this._postData({ path: "up", body: { items, incVer } })
        const toDownload = []
        for (const name in ret) {
            if (ret[name].code === 1001) toDownload.push(name)
        }
        if (toDownload.length > 0) {
            setTimeout(() => this.downloadData({ names: toDownload, uid: user_id }), 100)
            return { code: 1, msg: "try later" }
        }
        return ret
    }
    async getCache({ names }) {
        const name1 = {}
        for (const name of names) {
            const key = name + "_sync"
            let datal = await api.readData({ key })
            datal = api.parseJson(datal)
            name1[name] = { fv: datal ? datal.ver : null }
        }
        return name1
    }
    async downloadData({ names, uid }) {
        const { api } = this.gl
        console.log('downloadData:', names, uid)
        const { compressJson } = this.gl
        let namesObj = null
        if (uid == 515485465) {
            namesObj = await this.getCache({ names })
        }
        let items = await this._postData({ path: "down", body: { names, namesObj } })
        if (items.err) return { code: 101, err: items.err }
        for (const name in items) {
            let { v, encoding = 'c', data, err, code } = items[name]
            let json = null
            if (!err && encoding === 'c') {
                json = compressJson.decompress(data)
                data = JSON.stringify(json)
            }
            if (code === 0 && data) {
                if (v > 0 && uid == 515485465) { //save to cache
                    const key = name + "_sync"
                    let datal = await api.readData({ key })
                    datal = api.parseJson(datal)
                    if (!datal || datal.ver != v) {
                        await api.saveData({ key, value: { ver: v, data: json } })
                    }
                }
                let res = await this.updateMaxthonData({ name, uid, data, ver: v })
                console.log("updateMaxthonData ret:", res)
                if (res.code === 1) {
                    api.debug("mergeData:", name, "data:", data, "datal:", res.values)
                    const data1 = await this.mergeData({ name, data, datal: res.values })
                    api.debug('after merge:', data1)
                    const items = { [name]: { ver: v, data: data1 } }
                    const ret = await this.uploadData({ items })
                    res = await this.updateMaxthonData({ name, uid, data: JSON.stringify(data1), ver: ret[name].ver, merge: true })
                }
            }
            err && console.error(err)
        }
    }
    async _postData({ path, body = {} }) {
        const { api } = this.gl
        let err = null
        const { user_id, device, region, region_domain } = await api.userInfo()
        if (!user_id) {
            err = "_postData error getting user_id"
            console.error(err)
            return { err }
        }
        const mxtoken = await api.getCookie("MXTOKEN")
        api.debug("got mxtoken:", mxtoken)
        if (body) {
            body.from = device
            body.uid = user_id + ''
            body.region = region || region_domain
            body.os = await api.browserInfo().os
            body.mv = await api.browserInfo().version
        }
        const packedData = msgpackr.pack(body)
        const url = syncAPI + `/sync/` + path
        try {
            const ret = await fetch(url, {
                method: "POST",
                headers: {
                    'Content-Type': 'application/msgpack',
                    'mxtoken': mxtoken
                },
                credentials: 'include',
                body: packedData
            })
            const result = await ret.json()
            return result
        } catch (e) {
            err = e.message
            console.error("_postData:", e.message)
        }
        return { err }
    }
    async getRemoteVersion({ name }) {
        const res = await this._postData({ path: "vers", body: { names: [name] } })
        return res
    }
}